#include "MicroShell.h"
#include "core/microshell.h"

Serial *msh_con = NULL;
MICROSHELL msh_struct;
MSCORE_ACTION msh_action;

void msh_putc(char c)
{
    msh_con -> putc(c);
}
char msh_getc(void)
{
    return msh_con -> getc();
}
void msh_act_hook(MSCORE_ACTION action)
{
    msh_action = action;
}

MicroShell::MicroShell(PinName tx, PinName rx, int baud)
{
    if(msh_con==NULL) {
        msh_con = new Serial(tx,rx,baud);
        microshell_init(&msh_struct, msh_putc, msh_getc, msh_act_hook);
    }
}
void MicroShell::putc(int c)
{
    msh_putc(c);
}
void MicroShell::puts(const char *s)
{
    while (*s) {
        msh_putc(*s++);
    }
}
int MicroShell::getc()
{
    return msh_getc();
}
char *MicroShell::gets(char *s, int size)
{
    return microshell_getline(&msh_struct, s, size);
}
int MicroShell::printf(const char* format, ...)
{
    int ret;
    va_list args;
    va_start(args, format);
    ret = msh_con -> vprintf(format, args);
    va_end(args);
    return ret;
}
int MicroShell::scanf(const char* format, ...)
{
    char buf[256];
    microshell_getline(&msh_struct, buf, sizeof(buf));

    int ret;
    va_list args;
    va_start(args, format);
    ret = vsscanf(buf, format, args);
    va_end(args);
    return ret;
}
int MicroShell::vprintf(const char* format, std::va_list args)
{
    int ret;
    ret = msh_con -> vprintf(format, args);
    return ret;
}
int MicroShell::vscanf(const char* format, std::va_list args)
{
    char buf[256];
    microshell_getline(&msh_struct, buf, sizeof(buf));

    int ret;
    ret = vsscanf(buf, format, args);
    return ret;
}
