#include "mbed.h"
//#include "lib.h"

#define LIMEN 0.15

#define KP 1.8
#define KD 2000

#define DELTA_T 0.05

#define S1LIMEN 0.01
#define S4LIMEN 0.01
#define S0LIMEN 0.08

//#define DEBUG

//モータ1L
BusOut LM(PTA1, PTA2);
PwmOut LP(PTD4);
//モータ2R
BusOut RM(PTC0, PTC7);
PwmOut RP(PTA12);
//モータ3
BusOut i3(PTC6, PTC5);
PwmOut p3(PTA4);

DigitalOut led1(PTB8);
DigitalOut led2(PTB9);
DigitalOut led3(PTB10);
DigitalOut led4(PTB11);
DigitalOut ledb(PTE5);
DigitalOut ledb2(PTE4);

AnalogIn sensor1(PTC2);
AnalogIn sensor2(PTB3);
AnalogIn sensor3(PTB0);
AnalogIn sensor4(PTB2);
AnalogIn sensor0(PTB1);

void r_flont(float pow)
{
    RM = 1;
    RP = pow;
}


void l_flont(float pow)
{
    LM = 1;
    LP = pow;
}



void r_rev(float pow)
{
    RM = 2;
    RP = pow;
}

void l_rev(float pow)
{
    LM = 2;
    LP = pow;
}

void stop()
{
    RM = 3;
    LM = 3;
}

void fwd(float pow)
{
    r_flont(pow);
    l_flont(pow);
}

void rev(float pow)
{
    r_rev(pow);
    l_rev(pow);
}

void r_stop()
{
    RM = 3;
}
void l_stop()
{
    LM = 3;
}

void pivot_turn_l(float pow)//信地旋回
{
    l_flont(pow);
    r_rev(0.01f);
    //r_stop();
}
void pivot_turn_r(float pow)
{
    r_flont(pow);
    l_rev(0.01f);
    //l_stop();
}

void spin_turn_l(float pow)//超信地旋回
{
    l_flont(pow);
    r_rev(pow);
}

void spin_turn_r(float pow)
{
    r_flont(pow);
    l_rev(pow);
}

void led_off()
{
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    ledb = 0;
    ledb2 = 0;
}


void breake()
{
    rev(1.0f);
    wait(0.1);
    stop();
}
#ifdef DEBUG
Serial pc(USBTX, USBRX);
#endif

int main()
{
    static float pr,pl;
    float sen[5] = {};
    float old_sen[4] = {};
    int cnt = 0;
    ledb = 1;
    while(1) {
        ledb2 = 0;
        sen[0] = sensor1.read();
        sen[1] = sensor2.read();
        sen[2] = sensor3.read();
        sen[3] = sensor4.read();
        sen[4] = sensor0.read();
#ifdef DEBUG
        ledb2 = 1;
        pc.printf("s1 = %f, s2 = %f, s3 = %f, s4 = %f s0 = %f",sen[0],sen[1],sen[2],sen[3],sen[4]);
        pc.printf("\tpr = %f pl = %f\n",pr ,pl);
#endif
        if(sen[0] < S1LIMEN)
            led4 = 1;
        else
            led4 = 0;
        if(sen[1] < LIMEN)
            led3 = 1;
        else
            led3 = 0;
        if(sen[2] < LIMEN)
            led2 = 1;
        else
            led2 = 0;
        if(sen[3] < S4LIMEN)
            led1 = 1;
        else
            led1 = 0;

        pr = (KP * (sen[1] - 0.012) / (0.32 - 0.02) + KD * (sen[1] - old_sen[1]) ) * 1.0f;
        pl = (KP * (sen[2] - 0.012) / (0.32 - 0.02) + KD * (sen[2] - old_sen[2]) ) * 1.0f;
        /*   if(pr < 0.5)
               pr = 0.5;

           if(pl < 0.5)
               pl = 0.5;*/
#ifndef DEBUG
        if((cnt == 3 || cnt == 4) && (sen[3] < S4LIMEN || sen[0] < S1LIMEN)) {
            fwd(1.0f);
            wait(0.5);
            cnt ++;
        }
        if((cnt == 5) && (sen[3] < S4LIMEN || sen[0] < S1LIMEN)) {
            ledb2 = 1;
            pivot_turn_r(1.0f);
            //while(sensor4.read() > S4LIMEN){}
            wait(0.3);
            cnt ++;
        } else if(sen[3] < S4LIMEN && sen[0] < S1LIMEN)
            if( cnt == 0) {
                breake();
                fwd(1.0f);
                wait(0.5);
                cnt++;
            } else
                break;
        else if(sen[3] < S4LIMEN) {
            ledb2 = 1;
            pivot_turn_r(1.0f);
            //while(sensor4.read() > S4LIMEN){}
            wait(0.3);
            cnt ++;
        } else if(sen[0] < S1LIMEN) {
            ledb2 = 1;
            pivot_turn_l(1.0f);
            wait(0.3);
            cnt ++;
            //while(sensor1.read() > S1LIMEN){}
        } else {
            r_flont(pr);
            l_flont(pl);
        }
#endif

#ifdef DEBUG
        wait(1);
#endif
        old_sen[0] = sen[0];
        old_sen[1] = sen[1];
        old_sen[2] = sen[2];
        old_sen[3] = sen[3];
    }
    rev(1.0f);
    wait(0.1);
    stop();
    wait(1);
    led_off();
}