#include "mbed.h"
#include "MicroduinoPinNames.h"
#include "userDef.h"
#include "Protocol.h"
#include "Microduino_Motor.h"


Timer g_cubeTimer;
//Timeout g_cubeTimeout;

Motor MotorLeft(motor_pin0A, motor_pin0B);
Motor MotorRight(motor_pin1A, motor_pin1B);
///////////////////////////////////////////////////////////
#define CHANNEL_NUM 8
uint16_t channalData[CHANNEL_NUM]; //8通道数据
bool mode = 0; //nrf或者ble模式
int16_t throttle = 0; //油门
int16_t steering = 0; //转向
int safe_ms = 0;

static long map(long x, long in_min, long in_max, long out_min, long out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

int main()
{

    g_cubeTimer.start();

    mode = protocolSetup();  //遥控接收器初始化

    MotorLeft.Fix(motor_fixL);
    MotorRight.Fix(motor_fixR);

    
    while (1) {
        
        if (protocolRead(channalData, mode)) { //判断是否接收到遥控信号
            throttle = map(channalData[CHANNEL_THROTTLE], 1000, 2000, -MAX_THROTTLE, MAX_THROTTLE);
            steering = map(channalData[CHANNEL_STEERING], 1000, 2000, -MAX_STEERING, MAX_STEERING);

            MotorLeft.Driver(MotorLeft.GetData(throttle, steering, CHAN_LEFT));
            MotorRight.Driver(MotorRight.GetData(throttle, steering, CHAN_RIGHT));

            safe_ms = g_cubeTimer.read_ms();
        }

        if (safe_ms > g_cubeTimer.read_ms()) {
            safe_ms = g_cubeTimer.read_ms();
        }
        if (g_cubeTimer.read_ms() - safe_ms > SAFE_TIME_OUT) {
            MotorLeft.Free();
            MotorRight.Free();
        }
        
    } // while
}