#ifndef Motor_h
#define Motor_h

#include "mbed.h"

#define CHAN_LEFT 0
#define CHAN_RIGHT 1

typedef struct  {
    PinName nbr_A;
    PinName nbr_B;
} MotorPin_t;


typedef struct {
    MotorPin_t Pin;
} motor_t;

class Motor
{
public:
    Motor(PinName _motor_pinA, PinName _motor_pinB);
    void Fix(float _fix);
    void Driver(int16_t _motor_driver);
    void Free();
    void Brake();
    int16_t GetData(int16_t _throttle, int16_t _steering, uint8_t _dir);
private:
//    uint8_t motorIndex;               // index into the channel data for this key
    float fix;
    int16_t _motor_vol;
protected:
    pwmout_t _pwmA;
    gpio_t gpioB;
    int _period_us;
};

#endif