#include "Microduino_Motor.h"

Motor::Motor(PinName _motor_pinA, PinName _motor_pinB)
{
            _period_us = 255; // 500Hz
            pwmout_init(&_pwmA, _motor_pinA);
            pwmout_period_us(&_pwmA, _period_us); // 500Hz
            pwmout_pulsewidth_us(&_pwmA, 0);


            gpio_init_out(&gpioB, _motor_pinB);

            this->fix=1;
}

void Motor::Fix(float _fix)
{
    this->fix=_fix;
}

int16_t Motor::GetData(int16_t _throttle, int16_t _steering, uint8_t _dir)
{
    this->_motor_vol = _throttle;

    if(_dir == 1)
    {
        this->_motor_vol -= _steering / 2;
    }
    else
    {
        this->_motor_vol += _steering / 2;
    }
    if (this->_motor_vol > 255)
        this->_motor_vol = 255;
    else if (this->_motor_vol < -255)
        this->_motor_vol = -255;

    this->_motor_vol *= fix;

    return this->_motor_vol;
}

void Motor::Driver(int16_t _motor_driver)
{
    uint32_t pulseWidth = 0;

    if (_motor_driver == 0) {
        pwmout_pulsewidth_us(&_pwmA, 0);
        gpio_write(&gpioB, 0);
    } else if (_motor_driver > 0) {
        pulseWidth = _period_us / 255 * _motor_driver;
        pwmout_pulsewidth_us(&_pwmA, pulseWidth);
        gpio_write(&gpioB, 0);
    } else {
        //_motor_driver = abs(_motor_driver);
        pulseWidth = _period_us / 255 * (255 + _motor_driver);
        pwmout_pulsewidth_us(&_pwmA, pulseWidth);
        gpio_write(&gpioB, 1);
    }
}

void Motor::Free()
{
    pwmout_pulsewidth_us(&_pwmA, 0);
    gpio_write(&gpioB, 0);
}

void Motor::Brake()
{
    pwmout_pulsewidth_us(&_pwmA, _period_us);
    gpio_write(&gpioB, 1);
}