#include "mbed.h"
#include "GLCD.h"

//Host PC Baudrate (Virtual Com Port on USB)
#define D_BAUDRATE            9600
//#define D_BAUDRATE            57600

// Variables for Heartbeat and Status monitoring
//Note Port2 is used for the LCD
//DigitalOut myled1(P2_0);
//DigitalOut myled2(P2_1);
//DigitalOut myled3(P2_2);
//DigitalOut myled4(P2_3);
//DigitalOut myled5(P2_4);
//DigitalOut myled6(P2_5);
//DigitalOut myled7(P2_6);
//DigitalOut myled8(P2_7);

DigitalOut heartbeatLED(P3_26);      //SD_PWR, LD3: active low
DigitalOut USB_Device_PU(P2_9);      //USB Device Pull Up, LD14: active low (OK)
DigitalOut USB_Device_Up(P1_18);     //USB Device Up, LD13: active low (OK)
//DigitalOut USB_Host_Power(P1_19);    //USB Host Power, LD15: active low (does not seem to go high again? ?)
DigitalInOut USB_Host_Power(P1_19);    //USB Host Power, LD15: active low (does not seem to go high again? ?)

// Need this override function on non-mbed hardware to provide the MAC address.
//
// The mbed Ethernet library sets the MAC address by calling a weak function
// extern "C" void mbed_mac_address(char * mac) to copy in a 6 Byte (12 character) MAC address.
// This function performs a semihosting request to the mbed interface to get the serial number,
// which contains a MAC address unique to every mbed device.
// If you are using the eth library on your own board (i.e. not an mbed board),
// you should implement your own extern "C" void mbed_mac_address(char * mac) function
// to overwrite the existing one and avoid a call to the interface (which doesnt exist).

extern "C" void mbed_mac_address(char * mac) {

//mbed module clone
  mac[0] = 0x00;  
  mac[1] = 0x02;  
  mac[2] = 0xF7;  
  mac[3] = 0xF0;  
  mac[4] = 0x56;  
  mac[5] = 0x90;            
};

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx

// Variables for Heartbeat and Status monitoring
Ticker heartbeat;
bool heartbeatflag=false;

void clear_screen() {
//ANSI Terminal Commands
    pc.printf("\x1B[2J");
    pc.printf("\x1B[H");
}

void init_interfaces() {
    // Init Host PC communication, default is 9600
    pc.baud(D_BAUDRATE);
}
      

// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED; 
}

void heartbeat_start() {
  heartbeatLED = 0;
  heartbeat.attach(&pulse, 0.5);
}

void heartbeat_stop() {
  heartbeat.detach();
}

#if(1)
void flip_USB_Host_Power() {
 static bool pin = false;

 //USB Host Power, LD15: active low (DigitalOut does not seem to go high enough to disable?)
 if (pin) {  
   USB_Host_Power.input();         // input + pull up, power is Off
 }
 else {
   USB_Host_Power.output();        // output + low, power is On
   USB_Host_Power = 0;   
 }
 pin = !pin;   
}


void set_USB_Host_Power(bool pin) {
 //USB Host Power, LD15: active low (DigitalOut does not seem to go high enough to disable?)
 if (pin) {  
   USB_Host_Power.input();         // input + pull up, power is Off
 }
 else {
   USB_Host_Power.output();        // output + low, power is On
   USB_Host_Power = 0;   
 }
}
#endif

// GLCD
GLCD myGLCD;

int random(int max) {
  int rnd = rand() % max;

  return rnd;
}


#if(1)
void loop()
{
  int buf[318];
  int x, x2;
  int y, y2;
  int r;

// Clear the screen and draw the frame
  myGLCD.cls(White);

  myGLCD.setColor(255, 0, 0);
  myGLCD.fillRect(0, 0, 319, 13);
  myGLCD.setColor(64, 64, 64);
  myGLCD.fillRect(0, 226, 319, 239);
  myGLCD.setColor(255, 255, 255);
  myGLCD.setBackColor(255, 0, 0);
//  myGLCD.print("* Universal Color TFT Display Library *", CENTER, 1);
  myGLCD.setBackColor(64, 64, 64);
  myGLCD.setColor(255,255,0);
//  myGLCD.print("<http://electronics.henningkarlsen.com>", CENTER, 227);

  myGLCD.setColor(0, 0, 255);
  myGLCD.drawRect(0, 14, 319, 225);

// Draw crosshairs
  myGLCD.setColor(0, 0, 255);
  myGLCD.setBackColor(0, 0, 0);
  myGLCD.drawLine(159, 15, 159, 224);
  myGLCD.drawLine(1, 119, 318, 119);
  for (int i=9; i<310; i+=10)
    myGLCD.drawLine(i, 117, i, 121);
  for (int i=19; i<220; i+=10)
    myGLCD.drawLine(157, i, 161, i);

// Draw sin-, cos- and tan-lines  
  myGLCD.setColor(0,255,255);
//  myGLCD.print("Sin", 5, 15);
  for (int i=1; i<318; i++)
  {
    myGLCD.drawPixel(i,119+(sin(((i*1.13)*3.14)/180)*95));
  }
  
  myGLCD.setColor(255,0,0);
//  myGLCD.print("Cos", 5, 27);
  for (int i=1; i<318; i++)
  {
    myGLCD.drawPixel(i,119+(cos(((i*1.13)*3.14)/180)*95));
  }

  myGLCD.setColor(255,0,255);
//  myGLCD.print("Tan", 5, 39);
  for (int i=1; i<318; i++)
  {
    myGLCD.drawPixel(i,119+(tan(((i*1.13)*3.14)/180)));
  }

  wait(2);

  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);
  myGLCD.setColor(0, 0, 255);
  myGLCD.setBackColor(0, 0, 0);
  myGLCD.drawLine(159, 15, 159, 224);
  myGLCD.drawLine(1, 119, 318, 119);

// Draw a moving sinewave
  x=1;
  for (int i=1; i<(318*20); i++) 
  {
    x++;
    if (x==319)
      x=1;
    if (i>319)
    {
      if ((x==159)||(buf[x-1]==119))
        myGLCD.setColor(0,0,255);
      else
        myGLCD.setColor(0,0,0);
      myGLCD.drawPixel(x,buf[x-1]);
    }
    myGLCD.setColor(0,255,255);
    y=119+(sin(((i*1.1)*3.14)/180)*(90-(i / 100)));
    myGLCD.drawPixel(x,y);
    buf[x-1]=y;
  }

  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);

// Draw some filled rectangles
  for (int i=1; i<6; i++)
  {
    switch (i)
    {
      case 1:
        myGLCD.setColor(255,0,255);
        break;
      case 2:
        myGLCD.setColor(255,0,0);
        break;
      case 3:
        myGLCD.setColor(0,255,0);
        break;
      case 4:
        myGLCD.setColor(0,0,255);
        break;
      case 5:
        myGLCD.setColor(255,255,0);
        break;
    }
    myGLCD.fillRect(70+(i*20), 30+(i*20), 130+(i*20), 90+(i*20));
  }

  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);

// Draw some filled, rounded rectangles
  for (int i=1; i<6; i++)
  {
    switch (i)
    {
      case 1:
        myGLCD.setColor(255,0,255);
        break;
      case 2:
        myGLCD.setColor(255,0,0);
        break;
      case 3:
        myGLCD.setColor(0,255,0);
        break;
      case 4:
        myGLCD.setColor(0,0,255);
        break;
      case 5:
        myGLCD.setColor(255,255,0);
        break;
    }
    myGLCD.fillRoundRect(190-(i*20), 30+(i*20), 250-(i*20), 90+(i*20));
  }
  
  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);

// Draw some filled circles
  for (int i=1; i<6; i++)
  {
    switch (i)
    {
      case 1:
        myGLCD.setColor(255,0,255);
        break;
      case 2:
        myGLCD.setColor(255,0,0);
        break;
      case 3:
        myGLCD.setColor(0,255,0);
        break;
      case 4:
        myGLCD.setColor(0,0,255);
        break;
      case 5:
        myGLCD.setColor(255,255,0);
        break;
    }
    myGLCD.fillCircle(100+(i*20),60+(i*20), 30);
  }
  
  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);

// Draw some lines in a pattern
  myGLCD.setColor (255,0,0);
  for (int i=15; i<224; i+=5)
  {
    myGLCD.drawLine(1, i, (i*1.44)-10, 224);
  }
  myGLCD.setColor (255,0,0);
  for (int i=224; i>15; i-=5)
  {
    myGLCD.drawLine(318, i, (i*1.44)-11, 15);
  }
  myGLCD.setColor (0,255,255);
  for (int i=224; i>15; i-=5)
  {
    myGLCD.drawLine(1, i, 331-(i*1.44), 15);
  }
  myGLCD.setColor (0,255,255);
  for (int i=15; i<224; i+=5)
  {
    myGLCD.drawLine(318, i, 330-(i*1.44), 224);
  }
  
  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,225);

// Draw some random circles
  for (int i=0; i<100; i++)
  {
    myGLCD.setColor(random(255), random(255), random(255));
    x=32+random(256);
    y=45+random(146);
    r=random(30);
    myGLCD.drawCircle(x, y, r);
  }

  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);

// Draw some random rectangles
  for (int i=0; i<100; i++)
  {
    myGLCD.setColor(random(255), random(255), random(255));
    x=2+random(316);
    y=16+random(207);
    x2=2+random(316);
    y2=16+random(207);
    myGLCD.drawRect(x, y, x2, y2);
  }

  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);

// Draw some random rounded rectangles
  for (int i=0; i<100; i++)
  {
    myGLCD.setColor(random(255), random(255), random(255));
    x=2+random(316);
    y=16+random(207);
    x2=2+random(316);
    y2=16+random(207);
    myGLCD.drawRoundRect(x, y, x2, y2);
  }

  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);

  for (int i=0; i<100; i++)
  {
    myGLCD.setColor(random(255), random(255), random(255));
    x=2+random(316);
    y=16+random(209);
    x2=2+random(316);
    y2=16+random(209);
    myGLCD.drawLine(x, y, x2, y2);
  }

  wait(2);
  
  myGLCD.setColor(0,0,0);
  myGLCD.fillRect(1,15,318,224);

  for (int i=0; i<10000; i++)
  {
    myGLCD.setColor(random(255), random(255), random(255));
    myGLCD.drawPixel(2+random(316), 16+random(209));
  }

  wait(2);

  myGLCD.cls(Blue);  

  myGLCD.setColor(255, 0, 0);
  myGLCD.fillRoundRect(80, 70, 239, 169);
  
  myGLCD.setColor(255, 255, 255);
  myGLCD.setBackColor(255, 0, 0);
//  myGLCD.print("That's it!", CENTER, 93);
//  myGLCD.print("Restarting in a", CENTER, 119);
//  myGLCD.print("few seconds...", CENTER, 132);
  
  myGLCD.setColor(0, 255, 0);
  myGLCD.setBackColor(0, 0, 255);
//  myGLCD.print("Runtime: (msecs)", CENTER, 210);
//  myGLCD.printNumI(millis(), CENTER, 225);
  
  wait(2);
}
#endif


int main() {
    init_interfaces();
    
    clear_screen(); 
    
    heartbeat_start();    
  
    pc.printf("Hello World!\n\r");
    pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);       
    
#if(1)
    myGLCD.cls(White);
    myGLCD.setColor(Red);
    myGLCD.setBackColor(White);
    myGLCD.printf ("Hi Willem\n"); 
    myGLCD.printf("CPU SystemCoreClock is %d Hz\n", SystemCoreClock);              
        
    wait(0.5);
    
    myGLCD.drawRect (100, 100, 150, 150);

    myGLCD.setColor   (Green);    
    myGLCD.drawHLine (120, 160, 80);
    myGLCD.drawVLine (160, 120, 80);
    
    myGLCD.setColor   (Blue);    
    myGLCD.fillRoundRect  (100, 100, 130, 130);
    myGLCD.setColor   (Cyan);    
    myGLCD.drawCircle     (160, 160, 40);
       
    pc.printf("LCD Controller ID = 0x%04X\n\r", myGLCD.getDriverCode());    
    pc.printf("PixelsY= %d, PixelsX= %d\n\r", myGLCD.getDisplayYSize(), myGLCD.getDisplayXSize());            
    pc.printf("Lines= %d, Cols= %d\n\r", myGLCD.getRows(), myGLCD.getCols());        

#if(1)
    wait(2);
    loop();
#endif

    myGLCD.setColor(Black);
    myGLCD.locate(9,0);            
    myGLCD.printf("Bye Willem");        
#endif    
    pc.printf("Bye World!\n\r"); 

    USB_Device_PU  = 1;   //USB Device Pull Up, LD14: active low
    USB_Device_Up  = 1;   //USB Device Up, LD13: active low
    
    while (1) {
      //USB_Host_Power = !USB_Host_Power;  //Does not switch off!
      flip_USB_Host_Power();
      USB_Device_PU  = !USB_Device_PU;
      USB_Device_Up  = !USB_Device_Up;
      
      pc.putc('*');       
      wait(1.5);
    }  
}
