#include "mbed.h"
#include "SerLCDv25.h"



SerLCDv25::SerLCDv25(PinName rx, PinName tx) {
    device = new Serial(rx, tx);
}


void SerLCDv25::clear() {
    device->printf("%c%c",0xFE,0x01);
}
void SerLCDv25::cursorUnderline() {
    device->printf("%c%c",0xFE,0x0E);
}
void SerLCDv25::cursorBlinkingBox() {
    device->printf("%c%c",0xFE,0x0D);
}
void SerLCDv25::cursorClear() {
    device->printf("%c%c",0xFE,0x0C);
}
void SerLCDv25::displayON() {
    device->printf("%c%c",0xFE,0x0C);
}
void SerLCDv25::displayOFF() {
    device->printf("%c%c",0xFE,0x08);
}
void SerLCDv25::printf(char *string) {
    device->printf("%s",string);
}
void SerLCDv25::printValue(float *Value) {
    device->printf("%4.2f",*Value);
}
void SerLCDv25::putc(char lettre) {
    device->printf("%c",lettre);
}
void SerLCDv25::Brightness(int Value) {
    if (Value<0) {
        Value=0;
    }
    if (Value>100) {
        Value=100;
    }
    Value=Value*29/100+128;
    device->printf("%c%c",0x7C,Value);
}











