#include "mbed.h"
#include "nRF24L01P.h"
 
Serial pc(USBTX, USBRX); // tx, rx
 
nRF24L01P NRFT(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

AnalogIn Vert(p19);
AnalogIn Horz(p20);
AnalogIn Lslide(p16);
AnalogIn Rslide(p15);

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);
 
int main() {
 
// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   17
 
    char txData[TRANSFER_SIZE];
    //int txDataCnt = 0;
 
    NRFT.powerUp();
 
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  NRFT.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  NRFT.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", NRFT.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", NRFT.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", NRFT.getRxAddress() );
 
    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
 
    NRFT.setTransferSize( TRANSFER_SIZE );
 
    NRFT.setTransmitMode();
    NRFT.enable();
 
    while (1) {
 
        /*// If we've received anything over the host serial link...
        if ( pc.readable() ) {
 
            // ...add it to the transmit buffer
            txData[txDataCnt++] = pc.getc();
 
            // If the transmit buffer is full
            if ( txDataCnt >= sizeof( txData ) ) {
 
                // Send the transmitbuffer via the nRF24L01+
                NRFT.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
 
                txDataCnt = 0;
            }
 
            // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
            myled1 = !myled1;
        }*/
        int LSL,RSL,VER,HOR;
        
        while(1)
        {
        //wait(0.1);
        
            LSL = float(Lslide)*1000;
            txData[0] = LSL & 255;
            txData[1] = (LSL >> 8) & 255;
            txData[2] = (LSL >> 16) & 255;
            txData[3] = (LSL >> 24) & 255;
            led1 = Lslide;
            
            VER = float(Vert)*1000;
            txData[4] = VER & 255;
            txData[5] = (VER >> 8) & 255;
            txData[6] = (VER >> 16) & 255;
            txData[7] = (VER >> 24) & 255;
            led2 = Vert;
            
            HOR = float(Horz)*1000;
            txData[8] = HOR & 255;
            txData[9] = (HOR >> 8) & 255;
            txData[10] = (HOR >> 16) & 255;
            txData[11] = (HOR >> 24) & 255;
            led3 = Horz;
            
            RSL = float(Rslide)*1000;
            txData[12] = RSL & 255;
            txData[13] = (RSL >> 8) & 255;
            txData[14] = (RSL >> 16) & 255;
            txData[15] = (RSL >> 24) & 255;
            led4 = Rslide;
            txData[16] = 'a';
        
            NRFT.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE );
            //wait(0.1);
        }
    }
}