#include "VNH5019MC.h"

VNH5019MC::VNH5019MC(PinName M1En, PinName M1InA, PinName M1InB, PinName M1Pwm):
            mM1En(M1En), mM1InA(M1InA), mM1InB(M1InB), mM1Pwm(M1Pwm){
    mM1En = 0;
    mM1InA = 0;
    mM1InB = 0;
    mM1Pwm.period_us(50); // PWM Frequency: 20KHz 
    mM1Pwm = 0;
} 

void VNH5019MC::move(double duty){
    if (duty > 0){
        backward(duty);
    } else {
        forward(-duty);
    }
}

void VNH5019MC::forward(double duty){
    mM1En = 0; 
    mM1InA = 1;
    mM1InB = !mM1InA;
    mM1Pwm = duty/100;
    mM1En = 1;
}

void VNH5019MC::backward(double duty){
    mM1InA = 0; 
    mM1InB = !mM1InA;
    mM1Pwm = duty/100;
    mM1En = 1;
}


void VNH5019MC::stop(){
    mM1InA = 0;
    mM1InB = 0;
    mM1En = 0;
    mM1Pwm = 0;
}