
/*
    Simple test shell to exercise mouse,keyboard,mass storage and hubs.
    Add 2 15k pulldown resistors between D+/D- and ground, attach a usb socket and have at it.
*/

#include "mbed.h"
#include "Wiimote.h"

//-- Peripheral Declaration --//
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
const int ON = 1;
const int OFF = 0;


Serial pc(USBTX, USBRX);
/*
int GetConsoleChar()
{
    if (!pc.readable())
        return -1;
    char c = pc.getc();
    pc.putc(c); // echo
    return c;
}
*/
Wiimote wii;
// this is called by the USB infrastructure when a wii message comes in
void wii_interrupt() {

    // temporary action triggers
    if (wii.up)   {
        led2 = ON;
    } else {
        led2 = OFF;
    }
    if (wii.down) {
        led3 = ON;
    } else {
        led3 = OFF;
    }
    if (wii.left) {
        led1 = ON; 
    } else {
        led1 = OFF;
    }  
    if (wii.right) {
        led4 = ON;
        if (!wii.isOn(WIILED4)) wii.turnOn(WIILED4);
    } else {
        if (wii.isOn(WIILED4)) wii.turnOff(WIILED4);
        led4 = OFF;
    }
    if (wii.a) {
        led1 = led2 = led3 = led4 = ON; 
        if (!wii.isOn(WIILED2+WIILED3+WIILED4)) wii.turnOn(WIILED2+WIILED3+WIILED4);
    } else {
        led1 = led2 = led3 = led4 = OFF;
        if (wii.isOn(WIILED2+WIILED3+WIILED4)) wii.turnOff(WIILED2+WIILED3+WIILED4);
    }  
    if (wii.plus) {
        if (!wii.isOn(WIIRUMBLE))wii.turnOn(WIIRUMBLE);
    } 
    if (wii.minus) {
        if (wii.isOn(WIIRUMBLE))wii.turnOff(WIIRUMBLE);
    } 
}

void startWiiCom(const char * wiiMAC);

int main()
{
    char controller01[] = "00:1F:C5:4C:29:99";   // S.NAKAMURA 01
    char controller02[] = "00:21:47:F6:21:D8";    // S.NAKAMURA 02
    pc.baud(115200);
    printf("BlueUSB\nNow get a bunch of usb or bluetooth things and plug them in\n");
    startWiiCom(controller01);
}
