#include "mbed.h"
#include <iostream>

using namespace std;

PwmOut myservo(p21);
Serial pc(USBTX, USBRX);

const int maxPW = 2000;
const int neutralPW = 1500;
const int minPW = 1000;
const int period = 20; //ms 50Hz

void limit(int &pw){
    if (pw > maxPW)
        pw = maxPW;
    if (pw < minPW)
        pw =  minPW;
}

int pulseWidth = neutralPW;

int main() {
    pc.baud(115200);
    cout << "MBED ESC Interface:\r" << endl;
    cout << "Pulsewidth range: " << minPW << " - " << maxPW << "us\r" << endl;
    cout << "1,2,3 - PulseWidth (min, neutral, Max)\r" << endl; 
    cout << "a,s, z,x - PulseWidth (-10, + 10, -1, +1)\r" << endl; 
    
    myservo.period_ms(period); // 50Hz 
    myservo.pulsewidth_us(pulseWidth); // neutral
    
    while(1) {   
        cout << "Current pulsewidth: " << pulseWidth << "us \r" << endl;                
        switch(pc.getc()) {
            case '1': 
                pulseWidth = minPW;
                break;
            case '2': 
                pulseWidth = neutralPW;
                break;
            case '3': 
                pulseWidth = maxPW;
                break; 
            case 'a':
                pulseWidth -= 10;
                limit(pulseWidth);
                break;
            case 's':
                pulseWidth += 10;
                limit(pulseWidth);
                break;
            case 'z':
                pulseWidth -= 1;
                limit(pulseWidth);
                break;
            case 'x':
                pulseWidth += 1;
                limit(pulseWidth);
                break;
        } 
        
        myservo.pulsewidth_us(pulseWidth);  
        
    }
}
