#ifndef ENCODER_DSPIC33F_H
#define ENCODER_DSPIC33F_H

/**
 * Includes
 */
#include "mbed.h" 


class Encoder_dspic33f {
private:

    typedef union bytesFloat {
        float f;
        char c[4];
    }bytesFloat;
    
    typedef union bytes16Int {
        int16_t i;
        char c[2];
    }bytes16Int;

public:

    /**
     * Constructor.
     *
     * @param sda mbed pin to use for sda line of I2C interface.
     * @param scl mbed pin to use for SCL line of I2C interface.
     * @param resolution encoder resolution in x2 mode
     * @param freq i2c frequency
     * @param invert change polarity of encoder count
     * Usage: Encoder_dspic encoder_left(p9, p10, 10000, 0x08);
     */
    Encoder_dspic33f(PinName sda, PinName scl, int16_t resolution, int address, int freq=400000, bool invert = false);
    
    /**
     * Reset encoders.
     * set revolution count and POSXCNT to zero 
     *
     * @return void
     */
    void reset(void);
    
    /**
     * Set encoders resolution
     * resolution: number of pulse per revolution using X2 encoding
     *
     * @return void
     */
    void set_resolution(int16_t resolution);
    
    /**
     * Read angle values (radian) of encoders 
     *
     * @argument array of size 2 containing {angleEncA, angleEncB}
     */
    void read(double *inarr);
    
private:
    I2C i2c_;     
    int address_;
    int invert_;
    int16_t resolution_;
     
};
#endif /* ENCODER_DSPIC_H */