#include "Encoder_dspic33f.h"

Encoder_dspic33f::Encoder_dspic33f(PinName sda, PinName scl,int16_t resolution, int address, int freq, bool invert) : 
    i2c_(sda,scl),    
    address_ (address),
    resolution_ (resolution){
    //400KHz, as specified by the datasheet.
    i2c_.frequency(freq);
    //set_resolution(_resolution);
    if (invert) {
       invert_ = -1;
    } else {
       invert_ = 1;
    }
    wait_us(500);
}

void Encoder_dspic33f::reset(void){
    char rst = 'r';
    i2c_.write( (address_<< 1)  & 0xFE, &rst, 1);
}
  

void Encoder_dspic33f::set_resolution(int16_t resolution){
    char cmd = 'e';
    char dat[3];
    bytes16Int b;
    b.i = resolution;
    dat[0] = cmd;
    dat[1] = b.c[0];
    dat[2] = b.c[1];
    i2c_.write( (address_<< 1)  & 0xFE, dat, 3);
}

void Encoder_dspic33f::read(double * inarr){
    char rx[8];   
    float data[2] = {0.0, 0.0};
    bytesFloat b1, b2;
       
    i2c_.read((address_<< 1) | 0x01, rx, 8);
    
    for (int i = 0; i<4; ++i)
        b1.c[i] = rx[i];
    
    for (int i = 4; i<8; ++i)
        b2.c[i-4] = rx[i]; 
        
    inarr[0] = (double)b1.f;
    inarr[1] = (double)b2.f;
}
