/* Copyright (c) 2011, mbed
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *  
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *  
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
// Simple decoder class for Wii Remote data

#ifndef WIIMOTE_H
#define WIIMOTE_H

#include <stdint.h>

const int WIILED1 = 0x10;
const int WIILED2 = 0x20;
const int WIILED3 = 0x40;
const int WIILED4 = 0x80;
const int WIIRUMBLE = 0x01;

class Wiimote {

    int _control;   // Sockets for control (out) and interrupt (in)
public: 
    Wiimote();
    void setControl(const int& control);
    void decode(char *data);
    void dump();
    void turnOn(const int i);
    void turnOff(const int i);
    void toggle(const int i);
    bool isOn(const int i);
    
    // buttons
    uint32_t left:1;
    uint32_t right:1;
    uint32_t down:1;
    uint32_t up:1;
    uint32_t plus:1;
    uint32_t two:1;
    uint32_t one:1;
    uint32_t a:1;
    uint32_t b:1;
    uint32_t minus:1;
    uint32_t home:1;

    // accelerometers
    uint16_t rawx;
    uint16_t rawy;
    uint16_t rawz;
    
    float x;
    float y;
    float z;
    float wheel;
    
    // LED, Rumble status
    uint32_t ledRumbleState;
};

#endif
     