#include "Misc/SerialOutputLogger.h"

SerialOutputLogger::SerialOutputLogger(Serial *serialPort, IMU_RegisterDataBuffer_t *imuRegisterDataBuffer, RadioDecoder_RegisterDataBuffer_t *radioDecoderRegisterDataBuffer) {
    this->serialPort = serialPort;
    this->imuRegisterDataBuffer = imuRegisterDataBuffer;
    this->radioDecoderRegisterDataBuffer = radioDecoderRegisterDataBuffer;
}

void SerialOutputLogger::writeRadioDecoderDataLog(bool csv) {
    if (csv) {
        for(uint8_t i=0; i<3; i++) {
            serialPort->printf("%d, ", radioDecoderRegisterDataBuffer->channelValid[i]);
            serialPort->printf("%d, ", radioDecoderRegisterDataBuffer->channelActiveTime[i]);
            if (i == 2) {
                serialPort->printf("%d\r\n", radioDecoderRegisterDataBuffer->channelPercent[i]);
            }
        }
    } else {
        for(uint8_t i=0; i<3; i++) {
            serialPort->printf("RadioDecoder - Ch[%d] Valid:      %d\r\n",i,radioDecoderRegisterDataBuffer->channelValid[i]);
            serialPort->printf("RadioDecoder - Ch[%d] ActiveTime: %d\r\n",i,radioDecoderRegisterDataBuffer->channelActiveTime[i]);
            serialPort->printf("RadioDecoder - Ch[%d] Percentage: %d\r\n\r\n",i,radioDecoderRegisterDataBuffer->channelPercent[i]);
        }
    }
}


void SerialOutputLogger::writeImuDataLog(bool csv) {
    if (csv) {
        
    } else {
        
    }
}