#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_16
#define RB_LV_FONT_ROBOTO_16 1
#endif

#if RB_LV_FONT_ROBOTO_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xad, 0xac, 0xac, 0xac, 0xac, 0xac, 0x9b, 0x9b,
    0x56, 0x0, 0x57, 0x8c,

    /* U+22 "\"" */
    0xe2, 0xd4, 0xe2, 0xd3, 0xe0, 0xd2, 0xe0, 0xd1,
    0x0, 0x0,

    /* U+23 "#" */
    0x0, 0x0, 0xb6, 0x8, 0x90, 0x0, 0x0, 0xe3,
    0xb, 0x60, 0x0, 0x2, 0xf0, 0xf, 0x20, 0x7,
    0xff, 0xff, 0xff, 0xfa, 0x1, 0x29, 0xa2, 0x7c,
    0x21, 0x0, 0xb, 0x60, 0x89, 0x0, 0x0, 0xe,
    0x30, 0xb6, 0x0, 0xf, 0xff, 0xff, 0xff, 0xf0,
    0x2, 0x6d, 0x23, 0xf3, 0x20, 0x0, 0x6b, 0x3,
    0xe0, 0x0, 0x0, 0x98, 0x6, 0xb0, 0x0, 0x0,
    0xb6, 0x8, 0x90, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0xe, 0x40,
    0x0, 0x0, 0x2, 0xe6, 0x0, 0x0, 0xa, 0xff,
    0xfc, 0x10, 0x6, 0xf5, 0x4, 0xfa, 0x0, 0xac,
    0x0, 0x8, 0xe0, 0x9, 0xe0, 0x0, 0x26, 0x0,
    0x2f, 0xc3, 0x0, 0x0, 0x0, 0x3c, 0xfd, 0x50,
    0x0, 0x0, 0x3, 0xaf, 0x80, 0x1, 0x0, 0x0,
    0x9f, 0x0, 0xf6, 0x0, 0x5, 0xf1, 0xc, 0xd1,
    0x1, 0xce, 0x0, 0x3e, 0xfe, 0xff, 0x40, 0x0,
    0x5, 0xf6, 0x10, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+25 "%" */
    0x5, 0xee, 0x90, 0x0, 0x0, 0x0, 0xf, 0x31,
    0xd5, 0x0, 0x70, 0x0, 0x2e, 0x0, 0x97, 0x8,
    0x90, 0x0, 0xf, 0x31, 0xd5, 0x2e, 0x10, 0x0,
    0x5, 0xde, 0x90, 0xb5, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x29,
    0xec, 0x20, 0x0, 0x0, 0x98, 0x6c, 0x17, 0xc0,
    0x0, 0x3, 0xe0, 0x97, 0x1, 0xf0, 0x0, 0xd,
    0x50, 0x97, 0x1, 0xf0, 0x0, 0x19, 0x0, 0x6c,
    0x7, 0xc0, 0x0, 0x0, 0x0, 0x9, 0xfc, 0x20,

    /* U+26 "&" */
    0x0, 0x3c, 0xfd, 0x40, 0x0, 0x0, 0xec, 0x4a,
    0xf1, 0x0, 0x3, 0xf3, 0x1, 0xf3, 0x0, 0x2,
    0xf5, 0x6, 0xf1, 0x0, 0x0, 0xbd, 0x8f, 0x50,
    0x0, 0x0, 0x3f, 0xf3, 0x0, 0x0, 0x2, 0xec,
    0xf8, 0x0, 0x71, 0xd, 0xc0, 0x7f, 0x42, 0xf1,
    0x2f, 0x40, 0xa, 0xf9, 0xe0, 0x1f, 0x60, 0x0,
    0xcf, 0x70, 0xa, 0xe4, 0x15, 0xef, 0xb0, 0x0,
    0x8d, 0xfd, 0x85, 0xf8,

    /* U+27 "'" */
    0x3f, 0x3f, 0x3e, 0x2c,

    /* U+28 "(" */
    0x0, 0x2, 0x0, 0x3, 0xe1, 0x1, 0xe5, 0x0,
    0x9b, 0x0, 0x1f, 0x40, 0x6, 0xf0, 0x0, 0xab,
    0x0, 0xd, 0x90, 0x0, 0xe8, 0x0, 0xe, 0x70,
    0x0, 0xe8, 0x0, 0xb, 0xa0, 0x0, 0x8d, 0x0,
    0x3, 0xf1, 0x0, 0xd, 0x70, 0x0, 0x4f, 0x10,
    0x0, 0x9c, 0x0, 0x0, 0x80,

    /* U+29 ")" */
    0x20, 0x0, 0x8, 0xa0, 0x0, 0xd, 0x70, 0x0,
    0x4f, 0x10, 0x0, 0xd8, 0x0, 0x7, 0xe0, 0x0,
    0x4f, 0x20, 0x1, 0xf5, 0x0, 0xf, 0x60, 0x0,
    0xf6, 0x0, 0x1f, 0x50, 0x3, 0xf3, 0x0, 0x6f,
    0x0, 0xa, 0xb0, 0x0, 0xf4, 0x0, 0x8c, 0x0,
    0x4e, 0x20, 0x6, 0x20, 0x0,

    /* U+2A "*" */
    0x0, 0x1f, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x9b,
    0x6f, 0x5b, 0x73, 0x8d, 0xfd, 0x83, 0x0, 0xde,
    0xa0, 0x0, 0x9c, 0x1f, 0x50, 0x7, 0x30, 0x66,
    0x0,

    /* U+2B "+" */
    0x0, 0x2, 0xa2, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x11, 0x4f,
    0x51, 0x10, 0x6f, 0xff, 0xff, 0xff, 0x61, 0x44,
    0x7f, 0x74, 0x41, 0x0, 0x3, 0xf3, 0x0, 0x0,
    0x0, 0x3f, 0x30, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0,

    /* U+2C "," */
    0xf, 0x60, 0xf5, 0x4f, 0x28, 0x90, 0x0, 0x0,

    /* U+2D "-" */
    0x0, 0x0, 0xb, 0xff, 0xf1, 0x23, 0x33, 0x0,

    /* U+2E "." */
    0x88, 0xab,

    /* U+2F "/" */
    0x0, 0x0, 0x4e, 0x0, 0x0, 0xa, 0x90, 0x0,
    0x0, 0xf3, 0x0, 0x0, 0x6d, 0x0, 0x0, 0xc,
    0x70, 0x0, 0x2, 0xf1, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0xd, 0x60, 0x0, 0x3, 0xf0, 0x0, 0x0,
    0x9a, 0x0, 0x0, 0xe, 0x40, 0x0, 0x5, 0xe0,
    0x0, 0x0, 0xa9, 0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x6d, 0xfd, 0x60, 0x0, 0x5f, 0x84, 0x9f,
    0x50, 0xc, 0xb0, 0x0, 0xbc, 0x0, 0xf7, 0x0,
    0x7, 0xf0, 0x1f, 0x50, 0x0, 0x5f, 0x1, 0xf5,
    0x0, 0x5, 0xf1, 0x1f, 0x50, 0x0, 0x5f, 0x11,
    0xf6, 0x0, 0x6, 0xf0, 0xf, 0x70, 0x0, 0x7f,
    0x0, 0xcb, 0x0, 0xc, 0xb0, 0x5, 0xf9, 0x48,
    0xf5, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+31 "1" */
    0x0, 0x39, 0xa5, 0xdf, 0xfb, 0x99, 0x2c, 0xb0,
    0x0, 0xcb, 0x0, 0xc, 0xb0, 0x0, 0xcb, 0x0,
    0xc, 0xb0, 0x0, 0xcb, 0x0, 0xc, 0xb0, 0x0,
    0xcb, 0x0, 0xc, 0xb0, 0x0, 0xcb,

    /* U+32 "2" */
    0x0, 0x7d, 0xfd, 0x60, 0x0, 0x9f, 0x74, 0x9f,
    0x60, 0x1f, 0x60, 0x0, 0xcc, 0x2, 0xa2, 0x0,
    0x9, 0xd0, 0x0, 0x0, 0x0, 0xd9, 0x0, 0x0,
    0x0, 0x7f, 0x10, 0x0, 0x0, 0x4f, 0x60, 0x0,
    0x0, 0x2e, 0x90, 0x0, 0x0, 0x1d, 0xa0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0xa, 0xf4, 0x33,
    0x33, 0x10, 0xff, 0xff, 0xff, 0xf6,

    /* U+33 "3" */
    0x0, 0x8d, 0xfd, 0x50, 0xa, 0xe6, 0x48, 0xf5,
    0xf, 0x60, 0x0, 0xca, 0x1, 0x0, 0x0, 0xcb,
    0x0, 0x0, 0x16, 0xf4, 0x0, 0xf, 0xff, 0x70,
    0x0, 0x3, 0x49, 0xf4, 0x0, 0x0, 0x0, 0xbc,
    0x16, 0x10, 0x0, 0x8e, 0x1f, 0x60, 0x0, 0xbc,
    0xa, 0xe6, 0x48, 0xf4, 0x0, 0x8d, 0xfc, 0x50,

    /* U+34 "4" */
    0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x6, 0xff,
    0x0, 0x0, 0x1, 0xec, 0xf0, 0x0, 0x0, 0xac,
    0x6f, 0x0, 0x0, 0x3f, 0x26, 0xf0, 0x0, 0xd,
    0x80, 0x6f, 0x0, 0x7, 0xe0, 0x6, 0xf0, 0x1,
    0xf5, 0x0, 0x6f, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xa1, 0x33, 0x33, 0x8f, 0x32, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x0, 0x0, 0x6f, 0x0,

    /* U+35 "5" */
    0xd, 0xff, 0xff, 0xf0, 0xf, 0xa6, 0x66, 0x60,
    0x1f, 0x40, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0,
    0x4f, 0xcf, 0xfb, 0x10, 0x4f, 0x84, 0x7f, 0xb0,
    0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x2, 0xf4,
    0x43, 0x0, 0x2, 0xf4, 0x9d, 0x0, 0x6, 0xf1,
    0x2f, 0xa4, 0x6f, 0xa0, 0x3, 0xcf, 0xe9, 0x0,

    /* U+36 "6" */
    0x0, 0x3b, 0xe9, 0x0, 0x6, 0xfb, 0x62, 0x0,
    0x1f, 0x80, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0xcb, 0xbf, 0xf9, 0x0, 0xef, 0xa4, 0x7f, 0x80,
    0xfb, 0x0, 0x8, 0xf0, 0xf8, 0x0, 0x4, 0xf2,
    0xd9, 0x0, 0x4, 0xf2, 0x9e, 0x0, 0x8, 0xf0,
    0x2f, 0xc5, 0x7f, 0x70, 0x3, 0xcf, 0xe8, 0x0,

    /* U+37 "7" */
    0x6f, 0xff, 0xff, 0xff, 0x41, 0x33, 0x33, 0x38,
    0xf1, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0x0,
    0x3f, 0x20, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x6, 0xf1, 0x0,
    0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0x4f, 0x30,
    0x0, 0x0, 0xb, 0xc0, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x6d, 0xfd, 0x60, 0x0, 0x6f, 0x84, 0x8f,
    0x60, 0xc, 0xb0, 0x0, 0xbb, 0x0, 0xca, 0x0,
    0xa, 0xc0, 0x6, 0xf4, 0x5, 0xf6, 0x0, 0x9,
    0xff, 0xf9, 0x0, 0x5, 0xf7, 0x47, 0xf5, 0x0,
    0xe9, 0x0, 0x9, 0xe0, 0x1f, 0x50, 0x0, 0x5f,
    0x10, 0xf8, 0x0, 0x8, 0xf0, 0x8, 0xf7, 0x47,
    0xf7, 0x0, 0x7, 0xdf, 0xd7, 0x0,

    /* U+39 "9" */
    0x0, 0x7e, 0xfc, 0x30, 0x7, 0xf8, 0x5c, 0xf1,
    0xe, 0x90, 0x1, 0xf8, 0x2f, 0x40, 0x0, 0xac,
    0x3f, 0x40, 0x0, 0x8e, 0xf, 0x70, 0x0, 0xae,
    0xa, 0xe4, 0x17, 0xfe, 0x1, 0xcf, 0xfc, 0xac,
    0x0, 0x2, 0x20, 0xc8, 0x0, 0x0, 0x5, 0xf2,
    0x0, 0x26, 0xaf, 0x70, 0x0, 0x9e, 0xb5, 0x0,

    /* U+100 "Ā" */
    0x0, 0x5f, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x22,
    0x22, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0,
    0x0, 0x0, 0xf, 0xf6, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0xc0, 0x0, 0x0, 0x0, 0xbb, 0x4f, 0x20,
    0x0, 0x0, 0x1f, 0x60, 0xf8, 0x0, 0x0, 0x6,
    0xf1, 0xa, 0xd0, 0x0, 0x0, 0xcc, 0x0, 0x5f,
    0x30, 0x0, 0x2f, 0x70, 0x1, 0xf9, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0xdc, 0x33, 0x33,
    0x6f, 0x50, 0x3f, 0x50, 0x0, 0x0, 0xeb, 0x9,
    0xe0, 0x0, 0x0, 0x8, 0xf1,

    /* U+101 "ā" */
    0x0, 0xff, 0xff, 0xf3, 0x0, 0x22, 0x22, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfd, 0x50,
    0xb, 0xe5, 0x48, 0xf2, 0x4, 0x20, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+102 "Ă" */
    0x0, 0xf, 0x40, 0xc7, 0x0, 0x0, 0x0, 0x5d,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xbc, 0x0,
    0x0, 0x0, 0xb, 0xb4, 0xf2, 0x0, 0x0, 0x1,
    0xf6, 0xf, 0x80, 0x0, 0x0, 0x6f, 0x10, 0xad,
    0x0, 0x0, 0xc, 0xc0, 0x5, 0xf3, 0x0, 0x2,
    0xf7, 0x0, 0x1f, 0x90, 0x0, 0x8f, 0xff, 0xff,
    0xfe, 0x0, 0xd, 0xc3, 0x33, 0x36, 0xf5, 0x3,
    0xf5, 0x0, 0x0, 0xe, 0xb0, 0x9e, 0x0, 0x0,
    0x0, 0x8f, 0x10,

    /* U+103 "ă" */
    0x0, 0xa9, 0x7, 0xc0, 0x0, 0x2c, 0xfc, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7d, 0xfd, 0x50,
    0x8, 0xf6, 0x48, 0xf2, 0xb, 0x70, 0x0, 0xe7,
    0x0, 0x7c, 0xef, 0xf8, 0x9, 0xe5, 0x22, 0xe8,
    0xf, 0x60, 0x0, 0xe8, 0x1f, 0x60, 0x2, 0xf8,
    0xc, 0xe6, 0x6e, 0xf9, 0x2, 0xbf, 0xe6, 0xa9,

    /* U+104 "Ą" */
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x0, 0xf,
    0xf6, 0x0, 0x0, 0x0, 0x5, 0xe8, 0xc0, 0x0,
    0x0, 0x0, 0xb9, 0x2f, 0x20, 0x0, 0x0, 0x1f,
    0x30, 0xc8, 0x0, 0x0, 0x6, 0xd0, 0x6, 0xd0,
    0x0, 0x0, 0xc7, 0x0, 0x1f, 0x30, 0x0, 0x2f,
    0xff, 0xff, 0xf9, 0x0, 0x8, 0xc3, 0x33, 0x37,
    0xe0, 0x0, 0xd7, 0x0, 0x0, 0xf, 0x50, 0x3f,
    0x30, 0x0, 0x0, 0xbb, 0x9, 0xe0, 0x0, 0x0,
    0x7, 0xf1, 0x0, 0x0, 0x0, 0x2, 0xd4, 0x0,
    0x0, 0x0, 0x0, 0x9b, 0x30, 0x0, 0x0, 0x0,
    0x5, 0xfd, 0x0,

    /* U+105 "ą" */
    0x0, 0x9e, 0xfd, 0x50, 0xb, 0xe5, 0x48, 0xf2,
    0x4, 0x20, 0x0, 0xe7, 0x0, 0x7c, 0xef, 0xf8,
    0x9, 0xe5, 0x22, 0xe8, 0xf, 0x60, 0x0, 0xe8,
    0x1f, 0x60, 0x2, 0xf8, 0xc, 0xe6, 0x6e, 0xf9,
    0x2, 0xbf, 0xe6, 0xdb, 0x0, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0xf, 0x62, 0x0, 0x0, 0x9, 0xf9,

    /* U+106 "Ć" */
    0x0, 0x0, 0x1, 0x74, 0x0, 0x0, 0x0, 0x9,
    0xd1, 0x0, 0x0, 0x0, 0x3e, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xdf, 0xe8,
    0x0, 0x0, 0xce, 0x75, 0x7f, 0xb0, 0x6, 0xf3,
    0x0, 0x4, 0xf5, 0xc, 0xb0, 0x0, 0x0, 0xd8,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0xc7, 0x7, 0xf3, 0x0, 0x4, 0xf5, 0x0, 0xce,
    0x74, 0x7e, 0xb0, 0x0, 0x9, 0xef, 0xd7, 0x0,

    /* U+107 "ć" */
    0x0, 0x0, 0x8e, 0x30, 0x0, 0x4, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x50,
    0x7, 0xf8, 0x49, 0xf4, 0xe, 0x90, 0x0, 0xbb,
    0x3f, 0x40, 0x0, 0x12, 0x4f, 0x20, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0xf, 0x80, 0x0, 0x9a,
    0x7, 0xf7, 0x48, 0xf5, 0x0, 0x7d, 0xfd, 0x50,

    /* U+108 "Ĉ" */
    0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x1, 0xdd,
    0x80, 0x0, 0x0, 0xb, 0x80, 0xd4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xdf, 0xe8,
    0x0, 0x0, 0xce, 0x75, 0x7f, 0xb0, 0x6, 0xf3,
    0x0, 0x4, 0xf5, 0xc, 0xb0, 0x0, 0x0, 0xd8,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0xc7, 0x7, 0xf3, 0x0, 0x4, 0xf5, 0x0, 0xce,
    0x74, 0x7e, 0xb0, 0x0, 0x9, 0xef, 0xd7, 0x0,

    /* U+109 "ĉ" */
    0x0, 0xc, 0xd2, 0x0, 0x0, 0xb6, 0x3c, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x50,
    0x7, 0xf8, 0x49, 0xf4, 0xe, 0x90, 0x0, 0xbb,
    0x3f, 0x40, 0x0, 0x12, 0x4f, 0x20, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0xf, 0x80, 0x0, 0x9a,
    0x7, 0xf7, 0x48, 0xf5, 0x0, 0x7d, 0xfd, 0x50,

    /* U+10A "Ċ" */
    0x0, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x3a,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xdf, 0xe8, 0x0, 0x0, 0xce, 0x75, 0x7f,
    0xb0, 0x6, 0xf3, 0x0, 0x4, 0xf5, 0xc, 0xb0,
    0x0, 0x0, 0xd8, 0xf, 0x80, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xd,
    0xb0, 0x0, 0x0, 0xc7, 0x7, 0xf3, 0x0, 0x4,
    0xf5, 0x0, 0xce, 0x74, 0x7e, 0xb0, 0x0, 0x9,
    0xef, 0xd7, 0x0,

    /* U+10B "ċ" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x5, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x50,
    0x7, 0xf8, 0x49, 0xf4, 0xe, 0x90, 0x0, 0xbb,
    0x3f, 0x40, 0x0, 0x12, 0x4f, 0x20, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0xf, 0x80, 0x0, 0x9a,
    0x7, 0xf7, 0x48, 0xf5, 0x0, 0x7d, 0xfd, 0x50,

    /* U+10C "Č" */
    0x0, 0x7, 0x20, 0x54, 0x0, 0x0, 0x5, 0xd7,
    0xe1, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xdf, 0xe8,
    0x0, 0x0, 0xce, 0x75, 0x7f, 0xb0, 0x6, 0xf3,
    0x0, 0x4, 0xf5, 0xc, 0xb0, 0x0, 0x0, 0xd8,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0xc7, 0x7, 0xf3, 0x0, 0x4, 0xf5, 0x0, 0xce,
    0x74, 0x7e, 0xb0, 0x0, 0x9, 0xef, 0xd7, 0x0,

    /* U+10D "č" */
    0x0, 0xb6, 0x2d, 0x30, 0x0, 0xb, 0xc2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xfd, 0x40,
    0x7, 0xf8, 0x4a, 0xf2, 0xe, 0x90, 0x0, 0xd9,
    0x3f, 0x40, 0x0, 0x79, 0x4f, 0x20, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0xf, 0x80, 0x0, 0x68,
    0x7, 0xf7, 0x47, 0xf6, 0x0, 0x7d, 0xfd, 0x50,

    /* U+10E "Ď" */
    0x3, 0xd1, 0x8b, 0x0, 0x0, 0x3, 0xda, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xfe,
    0x91, 0x0, 0xae, 0x44, 0x6d, 0xe2, 0xa, 0xd0,
    0x0, 0xd, 0xc0, 0xad, 0x0, 0x0, 0x5f, 0x3a,
    0xd0, 0x0, 0x1, 0xf6, 0xad, 0x0, 0x0, 0xf,
    0x8a, 0xd0, 0x0, 0x0, 0xf8, 0xad, 0x0, 0x0,
    0x1f, 0x6a, 0xd0, 0x0, 0x5, 0xf3, 0xad, 0x0,
    0x0, 0xdc, 0xa, 0xd4, 0x46, 0xde, 0x20, 0xaf,
    0xff, 0xe9, 0x10, 0x0,

    /* U+10F "ď" */
    0x0, 0x0, 0x0, 0x9e, 0xf, 0x50, 0x0, 0x0,
    0x9, 0xe4, 0xf2, 0x0, 0x0, 0x0, 0x9e, 0x46,
    0x0, 0x8, 0xef, 0xaa, 0xe0, 0x0, 0x7, 0xf9,
    0x59, 0xfe, 0x0, 0x0, 0xea, 0x0, 0xa, 0xe0,
    0x0, 0x2f, 0x40, 0x0, 0x9e, 0x0, 0x3, 0xf3,
    0x0, 0x9, 0xe0, 0x0, 0x2f, 0x40, 0x0, 0x9e,
    0x0, 0x0, 0xe8, 0x0, 0x9, 0xe0, 0x0, 0x7,
    0xf6, 0x26, 0xfe, 0x0, 0x0, 0x8, 0xee, 0xa9,
    0xe0, 0x0,

    /* U+110 "Đ" */
    0x7, 0xff, 0xfe, 0xa3, 0x0, 0x7, 0xf5, 0x46,
    0xbf, 0x50, 0x7, 0xf1, 0x0, 0xa, 0xe1, 0x7,
    0xf1, 0x0, 0x1, 0xf6, 0x7, 0xf1, 0x0, 0x0,
    0xda, 0xff, 0xff, 0xf0, 0x0, 0xbc, 0x38, 0xf4,
    0x30, 0x0, 0xbc, 0x7, 0xf1, 0x0, 0x0, 0xda,
    0x7, 0xf1, 0x0, 0x1, 0xf7, 0x7, 0xf1, 0x0,
    0xa, 0xf1, 0x7, 0xf4, 0x45, 0xbf, 0x50, 0x7,
    0xff, 0xfe, 0xa3, 0x0,

    /* U+111 "đ" */
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xf5, 0x0, 0x0, 0x23, 0xae, 0x31, 0x0,
    0x8e, 0xfa, 0xae, 0x0, 0x7, 0xf9, 0x59, 0xfe,
    0x0, 0xe, 0xa0, 0x0, 0xae, 0x0, 0x2f, 0x40,
    0x0, 0x9e, 0x0, 0x3f, 0x30, 0x0, 0x9e, 0x0,
    0x2f, 0x40, 0x0, 0x9e, 0x0, 0xe, 0x80, 0x0,
    0x9e, 0x0, 0x7, 0xf6, 0x26, 0xfe, 0x0, 0x0,
    0x8e, 0xea, 0x9e, 0x0,

    /* U+112 "Ē" */
    0xb, 0xff, 0xff, 0x70, 0x2, 0x22, 0x22, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+113 "ē" */
    0x2, 0xff, 0xff, 0xf1, 0x0, 0x22, 0x22, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+114 "Ĕ" */
    0x6, 0xd0, 0x3f, 0x10, 0x0, 0x9e, 0xe6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+115 "ĕ" */
    0x0, 0xc7, 0x9, 0xa0, 0x0, 0x3c, 0xfb, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+116 "Ė" */
    0x0, 0x9, 0x50, 0x0, 0x0, 0xd, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+117 "ė" */
    0x0, 0x4, 0xe2, 0x0, 0x0, 0x2, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+118 "Ę" */
    0xaf, 0xff, 0xff, 0xf7, 0xae, 0x44, 0x44, 0x42,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xc0,
    0xad, 0x33, 0x33, 0x20, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x42, 0xaf, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x2d, 0x50, 0x0, 0x0, 0x8c, 0x30,
    0x0, 0x0, 0x4e, 0xe1,

    /* U+119 "ę" */
    0x0, 0x5d, 0xfd, 0x50, 0x5, 0xf7, 0x48, 0xf4,
    0xe, 0x60, 0x0, 0xab, 0x2f, 0xff, 0xff, 0xfd,
    0x4f, 0x63, 0x33, 0x33, 0x3f, 0x50, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x33, 0x7, 0xfa, 0x46, 0xe6,
    0x0, 0x6d, 0xff, 0x50, 0x0, 0x0, 0xd5, 0x0,
    0x0, 0x3, 0xf4, 0x10, 0x0, 0x0, 0xcf, 0x50,

    /* U+11A "Ě" */
    0x2, 0xd2, 0x6c, 0x0, 0x0, 0x2c, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf7,
    0xae, 0x44, 0x44, 0x42, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xc0, 0xad, 0x33, 0x33, 0x20,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x42,
    0xaf, 0xff, 0xff, 0xf8,

    /* U+11B "ě" */
    0x0, 0x8a, 0xc, 0x60, 0x0, 0x7, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xfd, 0x40,
    0x5, 0xf8, 0x4a, 0xf2, 0xe, 0xa0, 0x0, 0xd9,
    0x2f, 0x50, 0x0, 0x9d, 0x4f, 0xff, 0xff, 0xfe,
    0x3f, 0x63, 0x33, 0x33, 0xf, 0x80, 0x0, 0x10,
    0x6, 0xf8, 0x45, 0xd8, 0x0, 0x6d, 0xfe, 0x80,

    /* U+11C "Ĝ" */
    0x0, 0x0, 0x36, 0x0, 0x0, 0x0, 0x1, 0xed,
    0x70, 0x0, 0x0, 0xc, 0x71, 0xd3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xef, 0xd9,
    0x10, 0x0, 0xce, 0x74, 0x7e, 0xc0, 0x7, 0xf3,
    0x0, 0x3, 0xf6, 0xc, 0xc0, 0x0, 0x0, 0x75,
    0xf, 0x90, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x6, 0xff, 0xfb, 0xf,
    0x90, 0x1, 0x33, 0xdb, 0xb, 0xd0, 0x0, 0x0,
    0xcb, 0x5, 0xf5, 0x0, 0x0, 0xcb, 0x0, 0xaf,
    0x84, 0x6a, 0xf7, 0x0, 0x6, 0xdf, 0xec, 0x50,

    /* U+11D "ĝ" */
    0x0, 0x9, 0xe4, 0x0, 0x0, 0x99, 0x1c, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x8e,
    0x7, 0xf9, 0x59, 0xfe, 0xe, 0xa0, 0x0, 0xae,
    0x2f, 0x50, 0x0, 0x9e, 0x3f, 0x30, 0x0, 0x9e,
    0x1f, 0x40, 0x0, 0x9e, 0xe, 0x90, 0x0, 0xae,
    0x7, 0xf9, 0x59, 0xfe, 0x0, 0x8e, 0xfa, 0xad,
    0x0, 0x0, 0x0, 0xcb, 0x9, 0xc5, 0x49, 0xf4,
    0x0, 0x9e, 0xfc, 0x40,

    /* U+11E "Ğ" */
    0x0, 0xf, 0x40, 0xc7, 0x0, 0x0, 0x5, 0xdf,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xef, 0xd9, 0x10, 0x0, 0xce, 0x74, 0x7e,
    0xc0, 0x7, 0xf3, 0x0, 0x3, 0xf6, 0xc, 0xc0,
    0x0, 0x0, 0x75, 0xf, 0x90, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70, 0x6,
    0xff, 0xfb, 0xf, 0x90, 0x1, 0x33, 0xdb, 0xb,
    0xd0, 0x0, 0x0, 0xcb, 0x5, 0xf5, 0x0, 0x0,
    0xcb, 0x0, 0xaf, 0x84, 0x6a, 0xf7, 0x0, 0x6,
    0xdf, 0xec, 0x50,

    /* U+11F "ğ" */
    0x0, 0x9e, 0xfd, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x8e,
    0x7, 0xf9, 0x59, 0xfe, 0xe, 0xa0, 0x0, 0xae,
    0x2f, 0x50, 0x0, 0x9e, 0x3f, 0x30, 0x0, 0x9e,
    0x1f, 0x40, 0x0, 0x9e, 0xe, 0x90, 0x0, 0xae,
    0x7, 0xf9, 0x59, 0xfe, 0x0, 0x8e, 0xfa, 0xad,
    0x0, 0x0, 0x0, 0xcb, 0x9, 0xc5, 0x49, 0xf4,
    0x0, 0x9e, 0xfc, 0x40,

    /* U+120 "Ġ" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x49,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xef, 0xd9, 0x10, 0x0, 0xce, 0x74, 0x7e,
    0xc0, 0x7, 0xf3, 0x0, 0x3, 0xf6, 0xc, 0xc0,
    0x0, 0x0, 0x75, 0xf, 0x90, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70, 0x6,
    0xff, 0xfb, 0xf, 0x90, 0x1, 0x33, 0xdb, 0xb,
    0xd0, 0x0, 0x0, 0xcb, 0x5, 0xf5, 0x0, 0x0,
    0xcb, 0x0, 0xaf, 0x84, 0x6a, 0xf7, 0x0, 0x6,
    0xdf, 0xec, 0x50,

    /* U+121 "ġ" */
    0x0, 0x5, 0xe1, 0x0, 0x0, 0x3, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x8e,
    0x7, 0xf9, 0x59, 0xfe, 0xe, 0xa0, 0x0, 0xae,
    0x2f, 0x50, 0x0, 0x9e, 0x3f, 0x30, 0x0, 0x9e,
    0x1f, 0x40, 0x0, 0x9e, 0xe, 0x90, 0x0, 0xae,
    0x7, 0xf9, 0x59, 0xfe, 0x0, 0x8e, 0xfa, 0xad,
    0x0, 0x0, 0x0, 0xcb, 0x9, 0xc5, 0x49, 0xf4,
    0x0, 0x9e, 0xfc, 0x40,

    /* U+122 "Ģ" */
    0x0, 0x8, 0xef, 0xd9, 0x10, 0x0, 0xce, 0x74,
    0x7e, 0xc0, 0x7, 0xf3, 0x0, 0x3, 0xf6, 0xc,
    0xc0, 0x0, 0x0, 0x75, 0xf, 0x90, 0x0, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xf, 0x70,
    0x6, 0xff, 0xfb, 0xf, 0x90, 0x1, 0x33, 0xdb,
    0xb, 0xd0, 0x0, 0x0, 0xcb, 0x5, 0xf5, 0x0,
    0x0, 0xcb, 0x0, 0xaf, 0x84, 0x6a, 0xf7, 0x0,
    0x6, 0xdf, 0xec, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0,
    0x1f, 0x40, 0x0, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa4, 0x0,
    0x0, 0x3, 0xf3, 0x0, 0x0, 0x6, 0xf0, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0xfa, 0x8e, 0x7, 0xf9, 0x59, 0xfe,
    0xe, 0xa0, 0x0, 0xae, 0x2f, 0x50, 0x0, 0x9e,
    0x3f, 0x30, 0x0, 0x9e, 0x1f, 0x40, 0x0, 0x9e,
    0xe, 0x90, 0x0, 0xae, 0x7, 0xf9, 0x59, 0xfe,
    0x0, 0x8e, 0xfa, 0xad, 0x0, 0x0, 0x0, 0xcb,
    0x9, 0xc5, 0x49, 0xf4, 0x0, 0x9e, 0xfc, 0x40,

    /* U+124 "Ĥ" */
    0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x6c, 0x1b,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad,
    0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0, 0x7,
    0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad, 0x0,
    0x0, 0x7, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1,
    0xaf, 0xff, 0xff, 0xff, 0xf1, 0xad, 0x33, 0x33,
    0x39, 0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad,
    0x0, 0x0, 0x7, 0xf1, 0xad, 0x0, 0x0, 0x7,
    0xf1, 0xad, 0x0, 0x0, 0x7, 0xf1, 0xad, 0x0,
    0x0, 0x7, 0xf1,

    /* U+125 "ĥ" */
    0x2, 0xdc, 0x0, 0x2, 0xd4, 0x6c, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0xe8, 0x0,
    0x0, 0xe, 0x80, 0x0, 0x0, 0xe9, 0x9e, 0xe9,
    0xe, 0xfa, 0x58, 0xf6, 0xeb, 0x0, 0xc, 0xae,
    0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xce, 0x80,
    0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce, 0x80, 0x0,
    0xbc, 0xe8, 0x0, 0xb, 0xc0,

    /* U+126 "Ħ" */
    0xb, 0xc0, 0x0, 0x0, 0x7f, 0x0, 0xb, 0xc0,
    0x0, 0x0, 0x7f, 0x0, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x2c, 0xd2, 0x22, 0x22, 0x9f, 0x20,
    0xb, 0xc0, 0x0, 0x0, 0x8f, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xb, 0xd3, 0x33, 0x33,
    0x9f, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x7f, 0x0,
    0xb, 0xc0, 0x0, 0x0, 0x7f, 0x0, 0xb, 0xc0,
    0x0, 0x0, 0x7f, 0x0, 0xb, 0xc0, 0x0, 0x0,
    0x7f, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x7f, 0x0,

    /* U+127 "ħ" */
    0x0, 0xac, 0x0, 0x0, 0x3, 0xff, 0xff, 0xb0,
    0x0, 0x3, 0xbd, 0x32, 0x0, 0x0, 0xa, 0xc6,
    0xef, 0xb1, 0x0, 0xaf, 0xc5, 0x6f, 0xa0, 0xa,
    0xe1, 0x0, 0x9e, 0x0, 0xac, 0x0, 0x7, 0xf0,
    0xa, 0xc0, 0x0, 0x7f, 0x0, 0xac, 0x0, 0x7,
    0xf0, 0xa, 0xc0, 0x0, 0x7f, 0x0, 0xac, 0x0,
    0x7, 0xf0, 0xa, 0xc0, 0x0, 0x7f,

    /* U+128 "Ĩ" */
    0x0, 0x0, 0x1, 0x1c, 0xd4, 0x3e, 0x7b, 0x4d,
    0xf7, 0x11, 0x0, 0x10, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,

    /* U+129 "ĩ" */
    0x0, 0x0, 0x0, 0x3e, 0xc2, 0x6a, 0xa8, 0x5e,
    0xf4, 0x10, 0x0, 0x10, 0x0, 0xca, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,

    /* U+12A "Ī" */
    0x6f, 0xff, 0xfd, 0x12, 0x22, 0x22, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0,

    /* U+12B "ī" */
    0x9f, 0xff, 0xfa, 0x12, 0x22, 0x21, 0x0, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0,

    /* U+12C "Ĭ" */
    0xf, 0x30, 0xc6, 0x5, 0xee, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x9f, 0x0,

    /* U+12D "ĭ" */
    0x3e, 0x11, 0xf3, 0x8, 0xee, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0,

    /* U+12E "Į" */
    0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0,
    0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9,
    0xf0, 0xbf, 0x4d, 0x1c, 0xa3, 0x6f, 0xc0,

    /* U+12F "į" */
    0x0, 0xb9, 0x0, 0x76, 0x0, 0x0, 0x0, 0xca,
    0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca,
    0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xfd,
    0x7, 0xb0, 0xf, 0x62, 0xa, 0xf8,

    /* U+130 "İ" */
    0x59, 0x7, 0xd0, 0x0, 0x9, 0xf0, 0x9f, 0x9,
    0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f,
    0x9, 0xf0, 0x9f, 0x9, 0xf0, 0x9f, 0x0,

    /* U+131 "ı" */
    0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca,
    0xca,

    /* U+132 "Ĳ" */
    0x9f, 0x0, 0x0, 0x0, 0x9, 0xf9, 0xf0, 0x0,
    0x0, 0x0, 0x9f, 0x9f, 0x0, 0x0, 0x0, 0x9,
    0xf9, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0x9f, 0x0,
    0x0, 0x0, 0x9, 0xf9, 0xf0, 0x0, 0x0, 0x0,
    0x9f, 0x9f, 0x0, 0x0, 0x0, 0x9, 0xf9, 0xf0,
    0x0, 0x0, 0x0, 0x9f, 0x9f, 0x1, 0x41, 0x0,
    0x9, 0xe9, 0xf0, 0x1f, 0x60, 0x0, 0xcc, 0x9f,
    0x0, 0xbe, 0x52, 0x8f, 0x59, 0xf0, 0x1, 0x9e,
    0xfc, 0x50,

    /* U+133 "ĳ" */
    0xb9, 0x0, 0xd6, 0x76, 0x0, 0x93, 0x0, 0x0,
    0x0, 0xca, 0x0, 0xf7, 0xca, 0x0, 0xf7, 0xca,
    0x0, 0xf7, 0xca, 0x0, 0xf7, 0xca, 0x0, 0xf7,
    0xca, 0x0, 0xf7, 0xca, 0x0, 0xf7, 0xca, 0x0,
    0xf7, 0xca, 0x0, 0xf7, 0x0, 0x0, 0xf7, 0x0,
    0x37, 0xf4, 0x0, 0x9f, 0xa0,

    /* U+134 "Ĵ" */
    0x0, 0x0, 0x4, 0xf9, 0x0, 0x0, 0x0, 0x4d,
    0x1a, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0,
    0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x36,
    0x0, 0x0, 0xe9, 0x0, 0x6f, 0x10, 0x2, 0xf6,
    0x0, 0x1e, 0xc5, 0x6d, 0xe0, 0x0, 0x3, 0xbe,
    0xeb, 0x20, 0x0,

    /* U+135 "ĵ" */
    0x0, 0xcd, 0x10, 0xc, 0x64, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0,
    0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0,
    0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac,
    0x0, 0x0, 0xac, 0x0, 0x0, 0xbc, 0x0, 0x25,
    0xf8, 0x0, 0x8f, 0xb1, 0x0,

    /* U+136 "Ķ" */
    0xad, 0x0, 0x0, 0x8f, 0x40, 0xad, 0x0, 0x6,
    0xf6, 0x0, 0xad, 0x0, 0x4f, 0x90, 0x0, 0xad,
    0x2, 0xfb, 0x0, 0x0, 0xad, 0x1d, 0xd0, 0x0,
    0x0, 0xad, 0xcf, 0x60, 0x0, 0x0, 0xaf, 0xfc,
    0xf2, 0x0, 0x0, 0xaf, 0x41, 0xec, 0x0, 0x0,
    0xad, 0x0, 0x4f, 0x80, 0x0, 0xad, 0x0, 0x8,
    0xf4, 0x0, 0xad, 0x0, 0x0, 0xce, 0x10, 0xad,
    0x0, 0x0, 0x2f, 0xa0, 0x0, 0x8, 0xd0, 0x0,
    0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0, 0xe,
    0x40, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+137 "ķ" */
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x7f, 0x40,
    0xe8, 0x6, 0xf6, 0x0, 0xe8, 0x4f, 0x80, 0x0,
    0xeb, 0xfb, 0x0, 0x0, 0xef, 0xfe, 0x0, 0x0,
    0xed, 0x3f, 0xa0, 0x0, 0xe8, 0x6, 0xf5, 0x0,
    0xe8, 0x0, 0xae, 0x10, 0xe8, 0x0, 0x1e, 0xb0,
    0x0, 0x46, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0,
    0x0, 0xd8, 0x0, 0x0, 0x0, 0x81, 0x0, 0x0,

    /* U+138 "ĸ" */
    0xca, 0x0, 0x1d, 0xc0, 0xca, 0x0, 0xbe, 0x10,
    0xca, 0x7, 0xf4, 0x0, 0xca, 0x4f, 0x70, 0x0,
    0xcf, 0xfe, 0x0, 0x0, 0xcb, 0x6f, 0x80, 0x0,
    0xca, 0x7, 0xf6, 0x0, 0xca, 0x0, 0x9f, 0x40,
    0xca, 0x0, 0xb, 0xe2,

    /* U+139 "Ĺ" */
    0x8, 0xf2, 0x0, 0x0, 0x2f, 0x40, 0x0, 0x0,
    0x45, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xae, 0x44, 0x44, 0x40,
    0xaf, 0xff, 0xff, 0xf3,

    /* U+13A "ĺ" */
    0xa, 0xe1, 0x3f, 0x30, 0x54, 0x0, 0x0, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xca, 0x0, 0xca, 0x0,

    /* U+13B "Ļ" */
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x40, 0xaf, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0x80, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x0, 0x4e, 0x10, 0x0,
    0x0, 0x1, 0x0, 0x0,

    /* U+13C "ļ" */
    0xc, 0xa0, 0xca, 0xc, 0xa0, 0xca, 0xc, 0xa0,
    0xca, 0xc, 0xa0, 0xca, 0xc, 0xa0, 0xca, 0xc,
    0xa0, 0xca, 0x0, 0x0, 0xba, 0xd, 0x82, 0xf2,
    0x1, 0x0,

    /* U+13D "Ľ" */
    0xad, 0x0, 0xf5, 0x0, 0xad, 0x2, 0xf3, 0x0,
    0xad, 0x6, 0xc0, 0x0, 0xad, 0x0, 0x10, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x40, 0xaf, 0xff, 0xff, 0xf3,

    /* U+13E "ľ" */
    0xca, 0xf, 0x5c, 0xa2, 0xf3, 0xca, 0x6b, 0xc,
    0xa0, 0x0, 0xca, 0x0, 0xc, 0xa0, 0x0, 0xca,
    0x0, 0xc, 0xa0, 0x0, 0xca, 0x0, 0xc, 0xa0,
    0x0, 0xca, 0x0, 0xc, 0xa0, 0x0,

    /* U+13F "Ŀ" */
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x2, 0xa1, 0x0, 0xad, 0x4, 0xe2, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0xae, 0x44, 0x44, 0x40, 0xaf, 0xff, 0xff, 0xf3,

    /* U+140 "ŀ" */
    0xca, 0x0, 0xc, 0xa0, 0x0, 0xca, 0x0, 0xc,
    0xa0, 0x0, 0xca, 0x0, 0xc, 0xa4, 0xe1, 0xca,
    0x2a, 0xc, 0xa0, 0x0, 0xca, 0x0, 0xc, 0xa0,
    0x0, 0xca, 0x0, 0xc, 0xa0, 0x0,

    /* U+141 "Ł" */
    0xb, 0xd0, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x0,
    0x0, 0xb, 0xd0, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x0, 0xb, 0xd2, 0x60, 0x0, 0x2, 0xcf,
    0xd7, 0x0, 0x0, 0x9e, 0xd0, 0x0, 0x0, 0x0,
    0xbd, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0,
    0x0, 0xbd, 0x0, 0x0, 0x0, 0xb, 0xe4, 0x44,
    0x44, 0x0, 0xbf, 0xff, 0xff, 0xf3,

    /* U+142 "ł" */
    0x9, 0xd0, 0x0, 0x9d, 0x0, 0x9, 0xd0, 0x0,
    0x9d, 0x0, 0x9, 0xd1, 0x0, 0xaf, 0xd0, 0xae,
    0xd0, 0x0, 0x9d, 0x0, 0x9, 0xd0, 0x0, 0x9d,
    0x0, 0x9, 0xd0, 0x0, 0x9d, 0x0,

    /* U+143 "Ń" */
    0x0, 0x0, 0xd, 0xb0, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x0, 0x0, 0x72, 0x0, 0x0, 0xaf,
    0x20, 0x0, 0x6, 0xf1, 0xaf, 0xc0, 0x0, 0x6,
    0xf1, 0xaf, 0xf6, 0x0, 0x6, 0xf1, 0xad, 0xbe,
    0x10, 0x6, 0xf1, 0xad, 0x2f, 0x90, 0x6, 0xf1,
    0xad, 0x7, 0xf3, 0x6, 0xf1, 0xad, 0x0, 0xdd,
    0x6, 0xf1, 0xad, 0x0, 0x3f, 0x76, 0xf1, 0xad,
    0x0, 0x9, 0xf8, 0xf1, 0xad, 0x0, 0x1, 0xef,
    0xf1, 0xad, 0x0, 0x0, 0x5f, 0xf1, 0xad, 0x0,
    0x0, 0xb, 0xf1,

    /* U+144 "ń" */
    0x0, 0x3, 0xf6, 0x0, 0x1, 0xd6, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x89, 0xee, 0x90, 0xef, 0xa5,
    0x8f, 0x6e, 0xb0, 0x0, 0xca, 0xe8, 0x0, 0xb,
    0xbe, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce,
    0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce, 0x80,
    0x0, 0xbc,

    /* U+145 "Ņ" */
    0xaf, 0x20, 0x0, 0x6, 0xf1, 0xaf, 0xc0, 0x0,
    0x6, 0xf1, 0xaf, 0xf6, 0x0, 0x6, 0xf1, 0xad,
    0xbe, 0x10, 0x6, 0xf1, 0xad, 0x2f, 0x90, 0x6,
    0xf1, 0xad, 0x7, 0xf3, 0x6, 0xf1, 0xad, 0x0,
    0xdd, 0x6, 0xf1, 0xad, 0x0, 0x3f, 0x76, 0xf1,
    0xad, 0x0, 0x9, 0xf8, 0xf1, 0xad, 0x0, 0x1,
    0xef, 0xf1, 0xad, 0x0, 0x0, 0x5f, 0xf1, 0xad,
    0x0, 0x0, 0xb, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x3,
    0xf2, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x10, 0x0, 0x0,

    /* U+146 "ņ" */
    0xe8, 0x9e, 0xe9, 0xe, 0xfa, 0x58, 0xf6, 0xeb,
    0x0, 0xc, 0xae, 0x80, 0x0, 0xbb, 0xe8, 0x0,
    0xb, 0xce, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb,
    0xce, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x10, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x1, 0x0,
    0x0,

    /* U+147 "Ň" */
    0x0, 0x4d, 0x19, 0xa0, 0x0, 0x0, 0x4, 0xd9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x20, 0x0, 0x6, 0xf1, 0xaf, 0xc0, 0x0, 0x6,
    0xf1, 0xaf, 0xf6, 0x0, 0x6, 0xf1, 0xad, 0xbe,
    0x10, 0x6, 0xf1, 0xad, 0x2f, 0x90, 0x6, 0xf1,
    0xad, 0x7, 0xf3, 0x6, 0xf1, 0xad, 0x0, 0xdd,
    0x6, 0xf1, 0xad, 0x0, 0x3f, 0x76, 0xf1, 0xad,
    0x0, 0x9, 0xf8, 0xf1, 0xad, 0x0, 0x1, 0xef,
    0xf1, 0xad, 0x0, 0x0, 0x5f, 0xf1, 0xad, 0x0,
    0x0, 0xb, 0xf1,

    /* U+148 "ň" */
    0x7, 0xb0, 0xc6, 0x0, 0x7, 0xd6, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x89, 0xee, 0x90, 0xef, 0xa5,
    0x8f, 0x6e, 0xb0, 0x0, 0xca, 0xe8, 0x0, 0xb,
    0xbe, 0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce,
    0x80, 0x0, 0xbc, 0xe8, 0x0, 0xb, 0xce, 0x80,
    0x0, 0xbc,

    /* U+149 "ŉ" */
    0xf, 0x60, 0x0, 0x0, 0x2, 0xf3, 0x0, 0x0,
    0x0, 0x37, 0x0, 0x0, 0x0, 0x0, 0xe, 0x89,
    0xee, 0x90, 0x0, 0xef, 0xa5, 0x8f, 0x60, 0xe,
    0xb0, 0x0, 0xca, 0x0, 0xe8, 0x0, 0xb, 0xb0,
    0xe, 0x80, 0x0, 0xbc, 0x0, 0xe8, 0x0, 0xb,
    0xc0, 0xe, 0x80, 0x0, 0xbc, 0x0, 0xe8, 0x0,
    0xb, 0xc0, 0xe, 0x80, 0x0, 0xbc,

    /* U+14A "Ŋ" */
    0xbf, 0x10, 0x0, 0xa, 0xeb, 0xfa, 0x0, 0x0,
    0xae, 0xbf, 0xf4, 0x0, 0xa, 0xeb, 0xcb, 0xd0,
    0x0, 0xae, 0xbc, 0x2f, 0x70, 0xa, 0xeb, 0xc0,
    0x8f, 0x10, 0xae, 0xbc, 0x0, 0xea, 0xa, 0xeb,
    0xc0, 0x5, 0xf4, 0xae, 0xbc, 0x0, 0xb, 0xda,
    0xeb, 0xc0, 0x0, 0x2f, 0xfe, 0xbc, 0x0, 0x0,
    0x8f, 0xeb, 0xc0, 0x0, 0x0, 0xee, 0x0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0x25, 0xe9, 0x0,
    0x0, 0x7, 0xfb, 0x10,

    /* U+14B "ŋ" */
    0xd7, 0x8e, 0xe9, 0xd, 0xe8, 0x57, 0xf8, 0xda,
    0x0, 0xb, 0xcd, 0x90, 0x0, 0x9d, 0xd9, 0x0,
    0x9, 0xed, 0x90, 0x0, 0x9e, 0xd9, 0x0, 0x9,
    0xed, 0x90, 0x0, 0x9e, 0xd9, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0x9d, 0x0, 0x2, 0x5e, 0xa0, 0x0,
    0x7f, 0xb1,

    /* U+14C "Ō" */
    0x0, 0xf, 0xff, 0xff, 0x20, 0x0, 0x0, 0x22,
    0x22, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0xfd, 0x70, 0x0, 0x0, 0xbf,
    0x85, 0x8f, 0xb0, 0x0, 0x6f, 0x40, 0x0, 0x4f,
    0x60, 0xc, 0xc0, 0x0, 0x0, 0xcc, 0x0, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xf, 0x70, 0x0, 0x0,
    0x7f, 0x1, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0xf,
    0x80, 0x0, 0x0, 0x8f, 0x0, 0xcc, 0x0, 0x0,
    0xb, 0xc0, 0x6, 0xf4, 0x0, 0x3, 0xf6, 0x0,
    0xb, 0xf8, 0x58, 0xfc, 0x0, 0x0, 0x7, 0xdf,
    0xd8, 0x0, 0x0,

    /* U+14D "ō" */
    0x1, 0xff, 0xff, 0xf2, 0x0, 0x2, 0x22, 0x22,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+14E "Ŏ" */
    0x0, 0xb, 0x90, 0x8b, 0x0, 0x0, 0x0, 0x2c,
    0xfc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0xfd, 0x70, 0x0, 0x0, 0xbf,
    0x85, 0x8f, 0xb0, 0x0, 0x6f, 0x40, 0x0, 0x4f,
    0x60, 0xc, 0xc0, 0x0, 0x0, 0xcc, 0x0, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xf, 0x70, 0x0, 0x0,
    0x7f, 0x1, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0xf,
    0x80, 0x0, 0x0, 0x8f, 0x0, 0xcc, 0x0, 0x0,
    0xb, 0xc0, 0x6, 0xf4, 0x0, 0x3, 0xf6, 0x0,
    0xb, 0xf8, 0x58, 0xfc, 0x0, 0x0, 0x7, 0xdf,
    0xd8, 0x0, 0x0,

    /* U+14F "ŏ" */
    0x0, 0xb8, 0x8, 0xb0, 0x0, 0x2, 0xcf, 0xc2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+150 "Ő" */
    0x0, 0x0, 0x5f, 0x2c, 0xb0, 0x0, 0x0, 0xd,
    0x68, 0xd1, 0x0, 0x0, 0x2, 0x60, 0x72, 0x0,
    0x0, 0x0, 0x7d, 0xfd, 0x70, 0x0, 0x0, 0xbf,
    0x85, 0x8f, 0xb0, 0x0, 0x6f, 0x40, 0x0, 0x4f,
    0x60, 0xc, 0xc0, 0x0, 0x0, 0xcc, 0x0, 0xf8,
    0x0, 0x0, 0x8, 0xf0, 0xf, 0x70, 0x0, 0x0,
    0x7f, 0x1, 0xf7, 0x0, 0x0, 0x7, 0xf0, 0xf,
    0x80, 0x0, 0x0, 0x8f, 0x0, 0xcc, 0x0, 0x0,
    0xb, 0xc0, 0x6, 0xf4, 0x0, 0x3, 0xf6, 0x0,
    0xb, 0xf8, 0x58, 0xfc, 0x0, 0x0, 0x7, 0xdf,
    0xd8, 0x0, 0x0,

    /* U+151 "ő" */
    0x0, 0x6, 0xf2, 0xcb, 0x0, 0x0, 0xe6, 0x8d,
    0x0, 0x0, 0x26, 0x7, 0x10, 0x0, 0x5, 0xdf,
    0xd7, 0x0, 0x6, 0xf9, 0x48, 0xf8, 0x0, 0xea,
    0x0, 0x8, 0xf1, 0x2f, 0x40, 0x0, 0x2f, 0x54,
    0xf3, 0x0, 0x1, 0xf6, 0x3f, 0x40, 0x0, 0x2f,
    0x40, 0xe9, 0x0, 0x8, 0xf1, 0x6, 0xf8, 0x47,
    0xf8, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+152 "Œ" */
    0x0, 0x2a, 0xef, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x2e, 0xe9, 0x67, 0xfa, 0x77, 0x77, 0x70, 0xb,
    0xe1, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x2, 0xf5, 0x0, 0x0, 0x0, 0x2f, 0x50,
    0x0, 0x2f, 0x50, 0x0, 0x0, 0x3, 0xf4, 0x0,
    0x2, 0xff, 0xff, 0xff, 0x40, 0x3f, 0x40, 0x0,
    0x2f, 0x73, 0x33, 0x31, 0x2, 0xf4, 0x0, 0x2,
    0xf5, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x2, 0xf5,
    0x0, 0x0, 0x0, 0x2, 0xec, 0x64, 0x5f, 0x84,
    0x44, 0x44, 0x0, 0x2, 0xae, 0xff, 0xff, 0xff,
    0xff, 0xf1,

    /* U+153 "œ" */
    0x0, 0x5d, 0xfd, 0x50, 0x3c, 0xfd, 0x60, 0x5,
    0xf9, 0x48, 0xf8, 0xfb, 0x48, 0xf4, 0xe, 0xa0,
    0x0, 0x9f, 0xe0, 0x0, 0xbb, 0x2f, 0x50, 0x0,
    0x4f, 0x90, 0x0, 0x7e, 0x3f, 0x30, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0x2f, 0x40, 0x0, 0x4f, 0x93,
    0x33, 0x33, 0xe, 0xa0, 0x0, 0x9f, 0xb0, 0x0,
    0x0, 0x6, 0xf8, 0x48, 0xfa, 0xfa, 0x45, 0x97,
    0x0, 0x6d, 0xfd, 0x60, 0x4c, 0xff, 0xb2,

    /* U+154 "Ŕ" */
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x6e, 0x10,
    0x0, 0x0, 0x7, 0x20, 0x0, 0xb, 0xff, 0xff,
    0xc5, 0x0, 0xbe, 0x44, 0x5a, 0xf7, 0xb, 0xd0,
    0x0, 0xb, 0xe0, 0xbd, 0x0, 0x0, 0x7f, 0xb,
    0xd0, 0x0, 0xa, 0xf0, 0xbd, 0x0, 0x16, 0xf8,
    0xb, 0xff, 0xff, 0xf8, 0x0, 0xbd, 0x33, 0x7f,
    0x30, 0xb, 0xd0, 0x0, 0xdb, 0x0, 0xbd, 0x0,
    0x5, 0xf4, 0xb, 0xd0, 0x0, 0xc, 0xc0, 0xbd,
    0x0, 0x0, 0x4f, 0x50,

    /* U+155 "ŕ" */
    0x0, 0x7e, 0x30, 0x3d, 0x20, 0x0, 0x0, 0xe,
    0xac, 0xf3, 0xef, 0x85, 0x1e, 0xa0, 0x0, 0xe8,
    0x0, 0xe, 0x80, 0x0, 0xe8, 0x0, 0xe, 0x80,
    0x0, 0xe8, 0x0, 0xe, 0x80, 0x0,

    /* U+156 "Ŗ" */
    0xbf, 0xff, 0xfc, 0x50, 0xb, 0xe4, 0x45, 0xaf,
    0x70, 0xbd, 0x0, 0x0, 0xbe, 0xb, 0xd0, 0x0,
    0x7, 0xf0, 0xbd, 0x0, 0x0, 0xaf, 0xb, 0xd0,
    0x1, 0x6f, 0x80, 0xbf, 0xff, 0xff, 0x80, 0xb,
    0xd3, 0x37, 0xf3, 0x0, 0xbd, 0x0, 0xd, 0xb0,
    0xb, 0xd0, 0x0, 0x5f, 0x40, 0xbd, 0x0, 0x0,
    0xcc, 0xb, 0xd0, 0x0, 0x4, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0xf, 0x50, 0x0, 0x0, 0x5, 0xe0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x0, 0xe, 0xac, 0xf3, 0xe, 0xf8,
    0x51, 0xe, 0xa0, 0x0, 0xe, 0x80, 0x0, 0xe,
    0x80, 0x0, 0xe, 0x80, 0x0, 0xe, 0x80, 0x0,
    0xe, 0x80, 0x0, 0xe, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0xe, 0x70, 0x0, 0x2f,
    0x10, 0x0, 0x1, 0x0, 0x0,

    /* U+158 "Ř" */
    0x3, 0xd1, 0x8b, 0x0, 0x0, 0x3, 0xda, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xc5, 0x0, 0xbe, 0x44, 0x5a, 0xf7, 0xb, 0xd0,
    0x0, 0xb, 0xe0, 0xbd, 0x0, 0x0, 0x7f, 0xb,
    0xd0, 0x0, 0xa, 0xf0, 0xbd, 0x0, 0x16, 0xf8,
    0xb, 0xff, 0xff, 0xf8, 0x0, 0xbd, 0x33, 0x7f,
    0x30, 0xb, 0xd0, 0x0, 0xdb, 0x0, 0xbd, 0x0,
    0x5, 0xf4, 0xb, 0xd0, 0x0, 0xc, 0xc0, 0xbd,
    0x0, 0x0, 0x4f, 0x50,

    /* U+159 "ř" */
    0xa, 0x62, 0xd3, 0x0, 0x9b, 0x20, 0x0, 0x0,
    0x0, 0xe, 0xac, 0xf3, 0xe, 0xf8, 0x51, 0xe,
    0xa0, 0x0, 0xe, 0x80, 0x0, 0xe, 0x80, 0x0,
    0xe, 0x80, 0x0, 0xe, 0x80, 0x0, 0xe, 0x80,
    0x0, 0xe, 0x80, 0x0,

    /* U+15A "Ś" */
    0x0, 0x0, 0x4, 0x71, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f,
    0x95, 0x6c, 0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0,
    0xf9, 0x0, 0x0, 0x67, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0xb, 0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e,
    0xfa, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x39, 0x10,
    0x0, 0xb, 0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9,
    0xf9, 0x55, 0xaf, 0x60, 0x6, 0xcf, 0xec, 0x40,

    /* U+15B "ś" */
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x1, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xea, 0x10,
    0xa, 0xe5, 0x5d, 0xd0, 0xe, 0x80, 0x4, 0xf4,
    0xb, 0xe6, 0x10, 0x51, 0x0, 0x8e, 0xfd, 0x50,
    0x0, 0x0, 0x29, 0xf3, 0x2a, 0x20, 0x0, 0xf6,
    0xd, 0xd5, 0x49, 0xf2, 0x1, 0xae, 0xfc, 0x40,

    /* U+15C "Ŝ" */
    0x0, 0x0, 0x63, 0x0, 0x0, 0x0, 0x6d, 0xe2,
    0x0, 0x0, 0x3e, 0x25, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f,
    0x95, 0x6c, 0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0,
    0xf9, 0x0, 0x0, 0x67, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0xb, 0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e,
    0xfa, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x39, 0x10,
    0x0, 0xb, 0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9,
    0xf9, 0x55, 0xaf, 0x60, 0x6, 0xcf, 0xec, 0x40,

    /* U+15D "ŝ" */
    0x0, 0x9, 0xe5, 0x0, 0x0, 0x8a, 0x1c, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x30,
    0xa, 0xe5, 0x4c, 0xe1, 0xe, 0x80, 0x1, 0xb3,
    0xb, 0xe6, 0x10, 0x0, 0x0, 0x8e, 0xfd, 0x50,
    0x0, 0x0, 0x29, 0xf3, 0x2d, 0x40, 0x0, 0xf6,
    0xd, 0xd5, 0x49, 0xf2, 0x1, 0xae, 0xfc, 0x40,

    /* U+15E "Ş" */
    0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f, 0x95, 0x6c,
    0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0, 0xf9, 0x0,
    0x0, 0x67, 0xa, 0xf5, 0x0, 0x0, 0x0, 0xb,
    0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e, 0xfa, 0x0,
    0x0, 0x0, 0x6, 0xf8, 0x39, 0x10, 0x0, 0xb,
    0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9, 0xf9, 0x55,
    0xaf, 0x60, 0x6, 0xcf, 0xfc, 0x40, 0x0, 0x0,
    0x9c, 0x20, 0x0, 0x0, 0x0, 0xa8, 0x0, 0x0,
    0x0, 0xbc, 0x20, 0x0,

    /* U+15F "ş" */
    0x0, 0x9e, 0xfb, 0x30, 0xa, 0xe5, 0x4c, 0xe1,
    0xe, 0x80, 0x1, 0xb3, 0xb, 0xe6, 0x10, 0x0,
    0x0, 0x8e, 0xfd, 0x50, 0x0, 0x0, 0x29, 0xf3,
    0x2d, 0x40, 0x0, 0xf6, 0xd, 0xd5, 0x49, 0xf2,
    0x1, 0xae, 0xfc, 0x40, 0x0, 0x2, 0xe7, 0x0,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x4, 0xe7, 0x0,

    /* U+160 "Š" */
    0x0, 0x26, 0x1, 0x71, 0x0, 0x0, 0xc8, 0xc8,
    0x0, 0x0, 0x1, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7f,
    0x95, 0x6c, 0xf2, 0xe, 0xa0, 0x0, 0xe, 0xa0,
    0xf9, 0x0, 0x0, 0x67, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0xb, 0xfe, 0x93, 0x0, 0x0, 0x3, 0x9e,
    0xfa, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x39, 0x10,
    0x0, 0xb, 0xd2, 0xf7, 0x0, 0x0, 0xcc, 0x9,
    0xf9, 0x55, 0xaf, 0x60, 0x6, 0xcf, 0xec, 0x40,

    /* U+161 "š" */
    0x0, 0x8a, 0xc, 0x50, 0x0, 0x8, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xea, 0x10,
    0xa, 0xe5, 0x5d, 0xd0, 0xe, 0x80, 0x4, 0xf4,
    0xb, 0xe6, 0x10, 0x51, 0x0, 0x8e, 0xfd, 0x50,
    0x0, 0x0, 0x29, 0xf3, 0x2a, 0x20, 0x0, 0xf6,
    0xd, 0xd5, 0x49, 0xf2, 0x1, 0xae, 0xfc, 0x40,

    /* U+162 "Ţ" */
    0x9f, 0xff, 0xff, 0xff, 0xf3, 0x24, 0x44, 0xfa,
    0x44, 0x40, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xca, 0x10,
    0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0xdb, 0x10, 0x0,

    /* U+163 "ţ" */
    0x3, 0x80, 0x0, 0x6, 0xf1, 0x0, 0x6, 0xf1,
    0x0, 0xef, 0xff, 0xa0, 0x27, 0xf3, 0x10, 0x6,
    0xf1, 0x0, 0x6, 0xf1, 0x0, 0x6, 0xf1, 0x0,
    0x6, 0xf1, 0x0, 0x6, 0xf1, 0x0, 0x4, 0xf7,
    0x30, 0x0, 0xaf, 0x90, 0x0, 0x1e, 0x90, 0x0,
    0x1, 0xf2, 0x0, 0x2e, 0x90,

    /* U+164 "Ť" */
    0x0, 0x3d, 0x17, 0xb0, 0x0, 0x0, 0x3, 0xda,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xf3, 0x24, 0x44, 0xfa, 0x44,
    0x40, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+165 "ť" */
    0x0, 0x0, 0x46, 0x0, 0x0, 0x9c, 0x0, 0x0,
    0xd8, 0x6, 0xf1, 0x70, 0x6, 0xf1, 0x0, 0xef,
    0xff, 0xa0, 0x27, 0xf3, 0x10, 0x6, 0xf1, 0x0,
    0x6, 0xf1, 0x0, 0x6, 0xf1, 0x0, 0x6, 0xf1,
    0x0, 0x6, 0xf1, 0x0, 0x4, 0xf7, 0x30, 0x0,
    0xaf, 0x90,

    /* U+166 "Ŧ" */
    0x9f, 0xff, 0xff, 0xff, 0xf3, 0x24, 0x44, 0xfa,
    0x44, 0x40, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xf5,
    0x0, 0x0, 0x23, 0xfa, 0x31, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0,

    /* U+167 "ŧ" */
    0x0, 0x6f, 0x10, 0x0, 0x6f, 0x10, 0xe, 0xff,
    0xfa, 0x2, 0x7f, 0x31, 0x0, 0x6f, 0x10, 0x1f,
    0xff, 0xfe, 0x3, 0x8f, 0x42, 0x0, 0x6f, 0x10,
    0x0, 0x6f, 0x10, 0x0, 0x4f, 0x73, 0x0, 0xa,
    0xf9,

    /* U+168 "Ũ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd4, 0x3e,
    0x0, 0x6, 0xb4, 0xdf, 0x70, 0x0, 0x11, 0x0,
    0x10, 0x0, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5e, 0x90, 0x0, 0x2, 0xf5, 0xda, 0x0,
    0x0, 0x3f, 0x4a, 0xe0, 0x0, 0x8, 0xf1, 0x3f,
    0xc6, 0x59, 0xf8, 0x0, 0x3b, 0xff, 0xc6, 0x0,

    /* U+169 "ũ" */
    0x0, 0x0, 0x1, 0x1, 0xcf, 0xff, 0xe1, 0x2,
    0x22, 0x20, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb, 0xbe,
    0x80, 0x0, 0xbb, 0xda, 0x0, 0xd, 0xb9, 0xf6,
    0x5a, 0xfb, 0x1a, 0xfe, 0x9b, 0xb0,

    /* U+16A "Ū" */
    0x5, 0xff, 0xff, 0xd0, 0x0, 0x12, 0x22, 0x22,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+16B "ū" */
    0x2f, 0xff, 0xff, 0x10, 0x22, 0x22, 0x20, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd,
    0xa0, 0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf,
    0xe9, 0xbb,

    /* U+16C "Ŭ" */
    0x0, 0xf4, 0xc, 0x70, 0x0, 0x5, 0xde, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+16D "ŭ" */
    0xc, 0x70, 0x9a, 0x0, 0x3c, 0xfc, 0x20, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd,
    0xa0, 0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf,
    0xe9, 0xbb,

    /* U+16E "Ů" */
    0x0, 0x9, 0xb3, 0x0, 0x0, 0x5, 0x71, 0xb0,
    0x0, 0x0, 0x57, 0xb, 0x0, 0x0, 0x0, 0x9b,
    0x30, 0x0, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5e, 0x90, 0x0, 0x2, 0xf5, 0xda, 0x0,
    0x0, 0x3f, 0x4a, 0xe0, 0x0, 0x8, 0xf1, 0x3f,
    0xc6, 0x59, 0xf8, 0x0, 0x3b, 0xff, 0xc6, 0x0,

    /* U+16F "ů" */
    0x0, 0x7b, 0x50, 0x0, 0x2b, 0xc, 0x0, 0x2,
    0xb0, 0xc0, 0x0, 0x7, 0xb6, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb,
    0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0, 0xb, 0xbf,
    0x80, 0x0, 0xbb, 0xe8, 0x0, 0xb, 0xbd, 0xa0,
    0x0, 0xdb, 0x9f, 0x65, 0xaf, 0xb1, 0xaf, 0xe9,
    0xbb,

    /* U+170 "Ű" */
    0x0, 0xa, 0xc2, 0xf7, 0x0, 0x3, 0xf2, 0xc9,
    0x0, 0x0, 0x44, 0x27, 0x0, 0xe, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f,
    0x5e, 0x90, 0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0,
    0x2f, 0x5d, 0xa0, 0x0, 0x3, 0xf4, 0xae, 0x0,
    0x0, 0x8f, 0x13, 0xfc, 0x65, 0x9f, 0x80, 0x3,
    0xbf, 0xfc, 0x60, 0x0,

    /* U+171 "ű" */
    0x0, 0x7e, 0x2d, 0xa0, 0x1, 0xe5, 0x9c, 0x0,
    0x2, 0x61, 0x71, 0x0, 0xf8, 0x0, 0xb, 0xb0,
    0xf8, 0x0, 0xb, 0xb0, 0xf8, 0x0, 0xb, 0xb0,
    0xf8, 0x0, 0xb, 0xb0, 0xf8, 0x0, 0xb, 0xb0,
    0xe8, 0x0, 0xb, 0xb0, 0xda, 0x0, 0xd, 0xb0,
    0x9f, 0x65, 0xaf, 0xb0, 0x1a, 0xfe, 0x9b, 0xb0,

    /* U+172 "Ų" */
    0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90, 0x0, 0x2,
    0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e, 0x90,
    0x0, 0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2f, 0x5e,
    0x90, 0x0, 0x2, 0xf5, 0xda, 0x0, 0x0, 0x3f,
    0x4a, 0xe0, 0x0, 0x8, 0xf1, 0x3f, 0xc6, 0x59,
    0xf8, 0x0, 0x3b, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x0, 0x0, 0x3f, 0x41, 0x0, 0x0,
    0x0, 0xcf, 0x50, 0x0,

    /* U+173 "ų" */
    0xf8, 0x0, 0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8,
    0x0, 0xb, 0xbf, 0x80, 0x0, 0xbb, 0xf8, 0x0,
    0xb, 0xbe, 0x80, 0x0, 0xbb, 0xda, 0x0, 0xd,
    0xb9, 0xf6, 0x5a, 0xfb, 0x1a, 0xfe, 0x9b, 0xb0,
    0x0, 0x7, 0xc1, 0x0, 0x0, 0xe8, 0x20, 0x0,
    0x8, 0xfa,

    /* U+174 "Ŵ" */
    0x0, 0x0, 0x0, 0xbe, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xb, 0x82, 0xd2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x9f, 0x0, 0x0, 0xcb, 0x2f, 0x40, 0x0, 0xdf,
    0x30, 0x0, 0xf8, 0xe, 0x80, 0x1, 0xfe, 0x70,
    0x3, 0xf4, 0xb, 0xb0, 0x6, 0xf8, 0xb0, 0x6,
    0xf0, 0x7, 0xf0, 0xa, 0xa4, 0xf0, 0x9, 0xd0,
    0x4, 0xf2, 0xe, 0x60, 0xf4, 0xd, 0x90, 0x0,
    0xf6, 0x2f, 0x10, 0xb8, 0xf, 0x50, 0x0, 0xc9,
    0x7d, 0x0, 0x7c, 0x4f, 0x20, 0x0, 0x9d, 0xb9,
    0x0, 0x3f, 0x8e, 0x0, 0x0, 0x5f, 0xe4, 0x0,
    0xe, 0xea, 0x0, 0x0, 0x1f, 0xf0, 0x0, 0xa,
    0xf7, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x6, 0xf3,
    0x0,

    /* U+175 "ŵ" */
    0x0, 0x0, 0x2d, 0xc1, 0x0, 0x0, 0x0, 0x1,
    0xb3, 0x4a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0xb, 0xb0, 0x0, 0xe8,
    0x4f, 0x20, 0xf, 0xf0, 0x2, 0xf3, 0xf, 0x60,
    0x5d, 0xe5, 0x6, 0xf0, 0xb, 0xa0, 0x99, 0xa9,
    0xa, 0xb0, 0x6, 0xe0, 0xe4, 0x5e, 0xe, 0x60,
    0x2, 0xf5, 0xf0, 0xf, 0x5f, 0x20, 0x0, 0xed,
    0xb0, 0xb, 0xdd, 0x0, 0x0, 0x9f, 0x60, 0x6,
    0xf9, 0x0, 0x0, 0x5f, 0x10, 0x2, 0xf5, 0x0,

    /* U+176 "Ŷ" */
    0x0, 0x3, 0xeb, 0x0, 0x0, 0x0, 0x3d, 0x37,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x10, 0x0, 0x7, 0xf3, 0x1f, 0x90, 0x0, 0xe,
    0xa0, 0x9, 0xf1, 0x0, 0x7f, 0x20, 0x1, 0xf9,
    0x0, 0xea, 0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0,
    0x0, 0x1f, 0x9e, 0x90, 0x0, 0x0, 0x7, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+177 "ŷ" */
    0x0, 0x2d, 0xc1, 0x0, 0x1, 0xb3, 0x4b, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xae, 0x0, 0x5, 0xf3,
    0x4f, 0x30, 0x9, 0xd0, 0xe, 0x80, 0xe, 0x80,
    0x9, 0xd0, 0x3f, 0x20, 0x3, 0xf2, 0x8d, 0x0,
    0x0, 0xd8, 0xc7, 0x0, 0x0, 0x8e, 0xf2, 0x0,
    0x0, 0x2f, 0xc0, 0x0, 0x0, 0xe, 0x70, 0x0,
    0x0, 0x3f, 0x10, 0x0, 0x16, 0xda, 0x0, 0x0,
    0x5f, 0xb1, 0x0, 0x0,

    /* U+178 "Ÿ" */
    0x0, 0x48, 0x1, 0xa1, 0x0, 0x0, 0x8d, 0x2,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x10, 0x0, 0x7, 0xf3, 0x1f, 0x90, 0x0, 0xe,
    0xa0, 0x9, 0xf1, 0x0, 0x7f, 0x20, 0x1, 0xf9,
    0x0, 0xea, 0x0, 0x0, 0x8f, 0x17, 0xf2, 0x0,
    0x0, 0x1f, 0x9e, 0x90, 0x0, 0x0, 0x7, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+179 "Ź" */
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x6, 0xe1,
    0x0, 0x0, 0x0, 0x63, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xfb, 0x14, 0x44, 0x44, 0x8f, 0x70, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf4,
    0x0, 0x0, 0x2, 0xfc, 0x44, 0x44, 0x44, 0x5f,
    0xff, 0xff, 0xff, 0xf0,

    /* U+17A "ź" */
    0x0, 0x0, 0xad, 0x10, 0x0, 0x6, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf2,
    0x4, 0x44, 0x4e, 0xd0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xae, 0x10, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0x1e, 0xc3, 0x33, 0x31, 0x5f, 0xff, 0xff, 0xf6,

    /* U+17B "Ż" */
    0x0, 0x0, 0x84, 0x0, 0x0, 0x0, 0xd, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xfb, 0x14, 0x44, 0x44, 0x8f, 0x70, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf4,
    0x0, 0x0, 0x2, 0xfc, 0x44, 0x44, 0x44, 0x5f,
    0xff, 0xff, 0xff, 0xf0,

    /* U+17C "ż" */
    0x0, 0xa, 0xa0, 0x0, 0x0, 0x6, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf2,
    0x4, 0x44, 0x4e, 0xd0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xae, 0x10, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0x1e, 0xc3, 0x33, 0x31, 0x5f, 0xff, 0xff, 0xf6,

    /* U+17D "Ž" */
    0x0, 0x2d, 0x27, 0xb0, 0x0, 0x0, 0x3d, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xfb, 0x14, 0x44, 0x44, 0x8f, 0x70, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x7, 0xf4,
    0x0, 0x0, 0x2, 0xfc, 0x44, 0x44, 0x44, 0x5f,
    0xff, 0xff, 0xff, 0xf0,

    /* U+17E "ž" */
    0x1, 0xc4, 0x4d, 0x10, 0x0, 0xa, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf2,
    0x4, 0x44, 0x4e, 0xd0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x3, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0xae, 0x10, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0x1e, 0xc3, 0x33, 0x31, 0x5f, 0xff, 0xff, 0xf6,

    /* U+17F "ſ" */
    0x0, 0x0, 0x0, 0x9f, 0xe0, 0x6f, 0x63, 0xa,
    0xc0, 0x0, 0xcb, 0x0, 0xc, 0xb0, 0x0, 0xcb,
    0x0, 0xc, 0xb0, 0x0, 0xcb, 0x0, 0xc, 0xb0,
    0x0, 0xcb, 0x0, 0xc, 0xb0, 0x0, 0xcb, 0x0,
    0xc, 0xb0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 63, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 66, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12, .adv_w = 82, .box_w = 4, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 22, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 82, .adv_w = 144, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 154, .adv_w = 188, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 226, .adv_w = 159, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 286, .adv_w = 45, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 290, .adv_w = 88, .box_w = 5, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 335, .adv_w = 89, .box_w = 5, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 380, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 405, .adv_w = 145, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 446, .adv_w = 50, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 454, .adv_w = 71, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 462, .adv_w = 67, .box_w = 2, .box_h = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 464, .adv_w = 106, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 510, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 564, .adv_w = 144, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 594, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 648, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 696, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 750, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 798, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 846, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 900, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 954, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1002, .adv_w = 167, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1079, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1127, .adv_w = 167, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1210, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1258, .adv_w = 167, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1341, .adv_w = 139, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1389, .adv_w = 167, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1469, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1517, .adv_w = 167, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1597, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1645, .adv_w = 167, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1720, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1768, .adv_w = 167, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1848, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1896, .adv_w = 168, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1964, .adv_w = 163, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2030, .adv_w = 172, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2090, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2150, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2210, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2258, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2318, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2366, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2426, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2474, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2534, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2582, .adv_w = 146, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2642, .adv_w = 136, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2690, .adv_w = 174, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2770, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2830, .adv_w = 174, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2905, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2965, .adv_w = 174, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3040, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3100, .adv_w = 174, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 3185, .adv_w = 144, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3257, .adv_w = 183, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3332, .adv_w = 141, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3385, .adv_w = 179, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3457, .adv_w = 145, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3511, .adv_w = 70, .box_w = 6, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3559, .adv_w = 63, .box_w = 6, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3598, .adv_w = 70, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3643, .adv_w = 63, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3679, .adv_w = 70, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3724, .adv_w = 63, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3760, .adv_w = 70, .box_w = 3, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3783, .adv_w = 62, .box_w = 4, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 3813, .adv_w = 70, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3836, .adv_w = 63, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3845, .adv_w = 211, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3911, .adv_w = 123, .box_w = 6, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3956, .adv_w = 141, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4031, .adv_w = 64, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 4076, .adv_w = 161, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 4156, .adv_w = 130, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 4220, .adv_w = 142, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4256, .adv_w = 138, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4316, .adv_w = 62, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4348, .adv_w = 138, .box_w = 8, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 4416, .adv_w = 62, .box_w = 3, .box_h = 17, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 4442, .adv_w = 138, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4490, .adv_w = 81, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4520, .adv_w = 138, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4568, .adv_w = 90, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4598, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4652, .adv_w = 69, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4682, .adv_w = 183, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4757, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4799, .adv_w = 183, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 4884, .adv_w = 141, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 4933, .adv_w = 183, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5008, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5050, .adv_w = 141, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5104, .adv_w = 177, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5172, .adv_w = 145, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5214, .adv_w = 176, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5297, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5351, .adv_w = 176, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5434, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5488, .adv_w = 176, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5571, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5625, .adv_w = 244, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5715, .adv_w = 233, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5778, .adv_w = 158, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5846, .adv_w = 87, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5876, .adv_w = 158, .box_w = 9, .box_h = 17, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 5953, .adv_w = 87, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 5998, .adv_w = 158, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6066, .adv_w = 87, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6102, .adv_w = 152, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6174, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6222, .adv_w = 152, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6294, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6342, .adv_w = 152, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6410, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6458, .adv_w = 152, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6530, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6578, .adv_w = 153, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6653, .adv_w = 84, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6698, .adv_w = 153, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6773, .adv_w = 89, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6815, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6875, .adv_w = 84, .box_w = 6, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6908, .adv_w = 166, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6980, .adv_w = 141, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7026, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7094, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7136, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7204, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7246, .adv_w = 166, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7318, .adv_w = 141, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7367, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7435, .adv_w = 141, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7483, .adv_w = 166, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 7551, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 7593, .adv_w = 227, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7698, .adv_w = 192, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7770, .adv_w = 154, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7845, .adv_w = 121, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7905, .adv_w = 154, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7980, .adv_w = 153, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8048, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8096, .adv_w = 153, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8164, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8212, .adv_w = 153, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8280, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8328, .adv_w = 64, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 26, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 256, .range_length = 128, .glyph_id_start = 27,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6, 7, 6, 7, 6,
    7, 8, 9, 8, 9, 8, 9, 8,
    9, 10, 0, 10, 0, 11, 12, 11,
    12, 11, 12, 11, 12, 11, 12, 0,
    0, 0, 0, 0, 0, 0, 0, 13,
    14, 0, 0, 13, 0, 13, 0, 13,
    0, 13, 0, 13, 0, 0, 0, 15,
    0, 16, 0, 0, 17, 0, 17, 0,
    17, 0, 17, 0, 0, 0, 13, 14,
    13, 14, 13, 14, 14, 0, 0, 10,
    18, 10, 18, 10, 18, 0, 0, 0,
    19, 0, 19, 0, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 20, 0, 20,
    0, 20, 0, 15, 0, 15, 0, 15,
    0, 15, 0, 15, 0, 15, 0, 21,
    0, 22, 23, 22, 24, 25, 24, 25,
    24, 25, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 9, 10, 9, 10, 9,
    10, 11, 12, 11, 12, 11, 12, 11,
    12, 0, 12, 0, 0, 0, 12, 0,
    12, 0, 12, 0, 12, 0, 12, 11,
    12, 11, 12, 11, 12, 11, 12, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 14,
    0, 14, 0, 14, 14, 0, 0, 11,
    15, 11, 15, 11, 15, 11, 12, 0,
    0, 0, 0, 0, 0, 16, 17, 16,
    17, 16, 17, 16, 17, 18, 0, 18,
    0, 0, 0, 19, 20, 19, 20, 19,
    20, 19, 20, 19, 20, 19, 20, 21,
    0, 22, 23, 22, 24, 25, 24, 25,
    24, 25, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, -13, 0, 0, 0, 0, 0,
    0, -15, -6, 0, -7, 0, -2, -8,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, 3,
    0, 0, 0, 0, -21, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -28, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -15, 0,
    0, 0, 0, 0, 0, 0, 0, -1,
    0, 0, 0, -1, 0, 0, -16, -2,
    -1, -9, -12, -6, 0, 2, 0, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -13, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, -5, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    -2, 0, 0, 3, 0, -2, 0, 0,
    -3, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, -3, 0, 0, 0, 0, -13, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, -4, -3, 0, -3, -3, 0, 0,
    0, 0, -3, 0, 0, -5, 0, 0,
    0, -42, 0, 0, 0, 0, 0, 0,
    2, 0, -8, 0, 0, 0, 0, 0,
    0, -34, -7, -5, -18, -30, -17, 0,
    0, 0, -17, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -2,
    0, -2, 0, 2, 0, 0, 0, -15,
    0, 0, 0, -5, 0, -2, 0, 0,
    -2, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, -5, 0, 0, 0, 0,
    -27, -29, 0, -10, -14, -3, -12, -30,
    -14, -12, -2, -14, 2, 0, -12, 2,
    2, -9, 0, -7, 0, 0, 0, 2,
    0, -15, -7, 0, -5, -4, 0, -4,
    0, 0, -4, 0, 0, 2, 0, -2,
    0, 0, 0, 0, 0, 0, 0, -4,
    3, -6, -26, -6, 0, -12, -9, -4,
    -8, -12, -5, -8, -2, -7, 2, -12,
    -5, 2, 2, -2, 0, -4, 0, 2,
    0, 0, 0, -13, 0, 0, 0, -2,
    0, -2, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, -3, -3, 0, 0, -3, 0, 0,
    0, 0, -2, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -2, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 25,
    .right_class_cnt     = 25,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_16 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 21,          /*The maximum line height required by the font*/
    .base_line = 5,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_16*/


