#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 12 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef RB_LV_FONT_ROBOTO_12
#define RB_LV_FONT_ROBOTO_12 1
#endif

#if RB_LV_FONT_ROBOTO_12

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xf, 0x10, 0xf1, 0xf, 0x10, 0xf1, 0xf, 0x0,
    0xf0, 0x9, 0x0, 0x30, 0xe, 0x10,

    /* U+22 "\"" */
    0x39, 0x93, 0x39, 0x92, 0x38, 0x91, 0x1, 0x10,

    /* U+23 "#" */
    0x0, 0xc, 0x7, 0x60, 0x0, 0x1c, 0xa, 0x20,
    0xc, 0xee, 0xef, 0xe3, 0x0, 0x76, 0x1c, 0x0,
    0x0, 0xa3, 0x49, 0x0, 0x4e, 0xfe, 0xee, 0xb0,
    0x0, 0xd0, 0x93, 0x0, 0x2, 0xb0, 0xc1, 0x0,
    0x4, 0x80, 0xd0, 0x0,

    /* U+24 "$" */
    0x0, 0xd, 0x0, 0x0, 0x6, 0xf6, 0x0, 0xa,
    0xc7, 0xd8, 0x0, 0xf2, 0x3, 0xe0, 0xe, 0x40,
    0x5, 0x0, 0x6f, 0x81, 0x0, 0x0, 0x3a, 0xf5,
    0x0, 0x0, 0x4, 0xe0, 0x4d, 0x0, 0xf, 0x0,
    0xe7, 0x4a, 0xc0, 0x2, 0xaf, 0x91, 0x0, 0x0,
    0xd0, 0x0,

    /* U+25 "%" */
    0xb, 0xc8, 0x0, 0x0, 0x5, 0x80, 0xc0, 0x28,
    0x0, 0x58, 0xd, 0xb, 0x10, 0x0, 0x9c, 0x65,
    0x70, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0,
    0x94, 0x8c, 0x80, 0x0, 0x3a, 0x2b, 0xa, 0x30,
    0xb, 0x12, 0xa0, 0xa3, 0x0, 0x0, 0xa, 0xca,
    0x0,

    /* U+26 "&" */
    0x2, 0xcf, 0xb0, 0x0, 0x9, 0x90, 0xb6, 0x0,
    0x9, 0x80, 0xc4, 0x0, 0x3, 0xec, 0x80, 0x0,
    0x4, 0xee, 0x0, 0x30, 0x2e, 0x29, 0xb2, 0xd0,
    0x5b, 0x0, 0xcc, 0x90, 0x2e, 0x10, 0x5f, 0x50,
    0x5, 0xdd, 0xc7, 0xe1,

    /* U+27 "'" */
    0x67, 0x67, 0x66, 0x0,

    /* U+28 "(" */
    0x0, 0x2, 0x0, 0x5a, 0x1, 0xd0, 0x8, 0x80,
    0xd, 0x30, 0x1f, 0x0, 0x2e, 0x0, 0x3e, 0x0,
    0x2f, 0x0, 0xf, 0x10, 0xb, 0x50, 0x5, 0xa0,
    0x0, 0xb3, 0x0, 0x19,

    /* U+29 ")" */
    0x20, 0x0, 0x87, 0x0, 0xd, 0x20, 0x7, 0x90,
    0x2, 0xf0, 0x0, 0xe2, 0x0, 0xc4, 0x0, 0xc4,
    0x0, 0xd3, 0x0, 0xf1, 0x3, 0xd0, 0x9, 0x60,
    0x2c, 0x0, 0x82, 0x0,

    /* U+2A "*" */
    0x0, 0xd0, 0x4, 0x1c, 0x4, 0x7d, 0xfe, 0x90,
    0x6e, 0x80, 0x1d, 0x1d, 0x20, 0x10, 0x10,

    /* U+2B "+" */
    0x0, 0x1b, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0,
    0x2e, 0x0, 0x8, 0xff, 0xff, 0xf4, 0x12, 0x4e,
    0x22, 0x0, 0x2, 0xe0, 0x0, 0x0, 0x2e, 0x0,
    0x0,

    /* U+2C "," */
    0x4c, 0x5b, 0xa4, 0x0,

    /* U+2D "-" */
    0xbf, 0xf1,

    /* U+2E "." */
    0x4, 0x1, 0xe1,

    /* U+2F "/" */
    0x0, 0x8, 0x60, 0x0, 0xd1, 0x0, 0x3b, 0x0,
    0x9, 0x50, 0x0, 0xd0, 0x0, 0x4a, 0x0, 0xa,
    0x40, 0x0, 0xd0, 0x0, 0x59, 0x0, 0xb, 0x30,
    0x0,

    /* U+30 "0" */
    0x3, 0xde, 0xb1, 0x0, 0xe5, 0x9, 0xa0, 0x3d,
    0x0, 0x2e, 0x4, 0xc0, 0x0, 0xf0, 0x5c, 0x0,
    0xf, 0x14, 0xc0, 0x0, 0xf0, 0x3e, 0x0, 0x2f,
    0x0, 0xe5, 0x9, 0xa0, 0x3, 0xdf, 0xb1, 0x0,

    /* U+31 "1" */
    0x5, 0xc4, 0xea, 0xe4, 0x10, 0xd4, 0x0, 0xd4,
    0x0, 0xd4, 0x0, 0xd4, 0x0, 0xd4, 0x0, 0xd4,
    0x0, 0xd4,

    /* U+32 "2" */
    0x5, 0xdf, 0xb2, 0x2, 0xe3, 0x9, 0xb0, 0x48,
    0x0, 0x3d, 0x0, 0x0, 0x7, 0x90, 0x0, 0x2,
    0xe1, 0x0, 0x1, 0xd4, 0x0, 0x0, 0xc6, 0x0,
    0x0, 0xb8, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x40,

    /* U+33 "3" */
    0x5, 0xde, 0xb1, 0x2e, 0x20, 0x99, 0x25, 0x0,
    0x4c, 0x0, 0x0, 0xa8, 0x0, 0xbf, 0xd1, 0x0,
    0x0, 0x8a, 0x24, 0x0, 0x2e, 0x3e, 0x20, 0x8b,
    0x6, 0xef, 0xb1,

    /* U+34 "4" */
    0x0, 0x3, 0xf4, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x6a, 0xc4, 0x0, 0x1d, 0x1c, 0x40, 0x9, 0x70,
    0xc4, 0x3, 0xd0, 0xc, 0x40, 0xaf, 0xff, 0xff,
    0x70, 0x0, 0xc, 0x40, 0x0, 0x0, 0xc4, 0x0,

    /* U+35 "5" */
    0x6, 0xff, 0xff, 0x0, 0x88, 0x11, 0x10, 0x9,
    0x60, 0x0, 0x0, 0xbc, 0xec, 0x30, 0x6, 0x62,
    0x8e, 0x0, 0x0, 0x0, 0xe3, 0x7, 0x0, 0xd,
    0x30, 0xd6, 0x5, 0xe0, 0x2, 0xcf, 0xd3, 0x0,

    /* U+36 "6" */
    0x0, 0x5d, 0xf0, 0x0, 0x5e, 0x40, 0x0, 0xd,
    0x40, 0x0, 0x1, 0xf9, 0xec, 0x20, 0x3f, 0x60,
    0x7d, 0x3, 0xe0, 0x0, 0xf1, 0x1f, 0x0, 0xf,
    0x10, 0xb8, 0x7, 0xd0, 0x1, 0xbf, 0xc2, 0x0,

    /* U+37 "7" */
    0x8f, 0xff, 0xff, 0x30, 0x0, 0x2, 0xd0, 0x0,
    0x0, 0x97, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x7,
    0x90, 0x0, 0x0, 0xe2, 0x0, 0x0, 0x5b, 0x0,
    0x0, 0xc, 0x50, 0x0, 0x3, 0xe0, 0x0, 0x0,

    /* U+38 "8" */
    0x3, 0xdf, 0xb1, 0x0, 0xe5, 0x9, 0xa0, 0x1f,
    0x0, 0x3d, 0x0, 0xd5, 0x9, 0x90, 0x4, 0xff,
    0xe1, 0x1, 0xe4, 0x7, 0xb0, 0x4c, 0x0, 0xf,
    0x2, 0xe3, 0x6, 0xd0, 0x5, 0xdf, 0xc2, 0x0,

    /* U+39 "9" */
    0x5, 0xde, 0x90, 0x1f, 0x30, 0xc7, 0x5b, 0x0,
    0x4c, 0x5b, 0x0, 0x2e, 0x1f, 0x30, 0xae, 0x5,
    0xee, 0x8d, 0x0, 0x0, 0x79, 0x0, 0x15, 0xe2,
    0x3, 0xfc, 0x30,

    /* U+100 "Ā" */
    0x0, 0xee, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x2e, 0xe0, 0x0,
    0x0, 0x79, 0xc4, 0x0, 0x0, 0xd4, 0x7a, 0x0,
    0x3, 0xe0, 0x1f, 0x10, 0x9, 0xa0, 0xc, 0x60,
    0xe, 0xff, 0xff, 0xc0, 0x4e, 0x0, 0x1, 0xf2,
    0xa8, 0x0, 0x0, 0xb7,

    /* U+101 "ā" */
    0x7, 0xee, 0xe5, 0x0, 0x0, 0x0, 0x4, 0xde,
    0xb0, 0x1f, 0x30, 0xb7, 0x2, 0x0, 0x7a, 0x5,
    0xcd, 0xea, 0x3e, 0x10, 0x7a, 0x4e, 0x12, 0xca,
    0x9, 0xfd, 0x8b,

    /* U+102 "Ă" */
    0x0, 0x61, 0x25, 0x0, 0x0, 0x4c, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x2e, 0xe0, 0x0, 0x0, 0x79, 0xc4, 0x0,
    0x0, 0xd4, 0x7a, 0x0, 0x3, 0xe0, 0x1f, 0x10,
    0x9, 0xa0, 0xc, 0x60, 0xe, 0xff, 0xff, 0xc0,
    0x4e, 0x0, 0x1, 0xf2, 0xa8, 0x0, 0x0, 0xb7,

    /* U+103 "ă" */
    0x4, 0xa0, 0xd1, 0x0, 0x9c, 0x70, 0x0, 0x0,
    0x0, 0x7, 0xde, 0xb0, 0x18, 0x10, 0xb7, 0x0,
    0x0, 0x7a, 0x5, 0xcd, 0xea, 0x3e, 0x10, 0x7a,
    0x4e, 0x12, 0xca, 0x9, 0xfd, 0x8b,

    /* U+104 "Ą" */
    0x0, 0xc, 0x90, 0x0, 0x0, 0x2e, 0xe0, 0x0,
    0x0, 0x79, 0xc4, 0x0, 0x0, 0xd4, 0x7a, 0x0,
    0x3, 0xe0, 0x1f, 0x10, 0x9, 0xa0, 0xc, 0x60,
    0xe, 0xff, 0xff, 0xc0, 0x4e, 0x0, 0x1, 0xf2,
    0xa8, 0x0, 0x0, 0xa7, 0x0, 0x0, 0x1, 0xc1,
    0x0, 0x0, 0x6, 0x80, 0x0, 0x0, 0x4, 0xe6,

    /* U+105 "ą" */
    0x4, 0xde, 0xb0, 0x1f, 0x30, 0xb7, 0x2, 0x0,
    0x7a, 0x5, 0xcd, 0xea, 0x3e, 0x10, 0x7a, 0x4e,
    0x12, 0xca, 0x9, 0xfd, 0x9c, 0x0, 0x0, 0xb2,
    0x0, 0x3, 0xb0, 0x0, 0x1, 0xea,

    /* U+106 "Ć" */
    0x0, 0x0, 0xc6, 0x0, 0x0, 0x5, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xea, 0x10,
    0x9, 0xc2, 0x9, 0xc0, 0x1f, 0x20, 0x0, 0xe2,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0x1f, 0x10, 0x0, 0xe2,
    0x9, 0xb1, 0x18, 0xc0, 0x0, 0x9f, 0xea, 0x10,

    /* U+107 "ć" */
    0x0, 0xa, 0x90, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xb1, 0x1f, 0x40, 0x9a, 0x5b,
    0x0, 0x16, 0x6a, 0x0, 0x0, 0x5b, 0x0, 0x3,
    0x1e, 0x40, 0x8a, 0x3, 0xdf, 0xa0,

    /* U+108 "Ĉ" */
    0x0, 0xb, 0xa0, 0x0, 0x0, 0x42, 0x34, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xea, 0x10,
    0x9, 0xc2, 0x9, 0xc0, 0x1f, 0x20, 0x0, 0xe2,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0x1f, 0x10, 0x0, 0xe2,
    0x9, 0xb1, 0x18, 0xc0, 0x0, 0x9f, 0xea, 0x10,

    /* U+109 "ĉ" */
    0x0, 0x9c, 0x0, 0x5, 0x95, 0x80, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xb1, 0x1f, 0x40, 0x9a, 0x5b,
    0x0, 0x16, 0x6a, 0x0, 0x0, 0x5b, 0x0, 0x3,
    0x1e, 0x40, 0x8a, 0x3, 0xdf, 0xa0,

    /* U+10A "Ċ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0xea, 0x10, 0x9, 0xc2, 0x9, 0xc0,
    0x1f, 0x20, 0x0, 0xe2, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0x1f, 0x10, 0x0, 0xe2, 0x9, 0xb1, 0x18, 0xc0,
    0x0, 0x9f, 0xea, 0x10,

    /* U+10B "ċ" */
    0x0, 0x69, 0x0, 0x0, 0x12, 0x0, 0x4, 0xdf,
    0xb1, 0x1f, 0x40, 0x9a, 0x5b, 0x0, 0x16, 0x6a,
    0x0, 0x0, 0x5b, 0x0, 0x3, 0x1e, 0x40, 0x8a,
    0x3, 0xdf, 0xa0,

    /* U+10C "Č" */
    0x0, 0x57, 0x85, 0x0, 0x0, 0x4, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xea, 0x10,
    0x9, 0xc2, 0x9, 0xc0, 0x1f, 0x20, 0x0, 0xe2,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0x1f, 0x10, 0x0, 0xe2,
    0x9, 0xb1, 0x18, 0xc0, 0x0, 0x9f, 0xea, 0x10,

    /* U+10D "č" */
    0x5, 0xa6, 0x90, 0x0, 0x9c, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xb1, 0x1f, 0x40, 0x8a, 0x5b,
    0x0, 0x3, 0x6a, 0x0, 0x0, 0x5b, 0x0, 0x14,
    0x1e, 0x40, 0x8a, 0x3, 0xdf, 0xa0,

    /* U+10E "Ď" */
    0x0, 0xc3, 0xc1, 0x0, 0x0, 0x2f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xd5, 0x0,
    0xf, 0x10, 0x4e, 0x50, 0xf, 0x10, 0x4, 0xd0,
    0xf, 0x10, 0x0, 0xf1, 0xf, 0x10, 0x0, 0xf2,
    0xf, 0x10, 0x0, 0xf1, 0xf, 0x10, 0x5, 0xd0,
    0xf, 0x10, 0x4e, 0x50, 0xf, 0xff, 0xd5, 0x0,

    /* U+10F "ď" */
    0x0, 0x0, 0x2e, 0x4b, 0x0, 0x0, 0x2e, 0x78,
    0x0, 0x0, 0x2e, 0x52, 0x4, 0xde, 0x9e, 0x0,
    0x1f, 0x51, 0x9e, 0x0, 0x5c, 0x0, 0x2e, 0x0,
    0x6a, 0x0, 0x2e, 0x0, 0x5b, 0x0, 0x2e, 0x0,
    0xe, 0x30, 0x8e, 0x0, 0x4, 0xdd, 0x9e, 0x0,

    /* U+110 "Đ" */
    0xd, 0xff, 0xd7, 0x0, 0xd, 0x40, 0x3c, 0x80,
    0xd, 0x40, 0x2, 0xf0, 0xd, 0x40, 0x0, 0xe4,
    0xef, 0xfb, 0x0, 0xc5, 0xd, 0x40, 0x0, 0xe4,
    0xd, 0x40, 0x2, 0xf1, 0xd, 0x40, 0x3d, 0x80,
    0xd, 0xff, 0xd7, 0x0,

    /* U+111 "đ" */
    0x0, 0x0, 0x2e, 0x0, 0x0, 0xa, 0xff, 0xf0,
    0x0, 0x0, 0x2e, 0x0, 0x4, 0xde, 0x9e, 0x0,
    0x1f, 0x51, 0x9e, 0x0, 0x5c, 0x0, 0x2e, 0x0,
    0x6a, 0x0, 0x2e, 0x0, 0x5b, 0x0, 0x2e, 0x0,
    0xe, 0x30, 0x8e, 0x0, 0x4, 0xdd, 0x9e, 0x0,

    /* U+112 "Ē" */
    0x4, 0xee, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0x50, 0xf1, 0x0, 0x0, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0xff, 0xfd,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0xff, 0xff, 0x60,

    /* U+113 "ē" */
    0x9, 0xee, 0xe4, 0x0, 0x0, 0x0, 0x3, 0xdf,
    0xa0, 0xe, 0x50, 0xa8, 0x5c, 0x0, 0x3c, 0x6f,
    0xff, 0xfe, 0x5b, 0x0, 0x0, 0x1e, 0x40, 0x47,
    0x3, 0xcf, 0xc3,

    /* U+114 "Ĕ" */
    0x0, 0x70, 0x52, 0x0, 0x8, 0xca, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+115 "ĕ" */
    0x5, 0x90, 0xe0, 0x0, 0xac, 0x50, 0x0, 0x0,
    0x0, 0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c,
    0x0, 0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0,
    0x1e, 0x40, 0x47, 0x3, 0xcf, 0xc3,

    /* U+116 "Ė" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe2, 0x0, 0x0,
    0x2, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+117 "ė" */
    0x0, 0x3c, 0x0, 0x0, 0x3, 0x0, 0x3, 0xdf,
    0xa0, 0xe, 0x50, 0xa8, 0x5c, 0x0, 0x3c, 0x6f,
    0xff, 0xfe, 0x5b, 0x0, 0x0, 0x1e, 0x40, 0x47,
    0x3, 0xcf, 0xc3,

    /* U+118 "Ę" */
    0xf, 0xff, 0xff, 0x50, 0xf1, 0x0, 0x0, 0xf,
    0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0xff,
    0xfd, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0xff, 0xff, 0x60,
    0x0, 0x7, 0x80, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0xa, 0xe0,

    /* U+119 "ę" */
    0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c, 0x0,
    0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0, 0x1e,
    0x40, 0x47, 0x3, 0xcf, 0xf5, 0x0, 0xd, 0x40,
    0x0, 0x2d, 0x0, 0x0, 0xd, 0xb0,

    /* U+11A "Ě" */
    0x0, 0xc3, 0xc2, 0x0, 0x2, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf5, 0xf, 0x10,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xd0, 0xf, 0x10, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xf6,

    /* U+11B "ě" */
    0x2, 0xc4, 0xb0, 0x0, 0x6e, 0x10, 0x0, 0x0,
    0x0, 0x3, 0xdf, 0xa0, 0xe, 0x50, 0xa8, 0x5c,
    0x0, 0x3c, 0x6f, 0xff, 0xfe, 0x5b, 0x0, 0x0,
    0x1e, 0x40, 0x47, 0x3, 0xcf, 0xc3,

    /* U+11C "Ĝ" */
    0x0, 0x1b, 0xa0, 0x0, 0x0, 0x52, 0x33, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0x9, 0xc2, 0x7, 0xe0, 0xf, 0x20, 0x0, 0x61,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0xcf, 0xf4,
    0x3e, 0x0, 0x0, 0xd4, 0xf, 0x20, 0x0, 0xd4,
    0x8, 0xd2, 0x4, 0xf3, 0x0, 0x7e, 0xfd, 0x60,

    /* U+11D "ĝ" */
    0x0, 0x7d, 0x10, 0x3, 0xa3, 0x90, 0x0, 0x0,
    0x0, 0x4, 0xde, 0x8e, 0x1f, 0x51, 0x9e, 0x5c,
    0x0, 0x2e, 0x6a, 0x0, 0x2e, 0x5c, 0x0, 0x2e,
    0xf, 0x51, 0x9e, 0x4, 0xde, 0x9e, 0x0, 0x0,
    0x4d, 0xc, 0x20, 0xb9, 0x6, 0xde, 0xa0,

    /* U+11E "Ğ" */
    0x0, 0xb3, 0x59, 0x0, 0x0, 0x3b, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfb, 0x20,
    0x9, 0xc2, 0x7, 0xe0, 0xf, 0x20, 0x0, 0x61,
    0x3e, 0x0, 0x0, 0x0, 0x4d, 0x0, 0xcf, 0xf4,
    0x3e, 0x0, 0x0, 0xd4, 0xf, 0x20, 0x0, 0xd4,
    0x8, 0xd2, 0x4, 0xf3, 0x0, 0x7e, 0xfd, 0x60,

    /* U+11F "ğ" */
    0x7, 0x60, 0xd0, 0x3, 0xa1, 0xc0, 0x0, 0x8b,
    0x30, 0x4, 0xde, 0x8e, 0x1f, 0x51, 0x9e, 0x5c,
    0x0, 0x2e, 0x6a, 0x0, 0x2e, 0x5c, 0x0, 0x2e,
    0xf, 0x51, 0x9e, 0x4, 0xde, 0x9e, 0x0, 0x0,
    0x4d, 0xc, 0x20, 0xb9, 0x6, 0xde, 0xa0,

    /* U+120 "Ġ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0xfb, 0x20, 0x9, 0xc2, 0x7, 0xe0,
    0xf, 0x20, 0x0, 0x61, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0xcf, 0xf4, 0x3e, 0x0, 0x0, 0xd4,
    0xf, 0x20, 0x0, 0xd4, 0x8, 0xd2, 0x4, 0xf3,
    0x0, 0x7e, 0xfd, 0x60,

    /* U+121 "ġ" */
    0x0, 0x4b, 0x0, 0x0, 0x3, 0x0, 0x4, 0xde,
    0x8e, 0x1f, 0x51, 0x9e, 0x5c, 0x0, 0x2e, 0x6a,
    0x0, 0x2e, 0x5c, 0x0, 0x2e, 0xf, 0x51, 0x9e,
    0x4, 0xde, 0x9e, 0x0, 0x0, 0x4d, 0xc, 0x20,
    0xb9, 0x6, 0xde, 0xa0,

    /* U+122 "Ģ" */
    0x0, 0x9e, 0xfb, 0x20, 0x9, 0xc2, 0x7, 0xe0,
    0xf, 0x20, 0x0, 0x61, 0x3e, 0x0, 0x0, 0x0,
    0x4d, 0x0, 0xcf, 0xf4, 0x3e, 0x0, 0x0, 0xd4,
    0xf, 0x20, 0x0, 0xd4, 0x8, 0xd2, 0x4, 0xf3,
    0x0, 0x7e, 0xfd, 0x60, 0x0, 0x2, 0x60, 0x0,
    0x0, 0x5, 0xa0, 0x0, 0x0, 0x7, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+123 "ģ" */
    0x0, 0x0, 0x0, 0x0, 0xd, 0x0, 0x0, 0x4c,
    0x0, 0x0, 0x26, 0x0, 0x4, 0xde, 0x8e, 0x1f,
    0x51, 0x9e, 0x5c, 0x0, 0x2e, 0x6a, 0x0, 0x2e,
    0x5c, 0x0, 0x2e, 0xf, 0x51, 0x9e, 0x4, 0xde,
    0x9e, 0x0, 0x0, 0x4d, 0xc, 0x20, 0xb9, 0x6,
    0xde, 0xa0,

    /* U+124 "Ĥ" */
    0x0, 0x8, 0xc0, 0x0, 0x0, 0x4a, 0x59, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0xff, 0xff, 0xf8,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,
    0xf, 0x10, 0x0, 0x98, 0xf, 0x10, 0x0, 0x98,

    /* U+125 "ĥ" */
    0x0, 0xb9, 0x0, 0x8, 0x68, 0x50, 0x2e, 0x0,
    0x0, 0x2e, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x2e,
    0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e, 0x0, 0x4c,
    0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d, 0x2e, 0x0,
    0x4d, 0x2e, 0x0, 0x4d,

    /* U+126 "Ħ" */
    0xf, 0x10, 0x0, 0xa8, 0x0, 0xf1, 0x0, 0xa,
    0x80, 0xbf, 0xee, 0xee, 0xff, 0x40, 0xf1, 0x0,
    0xa, 0x80, 0xf, 0xff, 0xff, 0xf8, 0x0, 0xf1,
    0x0, 0xa, 0x80, 0xf, 0x10, 0x0, 0xa8, 0x0,
    0xf1, 0x0, 0xa, 0x80, 0xf, 0x10, 0x0, 0xa8,
    0x0,

    /* U+127 "ħ" */
    0x0, 0xf1, 0x0, 0x2, 0xff, 0xf8, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0xf, 0x7e, 0xe4, 0x0, 0xf9,
    0x6, 0xd0, 0xf, 0x10, 0x1f, 0x0, 0xf1, 0x1,
    0xf0, 0xf, 0x10, 0x1f, 0x0, 0xf1, 0x1, 0xf0,
    0xf, 0x10, 0x1f,

    /* U+128 "Ĩ" */
    0x0, 0x0, 0x1, 0xc8, 0x2a, 0x56, 0x5e, 0x40,
    0x0, 0x0, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3,
    0x0,

    /* U+129 "ĩ" */
    0x0, 0x0, 0x2, 0xe6, 0x47, 0x73, 0x7d, 0x20,
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f,
    0x0, 0x1, 0xf0, 0x0,

    /* U+12A "Ī" */
    0x4e, 0xee, 0x90, 0x0, 0x0, 0x0, 0xe3, 0x0,
    0xe, 0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30, 0x0, 0xe3, 0x0,

    /* U+12B "ī" */
    0x6e, 0xee, 0x70, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0,

    /* U+12C "Ĭ" */
    0x7, 0x4, 0x20, 0x8c, 0xa0, 0x0, 0x0, 0x0,
    0xe, 0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30, 0x0, 0xe3, 0x0, 0xe, 0x30,

    /* U+12D "ĭ" */
    0x2c, 0xc, 0x20, 0x8c, 0x70, 0x0, 0x0, 0x0,
    0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f,
    0x0,

    /* U+12E "Į" */
    0xe, 0x30, 0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30,
    0xe3, 0xe, 0x30, 0xe3, 0xf, 0x36, 0xa0, 0xd2,
    0x9, 0xe2,

    /* U+12F "į" */
    0x1, 0xe0, 0x0, 0x30, 0x1, 0xf0, 0x1, 0xf0,
    0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0,
    0x1, 0xf0, 0x8, 0x70, 0xf, 0x0, 0xb, 0xd0,

    /* U+130 "İ" */
    0x0, 0x0, 0xe2, 0x2, 0x0, 0xe3, 0xe, 0x30,
    0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30, 0xe3, 0xe,
    0x30, 0xe3,

    /* U+131 "ı" */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,

    /* U+132 "Ĳ" */
    0xe3, 0x0, 0x0, 0x2f, 0xe3, 0x0, 0x0, 0x2f,
    0xe3, 0x0, 0x0, 0x2f, 0xe3, 0x0, 0x0, 0x2f,
    0xe3, 0x0, 0x0, 0x2f, 0xe3, 0x0, 0x0, 0x2f,
    0xe3, 0x36, 0x0, 0x3e, 0xe3, 0x3e, 0x10, 0x8a,
    0xe3, 0x6, 0xde, 0xb1,

    /* U+133 "ĳ" */
    0x1e, 0x3, 0xc0, 0x30, 0x3, 0x1f, 0x3, 0xd1,
    0xf0, 0x3d, 0x1f, 0x3, 0xd1, 0xf0, 0x3d, 0x1f,
    0x3, 0xd1, 0xf0, 0x3d, 0x1f, 0x3, 0xd0, 0x0,
    0x3d, 0x0, 0x6, 0xc0, 0x6, 0xe5,

    /* U+134 "Ĵ" */
    0x0, 0x0, 0xba, 0x0, 0x0, 0x77, 0x86, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0,
    0x7b, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0, 0x7b,
    0x0, 0x0, 0x7, 0xb0, 0x0, 0x0, 0x7b, 0x6,
    0x40, 0x7, 0xa0, 0x7c, 0x11, 0xd6, 0x0, 0x9e,
    0xe9, 0x0,

    /* U+135 "ĵ" */
    0x2, 0xe4, 0x0, 0xc3, 0xc1, 0x0, 0x0, 0x0,
    0xf, 0x10, 0x0, 0xf1, 0x0, 0xf, 0x10, 0x0,
    0xf1, 0x0, 0xf, 0x10, 0x0, 0xf1, 0x0, 0xf,
    0x10, 0x0, 0xf1, 0x0, 0x2f, 0x0, 0x6e, 0x60,
    0x0,

    /* U+136 "Ķ" */
    0xf, 0x10, 0x8, 0xc0, 0xf, 0x10, 0x6e, 0x10,
    0xf, 0x13, 0xe3, 0x0, 0xf, 0x4e, 0x40, 0x0,
    0xf, 0xef, 0x40, 0x0, 0xf, 0x85, 0xe1, 0x0,
    0xf, 0x10, 0x9b, 0x0, 0xf, 0x10, 0xd, 0x70,
    0xf, 0x10, 0x3, 0xf3, 0x0, 0xa, 0x50, 0x0,
    0x0, 0xd, 0x20, 0x0, 0x0, 0x4, 0x0, 0x0,

    /* U+137 "ķ" */
    0x2e, 0x0, 0x0, 0x2, 0xe0, 0x0, 0x0, 0x2e,
    0x0, 0x0, 0x2, 0xe0, 0x1d, 0x50, 0x2e, 0xc,
    0x80, 0x2, 0xea, 0xa0, 0x0, 0x2f, 0xfb, 0x0,
    0x2, 0xf2, 0xd6, 0x0, 0x2e, 0x3, 0xe1, 0x2,
    0xe0, 0x8, 0xb0, 0x0, 0x34, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+138 "ĸ" */
    0x1f, 0x0, 0x8c, 0x1, 0xf0, 0x4e, 0x10, 0x1f,
    0x1e, 0x40, 0x1, 0xff, 0xb0, 0x0, 0x1f, 0x3e,
    0x50, 0x1, 0xf0, 0x4f, 0x20, 0x1f, 0x0, 0x6e,
    0x10,

    /* U+139 "Ĺ" */
    0x0, 0x71, 0x0, 0x0, 0xa5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0, 0x0,
    0xf2, 0x0, 0x0, 0xf, 0x20, 0x0, 0x0, 0xff,
    0xff, 0xf2,

    /* U+13A "ĺ" */
    0x1, 0x70, 0x9, 0x80, 0x6, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0,

    /* U+13B "Ļ" */
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,
    0x0, 0x71, 0x0, 0x0, 0xf, 0x0, 0x0, 0x2,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+13C "ļ" */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
    0x1f, 0x1f, 0x7, 0x1e, 0x47, 0x0,

    /* U+13D "Ľ" */
    0xf, 0x24, 0xb0, 0x0, 0xf2, 0x78, 0x0, 0xf,
    0x23, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,

    /* U+13E "ľ" */
    0x1f, 0xf, 0x1, 0xf3, 0xc0, 0x1f, 0x23, 0x1,
    0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f,
    0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0,
    0x0,

    /* U+13F "Ŀ" */
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x79, 0x0, 0xf, 0x21,
    0x10, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,

    /* U+140 "ŀ" */
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x3d, 0x1f, 0x2, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0,

    /* U+141 "Ł" */
    0xf, 0x10, 0x0, 0x0, 0xf1, 0x0, 0x0, 0xf,
    0x10, 0x0, 0x0, 0xf6, 0x60, 0x0, 0x9f, 0x71,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xf, 0x10, 0x0,
    0x0, 0xf1, 0x0, 0x0, 0xf, 0xff, 0xff, 0x20,

    /* U+142 "ł" */
    0xf, 0x20, 0xf, 0x20, 0xf, 0x20, 0xf, 0x20,
    0xf, 0xc0, 0x9f, 0x20, 0xf, 0x20, 0xf, 0x20,
    0xf, 0x20, 0xf, 0x20,

    /* U+143 "Ń" */
    0x0, 0x0, 0x36, 0x0, 0x0, 0x1, 0xc2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x98,
    0xf, 0xf1, 0x0, 0x98, 0xf, 0xba, 0x0, 0x98,
    0xf, 0x3e, 0x40, 0x98, 0xf, 0x25, 0xd0, 0x98,
    0xf, 0x20, 0xb8, 0x98, 0xf, 0x20, 0x2f, 0xb8,
    0xf, 0x20, 0x8, 0xf8, 0xf, 0x20, 0x0, 0xd8,

    /* U+144 "ń" */
    0x0, 0x6, 0xc0, 0x0, 0xd, 0x10, 0x0, 0x0,
    0x0, 0x2d, 0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e,
    0x0, 0x4c, 0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,
    0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,

    /* U+145 "Ņ" */
    0xf, 0x60, 0x0, 0x98, 0xf, 0xf1, 0x0, 0x98,
    0xf, 0xba, 0x0, 0x98, 0xf, 0x3e, 0x40, 0x98,
    0xf, 0x25, 0xd0, 0x98, 0xf, 0x20, 0xb8, 0x98,
    0xf, 0x20, 0x2f, 0xb8, 0xf, 0x20, 0x8, 0xf8,
    0xf, 0x20, 0x0, 0xd8, 0x0, 0x2, 0x50, 0x0,
    0x0, 0x5, 0xa0, 0x0, 0x0, 0x8, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+146 "ņ" */
    0x2d, 0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e, 0x0,
    0x4c, 0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d, 0x2e,
    0x0, 0x4d, 0x2e, 0x0, 0x4d, 0x0, 0x16, 0x0,
    0x0, 0x4b, 0x0, 0x0, 0x75, 0x0, 0x0, 0x0,
    0x0,

    /* U+147 "Ň" */
    0x0, 0x24, 0x6, 0x0, 0x0, 0x8, 0xa2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x98,
    0xf, 0xf1, 0x0, 0x98, 0xf, 0xba, 0x0, 0x98,
    0xf, 0x3e, 0x40, 0x98, 0xf, 0x25, 0xd0, 0x98,
    0xf, 0x20, 0xb8, 0x98, 0xf, 0x20, 0x2f, 0xb8,
    0xf, 0x20, 0x8, 0xf8, 0xf, 0x20, 0x0, 0xd8,

    /* U+148 "ň" */
    0x2, 0xc4, 0xc0, 0x0, 0x5e, 0x10, 0x0, 0x0,
    0x0, 0x2d, 0x8e, 0xd2, 0x2f, 0x60, 0x9a, 0x2e,
    0x0, 0x4c, 0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,
    0x2e, 0x0, 0x4d, 0x2e, 0x0, 0x4d,

    /* U+149 "ŉ" */
    0xf, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x25,
    0x0, 0x0, 0x0, 0x2d, 0x8e, 0xd2, 0x2, 0xf6,
    0x9, 0xa0, 0x2e, 0x0, 0x4c, 0x2, 0xe0, 0x4,
    0xd0, 0x2e, 0x0, 0x4d, 0x2, 0xe0, 0x4, 0xd0,
    0x2e, 0x0, 0x4d,

    /* U+14A "Ŋ" */
    0xf, 0x60, 0x0, 0xb6, 0xf, 0xe1, 0x0, 0xb6,
    0xf, 0xb9, 0x0, 0xb6, 0xf, 0x2e, 0x30, 0xb6,
    0xf, 0x16, 0xc0, 0xb6, 0xf, 0x10, 0xd6, 0xb6,
    0xf, 0x10, 0x3e, 0xc6, 0xf, 0x10, 0xa, 0xf6,
    0xf, 0x10, 0x1, 0xe6, 0x0, 0x0, 0x0, 0xb6,
    0x0, 0x0, 0x1, 0xe4, 0x0, 0x0, 0x2f, 0xa0,

    /* U+14B "ŋ" */
    0x2d, 0x8f, 0xd2, 0x2f, 0x50, 0x8b, 0x2f, 0x0,
    0x3e, 0x2f, 0x0, 0x2e, 0x2f, 0x0, 0x2e, 0x2f,
    0x0, 0x2e, 0x2f, 0x0, 0x2e, 0x0, 0x0, 0x2e,
    0x0, 0x0, 0x6c, 0x0, 0x9, 0xe4,

    /* U+14C "Ō" */
    0x0, 0xbe, 0xee, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0xfa, 0x10, 0x9, 0xc3, 0x29, 0xd0,
    0x1f, 0x20, 0x0, 0xd4, 0x3e, 0x0, 0x0, 0xa7,
    0x4d, 0x0, 0x0, 0x98, 0x4e, 0x0, 0x0, 0xa7,
    0x1f, 0x20, 0x0, 0xd4, 0x9, 0xc2, 0x19, 0xd0,
    0x0, 0x8e, 0xfb, 0x10,

    /* U+14D "ō" */
    0x8, 0xee, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xcf, 0xb1, 0x1, 0xe5, 0x7, 0xc0, 0x5c, 0x0,
    0xe, 0x27, 0xa0, 0x0, 0xc4, 0x5c, 0x0, 0xe,
    0x30, 0xe5, 0x7, 0xd0, 0x3, 0xcf, 0xc2, 0x0,

    /* U+14E "Ŏ" */
    0x0, 0x43, 0x6, 0x0, 0x0, 0x2b, 0xc5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x10,
    0x9, 0xc3, 0x29, 0xd0, 0x1f, 0x20, 0x0, 0xd4,
    0x3e, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0x98,
    0x4e, 0x0, 0x0, 0xa7, 0x1f, 0x20, 0x0, 0xd4,
    0x9, 0xc2, 0x19, 0xd0, 0x0, 0x8e, 0xfb, 0x10,

    /* U+14F "ŏ" */
    0x4, 0xa0, 0xd0, 0x0, 0x9, 0xc6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xfb, 0x10, 0x1e, 0x50,
    0x7c, 0x5, 0xc0, 0x0, 0xe2, 0x7a, 0x0, 0xc,
    0x45, 0xc0, 0x0, 0xe3, 0xe, 0x50, 0x7d, 0x0,
    0x3c, 0xfc, 0x20,

    /* U+150 "Ő" */
    0x0, 0x8, 0x79, 0x70, 0x0, 0x1d, 0x5b, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xfa, 0x10,
    0x9, 0xc3, 0x29, 0xd0, 0x1f, 0x20, 0x0, 0xd4,
    0x3e, 0x0, 0x0, 0xa7, 0x4d, 0x0, 0x0, 0x98,
    0x4e, 0x0, 0x0, 0xa7, 0x1f, 0x20, 0x0, 0xd4,
    0x9, 0xc2, 0x19, 0xd0, 0x0, 0x8e, 0xfb, 0x10,

    /* U+151 "ő" */
    0x0, 0x5b, 0x7b, 0x0, 0xb, 0x4c, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xfb, 0x10, 0x1e, 0x50,
    0x7c, 0x5, 0xc0, 0x0, 0xe2, 0x7a, 0x0, 0xc,
    0x45, 0xc0, 0x0, 0xe3, 0xe, 0x50, 0x7d, 0x0,
    0x3c, 0xfc, 0x20,

    /* U+152 "Œ" */
    0x1, 0xaf, 0xff, 0xff, 0xff, 0x80, 0xca, 0x31,
    0xd5, 0x22, 0x21, 0x3e, 0x0, 0xd, 0x40, 0x0,
    0x5, 0xb0, 0x0, 0xd4, 0x0, 0x0, 0x6b, 0x0,
    0xd, 0xff, 0xff, 0x5, 0xb0, 0x0, 0xd4, 0x0,
    0x0, 0x3e, 0x0, 0xd, 0x40, 0x0, 0x0, 0xc8,
    0x10, 0xd4, 0x0, 0x0, 0x1, 0xaf, 0xff, 0xff,
    0xff, 0x80,

    /* U+153 "œ" */
    0x3, 0xdf, 0xb1, 0x7e, 0xe6, 0x0, 0xe5, 0x8,
    0xee, 0x22, 0xe2, 0x5c, 0x0, 0xf, 0x70, 0xa,
    0x66, 0xa0, 0x0, 0xef, 0xff, 0xf7, 0x4c, 0x0,
    0xf, 0x60, 0x0, 0x0, 0xe5, 0x8, 0xed, 0x10,
    0x50, 0x3, 0xcf, 0xc2, 0x8e, 0xea, 0x10,

    /* U+154 "Ŕ" */
    0x0, 0x0, 0x71, 0x0, 0x0, 0xa, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xe9, 0x0,
    0xf, 0x10, 0x1b, 0x80, 0xf, 0x10, 0x6, 0xc0,
    0xf, 0x10, 0x1b, 0x80, 0xf, 0xff, 0xf9, 0x0,
    0xf, 0x10, 0xa8, 0x0, 0xf, 0x10, 0x2e, 0x0,
    0xf, 0x10, 0xb, 0x70, 0xf, 0x10, 0x4, 0xe0,

    /* U+155 "ŕ" */
    0x0, 0x5c, 0x0, 0xc, 0x10, 0x0, 0x0, 0x2,
    0xeb, 0xd0, 0x2f, 0x50, 0x2, 0xe0, 0x0, 0x2e,
    0x0, 0x2, 0xe0, 0x0, 0x2e, 0x0, 0x2, 0xe0,
    0x0,

    /* U+156 "Ŗ" */
    0xf, 0xff, 0xe9, 0x0, 0xf, 0x10, 0x1b, 0x80,
    0xf, 0x10, 0x6, 0xc0, 0xf, 0x10, 0x1b, 0x80,
    0xf, 0xff, 0xf9, 0x0, 0xf, 0x10, 0xa8, 0x0,
    0xf, 0x10, 0x2e, 0x0, 0xf, 0x10, 0xb, 0x70,
    0xf, 0x10, 0x4, 0xe0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x39, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+157 "ŗ" */
    0x0, 0x0, 0x2e, 0xbd, 0x2f, 0x50, 0x2e, 0x0,
    0x2e, 0x0, 0x2e, 0x0, 0x2e, 0x0, 0x2e, 0x0,
    0x7, 0x0, 0x2d, 0x0, 0x57, 0x0, 0x0, 0x0,

    /* U+158 "Ř" */
    0x0, 0x60, 0x61, 0x0, 0x0, 0x4b, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xe9, 0x0,
    0xf, 0x10, 0x1b, 0x80, 0xf, 0x10, 0x6, 0xc0,
    0xf, 0x10, 0x1b, 0x80, 0xf, 0xff, 0xf9, 0x0,
    0xf, 0x10, 0xa8, 0x0, 0xf, 0x10, 0x2e, 0x0,
    0xf, 0x10, 0xb, 0x70, 0xf, 0x10, 0x4, 0xe0,

    /* U+159 "ř" */
    0x1c, 0x3c, 0x0, 0x4d, 0x10, 0x0, 0x0, 0x2,
    0xeb, 0xd0, 0x2f, 0x50, 0x2, 0xe0, 0x0, 0x2e,
    0x0, 0x2, 0xe0, 0x0, 0x2e, 0x0, 0x2, 0xe0,
    0x0,

    /* U+15A "Ś" */
    0x0, 0x2, 0xe2, 0x0, 0x0, 0xa5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfd, 0x60, 0x1f, 0x50,
    0x3e, 0x53, 0xe0, 0x0, 0x56, 0xd, 0x92, 0x0,
    0x0, 0x18, 0xec, 0x40, 0x0, 0x0, 0x5e, 0x55,
    0x70, 0x0, 0x8a, 0x3f, 0x40, 0x2c, 0x70, 0x4c,
    0xfe, 0x80,

    /* U+15B "ś" */
    0x0, 0x7, 0xb0, 0x0, 0x1d, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xef, 0xa0, 0x1f, 0x20, 0xb6, 0x1f,
    0x40, 0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7,
    0x4e, 0x10, 0xa7, 0x6, 0xee, 0xa0,

    /* U+15C "Ŝ" */
    0x0, 0x2e, 0x50, 0x0, 0xc, 0x3b, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfd, 0x60, 0x1f, 0x50,
    0x3e, 0x53, 0xe0, 0x0, 0x56, 0xd, 0x92, 0x0,
    0x0, 0x18, 0xec, 0x40, 0x0, 0x0, 0x5e, 0x55,
    0x70, 0x0, 0x8a, 0x3f, 0x40, 0x2c, 0x70, 0x4c,
    0xfe, 0x80,

    /* U+15D "ŝ" */
    0x0, 0x6d, 0x10, 0x2, 0xb3, 0xa0, 0x0, 0x0,
    0x0, 0x6, 0xee, 0x90, 0x1f, 0x21, 0xc6, 0x1f,
    0x40, 0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7,
    0x4e, 0x10, 0xa7, 0x7, 0xee, 0xa0,

    /* U+15E "Ş" */
    0x4, 0xcf, 0xd6, 0x1, 0xf5, 0x3, 0xe5, 0x3e,
    0x0, 0x5, 0x60, 0xd9, 0x20, 0x0, 0x1, 0x8e,
    0xc4, 0x0, 0x0, 0x5, 0xe5, 0x57, 0x0, 0x8,
    0xa3, 0xf4, 0x2, 0xc7, 0x4, 0xcf, 0xe8, 0x0,
    0x0, 0xb6, 0x0, 0x0, 0x0, 0xd0, 0x0, 0x0,
    0xa7, 0x0,

    /* U+15F "ş" */
    0x6, 0xee, 0x90, 0x1f, 0x21, 0xc6, 0x1f, 0x40,
    0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7, 0x4e,
    0x10, 0xa7, 0x7, 0xef, 0xa0, 0x0, 0x2d, 0x20,
    0x0, 0x6, 0x70, 0x0, 0x2c, 0x20,

    /* U+160 "Š" */
    0x0, 0xb4, 0xc2, 0x0, 0x2, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfd, 0x60, 0x1f, 0x50,
    0x3e, 0x53, 0xe0, 0x0, 0x56, 0xd, 0x92, 0x0,
    0x0, 0x18, 0xec, 0x40, 0x0, 0x0, 0x5e, 0x55,
    0x70, 0x0, 0x8a, 0x3f, 0x40, 0x2c, 0x70, 0x4c,
    0xfe, 0x80,

    /* U+161 "š" */
    0x2, 0xb4, 0xb0, 0x0, 0x6d, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xef, 0xa0, 0x1f, 0x20, 0xb6, 0x1f,
    0x40, 0x0, 0x4, 0xce, 0x90, 0x12, 0x1, 0xb7,
    0x4e, 0x10, 0xa7, 0x6, 0xee, 0xa0,

    /* U+162 "Ţ" */
    0xbf, 0xff, 0xff, 0xe0, 0x0, 0xf2, 0x0, 0x0,
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0,
    0xb6, 0x0,

    /* U+163 "ţ" */
    0x6, 0x20, 0xc, 0x40, 0xdf, 0xe6, 0xc, 0x40,
    0xc, 0x40, 0xc, 0x40, 0xc, 0x40, 0xc, 0x60,
    0x5, 0xf7, 0x0, 0xc6, 0x0, 0x1d, 0x0, 0xb6,

    /* U+164 "Ť" */
    0x0, 0x60, 0x51, 0x0, 0x4, 0xb6, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xfe, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0, 0x0,
    0xf2, 0x0,

    /* U+165 "ť" */
    0x0, 0x5, 0x30, 0x0, 0xb4, 0x6, 0x2b, 0x0,
    0xc4, 0x0, 0xdf, 0xe6, 0x0, 0xc4, 0x0, 0xc,
    0x40, 0x0, 0xc4, 0x0, 0xc, 0x40, 0x0, 0xc6,
    0x0, 0x5, 0xf7, 0x0,

    /* U+166 "Ŧ" */
    0xbf, 0xff, 0xff, 0xe0, 0x0, 0xf2, 0x0, 0x0,
    0xf, 0x20, 0x0, 0x3f, 0xff, 0x70, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+167 "ŧ" */
    0x0, 0x62, 0x0, 0xc, 0x40, 0xd, 0xfe, 0x60,
    0xc, 0x40, 0x1f, 0xff, 0x90, 0xc, 0x40, 0x0,
    0xc4, 0x0, 0xc, 0x70, 0x0, 0x5f, 0x70,

    /* U+168 "Ũ" */
    0x0, 0x0, 0x0, 0x0, 0xa, 0xb1, 0xc0, 0x1,
    0xa2, 0xd7, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf2,
    0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3, 0xe0, 0xc9,
    0x11, 0xb9, 0x2, 0xbf, 0xe9, 0x0,

    /* U+169 "ũ" */
    0x0, 0x0, 0x0, 0x4, 0xe4, 0x75, 0xa, 0x19,
    0xc0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c,
    0x2e, 0x0, 0x4c, 0x1f, 0x31, 0xbc, 0x7, 0xee,
    0x9c,

    /* U+16A "Ū" */
    0x0, 0xee, 0xed, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x0, 0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3, 0xe0,
    0xc9, 0x11, 0xb9, 0x2, 0xbf, 0xe9, 0x0,

    /* U+16B "ū" */
    0x8, 0xee, 0xe4, 0x0, 0x0, 0x0, 0x3e, 0x0,
    0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x2e, 0x0, 0x4c, 0x1f, 0x31, 0xbc,
    0x7, 0xee, 0x9c,

    /* U+16C "Ŭ" */
    0x0, 0x61, 0x24, 0x0, 0x5, 0xcb, 0x30, 0x0,
    0x0, 0x0, 0x2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf1,
    0xf0, 0x0, 0x3e, 0xc, 0x91, 0x1b, 0x90, 0x2b,
    0xfe, 0x90,

    /* U+16D "ŭ" */
    0x5, 0x90, 0xe0, 0x0, 0x9c, 0x60, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x2e, 0x0, 0x4c,
    0x1f, 0x31, 0xbc, 0x7, 0xee, 0x9c,

    /* U+16E "Ů" */
    0x0, 0x9, 0x80, 0x0, 0x4, 0x58, 0x10, 0x0,
    0x9, 0x80, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf2,
    0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3, 0xe0, 0xc9,
    0x11, 0xb9, 0x2, 0xbf, 0xe9, 0x0,

    /* U+16F "ů" */
    0x0, 0x69, 0x20, 0x0, 0x91, 0x80, 0x0, 0x69,
    0x20, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x4c, 0x3e,
    0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c,
    0x2e, 0x0, 0x4c, 0x1f, 0x31, 0xbc, 0x7, 0xee,
    0x9c,

    /* U+170 "Ű" */
    0x0, 0xb, 0x5c, 0x40, 0x4, 0xa8, 0x70, 0x0,
    0x0, 0x0, 0x2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2,
    0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0, 0x2, 0xf1,
    0xf0, 0x0, 0x3e, 0xc, 0x91, 0x1b, 0x90, 0x2b,
    0xfe, 0x90,

    /* U+171 "ű" */
    0x0, 0x6a, 0x7a, 0x0, 0xc, 0x4c, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xe0, 0x4, 0xc0, 0x3e, 0x0,
    0x4c, 0x3, 0xe0, 0x4, 0xc0, 0x3e, 0x0, 0x4c,
    0x2, 0xe0, 0x4, 0xc0, 0x1f, 0x31, 0xbc, 0x0,
    0x7e, 0xe9, 0xc0,

    /* U+172 "Ų" */
    0x2f, 0x0, 0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f,
    0x0, 0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x2f, 0x0,
    0x2, 0xf2, 0xf0, 0x0, 0x2f, 0x1f, 0x0, 0x3,
    0xf0, 0xc9, 0x11, 0xbd, 0x2, 0xbf, 0xff, 0x50,
    0x0, 0x3f, 0x40, 0x0, 0x6, 0x90, 0x0, 0x0,
    0x2e, 0x70,

    /* U+173 "ų" */
    0x3e, 0x0, 0x4c, 0x3e, 0x0, 0x4c, 0x3e, 0x0,
    0x4c, 0x3e, 0x0, 0x4c, 0x2e, 0x0, 0x4c, 0x1f,
    0x31, 0xbc, 0x7, 0xee, 0x9c, 0x0, 0x0, 0xc3,
    0x0, 0x2, 0xc0, 0x0, 0x0, 0xda,

    /* U+174 "Ŵ" */
    0x0, 0x0, 0x17, 0x0, 0x0, 0x0, 0x0, 0x1b,
    0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0x90, 0x3, 0xf0, 0x0, 0xd4, 0x4c, 0x0,
    0x7f, 0x40, 0x1f, 0x1, 0xf0, 0xc, 0xa8, 0x4,
    0xd0, 0xd, 0x30, 0xe3, 0xc0, 0x79, 0x0, 0x97,
    0x4b, 0xe, 0xb, 0x50, 0x6, 0xa8, 0x60, 0xa5,
    0xe2, 0x0, 0x2e, 0xd2, 0x6, 0xae, 0x0, 0x0,
    0xed, 0x0, 0x1f, 0xa0, 0x0, 0xb, 0x90, 0x0,
    0xd7, 0x0,

    /* U+175 "ŵ" */
    0x0, 0x4, 0xe3, 0x0, 0x0, 0x1, 0xa1, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x70, 0x1f,
    0x10, 0x79, 0x5a, 0x5, 0xf5, 0xb, 0x51, 0xe0,
    0xa8, 0xa0, 0xe1, 0xd, 0x2d, 0xe, 0x2c, 0x0,
    0x99, 0xa0, 0xb9, 0x80, 0x4, 0xf6, 0x6, 0xf4,
    0x0, 0xf, 0x10, 0x2f, 0x0,

    /* U+176 "Ŷ" */
    0x0, 0x7, 0x10, 0x0, 0x0, 0xa6, 0xb1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa9, 0x0, 0x6, 0xd0,
    0x2f, 0x10, 0xe, 0x40, 0x9, 0x90, 0x6c, 0x0,
    0x1, 0xe1, 0xd4, 0x0, 0x0, 0x9c, 0xb0, 0x0,
    0x0, 0x1f, 0x40, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+177 "ŷ" */
    0x0, 0xba, 0x0, 0x6, 0x66, 0x50, 0x0, 0x0,
    0x0, 0xb7, 0x0, 0xc6, 0x6c, 0x1, 0xf1, 0x1f,
    0x15, 0xc0, 0xc, 0x6a, 0x70, 0x7, 0xbe, 0x20,
    0x1, 0xfd, 0x0, 0x0, 0xc8, 0x0, 0x0, 0xb3,
    0x0, 0x4, 0xd0, 0x0, 0x7e, 0x40, 0x0,

    /* U+178 "Ÿ" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0xe0, 0xa6, 0x0,
    0x0, 0x20, 0x10, 0x0, 0xa9, 0x0, 0x6, 0xd0,
    0x2f, 0x10, 0xe, 0x40, 0x9, 0x90, 0x6c, 0x0,
    0x1, 0xe1, 0xd4, 0x0, 0x0, 0x9c, 0xb0, 0x0,
    0x0, 0x1f, 0x40, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+179 "Ź" */
    0x0, 0x0, 0x71, 0x0, 0x0, 0x96, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x2f, 0x20, 0x0, 0xc, 0x70, 0x0, 0x7, 0xc0,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x7, 0xff,
    0xff, 0xfb,

    /* U+17A "ź" */
    0x0, 0xb, 0x70, 0x0, 0x4a, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xf5, 0x0, 0x5, 0xd0, 0x0,
    0x1e, 0x40, 0x0, 0xb9, 0x0, 0x6, 0xd0, 0x0,
    0x1e, 0x30, 0x0, 0x7f, 0xff, 0xf8,

    /* U+17B "Ż" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe2, 0x0, 0x0,
    0x2, 0x0, 0x6, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x2f, 0x20, 0x0, 0xc, 0x70, 0x0, 0x7, 0xc0,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x7, 0xff,
    0xff, 0xfb,

    /* U+17C "ż" */
    0x0, 0x78, 0x0, 0x0, 0x22, 0x0, 0x6f, 0xff,
    0xf5, 0x0, 0x5, 0xd0, 0x0, 0x1e, 0x40, 0x0,
    0xb9, 0x0, 0x6, 0xd0, 0x0, 0x1e, 0x30, 0x0,
    0x7f, 0xff, 0xf8,

    /* U+17D "Ž" */
    0x0, 0x60, 0x51, 0x0, 0x4, 0xb7, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x2f, 0x20, 0x0, 0xc, 0x70, 0x0, 0x7, 0xc0,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x7, 0xff,
    0xff, 0xfb,

    /* U+17E "ž" */
    0x6, 0x88, 0x70, 0x0, 0x99, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xf5, 0x0, 0x5, 0xd0, 0x0,
    0x1e, 0x40, 0x0, 0xb9, 0x0, 0x6, 0xd0, 0x0,
    0x1e, 0x30, 0x0, 0x7f, 0xff, 0xf8,

    /* U+17F "ſ" */
    0x5, 0xea, 0xe, 0x40, 0xf, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0,
    0x1f, 0x0, 0x1f, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 48, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 49, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14, .adv_w = 61, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 22, .adv_w = 118, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 58, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 100, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 141, .adv_w = 119, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 177, .adv_w = 33, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 181, .adv_w = 66, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 209, .adv_w = 67, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 237, .adv_w = 83, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 252, .adv_w = 109, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 277, .adv_w = 38, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 281, .adv_w = 53, .box_w = 4, .box_h = 1, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 283, .adv_w = 51, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 286, .adv_w = 79, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 311, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 343, .adv_w = 108, .box_w = 4, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 361, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 393, .adv_w = 108, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 420, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 452, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 484, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 516, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 548, .adv_w = 108, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 580, .adv_w = 108, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 607, .adv_w = 125, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 651, .adv_w = 104, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 678, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 726, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 756, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 804, .adv_w = 104, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 834, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 882, .adv_w = 101, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 912, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 960, .adv_w = 101, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 990, .adv_w = 125, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1042, .adv_w = 101, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1069, .adv_w = 125, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1117, .adv_w = 101, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1147, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1195, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1235, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1271, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1311, .adv_w = 109, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1350, .adv_w = 102, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1377, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1419, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1449, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1491, .adv_w = 102, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1518, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1560, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1590, .adv_w = 109, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1632, .adv_w = 102, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1662, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1710, .adv_w = 108, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1749, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1797, .adv_w = 108, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1836, .adv_w = 131, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1888, .adv_w = 108, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1924, .adv_w = 131, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1976, .adv_w = 108, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2018, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2066, .adv_w = 106, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2102, .adv_w = 134, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2143, .adv_w = 109, .box_w = 7, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2178, .adv_w = 52, .box_w = 5, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2211, .adv_w = 47, .box_w = 5, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2239, .adv_w = 52, .box_w = 5, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2267, .adv_w = 47, .box_w = 5, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2290, .adv_w = 52, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2320, .adv_w = 47, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2345, .adv_w = 52, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2363, .adv_w = 47, .box_w = 4, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2387, .adv_w = 52, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2405, .adv_w = 47, .box_w = 2, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2412, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2448, .adv_w = 92, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2478, .adv_w = 106, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2520, .adv_w = 48, .box_w = 5, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2553, .adv_w = 120, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2601, .adv_w = 97, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2650, .adv_w = 107, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2675, .adv_w = 103, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2717, .adv_w = 47, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2743, .adv_w = 103, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2789, .adv_w = 47, .box_w = 2, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2803, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2835, .adv_w = 61, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2860, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2892, .adv_w = 67, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2912, .adv_w = 103, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2944, .adv_w = 52, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2964, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3012, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3042, .adv_w = 137, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3094, .adv_w = 106, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3127, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3175, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3205, .adv_w = 106, .box_w = 7, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3240, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3288, .adv_w = 109, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3318, .adv_w = 132, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3362, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3394, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3442, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3477, .adv_w = 132, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3525, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3560, .adv_w = 183, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3610, .adv_w = 174, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3649, .adv_w = 118, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3697, .adv_w = 65, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3722, .adv_w = 118, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3774, .adv_w = 65, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3798, .adv_w = 118, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3846, .adv_w = 65, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3871, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3913, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3943, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3985, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4015, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4057, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4087, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4129, .adv_w = 99, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4159, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4201, .adv_w = 63, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4225, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4267, .adv_w = 66, .box_w = 5, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4295, .adv_w = 115, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4327, .adv_w = 63, .box_w = 5, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4350, .adv_w = 125, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4396, .adv_w = 106, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4429, .adv_w = 125, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4468, .adv_w = 106, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4495, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4537, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4567, .adv_w = 125, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4613, .adv_w = 106, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4646, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4688, .adv_w = 106, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4723, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4765, .adv_w = 106, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4795, .adv_w = 170, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4861, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4906, .adv_w = 115, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4954, .adv_w = 91, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4993, .adv_w = 115, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5041, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5083, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5113, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5155, .adv_w = 95, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5182, .adv_w = 115, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5224, .adv_w = 95, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5254, .adv_w = 48, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 26, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 256, .range_length = 128, .glyph_id_start = 27,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6, 7, 6, 7, 6,
    7, 8, 9, 8, 9, 8, 9, 8,
    9, 10, 0, 10, 0, 11, 12, 11,
    12, 11, 12, 11, 12, 11, 12, 0,
    0, 0, 0, 0, 0, 0, 0, 13,
    14, 0, 0, 13, 0, 13, 0, 13,
    0, 13, 0, 13, 0, 0, 0, 15,
    0, 16, 0, 0, 17, 0, 17, 0,
    17, 0, 17, 0, 0, 0, 13, 14,
    13, 14, 13, 14, 14, 0, 0, 10,
    18, 10, 18, 10, 18, 0, 0, 0,
    19, 0, 19, 0, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 20, 0, 20,
    0, 20, 0, 15, 0, 15, 0, 15,
    0, 15, 0, 15, 0, 15, 0, 21,
    0, 22, 23, 22, 24, 25, 24, 25,
    24, 25, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 9, 10, 9, 10, 9,
    10, 11, 12, 11, 12, 11, 12, 11,
    12, 0, 12, 0, 0, 0, 12, 0,
    12, 0, 12, 0, 12, 0, 12, 11,
    12, 11, 12, 11, 12, 11, 12, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 14,
    0, 14, 0, 14, 14, 0, 0, 11,
    15, 11, 15, 11, 15, 11, 12, 0,
    0, 0, 0, 0, 0, 16, 17, 16,
    17, 16, 17, 16, 17, 18, 0, 18,
    0, 0, 0, 19, 20, 19, 20, 19,
    20, 19, 20, 19, 20, 19, 20, 21,
    0, 22, 23, 22, 24, 25, 24, 25,
    24, 25, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, -11, -5, 0, -6, 0, -2, -6,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, 2,
    0, 0, 0, 0, -16, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -21, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -11, 0,
    0, 0, 0, 0, 0, 0, 0, -1,
    0, 0, 0, -1, 0, 0, -12, -2,
    -1, -6, -9, -5, 0, 1, 0, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, -4, 0,
    -2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    -2, 0, 0, 2, 0, -2, 0, 0,
    -2, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, -3, 0, 0, 0, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    0, -3, -2, 0, -2, -3, 0, 0,
    0, 0, -2, 0, 0, -4, 0, 0,
    0, -31, 0, 0, 0, 0, 0, 0,
    2, 0, -6, 0, 0, 0, 0, 0,
    0, -26, -5, -4, -13, -22, -12, 0,
    0, 0, -13, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -1,
    0, -1, 0, 2, 0, 0, 0, -12,
    0, 0, 0, -4, 0, -2, 0, 0,
    -2, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, -4, 0, 0, 0, 0,
    -20, -22, 0, -7, -11, -3, -9, -22,
    -10, -9, -1, -11, 2, 0, -9, 1,
    2, -7, 0, -6, 0, 0, 0, 1,
    0, -12, -6, 0, -4, -3, 0, -3,
    0, 0, -3, 0, 0, 1, 0, -2,
    0, 0, 0, 0, 0, 0, 0, -3,
    2, -5, -20, -5, 0, -9, -7, -3,
    -6, -9, -4, -6, -1, -5, 2, -9,
    -4, 2, 2, -2, 0, -3, 0, 1,
    0, 0, 0, -10, 0, 0, 0, -1,
    0, -1, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    0, -2, -2, 0, 0, -2, 0, 0,
    0, 0, -2, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -1, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 25,
    .right_class_cnt     = 25,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t RB_lv_font_roboto_12 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 17,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if RB_LV_FONT_ROBOTO_12*/


