#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "lvgl/lvgl.h"
#include "lv_conf.h"
#include "millis.h"
#include "FastPWM.h"
#include <string>
//#include <stdio.h>
#include "lv_i18n.h"

#include "lv_theme_rb.h" //GABOR

Ticker ticker;                //Initialize system tick
LCD_DISCO_F746NG lcd;         //Initialize display driver
TS_DISCO_F746NG ts;           //Initialize touchpad driver
TS_StateTypeDef TS_State;     //Initialize touch state sctruct

Serial serial(USBTX, USBRX);

/*********************
 *  ENTREES SORTIES
 *********************/
//TENSION BATTERIE
AnalogIn AI_TENSION_BAT(A4);

//PWM
FastPWM fastpwm(D12,1); //steup pwm output on pin d12 with a prescaler of 1   

//MARCHE POMPE
DigitalOut DO_POMPE(D13);

//COMPTEUR IMPULSION   
DigitalIn DI_CPTPuls(D7);
//InterruptIn DI_CPTPuls(D7); //


    
/**********************
 * VARIABLES GENERALES 
 **********************/
int X;
int Y;
Timer tempo;
bool Top1ms;
bool Top10ms;
bool Top100ms;
bool Top1s;
bool Top5s;
bool Top1min;
char text[100];
char text2[100];

int CsgPompe=0; 

uint64_t Micros=0;

uint64_t MemMicros0=0;
uint64_t MemMicros1=0;
uint64_t MemMicros2=0;
uint64_t MemMicros3=0;
uint64_t MemMicros4=0;
uint64_t MemMicros5=0;



int CalcFmPuls;
int CalcFdPuls;
bool FmCPTPuls;
uint64_t TimerPuls=0;
uint64_t TpsPuls=0;
float Calcul=0;
uint64_t MemTpsPuls=0;
uint64_t MemTps16Puls=0;
int NumDent=0;
uint64_t CptPuls=0;
uint64_t CalcDebit=0;
float TpsEntre2Puls[20];
float TpsMinEntre2Puls;
float TpsMaxEntre2Puls;
float VolParTour=1200;//en ml

int hres = 480;
int vres = 272;
bool CDA_POMPE;

uint64_t TpsMaPpe=0;


uint64_t test=0;

//VARIABLES GESTION MOT DE PASSE


/*********************
 *  FONCTIONS GENERALES
 *********************/
static char *S(string S);
char *Chemin; 
static char *HHMMSS(int32_t seconde);

/*********************
 *  OBJET PAGES
 *********************/
static lv_obj_t * BandeauHaut;
static void AFFBandeauHaut(int Num);
static lv_obj_t * SousMenu;
static void AFFSousMenu(int Num);
static lv_obj_t * Page;
int PageAff=0;
int MemPageAff=0;
static void AFFPage(int Num);


static lv_obj_t * PopupMDP;
static void AFFPopupMDP();

static void init_all_themes(uint16_t hue);

/*********************
 *  OBJET GENERAUX
 *********************/
static lv_obj_t *mbox;

/*****************************
 *  VARIABLES/OBJETS CONNEXION
 *****************************/
static lv_obj_t * SelectID;
static lv_obj_t * MDP;
static void SelectID_ACT(lv_obj_t * obj, lv_event_t event);
uint32_t TpsMdpEnCours=0;
struct Personne
{
    string Nom;
    string MDP; //mot de passe à 4 chiffres
    int Niveau; //0:aucun 1:Opérateur 2:superviseur 3:constructeur
    int Tps;    //Temps de connexion
};
Personne User[100];
Personne UserEC;

/*********
 * ETALON
 *********/
struct HistoEtal{    
    int Annee;  
    int Mois;
    float ProvDeriv1;//Provision de dérive étalon
    bool Ajustage;//Ajustage réalisé
};

struct Etalon
{
    string Nom;
    float ValPuls; //Valeur impulsion compteur
    float EMT;    //Ecart maximum toléré
    HistoEtal Hist[5];  //historique étalon  
};
Etalon EtalCpt[20];
Etalon EtaTemp[20];
Etalon EtalMano[20];

Etalon EtalCptEC;
Etalon EtaTempEC;
Etalon EtalManoEC;

/*****************************/

static void BpValidMDP_ACT(lv_obj_t * btn, lv_event_t event);
static void BpAnnulMDP_ACT(lv_obj_t * btn, lv_event_t event);
static void mboxMdp_ACT(lv_obj_t * btn, lv_event_t event);
static void mboxMdp_ACT2(lv_obj_t * btn, lv_event_t event);
static void kb_MDP_ACT(lv_obj_t * event_kb, lv_event_t event);
static void mbox_ACT(lv_obj_t * obj, lv_event_t event);

/*********************
 *  OBJETS BP MENU
 *********************/
 
static lv_obj_t * BPMENU;
static lv_obj_t * M100;
static lv_obj_t * M200;
static lv_obj_t * M300;
static lv_obj_t * M400;
static lv_obj_t * M500;
static lv_obj_t * M600;
static lv_obj_t * M700;

//FONCTIONS ASSOCIEES

static void BPMENU_ACT(lv_obj_t * btn, lv_event_t event);
static void M100_ACT(lv_obj_t * btn, lv_event_t event);
static void M200_ACT(lv_obj_t * btn, lv_event_t event);
static void M300_ACT(lv_obj_t * btn, lv_event_t event);
static void M400_ACT(lv_obj_t * btn, lv_event_t event);
static void M500_ACT(lv_obj_t * btn, lv_event_t event);
static void M600_ACT(lv_obj_t * btn, lv_event_t event);
static void M700_ACT(lv_obj_t * btn, lv_event_t event);

static void SM_ACT(lv_obj_t * btn, lv_event_t event);

int TpsAvFermMenu=5000;
int TpsAvFermSousMenu=5000;
int NumBandeauHaut;
int NumSousMenu;
bool DdeFermBandeauHaut;

/*********************
 *  OBJETS 
 *********************/ 
static lv_obj_t *FondGris ;
static lv_obj_t *FondGris2 ;

/*********************
 *  MATRICE DE BOUTONS 
 *********************/ 
static const char * PAVE_MDP_MAP[] = {"7", "8", "9", LV_SYMBOL_CLOSE,"\n",
                                  "4", "5","6", LV_SYMBOL_OK, "\n",
                                  "1", "2", "3", LV_SYMBOL_BACKSPACE,"\n", 
                                  "0", ""};
  

static const char * PAVE_NUMERIQUE_MAP[] = {
                                  "7", "8", "9","\n",
                                  "4", "5","6","\n",
                                  "1", "2", "3","\n", 
                                  "0",",","+/-","\n", 
                                  LV_SYMBOL_BACKSPACE,LV_SYMBOL_OK, LV_SYMBOL_CLOSE, ""};
                                  
                                  
       //                           "7", "8", "9","\n",
       //                           "4", "5","6", "\n",
       //                           "1", "2", "3","\n", 
       //                           "0", ".","+/-","\n",
       //                           LV_SYMBOL_BACKSPACE, LV_SYMBOL_OK,LV_SYMBOL_CLOSE};
/*********************
 *  STYLES
 *********************/
static lv_style_t P10,P12,P16,P18,P22,PG12,PG16,PG18,PG22;
static lv_style_t P16Saisie;
static lv_style_t Style_BP;

static void StyleBPSM(lv_obj_t * Obj);
static void StyleBPM(lv_obj_t * Obj);

/*********************
 *  MULTILANGUE
 *********************/ 
static void LANGUE_FR_ACT(lv_obj_t * btn, lv_event_t event);
static void LANGUE_EN_ACT(lv_obj_t * btn, lv_event_t event);


void initialisation();
void interruptCompteur();

static void BPRAZ_ACT(lv_obj_t * btn, lv_event_t event);
static void BPPOMPE_ACT(lv_obj_t * btn, lv_event_t event);
static lv_theme_t * th_act;
static lv_obj_t * label;
static lv_obj_t * label01;
static lv_obj_t * label02;
static lv_obj_t * label03;
static lv_obj_t * label04;

static lv_obj_t * AffCptPuls;
static lv_obj_t * Aff1TpsEntre2Puls;
static lv_obj_t * Aff2TpsEntre2Puls;
static lv_obj_t * AffTpsMinEntre2Puls;
static lv_obj_t * AffTpsMaxEntre2Puls;
static lv_obj_t * BPRAZ;
static lv_obj_t * BPPOMPE;


static lv_obj_t * AffChemin;
static lv_obj_t * AffSymbBat;
static lv_obj_t * AffPourcBat;

/************************
 *  TYPE DONNEES A SAISIR
 ************************/
static lv_obj_t * kb;
lv_obj_t *ChSaisi;

typedef struct Float_S
{
    float Val;
    const char * Unit;
    lv_obj_t * Aff;
    float Min;
    float Max;
    int Niveau; //0:aucun 1:Opérateur 2:superviseur 3:constructeur
    const char * Txt;
};
static Float_S *SaisieFloat;
static void  DdeSaisieFloat(lv_obj_t * label, lv_event_t event);   
static void PageSaisieFloat(lv_obj_t * label); 
static void KbSaisieFloat_ACT(lv_obj_t * event_kb, lv_event_t event);

typedef struct Int_S
{
    int Val;
    const char * Unit;
    lv_obj_t * Aff;
    int Min;
    int Max;
    int Niveau; //0:aucun 1:Opérateur 2:superviseur 3:constructeur
    const char * Txt;
};
static Int_S *SaisieInt;
static void DdeSaisieInt(lv_obj_t * label, lv_event_t event);   
static void PageSaisieInt(lv_obj_t * label); 
static void KbSaisieInt_ACT(lv_obj_t * event_kb, lv_event_t event);


typedef struct Txt_S
{
    char Val[];
    lv_obj_t * Aff;
    int Niveau; //0:aucun 1:Opérateur 2:superviseur 3:constructeur
    const char * Txt;
    int NbCarMax;    
};
static Txt_S *SaisieTxt;
static void DdeSaisieTxt(lv_obj_t * label, lv_event_t event);   
static void PageSaisieTxt(lv_obj_t * label); 
static void KbSaisieTxt_ACT(lv_obj_t * event_kb, lv_event_t event);

/**************************
 *  TYPE DONNEES A AFFICHER
 **************************/
typedef struct Float_A
{
    float Val;
    const char * Unit;
    lv_obj_t * Aff;
};
typedef struct Int_A
{
    long int Val;
    const char * Unit;
    lv_obj_t * Aff;
};
typedef struct Txt_A
{
    const char *  Val;
    lv_obj_t * Aff;
};


/*********************
 *  DONNEES A AFFICHER
 *********************/
Float_S CsgDebit;
Float_A Volume;
Float_A Debit;
Float_A DebitMoy;
Txt_A ProgEC;
Int_A Duree;
Int_A TotalisateurVol;
Int_A TotalisateurDuree;
Int_S NPremiereMin;
Int_S NDerniereMin;
Float_A DebNPremiereMin;
Float_A DebNDerniereMin;
Float_A EcartType;
Float_A TensionBat;
Float_A Intensite;
Float_A VitessePpe;
Float_A ConsoPrelev;
Float_A Puissance;
Txt_S NomEquipement;
Txt_S NumSerieEquipement;

float MoyTensBat[101];
float TpsCy=0;
uint64_t CalcTpsCy=0;
static lv_obj_t * AffTpsCy;

void lv_ticker_func();
void my_disp_flush(lv_disp_drv_t* disp_drv, const lv_area_t* area, lv_color_t* color_p);
bool my_touchpad_read(lv_indev_drv_t * indev_driver, lv_indev_data_t * data);
static void event_handler(lv_obj_t * obj, lv_event_t event);


static void ddlist_event_cb(lv_obj_t * ddlist, lv_event_t event);
static lv_obj_t * slider;

int PosX_MenuDepart = 0;
int PosX_MenuCible = 0;
bool DdeAlignMenu = 0;

int PosY_AnimSousMenu = 0;
int AnimSousMenu=0;


static void Reglage_R_RGB(lv_obj_t * obj, lv_event_t event);

int TestAff = 0;


static lv_obj_t  * Val_R;

static lv_obj_t  * R;


int Reglage_R;
uint8_t Reglage_G;
uint8_t Reglage_B;
uint32_t Reglage_RGB;

uint8_t R1=255,G1=255,B1=255,
        R2=0 ,G2=0 ,B2=0,
        R3=114 ,G3=179 ,B3=244,
        R4=255,G4=255,B4=240,
        R5=0,G5=145,B5=145,
        R6=0,G6=0,B6=0,
        R7=255,G7=255,B7=240,
        R8=114 ,G8=179 ,B8=244,
        R9=0,G9=145,B9=145,
        R10=155,G10=238,B10=131,
        R11=145,G11=145,B11=145,
        R12=51,G12=37,B12=22,
        R13=255,G13=255,B13=255,
        R14=153,G14=158,B14=117;
  
int NumCouleur=0;


static lv_theme_t * themes[8];


int main()
{      
     //demarrage communication avec PC
    serial.baud(9600);
    serial.printf("DEBUT DE PROGRAMME\r\n");
    //Entree impulsion
    DI_CPTPuls.mode(PullUp);
    
    //lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"LittlevGL DEMO", CENTER_MODE);
    ticker.attach(&lv_ticker_func,0.005);// Appel de la fonction LittlVGL toutes les 5ms
    wait(0.5);
    lv_init();                                  //Initialize the LittlevGL

    static lv_disp_buf_t disp_buf;
    static lv_color_t buf[LV_HOR_RES_MAX * 10]; //Declare a buffer for 10 lines
    lv_disp_buf_init(&disp_buf, buf, NULL, LV_HOR_RES_MAX * 10); //Initialize the display buffer

    //Implement and register a function which can copy a pixel array to an area of your display
    lv_disp_drv_t disp_drv;               //Descriptor of a display driver
    lv_disp_drv_init(&disp_drv);          //Basic initialization
    disp_drv.flush_cb = my_disp_flush;    //Set your driver function
    disp_drv.buffer = &disp_buf;          //Assign the buffer to the display
    lv_disp_drv_register(&disp_drv);      //Finally register the driver

    //Implement and register a function which can read an input device. E.g. for a touch pad
    ts.Init(lcd.GetXSize(), lcd.GetYSize());   //ST touch initialization
    lv_indev_drv_t indev_drv;                  //Descriptor of a input device driver
    lv_indev_drv_init(&indev_drv);             //Basic initialization
    indev_drv.type = LV_INDEV_TYPE_POINTER;    //Touch pad is a pointer-like device
    indev_drv.read_cb = my_touchpad_read;      //Set your driver function
    lv_indev_drv_register(&indev_drv);         //Finally register the driver

    //INITIALISATION MULTILANGUE
    lv_i18n_init(lv_i18n_language_pack);
    lv_i18n_set_locale("fr");

    initialisation();
    AFFBandeauHaut(2);
    AFFPage(102);
  
    //demarrage tempo générale
    tempo.start();    
    //Interruption compteur 
   // DI_CPTPuls.rise(&interruptCompteur);
    
    while(1) {
          
        //TEMPO GENERALE
        Micros=tempo.read_high_resolution_us();           
       //TOP base de temps
        Top1ms=false;   if (Micros>=MemMicros0+1000) {      Top1ms=true;    MemMicros0=MemMicros0+1000;     } 
        Top10ms=false;  if (Micros>=MemMicros1+10000) {     Top10ms=true;   MemMicros1=MemMicros1+10000;    }  
        Top100ms=false; if (Micros>=MemMicros2+100000) {    Top100ms=true;  MemMicros2=MemMicros2+100000;   } 
        Top1s=false;    if (Micros>=MemMicros3+1000000) {   Top1s=true;     MemMicros3=MemMicros3+1000000;  }      
        Top5s=false;    if (Micros>=MemMicros4+5000000) {   Top5s=true;     MemMicros4=MemMicros4+5000000;  }   
        Top1min=false;  if (Micros>=MemMicros5+60000000) {  Top1min=true;   MemMicros5=MemMicros5+60000000; }     
               
        
        //temps fonctionnement pompe
         if (Top1s){
            if (DO_POMPE) {TpsMaPpe++;}  
        }  
        //ARRET POMPE SI TENSION BATTERIE <2,9V
         if (Top1min){
            if (TensionBat.Val<2.9) {
                    DO_POMPE=false;                    
                    //if (R!=NULL){ lv_slider_set_value(R,10000,LV_ANIM_ON);}
                    Reglage_R=10000;
            }  
            serial.printf("Temps fonctionnment pompe= %ds        Tension= %3.3fV \r\n",TpsMaPpe,TensionBat);   //ENREGISTREMENT DONNEES
        }         
        
        
        //CALCUL TEMPS DE CYCLE    
        CalcTpsCy++;
        if (Top1s){
            TpsCy=1000000000/CalcTpsCy;  
            TpsCy=TpsCy/1000;
            CalcTpsCy=0;   
            Duree.Val++;        
        }  
        //Raffraichissement affichage toutes les 10ms        
        if (Top10ms){
            lv_task_handler(); 
        }  
                  
       //MISE A JOUR DES VARIABLES AFFICHEES 
        if (Top1s or MemPageAff!=PageAff){  
            MemPageAff=PageAff; 
            //bandeau haut   
            if (NumBandeauHaut==1){
                sprintf(text, Chemin); 
                lv_label_set_text(AffChemin, text);   
            }  
            //Raffraichissement données affichées   
            AFFPage(0);         
        }      
        
        //DETECTION IMPULSION        
        if (DI_CPTPuls and Top1ms){     CalcFdPuls=0;CalcFmPuls++;}
        if (not DI_CPTPuls and Top1ms){ CalcFmPuls=0;CalcFdPuls++;}
        if (CalcFmPuls>20 and not FmCPTPuls){interruptCompteur();FmCPTPuls=true;}
        if (CalcFdPuls>20 and FmCPTPuls){FmCPTPuls=false;}
        if (CalcFmPuls>500){CalcFmPuls=500;}
        if (CalcFdPuls>500){CalcFdPuls=500;}
       
        //MESURE TENSION BATTERIE
        if (Top10ms){
            MoyTensBat[0]=AI_TENSION_BAT.read()*3.3*2+0.018;
            TensionBat.Val=0;
            for (int i=100;i>0;i--){
                MoyTensBat[i]=MoyTensBat[i-1];
                TensionBat.Val=TensionBat.Val+MoyTensBat[i];      
            }
            TensionBat.Val=TensionBat.Val/100;   
        }              
           
        //COMMANDE POMPE PWM
        if (Top100ms){
            CsgPompe=Reglage_R;
            fastpwm.period_ticks (10000); //setup the period for 100Khz 
            fastpwm.pulsewidth_ticks(CsgPompe);//setup duty cycle to 50%
        }
     
        //RAZ MOT DE PASSE
        if (TpsMdpEnCours>0 and Top1s){
            TpsMdpEnCours--;
            if (TpsMdpEnCours==0){
                mbox=lv_mbox_create(lv_disp_get_scr_act(NULL), NULL);              
                sprintf(text, "Fin de connexion pour %s",UserEC.Nom );
                lv_mbox_set_text(mbox, text);
                lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
                lv_mbox_start_auto_close(mbox, 3000);
                UserEC.Nom="";    
                UserEC.Niveau=0;     
            }
        }
        
        //GESTION BANDEAU HAUT              
        if (Top1ms and TpsAvFermMenu>0){TpsAvFermMenu--;}
        if (Top1ms and SousMenu){TpsAvFermMenu=4000;}//maintien bandeau affiché si sous menu déployé
        if (TpsAvFermMenu>0 and X>0){TpsAvFermMenu=4000;} //mainitien bandeau affiché si appui sur écran
        if (TpsAvFermMenu>0 and PopupMDP){TpsAvFermMenu=4000;} //maintien bandeau affiché si Popup saisie MDP           
        if (TpsAvFermMenu==1){
            PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
            PosX_MenuCible = -lv_obj_get_x(M600);
            DdeAlignMenu=1;
            NumSousMenu=0;   
            DdeFermBandeauHaut=false;     
        }
        
        //ANIMATION BANDEAU HAUT
        if (Top1ms){
            if (DdeAlignMenu) {
                if (PosX_MenuDepart>PosX_MenuCible) {
                    PosX_MenuDepart=PosX_MenuDepart-1;
                    lv_obj_set_pos(BandeauHaut, PosX_MenuDepart, 0);
                }
                if (PosX_MenuDepart<PosX_MenuCible) {
                    PosX_MenuDepart=PosX_MenuDepart+1;
                    lv_obj_set_pos(BandeauHaut, PosX_MenuDepart, 0);
                }
                if (PosX_MenuDepart==PosX_MenuCible) {
                    DdeAlignMenu=0;
                    if (NumSousMenu>0){AFFSousMenu(NumSousMenu);}//affichage page sous menu
                    if (NumSousMenu==0){AFFBandeauHaut(1);}//Bandeau haut sans menu
                }
            }  
        }
        
        //ANIMATION SOUS MENU
        if (Top1ms){            
            //OUVERTURE SOUS MENU
            if (AnimSousMenu>0) {                
                PosY_AnimSousMenu=PosY_AnimSousMenu+2;
                lv_obj_set_size(SousMenu, 230, PosY_AnimSousMenu);
                if (PosY_AnimSousMenu>=AnimSousMenu){AnimSousMenu=0;}  
                TpsAvFermSousMenu=5000;    
            }   
            //TEMPS AVANT FERMEURE
            if (SousMenu and TpsAvFermSousMenu>0){TpsAvFermSousMenu--;}
            //FERMETURE SOUS MENU
            if (SousMenu and TpsAvFermSousMenu<=0) {                
                PosY_AnimSousMenu=PosY_AnimSousMenu-2;
                lv_obj_set_size(SousMenu, 230, PosY_AnimSousMenu);
                if (PosY_AnimSousMenu<=0){
                    lv_obj_del_async(SousMenu); 
                    SousMenu=NULL;
                    if(DdeFermBandeauHaut){TpsAvFermMenu=10;DdeFermBandeauHaut=false;}
                }           
            }  
        }
        if (SousMenu and X>0){TpsAvFermSousMenu=5000;}//mainitien sous menu affiché si appui sur écran        
        if (SousMenu and PopupMDP){TpsAvFermSousMenu=5000;} //maintien bandeau affiché si Popup saisie MDP  
            
  /**/      
    }//FIN BOUCLE
}//FIN MAIN



static void AffFloat(string Txt,Float_A &Var,int PosX, int PosY){
    label01 = lv_label_create(Page, NULL);       
    lv_obj_set_style(label01,&PG16);
    lv_obj_set_pos(label01,  PosX, PosY);   
    lv_label_set_text_fmt(label01, "%s",Txt);  
        
    Var.Aff = lv_label_create(Page, NULL);       
    lv_obj_set_style(Var.Aff,&P16);
    lv_obj_align(Var.Aff, label01, LV_ALIGN_OUT_RIGHT_MID, 5, 0); 
    lv_label_set_text_fmt(Var.Aff, "%2.2f %s",Var.Val,Var.Unit);
}

static void AffInt(string Txt,Int_A &Var,int PosX, int PosY){
    label01 = lv_label_create(Page, NULL);       
    lv_obj_set_style(label01,&PG16);
    lv_obj_set_pos(label01,  PosX, PosY);   
    lv_label_set_text_fmt(label01, "%s",Txt);  
        
    Var.Aff = lv_label_create(Page, NULL);       
    lv_obj_set_style(Var.Aff,&P16);
    lv_obj_align(Var.Aff, label01, LV_ALIGN_OUT_RIGHT_MID, 5, 0); 
    lv_label_set_text_fmt(Var.Aff, "%d %s",Var.Val,Var.Unit);
}

static void AffTxt(string Txt,Txt_A &Var,int PosX, int PosY){
    label01 = lv_label_create(Page, NULL);       
    lv_obj_set_style(label01,&PG16);
    lv_obj_set_pos(label01,  PosX, PosY); 
    lv_label_set_text_fmt(label01, "%s",Txt);  
       
    Var.Aff = lv_label_create(Page, NULL);       
    lv_obj_set_style(Var.Aff,&P16);
    lv_obj_align(Var.Aff, label01, LV_ALIGN_OUT_RIGHT_MID, 5, 0); 
    lv_obj_set_click(Var.Aff, true);  
}

static void InFloat(string Txt,Float_S &Var,int PosX, int PosY){
    label01 = lv_label_create(Page, NULL);       
    lv_obj_set_style(label01,&PG16);
    lv_obj_set_pos(label01,  PosX, PosY); 
    lv_label_set_text_fmt(label01, "%s",Txt);  
        
    Var.Aff = lv_label_create(Page, NULL);       
    lv_obj_set_style(Var.Aff,&P16Saisie);
    lv_obj_align(Var.Aff, label01, LV_ALIGN_OUT_RIGHT_MID, 5, 0); 
    lv_label_set_text_fmt(Var.Aff, "%2.2f %s",Var.Val,Var.Unit);
    
    lv_obj_set_click(Var.Aff, true);    
    lv_obj_set_user_data(Var.Aff, &Var);
    lv_obj_set_event_cb(Var.Aff, DdeSaisieFloat);
}

static void InInt(string Txt,Int_S &Var,int PosX, int PosY){
    label01 = lv_label_create(Page, NULL);       
    lv_obj_set_style(label01,&PG16);
    lv_obj_set_pos(label01,  PosX, PosY); 
    lv_label_set_text_fmt(label01, "%s",Txt);  
        
    Var.Aff = lv_label_create(Page, NULL);       
    lv_obj_set_style(Var.Aff,&P16Saisie);
    lv_obj_align(Var.Aff, label01, LV_ALIGN_OUT_RIGHT_MID, 5, 0); 
    lv_label_set_text_fmt(Var.Aff, "%d %s",Var.Val,Var.Unit);
 
    lv_obj_set_click(Var.Aff, true);     
    lv_obj_set_user_data(Var.Aff, &Var);
    lv_obj_set_event_cb(Var.Aff, DdeSaisieInt);
}

static void InTxt(string Txt,Txt_S &Var,int PosX, int PosY){
    label01 = lv_label_create(Page, NULL);       
    lv_obj_set_style(label01,&PG16);
    lv_obj_set_pos(label01,  PosX, PosY);  
    lv_label_set_text_fmt(label01, "%s",Txt);  
       
    Var.Aff = lv_label_create(Page, NULL);       
    lv_obj_set_style(Var.Aff,&P16Saisie);
    lv_obj_align(Var.Aff, label01, LV_ALIGN_OUT_RIGHT_MID, 5, 0); 
    
    lv_obj_set_click(Var.Aff, true);  
    lv_obj_set_user_data(Var.Aff, &Var);
    lv_obj_set_event_cb(Var.Aff, DdeSaisieTxt); 
}

static void AFFPage(int Num)
{
    //VARIABLES COMMUNES         
    int i=0;//index pour décalage ligne
    
    //CREATION PAGE
    if (Num>0){
        if(Page) {
            lv_obj_del(Page); ;
            Page = NULL;
        } 
        PageAff=Num;//MEMORISATION PAGE AFFICHEE       
        Page = lv_page_create(lv_scr_act(), NULL);
        lv_obj_set_size(Page, hres, vres-40);
        lv_obj_set_pos(Page,  0, 40);   
        lv_page_set_scrl_layout(Page, LV_LAYOUT_OFF);
        lv_page_set_scrl_fit2(Page, LV_FIT_FLOOD, LV_FIT_TIGHT);
        lv_coord_t max_w = lv_page_get_fit_width(Page);   
    }
     
      ////////////////////////////////////////    
     //CREATION PAGE 101: Etat d'avancement//
    ////////////////////////////////////////
    if (Num==101){   
        sprintf(Chemin, "%s \\ %s",_("M100"),_("M101")); 
        AffTxt(_("Etat de la mallette :"),ProgEC,5, i=i);        
        InFloat(_("Consigne débit :"),CsgDebit,5, i=i+20);          
        AffFloat(_("Débit intantanné :"),Debit,5, i=i+20);          
        AffFloat(_("Débit Moyen prélèvement :"),DebitMoy,5, i=i+20);     
        AffFloat(_("Volume prélevé :"),Volume,5, i=i+20);           
        AffInt(_("Durée prélèvement :"),Duree,5, i=i+20);            
        sprintf(text, _("Débit moyen des %d premières minutes :"),NPremiereMin.Val);       
        AffFloat(text,DebNPremiereMin,5, i=i+20);             
        sprintf(text, _("Débit moyen des %d dernières minutes :"),NDerniereMin.Val);       
        AffFloat(text,DebNDerniereMin,5, i=i+20);       
        AffFloat(_("Ecart type:"),EcartType,5, i=i+20);                
        AffInt(_("Totalisateur volume:"),TotalisateurVol,5, i=i+20); 
        AffInt(_("Totalisateur durée:"),TotalisateurDuree,5, i=i+20);  
        AffFloat(_("Tension :"),TensionBat,5, i=i+20);   
        AffFloat(_("Intensité :"),Intensite,5, i=i+20);   
        AffFloat(_("Vitesse pompe :"),VitessePpe,5, i=i+20);   
        AffFloat(_("Consommation prélèvement :"),ConsoPrelev,5, i=i+20);   
        AffFloat(_("Puissance :"),Puissance,5, i=i+20);                
        PageAff=101;                       
    }
    
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==101 and Num==0){     
        //PROGRAMME EN COURS  
        lv_label_set_text_fmt(ProgEC.Aff, "%s",ProgEC.Val);        
        //CONSIGNE DEBIT    
        lv_label_set_text_fmt(CsgDebit.Aff, "%2.2f %s",CsgDebit.Val,CsgDebit.Unit);               
        //DEBIT INSTANTANNE
        lv_label_set_text_fmt(Debit.Aff, "%2.2f %s",Debit.Val,Debit.Unit);        
        //DEBIT MOYEN
        lv_label_set_text_fmt(DebitMoy.Aff, "%2.2f %s",DebitMoy.Val,DebitMoy.Unit);        
        //VOLUME PRELEVE 
        lv_label_set_text_fmt(Volume.Aff, "%2.1f %s",Volume.Val,Volume.Unit); 
        //DUREE PRELEVEMENT  
        lv_label_set_text_fmt(Duree.Aff, "%s",HHMMSS(Duree.Val));         
        //DEBIT MOYEN DES N PREMIERES MINUTES
        lv_label_set_text_fmt(DebNPremiereMin.Aff, "%2.2f %s",DebNPremiereMin.Val,DebNPremiereMin.Unit);         
        //DEBIT MOYEN DES N DERNIERES MINUTES
        lv_label_set_text_fmt(DebNDerniereMin.Aff, "%2.2f %s",DebNDerniereMin.Val,DebNDerniereMin.Unit);         
        //ECART TYPE
        lv_label_set_text_fmt(EcartType.Aff, "%2.2f %s",EcartType.Val,EcartType.Unit);          
        //TOTALISATEUR VOLUME
        lv_label_set_text_fmt(TotalisateurVol.Aff, "%8.1f %s",TotalisateurVol.Val,TotalisateurVol.Unit);                       
        //TOTALISATEUR DUREE
        lv_label_set_text_fmt(TotalisateurDuree.Aff, "%2.2f %s",TotalisateurDuree.Val,TotalisateurDuree.Unit);       
        //TENSION
        lv_label_set_text_fmt(TensionBat.Aff, "%2.3f %s",TensionBat.Val,TensionBat.Unit);                
        //INTENSITE
        lv_label_set_text_fmt(Intensite.Aff, "%2.3f %s",Intensite.Val,Intensite.Unit);   
        //VITESSE POMPE
        lv_label_set_text_fmt(VitessePpe.Aff, "%4.0f %s",VitessePpe.Val,VitessePpe.Unit);         
        //CONSOMMATION PRELEVEMENT
        lv_label_set_text_fmt(ConsoPrelev.Aff, "%4.0f %s",ConsoPrelev.Val,ConsoPrelev.Unit);         
       //PUISSANCE
        lv_label_set_text_fmt(Puissance.Aff, "%4.0f %s",Puissance.Val,Puissance.Unit); 
    }

      ////////////////////////////////////////////    
     //CREATION PAGE 102: Information générales//
    ////////////////////////////////////////////
    if (Num==102){  
        sprintf(Chemin, "%s \\ %s",_("M100"),_("M102"));         
        InTxt(_("Nom équipement :"),NomEquipement,5, i=i);        
        InTxt(_("N°série constructeur :"),NumSerieEquipement,5, i=i+20);      
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==102 and Num==0){   
        lv_label_set_text_fmt(NomEquipement.Aff, "%s",NomEquipement.Val);  
        lv_label_set_text_fmt(NumSerieEquipement.Aff, "%s",NumSerieEquipement.Val);       
    }

      ////////////////////////////////////////////    
     //CREATION PAGE 103: Information générales//
    ////////////////////////////////////////////
    if (Num==103){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M100"),_("M103")); 
              
       
        PageAff=103;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==103 and Num==0){       
             
  
    }
    
      ////////////////////////////////////////    
     //CREATION PAGE 201: Test d'étanchéité//
    ////////////////////////////////////////
    if (Num==201){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M200"),_("M201")); 
             //affichage données
  /*      AffTensionBat = lv_label_create(Page, NULL);  
        lv_obj_set_pos(AffTensionBat,  50, i);    
        
        AffTpsCy = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffTpsCy,  50, i);
        
        AffCptPuls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffCptPuls,  50, i);
        
        Aff1TpsEntre2Puls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(Aff1TpsEntre2Puls,  50, i);
        
        Aff2TpsEntre2Puls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(Aff2TpsEntre2Puls,  50, i);
        
        AffTpsMinEntre2Puls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffTpsMinEntre2Puls,  50, i);
        
        AffTpsMaxEntre2Puls = lv_label_create(Page, NULL);   
        i=i+16;lv_obj_set_pos(AffTpsMaxEntre2Puls,  50, i);
        
        //BP RAZ
        BPRAZ = lv_btn_create(Page, NULL);
        i=i+30;lv_obj_set_pos(BPRAZ,  50, i);
        label = lv_label_create(BPRAZ, NULL);
        lv_label_set_text(label, "RAZ");
        lv_obj_set_size(BPRAZ,60,40);
        lv_obj_set_event_cb(BPRAZ, BPRAZ_ACT);
        
        //BP POMPE
        BPPOMPE = lv_btn_create(Page, NULL);
        lv_obj_set_pos(BPPOMPE,  150, i);
        label = lv_label_create(BPPOMPE, NULL);
        lv_label_set_text(label, "POMPE");
        lv_obj_set_size(BPPOMPE,90,40);
        lv_btn_set_toggle(BPPOMPE, true);
        lv_obj_set_event_cb(BPPOMPE, BPPOMPE_ACT);
        
         // SLIDER
        static lv_style_t style_bg,style_knob;
        static lv_style_t style_indic_R;    
    
        lv_style_copy(&style_bg, &lv_style_pretty);
        style_bg.body.main_color =  LV_COLOR_BLACK;
        style_bg.body.grad_color =  LV_COLOR_BLACK;
        style_bg.body.radius = LV_RADIUS_CIRCLE;
        style_bg.body.border.color = LV_COLOR_SILVER;
    
        lv_style_copy(&style_indic_R, &lv_style_pretty_color);
        style_indic_R.body.main_color =  LV_COLOR_RED;
        style_indic_R.body.grad_color =  LV_COLOR_RED;
        style_indic_R.body.radius = LV_RADIUS_CIRCLE;
        style_indic_R.body.shadow.width = 4;
        style_indic_R.body.shadow.color = LV_COLOR_RED;
        style_indic_R.body.padding.left = 3;
        style_indic_R.body.padding.right = 3;
        style_indic_R.body.padding.top = 3;
        style_indic_R.body.padding.bottom = 3;
    
        lv_style_copy(&style_knob, &lv_style_pretty);
        style_knob.body.radius = LV_RADIUS_CIRCLE;
        style_knob.body.opa = LV_OPA_70;
        style_knob.body.padding.top = 10 ;
        style_knob.body.padding.bottom = 10 ;
    
        //Create a slider ROUGE
        R = lv_slider_create(Page, NULL);
        lv_obj_set_pos(R,  10, 40);
        lv_obj_set_width(R, 30);
        lv_obj_set_height(R, 180);
        lv_slider_set_range(R, 0, 10000);
        lv_slider_set_value(R, Reglage_R, false);
        style_indic_R.body.main_color =  LV_COLOR_RED;
        style_indic_R.body.grad_color =  LV_COLOR_RED;
        style_indic_R.body.shadow.color = LV_COLOR_RED;
        lv_slider_set_style(R, LV_SLIDER_STYLE_BG, &style_bg);
        lv_slider_set_style(R, LV_SLIDER_STYLE_INDIC,&style_indic_R);
        lv_slider_set_style(R, LV_SLIDER_STYLE_KNOB, &style_knob);
        lv_obj_set_event_cb(R, Reglage_R_RGB);
        Val_R = lv_label_create(Page, NULL);
        lv_obj_align(Val_R, R, LV_ALIGN_OUT_TOP_MID, 0, -5);
        sprintf(text, " %d ", lv_slider_get_value(R));
        lv_label_set_text(Val_R, text);
    */    
       
        PageAff=201;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==201 and Num==0){       
               
  //      sprintf(text, _("Temps de cycle = %3.3f us"),TpsCy);       lv_label_set_text(AffTpsCy, text);         
   //     sprintf(text, _("Tension= %3.3f V "),TensionBat );         lv_label_set_text(AffTensionBat, text);
   //     sprintf(text, "Temps fonctionnment pompe= %d s",TpsMaPpe );      lv_label_set_text(AffCptPuls, text);
   //     sprintf(text, "Nombre d'impulsion= %d ",CptPuls );      lv_label_set_text(AffCptPuls, text);
   //     sprintf(text, "Volume = %3.3f L",Volume );              lv_label_set_text(AffVolume, text);           
   //     sprintf(text, "Debit= %3.3f L/min ",Debit );            lv_label_set_text(AffDebit, text);   
   //     sprintf(text, "%3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f ",TpsEntre2Puls[1],TpsEntre2Puls[2],TpsEntre2Puls[3],TpsEntre2Puls[4],TpsEntre2Puls[5],TpsEntre2Puls[6],TpsEntre2Puls[7],TpsEntre2Puls[8]); lv_label_set_text(Aff1TpsEntre2Puls, text);
    //    sprintf(text, "%3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f / %3.0f ",TpsEntre2Puls[9],TpsEntre2Puls[10],TpsEntre2Puls[11],TpsEntre2Puls[12],TpsEntre2Puls[13],TpsEntre2Puls[14],TpsEntre2Puls[15],TpsEntre2Puls[16]); lv_label_set_text(Aff2TpsEntre2Puls, text);
    //    sprintf(text, "Temps mini entre 2 impulsions = %d ",NumSousMenu ); lv_label_set_text(AffTpsMinEntre2Puls, text);   
    //    sprintf(text, "Temps maxi entre 2 impulsions = %d",test ); lv_label_set_text(AffTpsMaxEntre2Puls, text);     
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 202: Séquence unique//
    //////////////////////////////////////
    if (Num==202){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M200"),_("M202")); 
              
       
        PageAff=202;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==202 and Num==0){       
             
  
    }
      ////////////////////////////////////////    
     //CREATION PAGE 203: //
    ////////////////////////////////////////
    if (Num==203){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M200"),_("M203")); 
              
       
        PageAff=203;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==203 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 204: //
    //////////////////////////////////////
    if (Num==204){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M200"),_("M204")); 
              
       
        PageAff=204;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==204 and Num==0){       
             
  
    }
      
      ////////////////////////////////////////    
     //CREATION PAGE 301: //
    ////////////////////////////////////////
    if (Num==301){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M300"),_("M301")); 
              
       
        PageAff=301;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==301 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 302: //
    //////////////////////////////////////
    if (Num==302){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M300"),_("M302")); 
              
       
        PageAff=302;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==302 and Num==0){       
             
  
    }
      ////////////////////////////////////////    
     //CREATION PAGE 303: //
    ////////////////////////////////////////
    if (Num==303){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M300"),_("M303")); 
              
       
        PageAff=303;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==303 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 304: //
    //////////////////////////////////////
    if (Num==304){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M300"),_("M304")); 
              
       
        PageAff=304;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==304 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 305: //
    //////////////////////////////////////
    if (Num==305){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M300"),_("M305")); 
              
       
        PageAff=305;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==305 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 306: //
    //////////////////////////////////////
    if (Num==306){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M300"),_("M306")); 
              
       
        PageAff=306;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==306 and Num==0){       
             
  
    }
      ////////////////////////////////////////    
     //CREATION PAGE 401: Test d'étanchéité//
    ////////////////////////////////////////
    if (Num==401){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M400"),_("M401")); 
              
       
        PageAff=401;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==401 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 402: Séquence unique//
    //////////////////////////////////////
    if (Num==402){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M400"),_("M402")); 
              
       
        PageAff=402;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==402 and Num==0){       
             
  
    }
      ////////////////////////////////////////    
     //CREATION PAGE 403: //
    ////////////////////////////////////////
    if (Num==403){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M400"),_("M403")); 
              
       
        PageAff=403;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==403 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 404: //
    //////////////////////////////////////
    if (Num==404){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M400"),_("M404")); 
           
              
        //CREATION LISTE ETALON POUR AFFICHAGE
        int i; 
        int j; 
        int k=0; 
        char p[2200];    
        for (i = 1; i < 2200; i++) { p[i]=='\0';}    
        
        for (i = 1; i < 20; i++) { 
            string s=EtalCpt[i].Nom; 
            if (s.length()>0){
                for (j = 0; j < s.length(); j++) { 
                    p[k] = s[j];
                    k++;
                } 
                p[k]='\n';
                k++;
            }
        }    
        p[k+1]='\0'; 
        char * ListeEtal= p  ;
    
        //TITRE TEST
        lv_obj_t * test = lv_label_create(Page, NULL);        
        lv_label_set_text(test, _("test"));
        lv_obj_align(test, Page, LV_ALIGN_OUT_TOP_MID, 0, 0);
        
        //SELECTEUR COMPTEUR ETALON    
        lv_obj_t * SelectEtal = lv_roller_create(Page, NULL);
        lv_roller_set_options(SelectEtal,ListeEtal,LV_ROLLER_MODE_NORMAL);
        lv_roller_set_visible_row_count(SelectEtal, 4);  
        lv_roller_set_fix_width(SelectEtal, 130);
        lv_obj_align(SelectEtal, Page, LV_ALIGN_IN_TOP_LEFT, 10, 20); 
        
        //TITRE COMPTEUR ETALON
        lv_obj_t * Titre = lv_label_create(Page, NULL);        
        lv_label_set_text(Titre, _("COMPTEUR"));
        lv_obj_align(Titre, SelectEtal, LV_ALIGN_OUT_TOP_MID, 0, 0);   
         
        //BP MODIFIER
        lv_obj_t * BPModifCompt = lv_btn_create(Page, NULL);         
   //     StyleBPSM(BPModifCompt);  
        lv_obj_set_size(BPModifCompt,130,30);       
        lv_obj_align(BPModifCompt, SelectEtal, LV_ALIGN_OUT_BOTTOM_MID, 0, 5);
        label = lv_label_create(BPModifCompt, NULL);
        lv_label_set_text(label, _("Modifier"));
      //  lv_obj_set_event_cb(BPModifCompt, BPModifCompt_ACT);  
        
        //BP AJOUTER
        lv_obj_t * BPAjoutCompt = lv_btn_create(Page, NULL);        
     //   StyleBPSM(BPAjoutCompt);   
        lv_obj_set_size(BPAjoutCompt,130,30);      
        lv_obj_align(BPAjoutCompt, BPModifCompt, LV_ALIGN_OUT_BOTTOM_MID, 0, 5);
        label = lv_label_create(BPAjoutCompt, NULL);
        lv_label_set_text(label, _("Ajouter"));
      //  lv_obj_set_event_cb(BPAjoutCompt, BPAjoutCompt_ACT);  
        
        //BP SUPPRIMER
        lv_obj_t * BPSupprCompt = lv_btn_create(Page, NULL);        
      //  StyleBPSM(BPModifCompt);    
        lv_obj_set_size(BPSupprCompt,130,30);     
        lv_obj_align(BPSupprCompt, BPAjoutCompt, LV_ALIGN_OUT_BOTTOM_MID, 0, 5);
        label = lv_label_create(BPSupprCompt, NULL);
        lv_label_set_text(label, _("Supprimer"));
      //  lv_obj_set_event_cb(BPSupprCompt, BPSupprCompt_ACT);  
   
        PageAff=404;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==404 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 405: //
    //////////////////////////////////////
    if (Num==405){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M400"),_("M405")); 
              
       
        PageAff=405;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==405 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 406: //
    //////////////////////////////////////
    if (Num==406){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M400"),_("M406")); 
              
       
        PageAff=406;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==406 and Num==0){       
             
  
    }
    
      ///////////////////////////////////////    
     //CREATION PAGE 501: Sélection langue//
    ///////////////////////////////////////
    if (Num==501){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M500"),_("M501")); 
         
        //BP SELECTION LANGUE: FRANCAIS        
        lv_obj_t * LANGUE_FR = lv_btn_create(Page, NULL);        
        lv_obj_align(LANGUE_FR, Page, LV_ALIGN_IN_TOP_MID, -80, 50);
        label = lv_label_create(LANGUE_FR, NULL);
        lv_label_set_text(label, _("Francais"));
        lv_obj_set_size(LANGUE_FR,100,40);
        lv_obj_set_event_cb(LANGUE_FR, LANGUE_FR_ACT);
        
        //BP SELECTION LANGUE: ANGLAIS
        lv_obj_t * LANGUE_EN = lv_btn_create(Page, NULL);        
        lv_obj_align(LANGUE_EN, Page, LV_ALIGN_IN_TOP_MID, 80, 50);
        label = lv_label_create(LANGUE_EN, NULL);
        lv_label_set_text(label, _("English"));
        lv_obj_set_size(LANGUE_EN,100,40);
        lv_obj_set_event_cb(LANGUE_EN, LANGUE_EN_ACT);  
        
        PageAff=501;       
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==501 and Num==0){       
        
    }
          
      //////////////////////////////////////    
     //CREATION PAGE 502: Séquence unique//
    //////////////////////////////////////
    if (Num==502){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M500"),_("M502")); 
              
       
        PageAff=502;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==502 and Num==0){       
             
  
    }
      ////////////////////////////////////////    
     //CREATION PAGE 503: //
    ////////////////////////////////////////
    if (Num==503){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M500"),_("M503")); 
              
       
        PageAff=503;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==503 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 504: //
    //////////////////////////////////////
    if (Num==504){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M500"),_("M504")); 
              
       
        PageAff=504;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==504 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 505: //
    //////////////////////////////////////
    if (Num==505){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M500"),_("M505")); 
              
       
        PageAff=505;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==505 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 506: //
    //////////////////////////////////////
    if (Num==506){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M500"),_("M506")); 
              
       
        PageAff=506;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==506 and Num==0){       
             
  
    }
       ////////////////////////////////////////    
     //CREATION PAGE 601: Test d'étanchéité//
    ////////////////////////////////////////
    if (Num==601){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M600"),_("M601")); 
              
       
        PageAff=601;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==601 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 602: Séquence unique//
    //////////////////////////////////////
    if (Num==602){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M600"),_("M602")); 
              
       
        PageAff=602;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==602 and Num==0){       
             
  
    }
      ////////////////////////////////////////    
     //CREATION PAGE 603: //
    ////////////////////////////////////////
    if (Num==603){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M600"),_("M603")); 
              
       
        PageAff=603;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==603 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 604: //
    //////////////////////////////////////
    if (Num==604){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M600"),_("M604")); 
              
       
        PageAff=604;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==604 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 605: //
    //////////////////////////////////////
    if (Num==605){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M600"),_("M605")); 
              
       
        PageAff=605;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==605 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 606: //
    //////////////////////////////////////
    if (Num==606){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M600"),_("M606")); 
              
       
        PageAff=606;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==606 and Num==0){       
             
  
    }
      ////////////////////////////////////////    
     //CREATION PAGE 701:??????????????????//
    ////////////////////////////////////////
    if (Num==701){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M700"),_("M701")); 
              
        //Programme en cours       
        lv_obj_t *ProgEC = lv_label_create(Page, NULL);  
        lv_obj_set_pos(ProgEC,  50, i);   
        
        PageAff=401;              
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==701 and Num==0){       
        
    }
         
      //////////////////////////////////////    
     //CREATION PAGE 702: Séquence unique//
    //////////////////////////////////////
    if (Num==702){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M700"),_("M702")); 
              
       
        PageAff=702;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==702 and Num==0){       
             
  
    }
      ////////////////////////////////////////    
     //CREATION PAGE 703: //
    ////////////////////////////////////////
    if (Num==703){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M700"),_("M703")); 
              
       
        PageAff=703;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==703 and Num==0){       
             
  
    }
    
      //////////////////////////////////////    
     //CREATION PAGE 704: //
    //////////////////////////////////////
    if (Num==704){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M700"),_("M704")); 
              
       
        PageAff=704;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==704 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 705: //
    //////////////////////////////////////
    if (Num==705){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M700"),_("M705")); 
              
       
        PageAff=705;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==705 and Num==0){       
             
  
    }
      //////////////////////////////////////    
     //CREATION PAGE 706: //
    //////////////////////////////////////
    if (Num==706){  
        // CHEMIN PAGE   
        sprintf(Chemin, "%s \\ %s",_("M700"),_("M706")); 
              
       
        PageAff=706;               
        
    }
    //RAFFRAICHISSEMENT DONNEES
    if (PageAff==706 and Num==0){       
             
  
    }
}

//FONCTION INTERRUPTION COMPTEUR D'IMPULSION
void interruptCompteur()
{   
    //Timestamp pulsation
    TimerPuls=tempo.read_high_resolution_us();
    
    // Calcul temps entre 2 impulsions 
    TpsPuls=TimerPuls-MemTpsPuls;
    MemTpsPuls=TimerPuls;
    
    //Incrementation numéro de dent roue
    NumDent++;
    
     //Memorisation ecart entre chaque impulsion et Calcul des Min Max    
    Calcul=TpsPuls;
    Calcul=Calcul/1000;
    TpsEntre2Puls[NumDent]=Calcul;
    if (Calcul<TpsMinEntre2Puls){TpsMinEntre2Puls=Calcul;}
    if (Calcul>TpsMaxEntre2Puls){TpsMaxEntre2Puls=Calcul;}
        
    //Calcul débit
    if (NumDent>=16){
        CalcDebit=VolParTour;
        CalcDebit=60000000*CalcDebit/(TimerPuls-MemTps16Puls);
        Debit.Val=CalcDebit;
        Debit.Val=Debit.Val/1000;
        MemTps16Puls=TimerPuls;
        NumDent=0;
    }
        
    //Nombre d'impulsion total   
    CptPuls++;
    
    //Calcul Volume
    Volume.Val=CptPuls*VolParTour/16000;
     
}

void initialisation(void)
{
    //CHARGEMENT DU THEME
       th_act = lv_theme_rb_init(0, &RB_lv_font_roboto_16); //Gabor: When i change something in my Theme nothing's happen. Can you see in /lvgl_RB/lv_theme_rb.c
 
 //   th_act = lv_theme_rb_init(0, NULL); //Gabor: When i change something in my Theme nothing's happen. Can you see in /lvgl_RB/lv_theme_rb.c
  //    th_act = lv_theme_night_init(0, NULL);
    lv_theme_set_current(th_act);

    lv_obj_t * scr = lv_obj_create(NULL, NULL);
    lv_disp_load_scr(scr);
    
    //POLICES
    lv_style_copy(&P10, &lv_style_pretty);     P10.text.font = &RB_lv_font_roboto_10;
    lv_style_copy(&P12, &lv_style_pretty);     P12.text.font = &RB_lv_font_roboto_12;
    lv_style_copy(&P16, &lv_style_pretty);     P16.text.font = &RB_lv_font_roboto_16;
    lv_style_copy(&P18, &lv_style_pretty);     P18.text.font = &RB_lv_font_roboto_18;
    lv_style_copy(&P22, &lv_style_pretty);     P22.text.font = &RB_lv_font_roboto_22;
    lv_style_copy(&PG12, &lv_style_pretty);    PG12.text.font = &RB_lv_font_roboto_bold_12;
    lv_style_copy(&PG16, &lv_style_pretty);    PG16.text.font = &RB_lv_font_roboto_bold_16;      
    lv_style_copy(&PG18, &lv_style_pretty);    PG18.text.font = &RB_lv_font_roboto_bold_18;
    lv_style_copy(&PG22, &lv_style_pretty);    PG22.text.font = &RB_lv_font_roboto_bold_22;    
    
    lv_style_copy(&P16Saisie, &lv_style_pretty);     P16Saisie.text.font = &RB_lv_font_roboto_16;  P16Saisie.text.color = LV_COLOR_MAKE(0, 0, 255); 

    
    //INITIALISATION TABLEAU UTILISATEUR
     User[1].Nom="Romain BECAN";        User[1].MDP="1234";   User[1].Niveau=3; User[1].Tps=1;
     User[2].Nom="Guy HERVE";           User[2].MDP="5678";   User[2].Niveau=2; User[2].Tps=120;
     User[31].Nom="OPERATEUR 1";        User[31].MDP="4321";  User[31].Niveau=1; User[31].Tps=1;
     User[32].Nom="OPERATEUR 2";        User[32].MDP="4321";  User[32].Niveau=1; User[32].Tps=60;
     User[33].Nom="OPERATEUR 3";        User[33].MDP="4321";  User[33].Niveau=1; User[33].Tps=70;
     User[34].Nom="OPERATEUR 4";        User[34].MDP="4321";  User[34].Niveau=1; User[34].Tps=30;
     User[35].Nom="OPERATEUR 5";        User[35].MDP="4321";  User[35].Niveau=3; User[35].Tps=30;
     User[36].Nom="OPERATEUR 6";        User[36].MDP="4321";  User[36].Niveau=3; User[36].Tps=30;
     User[99].Nom="OPERATEUR 100";      User[99].MDP="4321";  User[99].Niveau=3; User[99].Tps=30;
          
    
    //INITIALISATION TABLEAU ETALON
     EtalCpt[1].Nom="COMPT AB1";    EtalCpt[1].ValPuls=68.38;   EtalCpt[1].EMT=5.0;  
            EtalCpt[1].Hist[1].Annee=2020; EtalCpt[1].Hist[1].Mois=01;     EtalCpt[1].Hist[1].ProvDeriv1=1.2;  EtalCpt[1].Hist[1].Ajustage=true;
            EtalCpt[1].Hist[1].Annee=2019; EtalCpt[1].Hist[1].Mois=02;     EtalCpt[1].Hist[1].ProvDeriv1=1.3;  EtalCpt[1].Hist[1].Ajustage=false;
            EtalCpt[1].Hist[1].Annee=2018; EtalCpt[1].Hist[1].Mois=10;     EtalCpt[1].Hist[1].ProvDeriv1=1.4;  EtalCpt[1].Hist[1].Ajustage=false;
            EtalCpt[1].Hist[1].Annee=2017; EtalCpt[1].Hist[1].Mois=03;     EtalCpt[1].Hist[1].ProvDeriv1=1.5;  EtalCpt[1].Hist[1].Ajustage=true;
            EtalCpt[1].Hist[1].Annee=2016; EtalCpt[1].Hist[1].Mois=04;     EtalCpt[1].Hist[1].ProvDeriv1=1.6;  EtalCpt[1].Hist[1].Ajustage=true;
     EtalCpt[2].Nom="COMPT 123";    EtalCpt[2].ValPuls=66.35;   EtalCpt[2].EMT=5.0;  
            EtalCpt[2].Hist[1].Annee=2020; EtalCpt[2].Hist[1].Mois=01;     EtalCpt[2].Hist[1].ProvDeriv1=1.2;  EtalCpt[2].Hist[1].Ajustage=true;
            EtalCpt[2].Hist[1].Annee=2019; EtalCpt[2].Hist[1].Mois=02;     EtalCpt[2].Hist[1].ProvDeriv1=1.3;  EtalCpt[2].Hist[1].Ajustage=false;
            EtalCpt[2].Hist[1].Annee=2018; EtalCpt[2].Hist[1].Mois=10;     EtalCpt[2].Hist[1].ProvDeriv1=1.4;  EtalCpt[2].Hist[1].Ajustage=false;
            EtalCpt[2].Hist[1].Annee=2017; EtalCpt[2].Hist[1].Mois=03;     EtalCpt[2].Hist[1].ProvDeriv1=1.5;  EtalCpt[2].Hist[1].Ajustage=true;
            EtalCpt[2].Hist[1].Annee=2016; EtalCpt[2].Hist[1].Mois=04;     EtalCpt[2].Hist[1].ProvDeriv1=1.6;  EtalCpt[2].Hist[1].Ajustage=true;
    EtalCpt[3].Nom="COMPT 446";    EtalCpt[3].ValPuls=64.18;   EtalCpt[3].EMT=5.0;  
            EtalCpt[3].Hist[1].Annee=2020; EtalCpt[3].Hist[1].Mois=01;     EtalCpt[3].Hist[1].ProvDeriv1=1.2;  EtalCpt[3].Hist[1].Ajustage=true;
            EtalCpt[3].Hist[1].Annee=2019; EtalCpt[3].Hist[1].Mois=02;     EtalCpt[3].Hist[1].ProvDeriv1=1.3;  EtalCpt[3].Hist[1].Ajustage=false;
            EtalCpt[3].Hist[1].Annee=2018; EtalCpt[3].Hist[1].Mois=10;     EtalCpt[3].Hist[1].ProvDeriv1=1.4;  EtalCpt[3].Hist[1].Ajustage=false;
            EtalCpt[3].Hist[1].Annee=2017; EtalCpt[3].Hist[1].Mois=03;     EtalCpt[3].Hist[1].ProvDeriv1=1.5;  EtalCpt[3].Hist[1].Ajustage=true;
            EtalCpt[3].Hist[1].Annee=2016; EtalCpt[3].Hist[1].Mois=04;     EtalCpt[3].Hist[1].ProvDeriv1=1.6;  EtalCpt[3].Hist[1].Ajustage=true;
        
    CsgDebit.Val = 50;  CsgDebit.Unit = "L/min";   CsgDebit.Min = 10;  CsgDebit.Max = 100;    CsgDebit.Txt = "Consigne Débit";    CsgDebit.Niveau = 1;  
    Volume.Val = 12345; Volume.Unit = "L"; 
    Debit.Val = 8;      Debit.Unit = "L/min"; 
    DebitMoy.Val =7;    DebitMoy.Unit = "L/min";
    ProgEC.Val ="AUCUN PROGRAMME EN COURS";
    Duree.Val =7;       Duree.Unit = "";
    TotalisateurVol.Val =7;     TotalisateurVol.Unit = "L";
    TotalisateurDuree.Val =7;   TotalisateurDuree.Unit = "h";
    NPremiereMin.Val =10;       NPremiereMin.Unit = "min";
    NDerniereMin.Val =10;       NDerniereMin.Unit = "min";
    DebNPremiereMin.Val =8;     DebNPremiereMin.Unit = "L/min";
    DebNDerniereMin.Val =8;     DebNDerniereMin.Unit = "L/min";
    EcartType.Val =0.12;        EcartType.Unit = "L/min";
    TensionBat.Val =3.2;        TensionBat.Unit = "V";
    Intensite.Val =1;           Intensite.Unit = "A";
    VitessePpe.Val =4000;       VitessePpe.Unit = "tr/min";
    ConsoPrelev.Val =100;       ConsoPrelev.Unit = "W";
    Puissance.Val =100;         Puissance.Unit = "Wh";   
    
    char chaine[] = "Texte";  
    strcpy(NomEquipement.Val, chaine);
  //  NomEquipement.Val[]="1234567890";   NomEquipement.NbCarMax = 10;    NomEquipement.Txt = "Nom équipement";    NomEquipement.Niveau = 1;  
 //   NumSerieEquipement.Val="12345678";   NumSerieEquipement.NbCarMax = 8;    NumSerieEquipement.Txt = "Numéro série constructeur";    NumSerieEquipement.Niveau = 3;  
}

  //////////////////    
 // BANDEAU HAUT //
//////////////////
static void AFFBandeauHaut(int Num)
{
    if(BandeauHaut) {
        lv_obj_del(BandeauHaut);
        BandeauHaut = NULL;
    } 
    NumBandeauHaut=Num;
    
    //Bandeau haut sans Menu
    if (NumBandeauHaut==1){          
        // CREATION OBJET BANDEAU HAUT
        BandeauHaut = lv_cont_create(lv_scr_act(), NULL);
        lv_obj_set_size(BandeauHaut,hres,40);
        lv_obj_set_pos(BandeauHaut, 0, 0);
        
        //BP APPEL MENU        
        BPMENU = lv_btn_create(BandeauHaut, NULL);
        label = lv_label_create(BPMENU, NULL);
        lv_label_set_text(label, LV_SYMBOL_PLAY);
        lv_obj_set_size(BPMENU,40,40);
        lv_obj_set_pos(BandeauHaut, 0, 0);
        lv_obj_set_event_cb(BPMENU, BPMENU_ACT);
        
        //CHEMIN PAGE
        AffChemin = lv_label_create(BandeauHaut, NULL);   
        lv_obj_set_style(AffChemin, &P22);                 
        lv_obj_align(AffChemin, BandeauHaut, LV_ALIGN_IN_LEFT_MID, 45, 0); 
        sprintf(text, Chemin); lv_label_set_text(AffChemin, text);  
                
        //ETAT BATTERIE
        AffSymbBat = lv_label_create(BandeauHaut, NULL); 
        lv_obj_set_style(AffSymbBat, &P22);           
        lv_obj_align(AffSymbBat, BandeauHaut, LV_ALIGN_IN_TOP_RIGHT, -15, 3); 
        sprintf(text,LV_SYMBOL_BATTERY_3 ); lv_label_set_text(AffSymbBat, text); 
        AffPourcBat = lv_label_create(BandeauHaut, NULL); 
        lv_obj_set_style(AffPourcBat, &P12);           
        lv_obj_align(AffPourcBat, AffSymbBat, LV_ALIGN_OUT_BOTTOM_LEFT, 0, -8); 
        sprintf(text,"75%%"); lv_label_set_text(AffPourcBat, text);   
        
    }
    
    //Bandeau haut avec Menu
    if (NumBandeauHaut==2){  
        //TEMPS D'AFFICHAGE BANDEAU HAUT
        TpsAvFermMenu=5000;
        
         // CREATION OBJET BANDEAU HAUT
        BandeauHaut = lv_cont_create(lv_scr_act(), NULL);
        lv_obj_set_size(BandeauHaut,2000,40);
       // lv_cont_set_fit2(BandeauHaut,LV_FIT_TIGHT, LV_FIT_NONE);
        lv_obj_set_pos(BandeauHaut, 0, 0);
        lv_obj_set_drag_dir(BandeauHaut, LV_DRAG_DIR_HOR);
        lv_obj_set_drag_throw(BandeauHaut, true);
        
        //MENU 1
        M100 = lv_btn_create(BandeauHaut, NULL);
        StyleBPM(M100);  
        lv_obj_t * label = lv_label_create(M100, NULL);
        lv_label_set_text(label, _("M100"));
        lv_obj_set_size(M100,130,40);
        lv_obj_set_drag_parent(M100, true);
        lv_obj_set_event_cb(M100, M100_ACT);
    
        //MENU 2
        M200 = lv_btn_create(BandeauHaut, NULL);
        StyleBPM(M200);  
        label = lv_label_create(M200, NULL);
        lv_label_set_text(label, _("M200"));
        lv_obj_set_size(M200,130,40);
        lv_obj_align(M200, M100, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
        lv_obj_set_drag_parent(M200, true);
        lv_obj_set_event_cb(M200, M200_ACT);
    
        //MENU 3
        M300 = lv_btn_create(BandeauHaut, NULL);
        StyleBPM(M300);  
        label = lv_label_create(M300, NULL);
        lv_label_set_text(label, _("M300"));
        lv_obj_set_size(M300,130,40);
        lv_obj_align(M300, M200, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
        lv_obj_set_drag_parent(M300, true);
        lv_obj_set_event_cb(M300, M300_ACT);
    
        //MENU 4
        M400 = lv_btn_create(BandeauHaut, NULL);
        StyleBPM(M400);  
        label = lv_label_create(M400, NULL);
        lv_label_set_text(label, _("M400"));
        lv_obj_set_size(M400,130,40);
        lv_obj_align(M400, M300, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
        lv_obj_set_drag_parent(M400, true);
        lv_obj_set_event_cb(M400, M400_ACT);
    
        //MENU 5
        M500 = lv_btn_create(BandeauHaut, NULL);
        StyleBPM(M500);  
        label = lv_label_create(M500, NULL);
        lv_label_set_text(label, _("M500"));
        lv_obj_set_size(M500,130,40);
        lv_obj_align(M500, M400, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
        lv_obj_set_drag_parent(M500, true);
        lv_obj_set_event_cb(M500, M500_ACT);
    
        //MENU 6
        M600 = lv_btn_create(BandeauHaut, NULL);
        StyleBPM(M600);  
        label = lv_label_create(M600, NULL);
        lv_label_set_text(label, _("M600"));
        lv_obj_set_size(M600,130,40);
        lv_obj_align(M600, M500, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
        lv_obj_set_drag_parent(M600, true);
        lv_obj_set_event_cb(M600, M600_ACT);
        
        //MENU 7
 //       M700 = lv_btn_create(BandeauHaut, NULL);
 //       StyleBPM(M700);  
 //       label = lv_label_create(M700, NULL);
 //       lv_label_set_text(label, _("M700"));
 //       lv_obj_set_size(M700,130,40);
 //       lv_obj_align(M700, M600, LV_ALIGN_OUT_RIGHT_MID, 0, 0);
 //       lv_obj_set_drag_parent(M700, true);
 //       lv_obj_set_event_cb(M700, M700_ACT);
    }    
}


static void AFFSousMenu(int Num)
{
    //SI SOUS MENU DEJA AFFICHE : SUPPRIMER PAGE AVANT CREATION NOUVELLE
    if(SousMenu) {
        lv_obj_del(SousMenu);
        SousMenu = NULL;
    } 
   //Memorisation sousmenu en cours
   NumSousMenu=Num;
    /*Create a list*/
    SousMenu = lv_list_create(lv_scr_act(), NULL);
    lv_obj_set_pos(SousMenu, 0, 40);
    StyleBPSM(SousMenu);  
    AnimSousMenu=48;//TAILLE FENETRE FOIS NB BOUTON

    //SOUS MENU 100
    if (Num==100){
        AnimSousMenu=AnimSousMenu*2;//TAILLE FENETRE
        lv_obj_t * SM101 = lv_list_add_btn(SousMenu, NULL, _("M101")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM101, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM101, SM_ACT);
           
        lv_obj_t * SM102 = lv_list_add_btn(SousMenu, NULL, _("M102")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM102, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM102, SM_ACT);
    }
    
    //SOUS MENU 200
    if (Num==200){
        AnimSousMenu=AnimSousMenu*3;//TAILLE FENETRE
        lv_obj_t * SM201 = lv_list_add_btn(SousMenu, NULL, _("M201")); 
        if (UserEC.Niveau<1){lv_btn_set_state(SM201, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM201, SM_ACT);
    
        lv_obj_t * SM202 = lv_list_add_btn(SousMenu, NULL, _("M202")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM202, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM202, SM_ACT);
        
        lv_obj_t * SM203 = lv_list_add_btn(SousMenu, NULL, _("M203")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM203, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM203, SM_ACT);
    }
     
    //SOUS MENU 300
    if (Num==300){
        AnimSousMenu=AnimSousMenu*9;//TAILLE FENETRE
        lv_obj_t * SM301 = lv_list_add_btn(SousMenu, NULL, _("M301")); 
        if (UserEC.Niveau<1){lv_btn_set_state(SM301, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM301, SM_ACT);
    
        lv_obj_t * SM302 = lv_list_add_btn(SousMenu, NULL, _("M302")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM302, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM302, SM_ACT);
        
        lv_obj_t * SM303 = lv_list_add_btn(SousMenu, NULL, _("M303")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM303, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM303, SM_ACT);
        
        lv_obj_t * SM304 = lv_list_add_btn(SousMenu, NULL, _("M304")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM304, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM304, SM_ACT);
        
        lv_obj_t * SM305 = lv_list_add_btn(SousMenu, NULL, _("M305")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM305, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM305, SM_ACT);
        
        lv_obj_t * SM306 = lv_list_add_btn(SousMenu, NULL, _("M306")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM306, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM306, SM_ACT);     
           
        lv_obj_t * SM307 = lv_list_add_btn(SousMenu, NULL, _("M307")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM307, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM307, SM_ACT);
                
        lv_obj_t * SM308 = lv_list_add_btn(SousMenu, NULL, _("M308")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM308, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM308, SM_ACT);
                
        lv_obj_t * SM309 = lv_list_add_btn(SousMenu, NULL, _("M309")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM309, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM309, SM_ACT);
    }   
    
    //SOUS MENU 400
    if (Num==400){
        AnimSousMenu=AnimSousMenu*5;//TAILLE FENETRE
        lv_obj_t * SM401 = lv_list_add_btn(SousMenu, NULL, _("M401")); 
        if (UserEC.Niveau<1){lv_btn_set_state(SM401, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM401, SM_ACT);
    
        lv_obj_t * SM402 = lv_list_add_btn(SousMenu, NULL, _("M402")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM402, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM402, SM_ACT);
        
        lv_obj_t * SM403 = lv_list_add_btn(SousMenu, NULL, _("M403")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM403, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM403, SM_ACT);
        
        lv_obj_t * SM404 = lv_list_add_btn(SousMenu, NULL, _("M404")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM404, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM404, SM_ACT);
        
        lv_obj_t * SM405 = lv_list_add_btn(SousMenu, NULL, _("M405")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM405, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM405, SM_ACT);
    }
    
    //SOUS MENU 500
    if (Num==500){
        AnimSousMenu=AnimSousMenu*3;//TAILLE FENETRE
        lv_obj_t * SM501 = lv_list_add_btn(SousMenu, NULL, _("M501")); 
        if (UserEC.Niveau<1){lv_btn_set_state(SM501, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM501, SM_ACT);
    
        lv_obj_t * SM502 = lv_list_add_btn(SousMenu, NULL, _("M502")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM502, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM502, SM_ACT);
    
        lv_obj_t * SM503 = lv_list_add_btn(SousMenu, NULL, _("M503")); 
        if (UserEC.Niveau<0){lv_btn_set_state(SM503, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM503, SM_ACT);
    } 
    
    //SOUS MENU 600
    if (Num==600){
        AnimSousMenu=AnimSousMenu*1;//TAILLE FENETRE
        lv_obj_t * SM601 = lv_list_add_btn(SousMenu, NULL, _("M601")); 
        if (UserEC.Niveau<1){lv_btn_set_state(SM601, LV_BTN_STATE_INA );}
        lv_obj_set_event_cb(SM601, SM_ACT);
    }  
    
    //SOUS MENU 700
 //   if (Num==700){
 //       AnimSousMenu=AnimSousMenu*1;//TAILLE FENETRE
 //       lv_obj_t * SM701 = lv_list_add_btn(SousMenu, NULL, _("M701")); 
 //       if (UserEC.Niveau<1){lv_btn_set_state(SM701, LV_BTN_STATE_INA );}
 //       lv_obj_set_event_cb(SM701, SM_ACT);       
 //   } 
    if (AnimSousMenu>232){AnimSousMenu=232;}//TAILLE FENETRE MAXI 232=272-40
}


//********************
// POPUP CONNEXION MDP
//********************
static void AFFPopupMDP(){
    //FOND GRISE 
    static lv_style_t modal_style;
    lv_style_copy(&modal_style, &lv_style_plain_color);
    modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
    modal_style.body.opa = LV_OPA_50;
    FondGris = lv_obj_create(lv_scr_act(), NULL);
    lv_obj_set_style(FondGris, &modal_style);
    lv_obj_set_pos(FondGris, 0, 0);
    lv_obj_set_size(FondGris, LV_HOR_RES, LV_VER_RES);
    lv_obj_set_opa_scale_enable(FondGris, true); 
    
    //CREATION POPUP CONNEXION MDP
    PopupMDP = lv_obj_create(FondGris, NULL);
    lv_obj_set_size(PopupMDP,400,260); 
    lv_obj_align(PopupMDP, FondGris, LV_ALIGN_CENTER, 0, 0);
    lv_obj_set_opa_scale_enable(PopupMDP, true);
    lv_obj_set_opa_scale(PopupMDP, 240);
    
    //TITRE
    label = lv_label_create(PopupMDP, NULL);  
    lv_obj_set_style(label,&PG12);        
    lv_label_set_text(label, _("NIVEAU D'ACCES INSSUFISANT POUR REALISER CETTE ACTION\nVEUILLEZ VOUS IDENTIFER:"));
    lv_obj_align(label, PopupMDP, LV_ALIGN_IN_TOP_MID, 0, 3);
    lv_obj_set_opa_scale_enable(label, true);
    lv_obj_set_opa_scale(label, LV_OPA_COVER);
    
    //CREATION LISTE UTILISATEUR POUR AFFICHAGE
    //G/ABOR: Mabye you have a better solution than:
    //ROMAIN: There is no much better way, but I have a few comments
    int i; 
    int j; 
    int k=0; 
    char p[2200];    
    
    //ROMAIN:
    // - p[i]=='\0'; it should be p[i]='\0'; isn't it?
    // - If so why not start from i = 0 to initalize?
    // - memset(p, '\0', sizeof(p)) can be a clearer option to initialize
    for (i = 1; i < 2200; i++) { p[i]=='\0';}    
    
    for (i = 1; i < 100; i++) { //ROMAIN: Why start from 1?
        string s=User[i].Nom; 
        if (s.length()>0){
            //ROMAIN: I suggest using memcpy instead
            // memcpy(&p[k], s, s.length())
            // k += s.length();
            // p[k] = '\n';
            // k++;
            for (j = 0; j < s.length(); j++) { 
                p[k] = s[j];
                k++;
            } 
            p[k]='\n';
            k++;
        }
    }    
    //ROMAIN: 
    // - you alraedy incremented k, so it should p[k] = '\0', shouldn't it?
    // - and you initialized p to '\0' so it's not required 
    p[k+1]='\0'; 
    char * ListeUser= p  ;
    
    //SELECTEUR UTILISATEUR    
    SelectID = lv_roller_create(PopupMDP, NULL);
    lv_roller_set_options(SelectID,ListeUser,LV_ROLLER_MODE_NORMAL);
    lv_roller_set_visible_row_count(SelectID, 9);  
    lv_roller_set_fix_width(SelectID, 175);
    lv_obj_align(SelectID, PopupMDP, LV_ALIGN_IN_TOP_LEFT, 10, 40); 
 
    //CHAMPS MOT DE PASSE
    MDP = lv_ta_create(PopupMDP, NULL);
    lv_ta_set_text(MDP, "");
    lv_ta_set_pwd_mode(MDP, true);
    lv_ta_set_one_line(MDP, true);
    lv_obj_set_width(MDP, 175);
    lv_obj_align(MDP, PopupMDP, LV_ALIGN_IN_TOP_RIGHT, -10, 40); 
    lv_obj_set_opa_scale_enable(MDP, true);
    lv_obj_set_opa_scale(MDP, LV_OPA_COVER); 
    lv_ta_set_max_length(MDP, 4);
        
    // PAVE NUMERIQUE SAISIE MOT DE PASSE
    static lv_style_t rel_style, pr_style; //STYLE CLAVIER
    lv_style_copy(&rel_style, &lv_style_btn_rel);
    rel_style.body.radius = 0;
    rel_style.body.border.width = 1;
    lv_style_copy(&pr_style, &lv_style_btn_pr);
    pr_style.body.radius = 0;
    pr_style.body.border.width = 1;
  
    kb = lv_kb_create(PopupMDP, NULL);
    lv_kb_set_mode(kb, LV_KB_MODE_NUM );
    lv_obj_set_event_cb(kb, kb_MDP_ACT);
    lv_kb_set_ta(kb, MDP);
    lv_obj_set_size(kb,175,175);     
    lv_btnm_set_map(kb, PAVE_MDP_MAP);
    lv_obj_align(kb, MDP, LV_ALIGN_OUT_BOTTOM_MID, 0, 5); 
    lv_obj_set_opa_scale_enable(kb, true);
    lv_obj_set_opa_scale(kb, LV_OPA_COVER);     
    lv_kb_set_cursor_manage(kb, true);
    lv_kb_set_style(kb, LV_KB_STYLE_BG, &lv_style_transp_tight);
    lv_kb_set_style(kb, LV_KB_STYLE_BTN_REL, &rel_style);
    lv_kb_set_style(kb, LV_KB_STYLE_BTN_PR, &pr_style); 
    lv_ta_set_text(MDP, "");
    
        
}
static void kb_MDP_ACT(lv_obj_t * event_kb, lv_event_t event)
{    
    lv_kb_def_event_cb(event_kb, event);
    if(event == LV_EVENT_APPLY ) { 
      //RECUPERATION DU NOM DE L'UTILISATEUR SELECTIONNE
        char NomSelect[20];        
        lv_roller_get_selected_str(SelectID, NomSelect, sizeof(NomSelect));
         
        //RECUPERATION MOT DE PASSE SAISIE 
        string MdpSaisie;
        MdpSaisie = lv_ta_get_text(MDP);
        
        //FOND GRISE 
        static lv_style_t modal_style;
        lv_style_copy(&modal_style, &lv_style_plain_color);
        modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
        modal_style.body.opa = LV_OPA_50;
        FondGris2 = lv_obj_create(lv_scr_act(), NULL);
        lv_obj_set_style(FondGris2, &modal_style);
        lv_obj_set_pos(FondGris2, 0, 0);
        lv_obj_set_size(FondGris2, LV_HOR_RES, LV_VER_RES);
        lv_obj_set_opa_scale_enable(FondGris2, true); 
        //COMPARAISON AVEC LISTE           
        static const char * btns2[] = {"Ok", ""}; 
        for (int i = 1; i < 100; i++) { 
            if (User[i].Nom==NomSelect)
                if (User[i].MDP==MdpSaisie){                   
                    mbox=lv_mbox_create(FondGris2, NULL);
                    lv_mbox_add_btns(mbox, btns2);
                    if (User[i].Niveau==1){sprintf(text2, "qu'operateur" );}
                    if (User[i].Niveau==2){sprintf(text2, "que superviseur");}  
                    if (User[i].Niveau==3){sprintf(text2, "que constructeur");}                    
                    sprintf(text, "Connexion autorisee a %s en tant %s pour une duree de %d min",User[i].Nom ,text2,User[i].Tps );
                    lv_mbox_set_text(mbox, text);
                    lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
                    lv_obj_set_event_cb(mbox, mboxMdp_ACT);                      
                    TpsMdpEnCours=User[i].Tps*60;
                    UserEC=User[i];                           
                    //RECLASSEMENT DU TABLEAU DES UTILISATEURS POUR AVOIR LE DERNIER CONNECTé EN PREMIER
                    User[0]=User[i];
                    for (int j = i; j >0; j--) { //DECALAGE TABLEAU
                       User[j]=User[j-1]; 
                    }
                    return;
                }           
         }  
         mbox=lv_mbox_create(FondGris2, NULL);
         lv_mbox_add_btns(mbox, btns2);
         lv_mbox_set_text(mbox, "MOT DE PASSE ERRONE");
         lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
         lv_obj_set_event_cb(mbox, mboxMdp_ACT2); 
    }
    if(event == LV_EVENT_CANCEL ) {  
        lv_obj_del_async(FondGris);        
        PopupMDP=NULL;
    } 
}
static void mboxMdp_ACT(lv_obj_t * obj, lv_event_t event)
{     
    if(event == LV_EVENT_CLICKED) {
        lv_obj_del_async(FondGris);
        lv_obj_del_async(FondGris2);
        PopupMDP=NULL;
        if(BandeauHaut){AFFBandeauHaut(NumBandeauHaut);}
        if(SousMenu){AFFSousMenu(NumSousMenu);}
    }  
}
static void mboxMdp_ACT2(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        lv_obj_del_async(FondGris2);   
        lv_ta_set_text(MDP, "");
    }
}


//********************
// SAISIE FLOAT
//********************
static void DdeSaisieFloat(lv_obj_t * label, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {       
        SaisieFloat = (Float_S *)lv_obj_get_user_data(label);
        if (UserEC.Niveau<SaisieFloat->Niveau){
            AFFPopupMDP();
        }
        else{
            PageSaisieFloat(label);
        }
    }
}
static void PageSaisieFloat(lv_obj_t * label){
    
    //STRUCTURE SAISIE
    SaisieFloat = (Float_S *)lv_obj_get_user_data(label);
    
    //FOND GRISE 
    static lv_style_t modal_style;
    lv_style_copy(&modal_style, &lv_style_plain_color);
    modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
    modal_style.body.opa = LV_OPA_50;
    FondGris = lv_obj_create(lv_scr_act(), NULL);
    lv_obj_set_style(FondGris, &modal_style);
    lv_obj_set_pos(FondGris, 0, 0);
    lv_obj_set_size(FondGris, LV_HOR_RES, LV_VER_RES);
    lv_obj_set_opa_scale_enable(FondGris, true); 
    
    //CREATION POPUP 
    lv_obj_t *PopupNum = lv_obj_create(FondGris, NULL);
    lv_obj_set_size(PopupNum,400,260); 
    lv_obj_align(PopupNum, FondGris, LV_ALIGN_CENTER, 0, 0);
    lv_obj_set_opa_scale_enable(PopupNum, true);
    lv_obj_set_opa_scale(PopupNum, 240);
    
    //TITRE
    label = lv_label_create(PopupNum, NULL); 
    lv_obj_set_style(label,&PG16);  
    sprintf(text, "%s", SaisieFloat->Txt);
    lv_label_set_text(label, text);   
    lv_obj_align(label, PopupNum, LV_ALIGN_IN_TOP_MID, 0, 3);
    lv_obj_set_opa_scale_enable(label, true);
    lv_obj_set_opa_scale(label, LV_OPA_COVER);
    
    //CHAMPS SAISI
    ChSaisi = lv_ta_create(PopupNum, NULL);
    lv_ta_set_text(ChSaisi, "");
    lv_ta_set_one_line(ChSaisi, true);
    lv_obj_set_width(ChSaisi, 200);
    lv_obj_align(ChSaisi, PopupNum, LV_ALIGN_IN_TOP_LEFT, 20, 25); 
    lv_obj_set_opa_scale_enable(ChSaisi, true);
    lv_obj_set_opa_scale(ChSaisi, LV_OPA_COVER); 
    
    //VALEUR EN COURS / mini /maxi
    label = lv_label_create(PopupNum, NULL); 
    lv_obj_set_style(label,&P12);  
    sprintf(text, _("Valeur Actuelle = %2.2f %s\nValeur mini = %2.2f %s\nValeur maxi = %2.2f %s\n"), SaisieFloat->Val, SaisieFloat->Unit, SaisieFloat->Min, SaisieFloat->Unit, SaisieFloat->Max, SaisieFloat->Unit);
    lv_label_set_text(label, text);
    lv_obj_align(label, ChSaisi, LV_ALIGN_OUT_RIGHT_MID,5, 30);
    lv_obj_set_opa_scale_enable(label, true);
    lv_obj_set_opa_scale(label, LV_OPA_COVER);
       
   // PAVE NUMERIQUE SAISIE 
    static lv_style_t rel_style, pr_style; //STYLE CLAVIER
    lv_style_copy(&rel_style, &lv_style_btn_rel);
    rel_style.body.radius = 0;
    rel_style.body.border.width = 1;
    lv_style_copy(&pr_style, &lv_style_btn_pr);
    pr_style.body.radius = 0;
    pr_style.body.border.width = 1;
  
    kb = lv_kb_create(PopupNum, NULL);
    lv_kb_set_mode(kb, LV_KB_MODE_NUM );
    lv_obj_set_event_cb(kb, KbSaisieFloat_ACT);
    lv_kb_set_ta(kb, ChSaisi);
    lv_obj_set_size(kb,200,180);     
 //   lv_btnm_set_map(kb, PAVE_NUMERIQUE_MAP);
    lv_obj_align(kb, ChSaisi, LV_ALIGN_OUT_BOTTOM_MID, 0, 5); 
    lv_obj_set_opa_scale_enable(kb, true);
    lv_obj_set_opa_scale(kb, LV_OPA_COVER);     
    lv_kb_set_cursor_manage(kb, true);
    lv_kb_set_style(kb, LV_KB_STYLE_BG, &lv_style_transp_tight);
    lv_kb_set_style(kb, LV_KB_STYLE_BTN_REL, &rel_style);
    lv_kb_set_style(kb, LV_KB_STYLE_BTN_PR, &pr_style); 
    lv_ta_set_text(ChSaisi, "");  
    
 }   
     
static void KbSaisieFloat_ACT(lv_obj_t * event_kb, lv_event_t event)
{    
    lv_kb_def_event_cb(event_kb, event);
    if(event == LV_EVENT_APPLY ) { 
        //CONVERSION VALEUR SAISIE        
        const char * tmp = lv_ta_get_text(ChSaisi);
        float ValSaisie=strtof(tmp, NULL);
        //VALEUR OK
        if (ValSaisie>=SaisieFloat->Min and ValSaisie<=SaisieFloat->Max){
            SaisieFloat->Val=ValSaisie;
            lv_obj_del_async(FondGris); 
        }
        else{                
        //VALEUR HORS LIMITES
        //MESSAGE BOX SUR FOND GRISE 
            static lv_style_t modal_style;
            lv_style_copy(&modal_style, &lv_style_plain_color);
            modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
            modal_style.body.opa = LV_OPA_50;
            FondGris2 = lv_obj_create(lv_scr_act(), NULL);
            lv_obj_set_style(FondGris2, &modal_style);
            lv_obj_set_pos(FondGris2, 0, 0);
            lv_obj_set_size(FondGris2, LV_HOR_RES, LV_VER_RES);
            lv_obj_set_opa_scale_enable(FondGris2, true);             
            static const char * btns2[] = {"Ok", ""}; 
            mbox=lv_mbox_create(FondGris2, NULL);
            lv_mbox_add_btns(mbox, btns2);
            lv_mbox_set_text(mbox, "VALEUR SAISIE HORS LIMITES");
            lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
            lv_obj_set_event_cb(mbox, mbox_ACT);        
        }      
    }
    if(event == LV_EVENT_CANCEL ) {            
        lv_obj_del_async(FondGris);  
    } 
}

//********************
// SAISIE INT
//********************
static void DdeSaisieInt(lv_obj_t * label, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {       
        SaisieFloat = (Float_S *)lv_obj_get_user_data(label);
        if (UserEC.Niveau<SaisieInt->Niveau){
            AFFPopupMDP();
        }
        else{
            PageSaisieInt(label);
        }
    }
}
static void PageSaisieInt(lv_obj_t * label)
{    
    //STRUCTURE SAISIE
    SaisieInt = (Int_S *)lv_obj_get_user_data(label);
    
    //FOND GRISE 
    static lv_style_t modal_style;
    lv_style_copy(&modal_style, &lv_style_plain_color);
    modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
    modal_style.body.opa = LV_OPA_50;
    FondGris = lv_obj_create(lv_scr_act(), NULL);
    lv_obj_set_style(FondGris, &modal_style);
    lv_obj_set_pos(FondGris, 0, 0);
    lv_obj_set_size(FondGris, LV_HOR_RES, LV_VER_RES);
    lv_obj_set_opa_scale_enable(FondGris, true); 
    
    //CREATION POPUP 
    lv_obj_t *PopupNum = lv_obj_create(FondGris, NULL);
    lv_obj_set_size(PopupNum,400,260); 
    lv_obj_align(PopupNum, FondGris, LV_ALIGN_CENTER, 0, 0);
    lv_obj_set_opa_scale_enable(PopupNum, true);
    lv_obj_set_opa_scale(PopupNum, 240);
    
    //TITRE
    label = lv_label_create(PopupNum, NULL); 
    lv_obj_set_style(label,&PG16);  
    sprintf(text, "%s", SaisieInt->Txt);
    lv_label_set_text(label, text);   
    lv_obj_align(label, PopupNum, LV_ALIGN_IN_TOP_MID, 0, 3);
    lv_obj_set_opa_scale_enable(label, true);
    lv_obj_set_opa_scale(label, LV_OPA_COVER);
    
    //CHAMPS SAISI
    ChSaisi = lv_ta_create(PopupNum, NULL);
    lv_ta_set_text(ChSaisi, "");
    lv_ta_set_one_line(ChSaisi, true);
    lv_obj_set_width(ChSaisi, 200);
    lv_obj_align(ChSaisi, PopupNum, LV_ALIGN_IN_TOP_LEFT, 20, 25); 
    lv_obj_set_opa_scale_enable(ChSaisi, true);
    lv_obj_set_opa_scale(ChSaisi, LV_OPA_COVER); 
    
    //VALEUR EN COURS / mini /maxi
    label = lv_label_create(PopupNum, NULL); 
    lv_obj_set_style(label,&P12);  
    sprintf(text, _("Valeur Actuelle = %d %s\nValeur mini = %d %s\nValeur maxi = %d %s\n"), SaisieInt->Val, SaisieInt->Unit, SaisieInt->Min, SaisieInt->Unit, SaisieInt->Max, SaisieInt->Unit);
    lv_label_set_text(label, text);
    lv_obj_align(label, ChSaisi, LV_ALIGN_OUT_RIGHT_MID,5, 30);
    lv_obj_set_opa_scale_enable(label, true);
    lv_obj_set_opa_scale(label, LV_OPA_COVER);
       
   // PAVE NUMERIQUE SAISIE 
    static lv_style_t rel_style, pr_style; //STYLE CLAVIER
    lv_style_copy(&rel_style, &lv_style_btn_rel);
    rel_style.body.radius = 0;
    rel_style.body.border.width = 1;
    lv_style_copy(&pr_style, &lv_style_btn_pr);
    pr_style.body.radius = 0;
    pr_style.body.border.width = 1;
  
    kb = lv_kb_create(PopupNum, NULL);
    lv_kb_set_mode(kb, LV_KB_MODE_NUM );
    lv_obj_set_event_cb(kb, KbSaisieInt_ACT);
    lv_kb_set_ta(kb, ChSaisi);
    lv_obj_set_size(kb,200,180);     
 //   lv_btnm_set_map(kb, PAVE_NUMERIQUE_MAP);
    lv_obj_align(kb, ChSaisi, LV_ALIGN_OUT_BOTTOM_MID, 0, 5); 
    lv_obj_set_opa_scale_enable(kb, true);
    lv_obj_set_opa_scale(kb, LV_OPA_COVER);     
    lv_kb_set_cursor_manage(kb, true);
    lv_kb_set_style(kb, LV_KB_STYLE_BG, &lv_style_transp_tight);
    lv_kb_set_style(kb, LV_KB_STYLE_BTN_REL, &rel_style);
    lv_kb_set_style(kb, LV_KB_STYLE_BTN_PR, &pr_style); 
    lv_ta_set_text(ChSaisi, "");      
}   
     
static void KbSaisieInt_ACT(lv_obj_t * event_kb, lv_event_t event)
{    
    lv_kb_def_event_cb(event_kb, event);
    if(event == LV_EVENT_APPLY ) { 
        //CONVERSION VALEUR SAISIE        
        const char * tmp = lv_ta_get_text(ChSaisi);
        int ValSaisie=strtof(tmp, NULL);
        //VALEUR OK
        if (ValSaisie>=SaisieInt->Min and ValSaisie<=SaisieInt->Max){
            SaisieInt->Val=ValSaisie;
            lv_obj_del_async(FondGris); 
        }
        else{                
        //VALEUR HORS LIMITES
        //MESSAGE BOX SUR FOND GRISE 
            static lv_style_t modal_style;
            lv_style_copy(&modal_style, &lv_style_plain_color);
            modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
            modal_style.body.opa = LV_OPA_50;
            FondGris2 = lv_obj_create(lv_scr_act(), NULL);
            lv_obj_set_style(FondGris2, &modal_style);
            lv_obj_set_pos(FondGris2, 0, 0);
            lv_obj_set_size(FondGris2, LV_HOR_RES, LV_VER_RES);
            lv_obj_set_opa_scale_enable(FondGris2, true);             
            static const char * btns2[] = {"Ok", ""}; 
            mbox=lv_mbox_create(FondGris2, NULL);
            lv_mbox_add_btns(mbox, btns2);
            lv_mbox_set_text(mbox, "VALEUR SAISIE HORS LIMITES");
            lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
            lv_obj_set_event_cb(mbox, mbox_ACT);        
        }      
    }
    if(event == LV_EVENT_CANCEL ) {            
        lv_obj_del_async(FondGris);  
    } 
}

//********************
// SAISIE TEXTE
//********************
static void DdeSaisieTxt(lv_obj_t * label, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {       
        SaisieTxt = (Txt_S *)lv_obj_get_user_data(label);
        if (UserEC.Niveau<SaisieTxt->Niveau){
            AFFPopupMDP();
        }
        else{
            PageSaisieTxt(label);
        }
    }
}
static void PageSaisieTxt(lv_obj_t * label)
{    
    //STRUCTURE SAISIE
    SaisieTxt = (Txt_S *)lv_obj_get_user_data(label);
    
    //FOND GRISE 
    static lv_style_t modal_style;
    lv_style_copy(&modal_style, &lv_style_plain_color);
    modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
    modal_style.body.opa = LV_OPA_50;
    FondGris = lv_obj_create(lv_scr_act(), NULL);
    lv_obj_set_style(FondGris, &modal_style);
    lv_obj_set_pos(FondGris, 0, 0);
    lv_obj_set_size(FondGris, LV_HOR_RES, LV_VER_RES);
    lv_obj_set_opa_scale_enable(FondGris, true); 
    
    //CREATION POPUP 
    lv_obj_t *PopupNum = lv_obj_create(FondGris, NULL);
    lv_obj_set_size(PopupNum,480,260); 
    lv_obj_align(PopupNum, FondGris, LV_ALIGN_CENTER, 0, 0);
    lv_obj_set_opa_scale_enable(PopupNum, true);
    lv_obj_set_opa_scale(PopupNum, 240);
    
    //TITRE
    label = lv_label_create(PopupNum, NULL); 
    lv_obj_set_style(label,&PG16);  
    sprintf(text, "%s", SaisieTxt->Txt);
    lv_label_set_text(label, text);   
    lv_obj_align(label, PopupNum, LV_ALIGN_IN_TOP_MID, 0, 3);
    lv_obj_set_opa_scale_enable(label, true);
    lv_obj_set_opa_scale(label, LV_OPA_COVER);
    
    //CHAMPS SAISI
    ChSaisi = lv_ta_create(PopupNum, NULL);
    lv_ta_set_text(ChSaisi, "");
    lv_ta_set_one_line(ChSaisi, true);
    lv_obj_set_width(ChSaisi, 250);
    lv_obj_align(ChSaisi, PopupNum, LV_ALIGN_IN_TOP_LEFT, 20, 25); 
    lv_obj_set_opa_scale_enable(ChSaisi, true);
    lv_obj_set_opa_scale(ChSaisi, LV_OPA_COVER); 
    lv_ta_set_max_length(ChSaisi, SaisieTxt->NbCarMax);
    
    //VALEUR EN COURS /Nombre de caractère maxi
    label = lv_label_create(PopupNum, NULL); 
    lv_obj_set_style(label,&P12);  
    sprintf(text, _("Actuel = %s\n%d caractères maximum"), SaisieTxt->Val, SaisieTxt->NbCarMax);
    lv_label_set_text(label, text);
    lv_obj_align(label, ChSaisi, LV_ALIGN_OUT_RIGHT_MID,5, 0);
    lv_obj_set_opa_scale_enable(label, true);
    lv_obj_set_opa_scale(label, LV_OPA_COVER);
       
   // PAVE NUMERIQUE SAISIE 
    static lv_style_t rel_style, pr_style; //STYLE CLAVIER
    lv_style_copy(&rel_style, &lv_style_btn_rel);
    rel_style.body.radius = 0;
    rel_style.body.border.width = 1;
    lv_style_copy(&pr_style, &lv_style_btn_pr);
    pr_style.body.radius = 0;
    pr_style.body.border.width = 1;
  
    kb = lv_kb_create(PopupNum, NULL);
//    lv_kb_set_mode(kb, LV_KB_MODE_NUM );
    lv_obj_set_event_cb(kb, KbSaisieTxt_ACT);
    lv_kb_set_ta(kb, ChSaisi);
    lv_obj_set_size(kb,480,190);     ;
    lv_obj_align(kb, PopupNum, LV_ALIGN_IN_TOP_LEFT, 0, 65); 
    lv_obj_set_opa_scale_enable(kb, true);
    lv_obj_set_opa_scale(kb, LV_OPA_COVER);     
    lv_kb_set_cursor_manage(kb, true);
    lv_kb_set_style(kb, LV_KB_STYLE_BG, &lv_style_transp_tight);
    lv_kb_set_style(kb, LV_KB_STYLE_BTN_REL, &rel_style);
    lv_kb_set_style(kb, LV_KB_STYLE_BTN_PR, &pr_style); 
    lv_ta_set_text(ChSaisi, "");      
}   
     
static void KbSaisieTxt_ACT(lv_obj_t * event_kb, lv_event_t event)
{    
    lv_kb_def_event_cb(event_kb, event);
    if(event == LV_EVENT_APPLY ) { 
        //CONVERSION VALEUR SAISIE      
        const char * ValSaisie = lv_ta_get_text(ChSaisi);
        string CalcNbCar = lv_ta_get_text(ChSaisi);
        char test[100];
        
        //VALEUR OK
        if (CalcNbCar.length()>0){
            strcpy(SaisieTxt->Val, ValSaisie);
          //  SaisieTxt->Val=ValSaisie;
            lv_obj_del_async(FondGris); 
        }
        else{                
        //VALEUR HORS LIMITES
        //MESSAGE BOX SUR FOND GRISE 
            static lv_style_t modal_style;
            lv_style_copy(&modal_style, &lv_style_plain_color);
            modal_style.body.main_color = modal_style.body.grad_color = LV_COLOR_BLACK;
            modal_style.body.opa = LV_OPA_50;
            FondGris2 = lv_obj_create(lv_scr_act(), NULL);
            lv_obj_set_style(FondGris2, &modal_style);
            lv_obj_set_pos(FondGris2, 0, 0);
            lv_obj_set_size(FondGris2, LV_HOR_RES, LV_VER_RES);
            lv_obj_set_opa_scale_enable(FondGris2, true);             
            static const char * btns2[] = {"Ok", ""}; 
            mbox=lv_mbox_create(FondGris2, NULL);
            lv_mbox_add_btns(mbox, btns2);
            lv_mbox_set_text(mbox, "SAISIR AU MOINS 1 CARACTERE");
            lv_obj_align(mbox, NULL, LV_ALIGN_CENTER, 0, 0);
            lv_obj_set_event_cb(mbox, mbox_ACT);        
        }              
    }
    if(event == LV_EVENT_CANCEL ) {            
        lv_obj_del_async(FondGris);  
    } 
}



//FERMETURE POPUP MESSAGE BOX
static void mbox_ACT(lv_obj_t * obj, lv_event_t event)
{   
    if(event == LV_EVENT_CLICKED) {
        lv_obj_del_async(FondGris2); 
    }
}



//**************************
// ACTION BOUTONS MENUS
//**************************

static void Reglage_R_RGB(lv_obj_t * obj, lv_event_t event)
{
    if(event == LV_EVENT_PRESSING) {
        Reglage_R= lv_slider_get_value(obj);
        sprintf(text, " %d ",Reglage_R );
        lv_label_set_text(Val_R, text);
    }
}

static void BPRAZ_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        TpsMinEntre2Puls=999999;
        TpsMaPpe=0;
        TpsMaxEntre2Puls=0;
        CptPuls=0;   
        Volume.Val=0;
        Duree.Val=50*60;
        for (NumDent=20;NumDent>0;NumDent--){
               TpsEntre2Puls[NumDent]=0;    
               MemTpsPuls=0;  
               MemTps16Puls=0;
        }
    }
}
static void BPPOMPE_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        DO_POMPE=!DO_POMPE;
    }
}
static void LANGUE_FR_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {       
        lv_i18n_set_locale("fr");     
        AFFBandeauHaut(1);
        AFFPage(PageAff);
    }
}
static void LANGUE_EN_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {        
       lv_i18n_set_locale("en-GB");       
       AFFBandeauHaut(1);
       AFFPage(PageAff);
   }
}

static void BPMENU_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        AFFBandeauHaut(2);
    }
}

static void M100_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M100);
        DdeAlignMenu=1;
        NumSousMenu=100;
    }
}
static void M200_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M200);
        DdeAlignMenu=1;
        NumSousMenu=200;
    }
}
static void M300_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M300);
        DdeAlignMenu=1;
        NumSousMenu=300;
    }
}
static void M400_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M400);
        DdeAlignMenu=1;
        NumSousMenu=400;
    }
}
static void M500_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M500);
        DdeAlignMenu=1;
        NumSousMenu=500;
    }
}
static void M600_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M600);
        DdeAlignMenu=1;
        NumSousMenu=600;
    }
}
static void M700_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {
        PosX_MenuDepart = lv_obj_get_x(BandeauHaut);
        PosX_MenuCible = -lv_obj_get_x(M700);
        DdeAlignMenu=1;
        NumSousMenu=700;
    }
}
//**************************
// ACTION BOUTONS SOUS MENUS
//**************************
static void SM_ACT(lv_obj_t * btn, lv_event_t event)
{
    if(event == LV_EVENT_CLICKED) {  
        //VERIFICATION AUTORISATION ACCES
        uint8_t EtatBp = lv_btn_get_state(btn);
        if (EtatBp==LV_BTN_STATE_INA){   
            AFFPopupMDP();
        }    
        else{               
            DdeFermBandeauHaut=true;
            TpsAvFermSousMenu=0;
     //       AFFPage(101);
            lv_obj_t * label =  lv_obj_get_child(btn, NULL);
            const char * txt = lv_label_get_text(label);
            if(strcmp(txt, _("M101")) == 0) {AFFPage(101);} 
            if(strcmp(txt, _("M102")) == 0) {AFFPage(102);} 
            if(strcmp(txt, _("M103")) == 0) {AFFPage(103);} 
            if(strcmp(txt, _("M104")) == 0) {AFFPage(104);} 
            if(strcmp(txt, _("M105")) == 0) {AFFPage(105);} 
            if(strcmp(txt, _("M106")) == 0) {AFFPage(106);} 
            if(strcmp(txt, _("M107")) == 0) {AFFPage(107);}             
            
            if(strcmp(txt, _("M201")) == 0) {AFFPage(201);} 
            if(strcmp(txt, _("M202")) == 0) {AFFPage(202);} 
            if(strcmp(txt, _("M203")) == 0) {AFFPage(203);} 
            if(strcmp(txt, _("M204")) == 0) {AFFPage(204);} 
            if(strcmp(txt, _("M205")) == 0) {AFFPage(205);} 
            if(strcmp(txt, _("M206")) == 0) {AFFPage(206);} 
            if(strcmp(txt, _("M207")) == 0) {AFFPage(207);}      
            
            if(strcmp(txt, _("M301")) == 0) {AFFPage(301);} 
            if(strcmp(txt, _("M302")) == 0) {AFFPage(302);} 
            if(strcmp(txt, _("M303")) == 0) {AFFPage(303);} 
            if(strcmp(txt, _("M304")) == 0) {AFFPage(304);} 
            if(strcmp(txt, _("M305")) == 0) {AFFPage(305);} 
            if(strcmp(txt, _("M306")) == 0) {AFFPage(306);} 
            if(strcmp(txt, _("M307")) == 0) {AFFPage(307);}      
            
            if(strcmp(txt, _("M401")) == 0) {AFFPage(401);} 
            if(strcmp(txt, _("M402")) == 0) {AFFPage(402);} 
            if(strcmp(txt, _("M403")) == 0) {AFFPage(403);} 
            if(strcmp(txt, _("M404")) == 0) {AFFPage(404);} 
            if(strcmp(txt, _("M405")) == 0) {AFFPage(405);} 
            if(strcmp(txt, _("M406")) == 0) {AFFPage(406);} 
            if(strcmp(txt, _("M407")) == 0) {AFFPage(407);}      
            
            if(strcmp(txt, _("M501")) == 0) {AFFPage(501);} 
            if(strcmp(txt, _("M502")) == 0) {AFFPage(502);} 
            if(strcmp(txt, _("M503")) == 0) {AFFPage(503);} 
            if(strcmp(txt, _("M504")) == 0) {AFFPage(504);} 
            if(strcmp(txt, _("M505")) == 0) {AFFPage(505);} 
            if(strcmp(txt, _("M506")) == 0) {AFFPage(506);} 
            if(strcmp(txt, _("M507")) == 0) {AFFPage(507);}      
            
            if(strcmp(txt, _("M601")) == 0) {AFFPage(601);} 
            if(strcmp(txt, _("M602")) == 0) {AFFPage(602);} 
            if(strcmp(txt, _("M603")) == 0) {AFFPage(603);} 
            if(strcmp(txt, _("M604")) == 0) {AFFPage(604);} 
            if(strcmp(txt, _("M605")) == 0) {AFFPage(605);} 
            if(strcmp(txt, _("M606")) == 0) {AFFPage(606);} 
            if(strcmp(txt, _("M607")) == 0) {AFFPage(607);}      
            
            if(strcmp(txt, _("M701")) == 0) {AFFPage(701);} 
            if(strcmp(txt, _("M702")) == 0) {AFFPage(702);} 
            if(strcmp(txt, _("M703")) == 0) {AFFPage(703);} 
            if(strcmp(txt, _("M704")) == 0) {AFFPage(704);} 
            if(strcmp(txt, _("M705")) == 0) {AFFPage(705);} 
            if(strcmp(txt, _("M706")) == 0) {AFFPage(706);} 
            if(strcmp(txt, _("M707")) == 0) {AFFPage(707);} 
            
        }
    }
}


//********************
// FONCTIONS GENERALES
//********************
void lv_ticker_func()
{
    lv_tick_inc(5); //Call lv_tick_inc(x) every x milliseconds in a Timer or Task (x should be between 1 and 10). It is required for the internal timing of LittlevGL.
}

//FONCTION D'AFFICHAGE
void my_disp_flush(lv_disp_drv_t* disp_drv, const lv_area_t* area, lv_color_t* color_p)
{
    //The most simple case (but also the slowest) to put all pixels to the screen one-by-one
    uint16_t x, y;
    for(y = area->y1; y <= area->y2; y++) {
        for(x = area->x1; x <= area->x2; x++) {

            lcd.DrawPixel( x, y, color_p->full);
            color_p++;
        }
    }

    // IMPORTANT!!!
    // Inform the graphics library that you are ready with the flushing
    lv_disp_flush_ready(disp_drv);
}

//FONCTION RECUPERATION COORDONNEES APPUI
bool my_touchpad_read(lv_indev_drv_t * indev_driver, lv_indev_data_t * data)
{
    static lv_coord_t last_x = 0;
    static lv_coord_t last_y = 0;

    //Save the state and save the pressed coordinate
    ts.GetState(&TS_State);

    if(TS_State.touchDetected == 1) {
        data->state = LV_INDEV_STATE_PR;
    } else {
        data->state = LV_INDEV_STATE_REL;
    }

    //data->state = tttt ? LV_INDEV_STATE_PR : LV_INDEV_STATE_REL;
    //  if(data->state == LV_INDEV_STATE_PR){
    if(data->state == LV_INDEV_STATE_PR) {
        //touchpad_get_xy(&last_x, &last_y);
        last_x = TS_State.touchX[0];
        last_y = TS_State.touchY[0];
    }

    //Set the coordinates (if released use the last pressed coordinates)
    data->point.x = last_x;
    data->point.y = last_y;

    X = TS_State.touchDetected ;



    return false; //Return `false` because we are not buffering and no more data to read
}

//FONCTION CONVERSION STRING EN CHAINE DE CARACTERE
static char *S(string S){
    char Ch[100];
    for (int i = 0; i < S.length(); i++) { Ch[i] = S[i];} 
    return Ch;    
}
// FONCTION CONVERSION DUREE EN SECONDE EN CHAINE DE CARACTERES hh:mm:ss
static char *HHMMSS(int32_t Seconde){
        char Ch[8];
        char HH[2];
        char MM[2];
        char SS[2];
        int32_t h = (Seconde / 3600);
        int32_t m = ((Seconde - (h * 3600)) / 60);
        int32_t s = (Seconde - ((h * 3600) + (m * 60)));
        sprintf(HH, "%d",h );
        if (h<10){sprintf(HH, "0%d",h );}
        sprintf(MM, "%d",m );
        if (m<10){sprintf(MM, "0%d",m );}
        sprintf(SS, "%d",s );
        if (s<10){sprintf(SS, "0%d",s );}
        sprintf(Ch, "%s:%s:%s",HH,MM,SS );
        return Ch;    
        
}

/*****************************
**********STYLES**************
*****************************/
static void StyleBPM(lv_obj_t * Obj){
    static lv_style_t btn_rel, btn_pr, btn_tgl_rel, btn_tgl_pr, btn_ina;
     
    lv_style_copy(&btn_rel, &lv_style_btn_rel);    
    btn_rel.text.font = &RB_lv_font_roboto_bold_18;   
    btn_rel.body.padding.top    = 10;
    btn_rel.body.padding.bottom = 10;       
    btn_rel.body.main_color     = LV_COLOR_MAKE(R3, G3, B3);
    btn_rel.body.grad_color     = LV_COLOR_MAKE(R4, G4, B4);
    btn_rel.body.border.color   = LV_COLOR_MAKE(R5, G5, B5);
    btn_rel.text.color          = LV_COLOR_MAKE(R6, G6, B6); 
 
    lv_style_copy(&btn_pr, &lv_style_btn_pr); 
    btn_pr.text.font = &RB_lv_font_roboto_bold_16;
    btn_pr.body.padding.top    = 10;
    btn_pr.body.padding.bottom = 10;        
    btn_pr.body.main_color = LV_COLOR_MAKE(R7, G7, B7);
    btn_pr.body.grad_color = LV_COLOR_MAKE(R8, G8, B8);
    btn_pr.body.border.color   = LV_COLOR_MAKE(R9, G9, B9);
    btn_pr.text.color          = LV_COLOR_MAKE(R10, G10, B10); 

    lv_style_copy(&btn_tgl_rel, &btn_rel);  
    btn_tgl_rel.text.font = &RB_lv_font_roboto_bold_16;
    btn_tgl_rel.body.padding.top    = 10;
    btn_tgl_rel.body.padding.bottom = 10;           

    lv_style_copy(&btn_tgl_pr, &btn_pr); 
    btn_tgl_pr.text.font = &RB_lv_font_roboto_bold_16;
    btn_tgl_pr.body.padding.top    = 10;
    btn_tgl_pr.body.padding.bottom = 10;        

    lv_style_copy(&btn_ina, &lv_style_btn_ina); 
    btn_ina.text.font = &RB_lv_font_roboto_bold_16;  
    btn_ina.body.padding.top    = 10;
    btn_ina.body.padding.bottom = 10;      
    btn_ina.body.main_color = LV_COLOR_MAKE(R11, G11, B11);
    btn_ina.body.grad_color = LV_COLOR_MAKE(R12, G12, B12);
    btn_ina.body.border.color = LV_COLOR_MAKE(R13, G13, B13);
    btn_ina.text.color          = LV_COLOR_MAKE(R14, G14, B14); 
   
    lv_btn_set_style(Obj, LV_BTN_STATE_REL, &btn_rel);
    lv_btn_set_style(Obj, LV_BTN_STATE_PR, &btn_pr);
    lv_btn_set_style(Obj, LV_BTN_STATE_TGL_REL, &btn_pr);
    lv_btn_set_style(Obj, LV_BTN_STATE_TGL_PR, &btn_tgl_pr);
    lv_btn_set_style(Obj, LV_BTN_STATE_INA, &btn_ina);    
}

static void StyleBPSM(lv_obj_t * Obj){
    
    static lv_style_t btn_rel, btn_pr, btn_tgl_rel, btn_tgl_pr, btn_ina;
      
    lv_style_copy(&btn_rel, &lv_style_btn_rel);    
    btn_rel.text.font = &RB_lv_font_roboto_16;   
    btn_rel.body.padding.top    = 10;
    btn_rel.body.padding.bottom = 10;       
    btn_rel.body.padding.left = 5;          
    btn_rel.body.padding.right = 50;   
    btn_rel.body.main_color     = LV_COLOR_MAKE(R3, G3, B3);
    btn_rel.body.grad_color     = LV_COLOR_MAKE(R4, G4, B4);
    btn_rel.body.border.color   = LV_COLOR_MAKE(R5, G5, B5);
    btn_rel.text.color          = LV_COLOR_MAKE(R6, G6, B6); 
 
    lv_style_copy(&btn_pr, &lv_style_btn_pr); 
    btn_pr.text.font = &RB_lv_font_roboto_16;
    btn_pr.body.padding.top    = 10;
    btn_pr.body.padding.bottom = 10;   
    btn_pr.body.padding.left = 5;          
    btn_pr.body.padding.right = 50;    
    btn_pr.body.main_color = LV_COLOR_MAKE(R7, G7, B7);
    btn_pr.body.grad_color = LV_COLOR_MAKE(R8, G8, B8);
    btn_pr.body.border.color   = LV_COLOR_MAKE(R9, G9, B9);
    btn_pr.text.color          = LV_COLOR_MAKE(R10, G10, B10); 

    lv_style_copy(&btn_tgl_rel, &btn_rel);  
    btn_tgl_rel.text.font = &RB_lv_font_roboto_16;
    btn_tgl_rel.body.padding.top    = 10;
    btn_tgl_rel.body.padding.bottom = 10; 
    btn_tgl_rel.body.padding.left = 5;          
    btn_tgl_rel.body.padding.right = 50;              

    lv_style_copy(&btn_tgl_pr, &btn_pr); 
    btn_tgl_pr.text.font = &RB_lv_font_roboto_16;
    btn_tgl_pr.body.padding.top    = 10;
    btn_tgl_pr.body.padding.bottom = 10;    
    btn_tgl_pr.body.padding.left = 5;          
    btn_tgl_pr.body.padding.right = 50;          

    lv_style_copy(&btn_ina, &lv_style_btn_ina); 
    btn_ina.text.font = &RB_lv_font_roboto_16;  
    btn_ina.body.padding.top    = 10;
    btn_ina.body.padding.bottom = 10;     
    btn_ina.body.padding.left = 5;          
    btn_ina.body.padding.right = 50;      
    btn_ina.body.main_color = LV_COLOR_MAKE(R11, G11, B11);
    btn_ina.body.grad_color = LV_COLOR_MAKE(R12, G12, B12);
    btn_ina.body.border.color = LV_COLOR_MAKE(R13, G13, B13);
    btn_ina.text.color          = LV_COLOR_MAKE(R14, G14, B14); 
    
    lv_list_set_style(Obj, LV_LIST_STYLE_BTN_REL, &btn_rel);
    lv_list_set_style(Obj, LV_LIST_STYLE_BTN_PR, &btn_pr);
    lv_list_set_style(Obj, LV_LIST_STYLE_BTN_TGL_REL, &btn_pr);
    lv_list_set_style(Obj, LV_LIST_STYLE_BTN_TGL_PR, &btn_tgl_pr);
    lv_list_set_style(Obj, LV_LIST_STYLE_BTN_INA, &btn_ina);
    
}




