#include "mbed.h"
#include "GT511C3.hpp"
 
Serial debug(USBTX,USBRX);
 
DigitalOut myled(LED1);
GT511C3 finger(p9,p10);
 
int progress(int status,char *msg)
{
    debug.printf("%s",msg);
    return 0;
}
 
int main() {
    int sts = 0;
    int ID = 0;
 
    debug.format(8,Serial::None,1);
    debug.baud(115200);
 
    debug.printf("Fingerprint reader module \"GT-511C3 / GT-511C31\" test program.\n");
    debug.printf("Build: %s %s\n",__DATE__,__TIME__);
 
    debug.printf("Open\n");
    sts = finger.Open();
    debug.printf("sts = %d\n",sts);
    if(sts == 0){
        int i;
        debug.printf("FirmwareVersion = %lx\n",finger.FirmwareVersion);
        debug.printf("IsoAreaMaxSize = %ld\n",finger.IsoAreaMaxSize);
        debug.printf("DeviceSerialNumber = ");
        for(i = 0; i < sizeof(finger.DeviceSerialNumber);i++){
            debug.printf("%02X",finger.DeviceSerialNumber[i]);
        }
        debug.printf("\n");
    }
 
    // Deletes All Fingerprints enrolled in the database
    debug.printf("Deleting IDs = %d\n", finger.DeleteAllIDs());
 
    // How to create and download a template from the scanner
    // Setting the enrollID to -1 tells the scanner to not save the template but
    // instead to send the data to the host.
    int EnrollID = -1;  
    // The size of one template
    unsigned char data[498];
    // Create a template with the scanner
    finger.Enroll(EnrollID,progress);
    // Receive the template from the scanner
    debug.printf("RecvData = %d\n", finger.RecvData(data, 498));
    debug.printf("Data[0-3] = %X %X %X %X\n", data[0], data[1],data[2],data[3]);
    
    // Since we have a template we want to enroll in the database
    // We call SetTemplate which will upload the template to the scanner
    // 11 is the ID that this template will be enrolled in
    debug.printf("SetTemplate = %d\n", finger.SetTemplate(11,data,498));
    
 
    // Turn on the scanner backlight so we can get good captures
    // during identification testing
    finger.CmosLed(1);
    while(1) {
        debug.printf("Press finger for Identify\n");
        // Wait for a finger on the scanner
        finger.WaitPress(1);
        // Wait until we get a good capture
        if(finger.Capture(1) != 0)
            continue;
            
        // Now that we have a good capute identify the finger
        ID = finger.Identify();
        
        // If you used the same finger this should return 11
        // Otherwise this will return -1
        debug.printf("ID = %d\n",ID);
        debug.printf("Remove finger\n");
        
        // Wait until the finger is removed so we don't double identify a finger
        finger.WaitPress(0);
    }
}