#include "mbed.h"
#include "SDFileSystem.h"

DigitalIn btn(USER_BUTTON);

// trim '\n'
void ntrim(char *str)
{
    int i;
    for (i = 0; str[i] != 0; ++i);

    if (i > 0 && str[i - 1] == '\n')
        str[i - 1] = 0;
}

int main()
{
    // SD filesystem
    SDFileSystem *sd = new SDFileSystem(PB_15, PB_14, PB_13, PA_9, "sd", NC, SDFileSystem::SWITCH_NONE, 20000000); // mosi, miso, sclk, name, card detect, sw type, freq

    while (1)
    {
        if (btn) continue;

        // file open
        FILE *fp = fopen("/sd/test.txt", "r");
        if (fp == NULL)
        {
            printf("open error!!\r\n");
            while(1);
        }
        
        // read text file
        char buf[1024];
        while (fgets(buf, sizeof(buf), fp) != NULL)
        {
            ntrim(buf);            
            printf("%s\r\n", buf);
        }
    
        // file close
        fclose(fp);        

        wait(1);
    }
}
