#include "mbed.h"

// SPI interface
SPI pad_spi(PC_12, PC_11, PC_10);   // MOSI(should pullup), MISO, SCK
DigitalOut pad_cs(PD_2);

// LED
DigitalOut red(PB_5);
DigitalOut yellow(PA_10);

// PS pad initialize
void pspad_init()
{
    pad_spi.format(8, 3);
    pad_spi.frequency(250000);
}

// Read PS Pad state
// 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
// SE -- -- ST  U  R  D  L L2 R2 L1 R1 TR  O  X SQ
void pspad_read(unsigned short *pad)
{
    pad_cs = 0;
    wait_us(500);

    pad_spi.write(0x80);
    pad_spi.write(0x42);
    pad_spi.write(0);
    pad_spi.write(0);
    int d1 = pad_spi.write(0);
    int d2 = pad_spi.write(0);

    pad_cs = 1;
    
    *pad = (char)~d1 << 8 | (char)~d2;
}

int main()
{
    pspad_init();
    
    unsigned short pad;
    
    while(1)
    {
        pspad_read(&pad);
        
        // Circle button
        yellow = pad & 4;
        
        // X button
        red = pad & 2;

        wait_ms(16);
    }
}