#include "mbed.h"

// DAC 20khz
#define DAC_Frequency 20000

AnalogOut dac(PA_4);

DigitalIn btn(USER_BUTTON);

Timer tim;
Ticker tic;

// C D E F G A B C
int freq_table[] = {262, 293, 330, 349, 392, 440, 493, 523};
int sel;

void DAC_Int(void)
{
    int period = 1000000 / freq_table[sel];
    int pos = tim.read_us() % period;

    // Square wave
    //dac = pos > (period / 2) ? 1 : 0;
    
    // Sine wave
    dac = sin(pos * 3.14f * 2 / period) / 2.0f + 0.5f;
}

int main()
{
    sel = 0;

    tim.start();

    tic.attach_us(&DAC_Int, 1000000 / DAC_Frequency);

    while(1)
    {
        if (btn == 0)
        {
            sel++;
            if (sel > 7) sel = 0;
            wait(0.5);
        }
    }
}
