/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
 
#include "mbed.h"
#include "PN532_HSU.h"
#include "snep.h"
#include "NdefMessage.h"
 
Serial pc(USBTX, USBRX);
 
uint8_t ndefBuf[128];
 
int main()
{
    wait(2);
    
    pc.printf("Initializing - ");
    Serial HSU(PA_9, PA_10, 115200);
    PN532_HSU pn532hsu(HSU);
    SNEP nfc(pn532hsu);
    pc.printf("Done\r\n");
    
    while (1) {
        pc.printf("Sending message - ");
        NdefMessage message = NdefMessage();
        message.addTextRecord("mbed NFC shield");
        message.addUriRecord("http://www.seeedstudio.com");
        int messageSize = message.getEncodedSize();
        if (messageSize > sizeof(ndefBuf)) {
            pc.printf("ndefBuf is too small\r\n");
            while (1) {
            }
        } 
        message.encode(ndefBuf);
        if (0 >= nfc.write(ndefBuf, messageSize)) {
            pc.printf("Failed\r\n");
        } else {
            pc.printf("Success\r\n");
        }
        
        wait(3);
    }
}
            