#include "mbed.h"
 
Serial s(USBTX, USBRX);     //serial connection
AnalogIn photoIn(p20);          //analog input pin20 and named PhotoIn
Timer t;                    //timer object for timestamp

void setupSerial(void)
{
    s.baud(19200);                    //sets the BaudRate
    s.format(7,SerialBase::Even,1);    //set DataBits, Parity, and StopBits
}

int main(void)
{
    setupSerial();
 
    float time;       //current time
    float data;       //current data
 
   
    t.reset();  //resets timer
    t.start();  //starts timer
 
    //Loop
    int go = 1;
    while(go==1) {
        //Read data
        data = photoIn.read();
        time= t.read();
 
        //Print data to serial port
        s.printf("%f,%f\n",time,data);
 
        wait(0.5); 
    }
}

