//Headers
#include "globals.h"
#include "Player.h"
#include "PinDetect.h"
#include "letters.h"
#include "bluetoothFunc.h"

//Local functions
void buttonHit (void);
void bluetoothResponse();
void moveCursor();
void callback();

BusOut myled(LED1,LED2,LED3,LED4);

//I/O
Serial blue(p28,p27);
uLCD_4DGL uLCD(p9,p10,p11); 
PinDetect buttonLeft(p15);
PinDetect buttonUp(p14);
PinDetect buttonRight(p16);
PinDetect buttonDown(p13);
AnalogIn potentiometer(p20);
Serial pc(USBTX, USBRX);

//Class initialization
Player player;
Mutex serialLock;

//VARIABLES
int state;
int fire, dir;
int winOrLose;
int enemyHits;

//bluetooth variables
int num;
int upOrDown;
int updateMove;

//move cursor variables
int x, y, prevX, prevY;

//ship placement variables
int newX, newY;
int ships[5];
int shipPointer;
int shipLength;
int prevXship[5];
int prevYship[5];
int prevShipColor[5];
int prevShipLength;
int layout;

//server variables
char cmd[4];
int clearBackground;
int fireX, fireY;
int nextHit;

int main() {    
    //Variable setups
    state = 1;
    fire = dir = 0;
    enemyHits = 0;
    x = y = prevX = prevY = 0;
    num = upOrDown = updateMove = 0;
    ships[0] = 5;
    ships[1] = 4;
    ships[2] = 3;
    ships[3] = 3;
    ships[4] = 2;
    newX = newY = shipPointer = 0;
    shipLength = ships[shipPointer];
    for(int i = 0; i < 5; i++){
        prevXship[i] = 0;
        prevYship[i] = 0;
        prevShipColor[i] = 0;   
    }
    prevShipLength = 0;
    layout = -1;
    clearBackground = 0;
    
    nextHit = 2;
    //Screen setup
    uLCD.set_font_size(8,8);
    uLCD.color(0xFFFFFF);
    uLCD.background_color(0x0000FF);
    uLCD.cls();
    addText();
    player.PrintBoard();    
    while(pc.readable()) {
        pc.getc();
    }
    //Main loop
    while(1){
        
        /////////////////////////////////////////////////
        //bluetooth function
        /////////////////////////////////////////////////
        if(bluetoothFunc(num,upOrDown)){
            if(num >= 1 && num <= 4 && upOrDown){
                layout = num;
                if(num == 1){
                    fire = 1;      
                } else if(num == 2){
                    updateMove = 1;
                    if(dir){
                        dir = 0;
                    } else {
                        dir = 1;   
                    }
                }
            } else if (num >= 5 && num <= 8 && upOrDown){
                updateMove = 1;
                if(num == 7){
                    x = prevX - 1; 
                    if(x < 0){
                        x = 0;   
                    } 
                } else if(num == 8){
                    x = prevX + 1;
                    if(x > 9){
                        x = 9;   
                    }   
                } else if(num == 5){
                    y = prevY - 1;
                    if(y < 0){
                        y = 0;   
                    }   
                } else if(num == 6){
                    y = prevY + 1;
                    if(y > 9){
                        y = 9;   
                    }   
                }  
                uLCD.rectangle(26+prevX*10,26+prevY*10,36+prevX*10,36+prevY*10,WHITE);
                uLCD.rectangle(26+x*10,26+y*10,36+x*10,36+y*10,RED);
                prevX = x;
                prevY = y;
            }
        }   
        
        /////////////////////////////////////////////////
        //STATE MACHINE
        /////////////////////////////////////////////////
        
        /////////////////////////////////////////////////
        //PLACE SHIPS
        /////////////////////////////////////////////////
        if(state == 1){
            /*
            if(player.presetShips()){
                state = 2;   
            }
            */
            //Clear the previous ships
            if(updateMove && clearBackground){
                clearBackground = 0;
                for(int i = 0; i < shipLength; i++){
                    newX = prevXship[i];
                    newY = prevYship[i];
                    if(prevShipColor[i]){
                        if(newX < 10 && newY < 10){
                            uLCD.filled_circle(31+newX*10,31+newY*10,4,0xFFFFFF);        
                        }
                    } else {
                        if(newX < 10 && newY < 10){
                            uLCD.filled_circle(31+newX*10,31+newY*10,4,0x0000FF);     
                        }
                    }
                }
            }
            
            if(updateMove){
                updateMove = 0;
                clearBackground = 1;
                //Print the ship
                if(dir){
                    for(int i = x; i < x + shipLength; i++){
                        if(i < 10){
                            uLCD.filled_circle(31+i*10,31+y*10,4,0x00FF00);    
                        } 
                    }
                    for(int i = 0; i < shipLength; i++){
                        prevXship[i] = x + i;
                        prevYship[i] = y;   
                        prevShipColor[i] = player.getColor(x+i,y);
                    }
                } else {
                    for(int i = y; i < y + shipLength; i++){
                        if(i < 10){
                            uLCD.filled_circle(31+x*10,31+i*10,4,0x00FF00); 
                        }        
                    }  
                    for(int i = 0; i < shipLength; i++){
                        prevXship[i] = x;
                        prevYship[i] = y + i;  
                        prevShipColor[i] = player.getColor(x,y+i); 
                    }                  
                }   
            }
            
            //Player presses the fire button
            if(fire){
                fire = 0;
                bool canPlace = true;
                //Check if the boat can be placed
                for(int i = 0; i < shipLength; i++){
                    if(player.getColor(prevXship[i],prevYship[i]) != 0){
                        canPlace = false;
                        break;
                    } 
                    if(prevXship[i] > 10 || prevYship[i] > 10){
                        canPlace = false;
                        break;
                    }
                }
                //Place the boat
                if(canPlace){
                    for(int i = 0; i < shipLength; i++){
                        player.PlaceShips(prevXship[i],prevYship[i]);
                    }
                    shipPointer++;
                    clearBackground = 0;
                    shipLength = ships[shipPointer];
                    player.PrintBoard();
                }
            }
            
            //Check if all the boats were placed
            if(shipPointer > 4){
                state = 2;   
            }
        }
        /////////////////////////////////////////////////            
        
        /////////////////////////////////////////////////
        //DETERMINE WHICH PLAYER GOES FIRST
        /////////////////////////////////////////////////
        else if(state == 2){
            myled[0] = 1;
            myled[1] = 1;
            myled[2] = 1;
            myled[3] = 1;
            
            fire = 0;
           
            for (int i = 0; i < 4; i++) {
                cmd[i] = pc.getc();    
            }
            
            if(cmd[0] == 'a'){
                player.PrintEnemyBoard();
                addAttack();
                state = 3;   
            } else {
                player.PrintBoard();
                addDefense();
                state = 4;    
            }
            myled[0] = 0;
            myled[1] = 0;
            myled[2] = 0;
            myled[3] = 0;
        }
        /////////////////////////////////////////////////
        
        /////////////////////////////////////////////////
        //ATTACK
        /////////////////////////////////////////////////
        else if(state == 3){
            myled[1] = 1;  
            
            if(fire){
                fire = 0;   
                if(player.getEnemyColor(x,y) == 0){
                    fireX = x;
                    fireY = y;
                    pc.putc(x + '0');
                    pc.putc(y + '0');
                    pc.putc(nextHit + '0');   //hit or miss
                    pc.putc('0');   //endgame
                    
                    player.PrintBoard();
                    addDefense();
                    state = 4;
                    myled[1] = 0;
                }
                
            }
        }
        /////////////////////////////////////////////////
                       
        /////////////////////////////////////////////////
        //WAIT
        /////////////////////////////////////////////////
        else if(state == 4){
            myled[2] = 1;
            wait(1);
            cmd[0] = pc.getc();
            cmd[1] = pc.getc();
            cmd[2] = pc.getc();
            cmd[3] = pc.getc();
            
            int enemyX = cmd[0] - '0';
            int enemyY = cmd[1] - '0';
            int yourHit = cmd[2] - '0';
            int win = cmd[3] - '0';
            
            state = 3;
            if(win){
                state = 5;
                winOrLose = 1;
            } else {
                //UPDATE ENEMY BOARD
                player.Shot(fireX,fireY,yourHit);
                //UPDATE YOUR BOARD
                nextHit = player.EnemyShot(enemyX,enemyY);
                if(nextHit == 1){
                    enemyHits++;
                    if(enemyHits == 17){
                        state = 5;
                        winOrLose = 0;
                        //SEND WIN CONDITION  
                        pc.putc('0');
                        pc.putc('0');
                        pc.putc('0');   
                        pc.putc('1');   
                    }
                } 
                wait_ms(3000);
            }
            myled[2] = 0;
            addAttack();
            player.PrintEnemyBoard();  
        }

        /////////////////////////////////////////////////
 
        /////////////////////////////////////////////////
        //END STATE
        /////////////////////////////////////////////////
        else if(state == 5){
            //GAME OVER
            myled[0] = 1;
            myled[1] = 1;
            myled[2] = 1;
            myled[3] = 1;
            uLCD.cls();
            if(winOrLose){
                addWin();
            } else {
                addLose();
            }
        }
        /////////////////////////////////////////////////
    }
}
