#include "Player.h"

Player::Player(){
    board = new int*[10];
    enemyBoard = new int*[10];
    for(int i = 0; i < 10; i++){
        board[i] = new int[10];
        enemyBoard[i] = new int[10];
        for(int j = 0; j < 10; j++){
            board[i][j] = 0;
            enemyBoard[i][j] = 0;
        }
    }
}

void Player::PrintBoard(){
    for(int i = 0; i < 10; i++){
        uLCD.line(26+i*10,26,26+i*10,127,0xFFFFFF);
        uLCD.line(26,26+i*10,127,26+i*10,0xFFFFFF);
        for(int j = 0; j < 10; j++){
            if(board[i][j] == 0){
                uLCD.filled_circle(31+i*10,31+j*10,4,0x0000FF);
            } else if(board[i][j] == 1) {
                uLCD.filled_circle(31+i*10,31+j*10,4,0xFF0000);    
            } else if(board[i][j] == 2) {
                uLCD.filled_circle(31+i*10,31+j*10,4,0xFFFFFF);    
            } else {
                uLCD.filled_circle(31+i*10,31+j*10,4,0xFFFFFF);   
                uLCD.filled_circle(31+i*10,31+j*10,3,0xFF0000);    
            }
        }
    }
    uLCD.line(126,26,126,127,0xFFFFFF);
    uLCD.line(26,126,127,126,0xFFFFFF);
}

void Player::PrintEnemyBoard(){
    for(int i = 0; i < 10; i++){
        uLCD.line(26+i*10,26,26+i*10,127,0xFFFFFF);
        uLCD.line(26,26+i*10,127,26+i*10,0xFFFFFF);
        for(int j = 0; j < 10; j++){
            if(enemyBoard[i][j] == 0){
                uLCD.filled_circle(31+i*10,31+j*10,4,0x0000FF);
            } else if(enemyBoard[i][j] == 1) {
                uLCD.filled_circle(31+i*10,31+j*10,4,0xFF0000);    
            } else if(enemyBoard[i][j] == 2) {
                uLCD.filled_circle(31+i*10,31+j*10,4,0xFFFFFF);   
            } else {
                uLCD.filled_circle(31+i*10,31+j*10,4,0xFFFFFF);   
                uLCD.filled_circle(31+i*10,31+j*10,3,0xFF0000);    
            }
        }
    }
}

void Player::Shot(int i, int j, int hit) {
    if(hit == 1){
        enemyBoard[i][j] = 3; 
    } else if(hit == 0){
        enemyBoard[i][j] = 1; 
    }
}

int Player::EnemyShot(int i, int j) {
    if(board[i][j] == 2){
        board[i][j] = 3;
        uLCD.filled_circle(31+i*10,31+j*10,4,0xFFFFFF);   
        uLCD.filled_circle(31+i*10,31+j*10,3,0xFF0000);  
        return 1;
    } else if(board[i][j] == 0){
        board[i][j] = 1;
        uLCD.filled_circle(31+i*10,31+j*10,4,0xFF0000);  
        return 0;
    }
    return 3;
    
}

void Player::PlaceShips(int i, int j){
    board[i][j] = 2;
}

int Player::getColor(int i, int j){
    return board[i][j]; 
}

int Player::getEnemyColor(int i, int j){
    return enemyBoard[i][j]; 
}

bool Player::presetShips(int con){
    if(con == 1){
    board[9][3] = 2;
    board[9][4] = 2;
    board[9][5] = 2;  
    board[9][6] = 2;  
    board[9][7] = 2;  
    
    board[5][3] = 2;  
    board[5][4] = 2;  
    board[5][5] = 2;  
    board[5][6] = 2;  
    
    board[1][7] = 2;  
    board[2][7] = 2;  
    board[3][7] = 2;  
    
    board[4][2] = 2;  
    board[5][2] = 2;  
    board[6][2] = 2;  
    
    board[0][0] = 2;  
    board[0][1] = 2;  
    } else if(con == 2){
    board[0][3] = 2;
    board[1][3] = 2;
    board[2][3] = 2;  
    board[3][3] = 2;  
    board[4][3] = 2;  
    
    board[2][5] = 2;  
    board[3][5] = 2;  
    board[4][5] = 2;  
    board[5][5] = 2;  
    
    board[7][1] = 2;  
    board[7][2] = 2;  
    board[7][3] = 2;  
    
    board[0][7] = 2;  
    board[0][8] = 2;  
    board[0][9] = 2;  
    
    board[9][8] = 2;  
    board[9][9] = 2;   
    } else if(con == 3){
    board[6][5] = 2;
    board[6][6] = 2;
    board[6][7] = 2;  
    board[6][8] = 2;  
    board[6][9] = 2;  
    
    board[6][3] = 2;  
    board[7][3] = 2;  
    board[8][3] = 2;  
    board[9][3] = 2;  
    
    board[4][1] = 2;  
    board[4][2] = 2;  
    board[4][3] = 2;  
    
    board[0][4] = 2;  
    board[0][5] = 2;  
    board[0][6] = 2;  
    
    board[4][5] = 2;  
    board[4][6] = 2;   
    } else if(con == 4){
    board[0][3] = 2;
    board[0][4] = 2;
    board[0][5] = 2;  
    board[0][6] = 2;  
    board[0][7] = 2;  
    
    board[1][3] = 2;  
    board[2][3] = 2;  
    board[3][3] = 2;  
    board[4][3] = 2;  
    
    board[8][7] = 2;  
    board[8][8] = 2;  
    board[8][9] = 2;  
    
    board[6][6] = 2;  
    board[7][6] = 2;  
    board[8][6] = 2;  
    
    board[6][9] = 2;  
    board[7][9] = 2;   
    } else {
        return false;   
    }
    return true;
}
    
Player::~Player(){
  for(int i = 0; i < 10; i++){
    delete[] board[i];
    delete[] enemyBoard[i];
  }
  delete[] board;
  delete[] enemyBoard;
}