

#include "Adafruit_ILI9341.h"
#include "Display.h"
#include "Screen.h"

Display::Display() { };

void Display::set_screens(Screen **screens, int num) {
    _screens = screens;
    _num_screens = num;
    _cur_screen_index = 0;
    _cur_screen = _screens[_cur_screen_index];
    _needs_init = 1;
}

void Display::switch_screen() {
    if (_cur_screen_index == _num_screens - 1) {
        _cur_screen_index = 0;
    }
    else {
        _cur_screen_index++;
    }
    _cur_screen = _screens[_cur_screen_index];
    _needs_init = 1;
}
        
void Display::update() {
    if (_needs_init) {
        _cur_screen->init();
        _needs_init = 0;
    }
    _cur_screen->update(); 
}

void Display::error(char *msg) {
    _cur_screen->error(msg);
}