#include "mbed.h"
#include "DS1820.h"

#define NUM_DS1820      3
#define PIN_DS1820      D2

// DEVICES 
double temperatures[NUM_DS1820];
DS1820* thermometers[NUM_DS1820];
Serial pc(USBTX, USBRX);

// Discover DS1820 probes on pin defined by PIN_DS1820
void ds1820_init() {
    // Initialize the thermometer array to DS1820 objects
    int num_devices = 0;
    while(DS1820::unassignedProbe(PIN_DS1820)) {
        thermometers[num_devices] = new DS1820(PIN_DS1820);
        num_devices++;
        if (num_devices == NUM_DS1820)
            break;
    }
    pc.printf("Found %d device(s)\r\n\n", num_devices);   
}

void read_temps() {
    double temp;
    thermometers[0]->convertTemperature(false, DS1820::all_devices);
    for (int i=0; i<NUM_DS1820; i++) {
        temp = (double) thermometers[i]->temperature();
        temperatures[i] = temp;
    }
}
int main()
{
    ds1820_init();
    pc.printf("HELLOP");
    while(1) {
        read_temps();   
        pc.printf("%.3f %.3f %.3f\n" , temperatures[0], temperatures[1], temperatures[2]);
    }
}
