/***************************************************
  This is our GFX example for the Adafruit ILI9341 Breakout and Shield
  ----> http://www.adafruit.com/products/1651
  Check out the links above for our tutorials and wiring diagrams
  These displays use SPI to communicate, 4 or 5 pins are required to
  interface (RST is optional)
  Adafruit invests time and resources providing this open source code,
  please support Adafruit and open-source hardware by purchasing
  products from Adafruit!
  Written by Limor Fried/Ladyada for Adafruit Industries.
  MIT license, all text above must be included in any redistribution
 ****************************************************/
 /*
    Ported to mbed by James Kidd
 */
 
 #ifndef ADAFRUIT_ILI9341_H
 #define ADAFRUIT_ILI9341_H
 
#include <stdint.h>
#include <stdbool.h>
#include "Adafruit_GFX.h"
#include "mbed.h"

//#include "BurstSPI.h"
#define spi_begin()
#define spi_end()

//#defines

#define LCD_SPI_MODE 0x03
#define LCD_SPI_BITS 0x10

//May need to lower this on certain boards
#define LCD_FREQ 6200000

#define PIN_RST  0x00
#define PIN_SCE  0x01
#define PIN_DC   0x02

#define ILI9341_TFTWIDTH  240
#define ILI9341_TFTHEIGHT 320

#define ILI9341_NOP     0x00
#define ILI9341_SWRESET 0x01
#define ILI9341_RDDID   0x04
#define ILI9341_RDDST   0x09

#define ILI9341_SLPIN   0x10
#define ILI9341_SLPOUT  0x11
#define ILI9341_PTLON   0x12
#define ILI9341_NORON   0x13

#define ILI9341_RDMODE  0x0A
#define ILI9341_RDMADCTL  0x0B
#define ILI9341_RDPIXFMT  0x0C
#define ILI9341_RDIMGFMT  0x0A
#define ILI9341_RDSELFDIAG  0x0F

#define ILI9341_INVOFF  0x20
#define ILI9341_INVON   0x21
#define ILI9341_GAMMASET 0x26
#define ILI9341_DISPOFF 0x28
#define ILI9341_DISPON  0x29

#define ILI9341_CASET   0x2A
#define ILI9341_PASET   0x2B
#define ILI9341_RAMWR   0x2C
#define ILI9341_RAMRD   0x2E

#define ILI9341_PTLAR   0x30
#define ILI9341_MADCTL  0x36
#define ILI9341_PIXFMT  0x3A

#define ILI9341_FRMCTR1 0xB1
#define ILI9341_FRMCTR2 0xB2
#define ILI9341_FRMCTR3 0xB3
#define ILI9341_INVCTR  0xB4
#define ILI9341_DFUNCTR 0xB6

#define ILI9341_PWCTR1  0xC0
#define ILI9341_PWCTR2  0xC1
#define ILI9341_PWCTR3  0xC2
#define ILI9341_PWCTR4  0xC3
#define ILI9341_PWCTR5  0xC4
#define ILI9341_VMCTR1  0xC5
#define ILI9341_VMCTR2  0xC7

#define ILI9341_RDID1   0xDA
#define ILI9341_RDID2   0xDB
#define ILI9341_RDID3   0xDC
#define ILI9341_RDID4   0xDD

#define ILI9341_GMCTRP1 0xE0
#define ILI9341_GMCTRN1 0xE1
/*
#define ILI9341_PWCTR6  0xFC
*/

// Color definitions
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

#define DELAY 0x80
//structs
struct AdaLcdPins
{
    PinName mosi;
    PinName miso;
    PinName sclk;
    PinName dc;
    PinName cs;
    PinName rst;
};


class Adafruit_ILI9341 : public Adafruit_GFX {
public:
    Adafruit_ILI9341(PinName DC, PinName CS, PinName RST);

    void     begin(void),
               setAddrWindow(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1),
               pushColor(uint16_t color),
               fillScreen(uint16_t color),
               drawPixel(int16_t x, int16_t y, uint16_t color),
               drawFastVLine(int16_t x, int16_t y, int16_t h, uint16_t color),
               drawFastHLine(int16_t x, int16_t y, int16_t w, uint16_t color),
               fillRect(int16_t x, int16_t y, int16_t w, int16_t h,
                 uint16_t color),
               setRotation(uint8_t r),
               invertDisplay(bool i);
      uint16_t color565(uint8_t r, uint8_t g, uint8_t b);

      void     spiwrite(uint16_t),
          writecommand(uint8_t c),
          writedata(uint16_t d),
          commandList(uint8_t *addr);
        uint8_t  spiread(void);



        uint8_t  readdata(void),
          readcommand8(uint8_t reg, uint8_t index = 0);
       // uint8_t  readdata(void),
        //  readcommand8(uint8_t reg, uint8_t index = 0);

private:
        bool hwSPI;
   AdaLcdPins _pins;
   SPI* LcdSPI;
   DigitalOut** Pins;
   uint8_t  tabcolor;
};

#endif
