#include "mbed.h"

#define DEBUG_SPI

#ifdef DEBUG_SPI
#define PRINTD(arg1,arg2...)    printf(arg1,##arg2)
#endif

SPI spi(PA_7,PA_6,PA_5); // MOSI, MISO, SCLK(CLK,SCK)
DigitalOut cs(PA_4);

void SPI_INIT()
{
    PRINTD("Set SPI init..\n");
    PRINTD("Set SPI format..\n");
    spi.format(8,0);
    PRINTD("Set frequency to default..\n");
    spi.frequency(1000000); // default 1MHz
}

void SPI_Write()
{
    char temp;
    int i,value;
    char response;
    char tx_cnt = -1;
    char rx_cnt = -1;
    char tx_buffer[255]={0};
    char rx_buffer[255]={0};
    PRINTD("\n==========MASTER==========\n");
    PRINTD("DATA SEND START...\n");
    PRINTD("Lock SPI BUS..\n");

    while(1)
    {
        
        temp=getchar();
        tx_buffer[++tx_cnt]=temp;
        if(temp==0x0d)
        {
            tx_buffer[tx_cnt]=0;
            PRINTD("\nData send Finish...\n");
            for(i=0;i<=tx_cnt;++i)
            {
                PRINTD("%c[%02x]",tx_buffer[i],tx_buffer[i]);
            }
            PRINTD("\n\n");
            spi.lock();
            for(i=0;i<=tx_cnt;++i)
            {
                value=tx_buffer[i];
                PRINTD("[M]write[%d]=%c[%02x]\n",i,value,value);
                cs=0;
                response=spi.write(value);
                cs=-1;
                PRINTD("[M]receive=%c[%x]\n",response,response);
                rx_buffer[++rx_cnt]=response;
            }
            spi.unlock();
            for(i=0;i<255;++i)
            {
                tx_buffer[i]=0;
            }
            for(i=0;i<=tx_cnt;i++)
            {
                PRINTD("init_tx_buffer[%d]=%c\n",i,tx_buffer[i]);
            }
            tx_cnt=-1;
        }
        else
        {
            PRINTD("%c[%02x]",tx_buffer[tx_cnt],tx_buffer[tx_cnt]);
        }
    }
}

int main()
{
    int send_data;
    SPI_INIT();    
   
    while(1)
    {
        SPI_Write();   
    }
}
