/*
*LSM6DSS can provide readings up to 6.6khz for acc and gyr
*LIS3MDL can only do 80hz
*LPS25H can do up to 25Hz
*
*/

#include "mbed.h"
#include "USBSerial.h"
#include "lis3mdl.h"
#include "LPS25H.h"
#include "LSM6DS33.h"
 
LIS3MDL mag(PTB3, PTB2);
LPS25H bar(PTB3, PTB2);
LSM6DS33 accgyr(PTB3, PTB2,LSM6DS33_AG_I2C_ADDR(1));

Timer tmain;
 
//Virtual serial port over USB
USBSerial serial;
 
int main(void) {
 
    accgyr.begin();
    
    double timeLog=0;
    tmain.start();
    timeLog +=tmain.read();
    
    //run main loop at 100Hz
    double mainPeriod = 0.01;
    //sample acc/gyr/mag at full rate
   
    serial.printf("begin teensyIMU\r\n");
    
    while(1)
    {
       
        if(tmain.read()< mainPeriod){
            wait(mainPeriod - tmain.read());//wait until time for next main loop
        }else{
             serial.printf("not fast enough\r\n");   
        }
        timeLog +=tmain.read();
        tmain.reset();
        
        //read accgyr at full rate
        
        accgyr.readAll();
        mag.readMag();
        
        bar.readPres();
        
        serial.printf("tIMU:%.9lf %f %f %f %f %f %f %f %d %d %d %f\r\n",timeLog,accgyr.temperature_c,
            accgyr.ax,accgyr.ay,accgyr.az,
            accgyr.gx,accgyr.gy,accgyr.gz,
            mag.mx_raw,mag.my_raw,mag.mz_raw,
            bar.presPa);
    }
}
