#include "mbed.h"
#include "tsi_sensor.h"
#include "SLCD.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif

DigitalIn s1(PTC3);
DigitalIn s3(PTC12);

Serial radio(PTE0, PTE1);

SLCD slcd;

int main(void) {
    PwmOut led(LED_GREEN);
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    radio.baud(9600);
    float controlSail=0;
    float controlRudder=0;
    
    while (true) {
        if(!s1){
        slcd.clear();           // All segments off
        slcd.Home();            // sets next charater to posistion 0 (start)
        controlSail=tsi.readPercentage();
        led = 1.0 - controlSail;
        slcd.printf("S%2.2f",controlSail); // standard printf function, only charaters in ASCII_TO_WF_CODIFICATION_TABLE will display   
        radio.putc('s');         
        radio.putc((char)(controlSail*255));     
        }
        else if(!s3){
        slcd.clear();           // All segments off
        slcd.Home();            // sets next charater to posistion 0 (start)
        controlRudder=tsi.readPercentage();
        led = 1.0 - controlRudder;
        slcd.printf("R%2.2f",controlRudder); // standard printf function, only charaters in ASCII_TO_WF_CODIFICATION_TABLE will display
        radio.putc('r');    
        radio.putc((char)(controlRudder*255));    
            
        }  
        else{
        slcd.clear();           // All segments off
        slcd.Home();            // sets next charater to posistion 0 (start)
        slcd.putc('R'); // standard printf function, only charaters in ASCII_TO_WF_CODIFICATION_TABLE will display
        slcd.CharPosition=3;    // x=0 to 3, 0 is start position
        slcd.putc('S'); // standard printf function, only charaters in ASCII_TO_WF_CODIFICATION_TABLE will display
            
            }      
        wait(0.1);
    }
}
