//**********************
// LPS25H.h for mbed
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#ifndef LPS25H_H_
#define LPS25H_H_

#define LPS25H_ADDR                 0xBA
#define LPS25H_REF_P_XL             0x08
#define LPS25H_REF_P_L              0x09
#define LPS25H_REF_P_H              0x0A
#define LPS25H_WHO_AM_I             0x0F
#define LPS25H_RES_CONF             0x10
#define LPS25H_CTRL_REG1            0x20
#define LPS25H_CTRL_REG2            0x21
#define LPS25H_CTRL_REG3            0x22
#define LPS25H_CTRL_REG4            0x23
#define LPS25H_INT_CFG              0x24
#define LPS25H_INT_SOURCE           0x25
#define LPS25H_STATUS_REG           0x27
#define LPS25H_PRESS_POUT_XL_REH    0x28
#define LPS25H_PRESS_OUT_L          0x29
#define LPS25H_PRESS_OUT_H          0x2A
#define LPS25H_TEMP_OUT_L           0x2B
#define LPS25H_TEMP_OUT_H           0x2C
#define LPS25H_FIFO_CTRL            0x2E
#define LPS25H_FIFO_STATUS          0x2F
#define LPS25H_THS_P_L              0x30
#define LPS25H_THS_P_H              0x31
#define LPS25H_RPDS_L               0x39
#define LPS25H_RPDS_H               0x3A

#include "mbed.h"
#include "typedef.h"

class LPS25H{
public:
    LPS25H (PinName sda, PinName scl);
    LPS25H (I2C& p_i2c);
    void init();
    float presPa;
    float tempC;

    void put(unsigned char a, unsigned char b);
    void get(unsigned char a);
    void readPres();
    void temperature();

protected:
    
    I2C _i2c;

    DWORD_VAL press;
    WORD_VAL temp;
    char buf[2];

};

#endif /* LPS25H_H_ */


