/**----------------------------------------------------------------------------
 
   \file main.cpp
--                                                                           --
--              ECEN 5803 Mastering Embedded System Architecture             --
--                  Project 1 Module 4                                       --
--                Microcontroller Firmware                                   --
--                      main.cpp                                             --
--                                                                           --
-------------------------------------------------------------------------------
--
--  Designed for:  University of Colorado at Boulder
--               
--                
--  Designed by:  Tim Scherr
--  Revised by:  Student's name 
-- 
-- Version: 2.1
-- Date of current revision:  2017-09-25   
-- Target Microcontroller: Freescale MKL25ZVMT4 
-- Tools used:  ARM mbed compiler
--              ARM mbed SDK
--              Freescale FRDM-KL25Z Freedom Board
--               
-- 
-- Functional Description:  Main code file generated by mbed, and then
--                           modified to implement a super loop bare metal OS.
--
--      Copyright (c) 2015, 2016 Tim Scherr  All rights reserved.
--
*/

#define MAIN
#include "shared.h"
#undef MAIN

#define ADC_0                   (0U)
#define CHANNEL_0               (0U)
#define CHANNEL_1               (1U)
#define CHANNEL_2               (2U)
#define LED_ON                  (0U)
#define LED_OFF                 (1U)
#define ADCR_VDD                (65535U)    /*! Maximum value when use 16b resolution */
#define V_BG                    (1000U)     /*! BANDGAP voltage in mV (trim to 1.0V) */
#define V_TEMP25                (716U)      /*! Typical VTEMP25 in mV */
#define M                       (1620U)     /*! Typical slope: (mV x 1000)/oC */
#define STANDARD_TEMP           (25)

extern volatile uint16_t SwTimerIsrCounter; 

int os_cb_sections = 0;


Ticker tick;             //  Creates a timer interrupt using mbed methods
Timer main_loop;
Timer timer0_loop;
 /****************      ECEN 5803 add code as indicated   ***************/
                // Add code to control red, green and blue LEDs here - Control section added here(completed)
                
PinName const redLED = PTB18;  // pin number for red LED
PinName const greenLED = PTB19; // pin number for green LED
PinName const blueLED = PTD1; // pin number for blue LED
//Set LEDs to be off right now  
DigitalOut rled(redLED,1);
DigitalOut gled(greenLED,1);
DigitalOut bled(blueLED,1);
  
Serial pc(USBTX, USBRX);     
 
void flip()  
{                
    gled = !gled;
}

uint16_t temperature = 0; // value that will be external to all variable. stores the value of temperature
//uint16_t Vtemp; // value in mV of the temperature calculated
//uint16_t frequency; // value that will store the frequency detected. Need it to be availaible to all functions
//uint16_t flow; // value that will store the flow that is determine
//uint16_t ADC_vortex_frequency_input; // value of the ADC_vortex_frequency_input
//uint16_t Vrefl; // value of the ADC_vortex_frequency_input

 
int main() 
{
/****************      ECEN 5803 add code as indicated   ***************/
                    //  Add code to call timer0 function every 100 uS - Completed already
    tick.attach(&timer0, 0.0001); // setup ticker to call timer0 very 100 uS                                                    

    // already being done in the code below pc.printf("Hello World!\n"); 
    uint32_t  count = 0;  


    
// initialize serial buffer pointers
   rx_in_ptr =  rx_buf; /* pointer to the receive in data */
   rx_out_ptr = rx_buf; /* pointer to the receive out data*/
   tx_in_ptr =  tx_buf; /* pointer to the transmit in data*/
   tx_out_ptr = tx_buf; /* pointer to the transmit out */
    
   
  // Print the initial banner
    pc.printf("\r\nHello World!\n\n\r");

    /****************      ECEN 5803 add code as indicated   ***************/
    // uncomment this section after adding monitor code.   - completed
      
  
   UART_direct_msg_put("\r\nSystem Reset\r\nCode ver. ");
   UART_direct_msg_put( CODE_VERSION );
   UART_direct_msg_put("\r\n");
   UART_direct_msg_put( COPYRIGHT );
   UART_direct_msg_put("\r\n");

   set_display_mode();   
     
   
        //int i=0; // defined and declard i just for main loop duration in seconds
    //  float main_loop_start_time=0;
//      float main_loop_end_time=0;
        
        adc_calibration(); // calibration completed on ADC channel before reading from them
        
    while(1)       /// Cyclical Executive Loop
    {
            //for (;i < 2; i++) {
      //  main_loop.start(); // start of the cyclical executive loop   
        count++;               // counts the number of times through the loop
//      __enable_interrupts();
//      __clear_watchdog_timer();

   /****************      ECEN 5803 add code as indicated   ***************/
                //  readADC()
   read_ADC(CHANNEL_0); // read in the reference low voltage
     read_ADC(CHANNEL_1); // read in virtual vortext frequency input on J10_4
     read_ADC(CHANNEL_2); // read in temperature from internal temp sensor in Vtemp (mV)
   temperature = STANDARD_TEMP-(V_BG*((Vtemp - V_TEMP25)/M)); // calculate the temperature converted in degrees celcius
// calculate frequency
        frequency_detect();

//  calculate flow()
    calculateFlow();
            
        serial();            // Polls the serial port
        chk_UART_msg();     // checks for a serial port message received
        monitor();           // Sends serial port output messages depending
                         //     on commands received and display mode
            
 /****************      ECEN 5803 add code as indicated   ***************/



  PwmOutputs_flowmeter();  // use TMP0 channel 3  proporional rate to flow

  Pulse_Output_Frequency();  // use TMP0 channel 4  propotional rate to frequency

//  LCD_Display()   // use the SPI port to send flow number
   LCD_Display();


//  End ECEN 5803 code addition

        if ((SwTimerIsrCounter & 0x1FFF) > 0x0FFF)
        {
            flip();  // Blink GREEN LED
        }
                if (LED_timer_flag == 1){
                    
                    rled = !rled; // Blink RED LED with 1 second period
                    LED_timer_flag =0;
                }
    //       main_loop.stop(); // end of the cyclical executive loop
                
}

}
