/**----------------------------------------------------------------------------
 *
 *            \file frequency_detector.cpp
--                                                                           --
--              ECEN 5803 Mastering Embedded System Architecture             --
--                  Project 1 Module 4                                       --
--                Microcontroller Firmware                                   --
--                      frequency_detector.cpp                                           --
--                                                                           --
-------------------------------------------------------------------------------
--
--  Designed for:  University of Colorado at Boulder
--                
--                
--  Designed by:  Tim Scherr
--  Revised by:  Naved Maududi and Bryan Cisneros 
-- 
-- Version: 2.1
-- Date of current revision:  2017-09-25   
-- Target Microcontroller: Freescale MKL25ZVMT4 
-- Tools used:  ARM mbed compiler
--              ARM mbed SDK
--              Freescale FRDM-KL25Z Freedom Board
--               
--               
   Functional Description:  
   This file contains code that takes in quasi-sine wave ADC inputs from the flow meter
     From the ADC inputs, it calculates the frequency of that sine wave. The frequency is 
     important in determining the flow rate and velocity for the flowmeter that are outputed
     to the display. 
-- 
--      Copyright (c) 2015 Tim Scherr  All rights reserved.
*/


#include "shared.h" 
#include "MKL25Z4.h"
#define SPI_bit_length 16 // bit length for the spi port
#define SPI_mode 0 // clock is set to trigger at high and in phase



/**********************/

PinName const SPI_MOSI = PTC6;  // channel 0 (PTB0) to A/D pin VREFL
PinName const SPI_MISO = PTC7; // channel 1 (PTB1) to J10_4 a virtual vortex frequency input,
PinName const SPI_SCK = PTC5; // channel 2 (PTB2) to an actual internal TempSensor


void LCD_Display(void){
    
SPI LCD(SPI_MOSI, SPI_MISO, SPI_SCK);
LCD.lock(); // Acquire exclusive access to this SPI bus.
LCD.format(SPI_bit_length, SPI_mode); // select correct mode and bits to transfer to the LDC monitor
LCD.write(flow); // write the value of flow to slave device, which is the peripheral LCD display
LCD.write(freq_value); //    write the value of frequency to slave device, which is the peripheral LCD display
LCD.write(temperature); //  write the value of temperature to slave device, which is the peripheral LCD display
}


