/**----------------------------------------------------------------------------
             \file Monitor.cpp
--                                                                           --
--              ECEN 5003 Mastering Embedded System Architecture             --
--                  Project 1 Module 3                                       --
--                Microcontroller Firmware                                   --
--                      Monitor.cpp                                            --
--                                                                           --
-------------------------------------------------------------------------------
--
--  Designed for:  University of Colorado at Boulder
--               
--                
--  Designed by:  Tim Scherr
--  Revised by:  Student's name 
-- 
-- Version: 2.0
-- Date of current revision:  2016-09-29   
-- Target Microcontroller: Freescale MKL25ZVMT4 
-- Tools used:  ARM mbed compiler
--              ARM mbed SDK
--              Freescale FRDM-KL25Z Freedom Board
--               
-- 
   Functional Description: See below 
--
--      Copyright (c) 2015 Tim Scherr All rights reserved.
--
*/              

#include <stdio.h>
#include "shared.h"

/*******************************************************************************
* Set Display Mode Function
* Function determines the correct display mode.  The 3 display modes operate as 
*   follows:
*
*  NORMAL MODE       Outputs only mode and state information changes   
*                     and calculated outputs
*
*  QUIET MODE        No Outputs
*
*  DEBUG MODE        Outputs mode and state information, error counts,
*                    register displays, sensor states, and calculated output
*
*
* There is deliberate delay in switching between modes to allow the RS-232 cable 
* to be plugged into the header without causing problems. 
*******************************************************************************/


#define NUMBER_OF_REGISTERS (16)
#define NUM_ADDR_TO_PRINT (5)
#define MEMORY_STARTING_ADDR (0x200)

extern UCHAR error_count;


__asm uint32_t getregister(uint32_t x){
   
    CMP r0,#0;
    BEQ return_from_function_r0
    CMP r0,#1;
    BEQ return_from_function_r1
    CMP r0,#2;
    BEQ return_from_function_r2 
    CMP r0,#3;
    BEQ return_from_function_r3 
    CMP r0,#4;
    BEQ return_from_function_r4
    CMP r0,#5;
    BEQ return_from_function_r5
    CMP r0,#6;
    BEQ return_from_function_r6
    CMP r0,#7;
    BEQ return_from_function_r7
    CMP r0,#8;
    BEQ return_from_function_r8
    CMP r0,#9;
    BEQ return_from_function_r9 
    CMP r0,#10;
    BEQ return_from_function_r10
    CMP r0,#11;
    BEQ return_from_function_r11
    CMP r0,#12;
    BEQ return_from_function_r12
    CMP r0,#13;
    BEQ return_from_function_r13
    CMP r0,#14;
    BEQ return_from_function_r14
    CMP r0,#15;
    BEQ return_from_function_r15
    
return_from_function_r0
    MOV r0,r0 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r1
    MOV r0,r1 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r2
    MOV r0,r2 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r3
    MOV r0,r3 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r4
    MOV r0,r4 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r5
    MOV r0,r5 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r6
    MOV r0,r6 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r7
    MOV r0,r7 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r8
    MOV r0,r8 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r9
    MOV r0,r9 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r10
    MOV r0,r10 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r11
    MOV r0,r11 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r12
    MOV r0,r12 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r13
    MOV r0,r13 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r14
    MOV r0,r14 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
return_from_function_r15
    MOV r0,r15 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
}

__asm uint32_t getregister0(void){
      MOV r0,r0 ; store the return value in r0
    BLX  lr            ; Else return from subroutine with link and returning the value of register
    
}
void set_display_mode(void)   
{
  UART_direct_msg_put("\r\nSelect Mode");
  UART_direct_msg_put("\r\n Hit NOR - Normal");
  UART_direct_msg_put("\r\n Hit QUI - Quiet");
  UART_direct_msg_put("\r\n Hit DEB - Debug" );
  UART_direct_msg_put("\r\n Hit V - Version#\r\n");
  UART_direct_msg_put("\r\nSelect:  ");
  
}
//*****************************************************************************/
/// \fn void chk_UART_msg(void) 
///
//*****************************************************************************/
void chk_UART_msg(void)    
{
   UCHAR j;
   while( UART_input() )      // becomes true only when a byte has been received
   { //j = *rx_out_ptr++; 
         //*tx_out_ptr++ = j;
         //UART0->D  = *tx_out_ptr++;     /* send next char */
         // skip if no characters pending
      j = UART_get();                 // get next character
      //UART0->D = *tx_out_ptr++;     /* send next char */            // echo the character   

      if( j == '\r' )          // on a enter (return) key press
      {                // complete message (all messages end in carriage return)
         UART_msg_put("->");
         UART_msg_process();
      }
      else 
      {
         if ((j != 0x02) )         // if not ^B
         {                             // if not command, then   
            UART_put(j);              // echo the character, modified code for UART_put   
         }
         else
         {
          ;            
         }
         if( j == '\b' ) 
         {                             // backspace editor
            if( msg_buf_idx != 0) 
            {                       // if not 1st character then destructive 
               UART_msg_put(" \b");// backspace
               msg_buf_idx--;
            }
         }
         else if( msg_buf_idx >= MSG_BUF_SIZE )  
         {                                // check message length too large
            UART_msg_put("\r\nToo Long!");
            msg_buf_idx = 0;
         }
         else if ((display_mode == QUIET) && (msg_buf[0] != 0x02) && 
                  (msg_buf[0] != 'D') && (msg_buf[0] != 'N') && 
                  (msg_buf[0] != 'V') &&
                  (msg_buf_idx != 0))
         {                          // if first character is bad in Quiet mode
            msg_buf_idx = 0;        // then start over
         }
         else {                        // not complete message, store character
              
            msg_buf[msg_buf_idx] = j;
            msg_buf_idx++;
            if (msg_buf_idx > 2)
            {
               UART_msg_process();
            }
         }
      }
   }
}

//*****************************************************************************/
///  \fn void UART_msg_process(void) 
///UART Input Message Processing
//*****************************************************************************/
void UART_msg_process(void)
{
   UCHAR chr,err=0;
//   unsigned char  data;
    chr = msg_buf[0];



    switch( chr ) 
    {
         case 'D':
            if((msg_buf[1] == 'E') && (msg_buf[2] == 'B') && (msg_buf_idx == 3)) 
            {
               display_mode = DEBUG;
               UART_direct_msg_put("\r\nMode=DEBUG");
               UART_direct_msg_put("\n");
                            display_timer = 0;
            }
            else
               err = 1;
            break;

         case 'N':
            if((msg_buf[1] == 'O') && (msg_buf[2] == 'R') && (msg_buf_idx == 3)) 
            {
               display_mode = NORMAL;
               UART_msg_put("\r\nMode=NORMAL\n");
               //display_timer = 0;
            }
            else
               err = 1;
            break;

         case 'Q':
            if((msg_buf[1] == 'U') && (msg_buf[2] == 'I') && (msg_buf_idx == 3)) 
            {
               display_mode = QUIET;
               UART_msg_put("\r\nMode=QUIET\n");
               display_timer = 0;
            }
            else
               err = 1;
            break;

         case 'V':
            display_mode = VERSION;
            UART_msg_put("\r\n");
            UART_msg_put( CODE_VERSION ); 
            UART_msg_put("\r\nSelect  ");
            display_timer = 0;
            break;
                
         default:
            err = 1;
    }


   if( err == 1 )
   {
      UART_msg_put("\n\rError!");
   }   
   else if( err == 2 )
   {
      UART_msg_put("\n\rNot in DEBUG Mode!");
   }   
   else
   {
    msg_buf_idx = 0;          // put index to start of buffer for next message
      ;
   }
    msg_buf_idx = 0;          // put index to start of buffer for next message


}


//*****************************************************************************
///   \fn   is_hex
/// Function takes 
///  @param a single ASCII character and returns 
///  @return 1 if hex digit, 0 otherwise.
///    
//*****************************************************************************
UCHAR is_hex(UCHAR c)
{
   if( (((c |= 0x20) >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'f'))  )
      return 1;
   return 0;
}

/*******************************************************************************
*   \fn  DEBUG and DIAGNOSTIC Mode UART Operation
*******************************************************************************/

void monitor(void)
{
/**********************************/
/*     Spew outputs               */
/**********************************/

   switch(display_mode)
   {
      case(QUIET):
         {
             UART_msg_put("\r\n ");
             display_flag = 0;
         }  
         break;
      case(VERSION):
         {
             display_flag = 0;
         }  
         break;         
      case(NORMAL):
         {
            if (display_flag == 1)
            {                       // resets and sets continous receive enable bit
               UART_direct_msg_put("\r\nNORMAL ");
               UART_direct_msg_put(" Flow: ");
               // ECEN 5803 add code as indicated
               //  add flow data output here, use UART_hex_put or similar for 
               // numbers
               UART_direct_msg_put(" Temp: ");
               //  add flow data output here, use UART_hex_put or similar for 
               // numbers
               UART_direct_msg_put(" Freq: ");
               //  add flow data output here, use UART_hex_put or similar for 
               // numbers
               display_flag = 0;
            }
         }  
         break;
      case(DEBUG):
         {
            if (display_flag == 1)
            {
               UART_direct_msg_put("\r\nDEBUG ");
               UART_direct_msg_put(" Flow: ");
               // ECEN 5803 add code as indicated               
               //  add flow data output here, use UART_hex_put or similar for 
               // numbers
               UART_direct_msg_put(" Temp: ");
               //  add flow data output here, use UART_hex_put or similar for 
               // numbers
               UART_direct_msg_put(" Freq: ");
               //  add flow data output here, use UART_hex_put or similar for 
               // numbers
               
               
 /****************      ECEN 5803 add code as indicated   ***************/             
               //  Create a display of  error counts, sensor states, and
               //  ARM Registers R0-R15 - Completed displaying register, not error counts or sensor states
                            /**********************************/
              /*     Define varables to store registers*/
              /**********************************/
                            //Assembly language call to function to get ARM registers (R0-R15)
                
                uint32_t registers[NUMBER_OF_REGISTERS] = {};
                char c = '0';
                    
                UART_direct_msg_put("\r\nARM REGISTERS[R0-R15]:\r\n");
                
                for (uint8_t i = 0; i < NUMBER_OF_REGISTERS; i++)
                {
                    /* get register value */
                    if (i == 0)
                    {
                        registers[i] = getregister0();
                    } else
                    {
                        registers[i] = getregister(i);
                    }
                    
                    /* start printing */
                    UART_direct_msg_put("Register R");
                    
                    /* Print the register number using char c. If we're printing registers 10-15,
                       we will need to print a leading 1. */
                    if (i > 9)
                    {
                        UART_put('1');
                    }
                    UART_put(c);
                    
                    /* finish printing the message */
                    UART_direct_msg_put(": ");
                    UART_direct_hex_put_word(registers[i]);
                    UART_direct_msg_put("\r\n");
                    
                    /* increment c to display the next register number. If greater than 9, rollover to 0 */
                    c++;
                    if (c > '9')
                    {
                        c = '0';
                    }
                }
                
                /* display error count */
                UART_direct_msg_put("\r\nerror count: ");
                UART_hex_put(error_count);
                UART_direct_msg_put("\r\n\n");

                            
                /* Create a command to read a section of Memory and display it */
                uint32_t *memory_ptr = (uint32_t*)MEMORY_STARTING_ADDR; /* create a pointer to reference memory  */
                UART_direct_msg_put("Reading data from memory:\r\n");
                for (uint8_t i = 0; i < NUM_ADDR_TO_PRINT; i++)
                {
                    UART_direct_msg_put("Address: ");
                    UART_direct_hex_put_word((uint32_t)memory_ptr); /* print address */
                    UART_direct_msg_put("\tData: ");
                    UART_direct_hex_put_word(*memory_ptr); /* print data at address */
                    UART_direct_msg_put("\r\n");
                    memory_ptr++;
                }
                UART_direct_msg_put("\r\n");
                             
                            
               //  Create a command to read 16 words from the current stack 
               // and display it in reverse chronological order.
              
              
               // clear flag to ISR      
               display_flag = 0;
             }   
         }  
         break;

      default:
      {
         UART_msg_put("Mode Error");
      }  
   }
}