/*
Main file: encapsulates the glue that links USB-serial or TCP port to the SmartCardReader

Author: Calin Bira
Date: 28.02.2011
*/

#include "mbed.h"
#include "SmartCardReader.h"
#include <string.h>
#include "commons.h"
#include "TcpServer.h"

Serial computer(USBTX, USBRX); // tx, rx
Serial smartcard(p13, p14); // tx, rx
DigitalOut reset(p20);
DigitalOut vcc(p18);
PwmOut clk(p21);//clock line

TcpServer TCPS(10779);
#define SendToHost(x,y) \
    computer.printf(x,y);\
    TCPS.Tprintf(x,y)

SmartCardReader SCR(&smartcard, &vcc, &reset, &clk, "8E1");

static const int CommandBufferLen = 2*MAX_MSG_SIZE + 20;//two bytes per char, and extra 20 Bytes for other params
static const int AnswerBufferLen = 2*MAX_MSG_SIZE + 20;//two bytes per char, and extra 20 Bytes for other params
static char CommandBuffer[CommandBufferLen];
static int CommandBufferIndex;
static char AnswerBuffer[AnswerBufferLen];
static char tmp[MAX_MSG_SIZE];

#define CMD_ERR_INVALID_FORMAT  0x0001
#define CMD_ERR_OK              0x0000
#define CMD_ERR_RECEIVE_TIMEOUT 0x00CA

void DecodeCommand(char* cmd, int len)
{
    int errorCode = CMD_ERR_OK;
    char * pch;
    pch = strtok (cmd," ");
    
    if (len < 6)
    {
        errorCode = CMD_ERR_INVALID_FORMAT;
        SendToHost("ERR %04x\r\n",errorCode);
    }
    else if (strncmp(pch,"ISCR",4)==0)
    {
        SCR.cold_reset();
        SendToHost("ISCR %04X\r\n",errorCode);
    }
    else if (strncmp(pch,"ISWR",4)==0)
    {
        SCR.warm_reset();
        SendToHost("ISWR %04X\r\n",errorCode);
    }
    else if (strncmp(pch,"ISSB",4)==0)
    {
        pch = strtok (NULL, " ");//size
        if (pch == NULL) {errorCode = CMD_ERR_INVALID_FORMAT; SendToHost("ERR %04X\r\n",errorCode); return;}
        
        int len = atoi(pch);
        int len_copy = len;
        pch = strtok (NULL, " ");//the other chars
        if (pch == NULL) {errorCode = CMD_ERR_INVALID_FORMAT;SendToHost("ERR %04X\r\n",errorCode); return;}
        
        char *src = tmp;
        while (len > 0)
        {
            sscanf(pch, "%2x", src++);
            pch += 2;
            len--;
        }
        
        SCR.send(tmp,len_copy);
        SendToHost("ISSB %04X\r\n",errorCode);
    }
    else if (strncmp(pch,"ISRB",4)==0)
    {
        char *dest;
        char *src = tmp;
        pch = strtok (NULL, " ");
        int expectedLen = atoi(pch);
        int len = SCR.receive(tmp);
        if (expectedLen > len) errorCode = CMD_ERR_RECEIVE_TIMEOUT;
        
        sprintf(AnswerBuffer,"ISRB %04X %d ",errorCode,len);
        dest = AnswerBuffer + strlen(AnswerBuffer);
        while (len > 0)
        {
            sprintf(dest,"%02X",*src);
            src++;dest+=2;len--;
        }
        *dest++ = '\r';        
        *dest++ = '\n';
        *dest++ = '\0';
        
        SendToHost("%s",AnswerBuffer);
    }
    
    while (pch !=NULL)
    {
        pch = strtok (NULL, " ");
    }
}

void AssembleCommand(char *buf, int len)
{
    for (int i=0; i<len; i++)
    {
       if (CommandBufferIndex < CommandBufferLen)
       {
        CommandBuffer[CommandBufferIndex] = buf[i];
        if (CommandBuffer[CommandBufferIndex] == 10)
           {
                DecodeCommand(CommandBuffer, CommandBufferIndex);
                CommandBufferIndex = 0;
           }
           else CommandBufferIndex++;
       }
       else 
       {
            CommandBufferIndex = 0;
       }
       
    }
    
    
    
}


//TcpServer TCPS(10779);
int main() 
{
    char ch;
    SCR.cold_reset();
    TCPS.SetReceiveCallback(&AssembleCommand);
    CommandBufferIndex = 0;
    
    while(1) 
    {
        while (computer.readable()) //if there is data from pc
        {
            ch = computer.getc();
            AssembleCommand(&ch,1);
        }  
        
        SCR.doEvents();      
        TCPS.doEvents();
    } 
}
