/*
A Tcp server based on the :
// TCP Echo server
// 2010/9/7

Modified by Calin Bira
Date: 28.02.2011
*/




#include "mbed.h"
#include "TcpServer.h"
#include <stdarg.h>

//#define DEBUG

#ifdef DEBUG
    #define dprintf printf
#else 
    #define dprintf noprintf
#endif
    TcpServer::TcpServer(int port)
    {
        Setup(port);
    }
    
    void TcpServer::onConnectedTCPSocketEvent(TCPSocketEvent e)
    {
       switch(e)
        {
        case TCPSOCKET_CONNECTED:
            dprintf("TCP Socket Connected\r\n");
            break;
        case TCPSOCKET_WRITEABLE:
          //Can now write some data...
            dprintf("TCP Socket Writable\r\n");
            break;
        case TCPSOCKET_READABLE:
          //Can now read dome data...
            dprintf("TCP Socket Readable\r\n");
           // Read in any available data into the buffer
           
           while ( int len = pConnectedSock->recv(buff, 256) ) 
           {
               onReceive(buff,len);
               //pConnectedSock->send(buff, len);
               //buff[len]=0; // make terminater
               //dprintf("Received&Wrote:%s\r\n",buff);
           }
           break;
        case TCPSOCKET_CONTIMEOUT:
            dprintf("TCP Socket Timeout\r\n");
            break;
        case TCPSOCKET_CONRST:
            dprintf("TCP Socket CONRST\r\n");
            break;
        case TCPSOCKET_CONABRT:
            dprintf("TCP Socket CONABRT\r\n");
            break;
        case TCPSOCKET_ERROR:
            dprintf("TCP Socket Error\r\n");
            break;
        case TCPSOCKET_DISCONNECTED:
        //Close socket...
            dprintf("TCP Socket Disconnected\r\n");        
            pConnectedSock->close();
            break;
        default:
            dprintf("DEFAULT\r\n"); 
          }
    }
    
    
    void TcpServer::onListeningTCPSocketEvent(TCPSocketEvent e)
    {
        switch(e)
        {
        case TCPSOCKET_ACCEPT:
        {
            dprintf("Listening: TCP Socket Accepted\r\n");
            // Accepts connection from client and gets connected socket.   
            err=ListeningSock.accept(&client, &pConnectedSock);
            if (err) {
                dprintf("onListeningTcpSocketEvent : Could not accept connection.\r\n");
                return; //Error in accept, discard connection
            }
            // Setup the new socket events
            pConnectedSock->setOnEvent(this, &TcpServer::onConnectedTCPSocketEvent);
            // We can find out from where the connection is coming by looking at the
            // Host parameter of the accept() method
            IpAddr clientIp = client.getIp();
            dprintf("Listening: Incoming TCP connection from %d.%d.%d.%d\r\n", 
               clientIp[0], clientIp[1], clientIp[2], clientIp[3]);
           break;
        }
        // the following cases will not happen
        case TCPSOCKET_CONNECTED:
            dprintf("Listening: TCP Socket Connected\r\n");
            break;
        case TCPSOCKET_WRITEABLE:
            dprintf("Listening: TCP Socket Writable\r\n");
            break;
        case TCPSOCKET_READABLE:
            dprintf("Listening: TCP Socket Readable\r\n");
            break;
        case TCPSOCKET_CONTIMEOUT:
            dprintf("Listening: TCP Socket Timeout\r\n");
            break;
        case TCPSOCKET_CONRST:
            dprintf("Listening: TCP Socket CONRST\r\n");
            break;
        case TCPSOCKET_CONABRT:
            dprintf("Listening: TCP Socket CONABRT\r\n");
            break;
        case TCPSOCKET_ERROR:
            dprintf("Listening: TCP Socket Error\r\n");
            break;
        case TCPSOCKET_DISCONNECTED:
        //Close socket...
            dprintf("Listening: TCP Socket Disconnected\r\n");        
            ListeningSock.close();
            break;
        default:
            dprintf("DEFAULT\r\n"); 
         };
    }
    
    int TcpServer::Setup(int port) {
      dprintf("\r\n");
      dprintf("Setting up...\r\n");
      EthernetErr ethErr = eth.setup();
      if(ethErr)
      {
        dprintf("Error %d in setup.\r\n", ethErr);
        return -1;
      }
      dprintf("Setup OK\r\n");
    
      IpAddr ip = eth.getIp();
      dprintf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);
    
      
      // Set the callbacks for Listening
      ListeningSock.setOnEvent(this,&TcpServer::onListeningTCPSocketEvent); 
      
      // bind and listen on TCP
      err=ListeningSock.bind(Host(IpAddr(), port));
      dprintf("Binding..\r\n");
      if(err)
      {
       //Deal with that error...
        dprintf("Binding Error\n");
      }
       err=ListeningSock.listen(); // Starts listening
       dprintf("Listening...\r\n");
       if(err)
       {
        dprintf("Listening Error\r\n");
       }
       return 0;
    }
    
    void TcpServer::doEvents()
    {
        Net::poll();
    }
    
     void TcpServer::SetReceiveCallback(void (*f)(char*buf, int len))
    {
        onReceive = f;
    }
    
    
    void TcpServer::Tprintf(const char * format, ...)
    {
     	va_list ap;
        va_start(ap, format);
        vsprintf(buff, format, ap);
        va_end(ap);
    
        pConnectedSock->send(buff, strlen(buff));
    }
    
     void TcpServer::noprintf(const char * format, ...)
    {
     
    }

