/*
This file encapsulates logic for SmartCard Reader

Author: Calin Bira
Date: 28.02.2011
*/

#include "SmartCardReader.h"

SmartCardReader::SmartCardReader(Serial *_dut, DigitalOut *_vcc, DigitalOut *_rst,PwmOut *_clock, char *_format)
    {
        int databits,stopbits;
        Serial::Parity parity;
        
        freq = 1000*1000;
        divfact = 372;
                
        dut = _dut;
        rst = _rst;
        vcc = _vcc;
        clk = _clock;
        
        BytesToIgnore = 0;
        ReceiveBufferIndex = 0;
                
        databits = _format[0] - '0';
        switch (_format[1])
        {
            case 'E': {parity = Serial::Even; break;}
            case 'O': {parity = Serial::Odd; break;}
            default: {parity = Serial::None; break;}
        }
        
        stopbits = _format[2] - '0';
        dut->format(databits,parity,stopbits);
        
        setClock(freq);
        clk->write(0.5);// 50% duty cycle
        
        
    }
    
void SmartCardReader::setClock(int Hz)
    {
        freq = Hz;
        clk->period_us(1000*1000/freq);
        dut->baud(freq/divfact);
    }

void SmartCardReader::cold_reset()
    {
        *vcc = 0;
        *rst = 0;
        wait(0.1);
        *vcc = 1;
        wait(0.1);
        
        while (dut->readable())
            dut->getc();
        *rst = 1;
    }
    
void SmartCardReader::warm_reset()
    {
        *rst = 0;
        wait(0.1);
        *rst = 1;
    }

/*    
void SmartCardReader::Relay_PC_SC()
        {
            static char ignore=0;
            
            while (dut->readable()) //if there is data from smartcard
            {
                if (ignore>0)
                {
                    dut->getc();//ignore data: this is data from pc
                    ignore--;
                }
                else pc->putc(dut->getc());//send to pc
            }
            
            while (pc->readable()) //if there is data from pc
            {
                ignore++;
                dut->putc(pc->getc());  //send data to smartcard
            }    
        }
*/
void SmartCardReader::send(char *buf, int len)
{
    while(len-- >0)
    {
        BytesToIgnore++;
        dut->putc(*buf++);
    }
}

int SmartCardReader::receive(char *buf)
{
    int OldIndex = ReceiveBufferIndex;
    for (int i=0; i < ReceiveBufferIndex; i++)
    {
        buf[i] =  ReceiveBuffer[i];
    }
    ReceiveBufferIndex = 0;
    return OldIndex;
}

void SmartCardReader::doEvents()
    {
        //Relay_PC_SC();
          
            while (dut->readable()) //if there is data from smartcard
            {
                if (BytesToIgnore > 0)
                {
                    dut->getc();//ignore data: this is data from previous send
                    BytesToIgnore--;
                }
                else 
                {
                    if (ReceiveBufferIndex < ReceiveBufferLen)
                        ReceiveBuffer[ReceiveBufferIndex++] = dut->getc();
                    else dut->getc();//discard data, no space in buffer
                }
            }  
    }
