#include "mbed.h"
#include "stm32f103c8t6.h"
#include <string>
#include "stdio.h"
#include "stdlib.h"
#include "rtos.h"

#define MAX_LENGTH_STEPS 55
#define MIN_LENGTH_STEPS 10
#define MOVING_UP 1
#define MOVING_DOWN 2
#define MOVING_FORWARD 1
#define MOVING_BACKWARD 2
#define STOP 0
#define DEBOUNCE 4   /*4*20ms*/

DigitalOut MOTOA1(PB_4);
DigitalOut MOTOB1(PB_5);

DigitalOut MOTOA2(PB_8);
DigitalOut MOTOB2(PB_9);

AnalogIn SensorCurrent(PA_0);

void motor1_move(uint8_t dir);
void motor2_move(uint8_t dir);

uint8_t sensor_cnt,cal_cnt, cur_cnt, tar_cnt, pre_sensor_cnt;
float sense_value;
uint8_t ov_flag, init_flag;
uint8_t open_flag,close_flag;

#if 1 /*WIFI related*/
DigitalOut led1(PC_13);
Serial debug_uart(PB_10, PB_11, 115200);
Serial wifi_uart(PA_2, PA_3, 115200);
Timer timer;  /*used by led0_thread*/
string a(""); /*reserved*/
string b(""); /*used by led0_thread*/
char  g_isCloud = 0;   //flag for connected xiaomi cloud
#endif

Timer timer_m;
int flag = 0;

void Power_thread(void const *argument){/*detect current*/
  char i = 0;
  while(true){
    Thread::wait(200); /*unit millisec*/
    sense_value = SensorCurrent.read();
        //debug_uart.printf("dfdfdfdfddfdf\r\n");
    if(sense_value>0.5){
      debug_uart.printf("Power_thread: sense_value = %0.4f > 0.5 \r\n", sense_value);
      i++;
      if(i>1){
        ov_flag = 1;  
      }
    }else{
        i = 0;
    }    
  }
}

char CheckStopper(int ch){
    DigitalIn Stopper1(PA_13);
    DigitalIn Stopper2(PA_15);
    timer_m.reset();    
    char i = 0;
    while(ch == MOVING_UP){
        if(!Stopper1){i++;};
        if(i>DEBOUNCE){break;}
        if(timer_m.read_ms()>5000){return 1;}
        wait_ms(20);
    }
    while(ch == MOVING_DOWN){
        if(!Stopper2){i++;};
        if(i>DEBOUNCE){break;}
        if(timer_m.read_ms()>5000){return 1;}
        wait_ms(20);
    }
    return 0;
}

void Motor_thread(void const *argument){
  while(true){
    Thread::wait(200); /*unit millisec*/
        if(!init_flag){
      wait(1);
      debug_uart.printf("Motor_thread: motor2 move up\r\n");   
      motor2_move(MOVING_UP);
            if(CheckStopper(MOVING_UP)){
                debug_uart.printf("Motor_thread: motor2 timeout, stop motor2 and finish the calibration\r\n");
                init_flag = 1;
                motor2_move(STOP);
                continue;
            }
            motor2_move(STOP); 
            wait(1);
            debug_uart.printf("Motor_thread: motor1 move forward\r\n"); 
            sensor_cnt = 0;         
      motor1_move(MOVING_FORWARD);
      while(1){   
                if(ov_flag){
                    motor1_move(STOP);
                    cal_cnt = sensor_cnt;
                    ov_flag = 0;
                    break;
                }
      }     
      wait(1);
            debug_uart.printf("Motor_thread: motor2 move down\r\n");  
      motor2_move(MOVING_DOWN);
            if(CheckStopper(MOVING_DOWN)){
                debug_uart.printf("Motor_thread: motor2 timeout, stop motor2 and finish the calibration\r\n");
                init_flag = 1;
                motor2_move(STOP);
                continue;
            }
      motor2_move(STOP);
            wait(1);
            debug_uart.printf("Motor_thread: motor1 move backward\r\n");  
            sensor_cnt = 0;
      motor1_move(MOVING_BACKWARD);
      while(1){   
                if(ov_flag){
                    motor1_move(STOP);
                    ov_flag = 0;
                    debug_uart.printf("Motor_thread: cal_cnt = %d, 1/2(cal_cnt+sensor_cnt)\r\n", (cal_cnt+sensor_cnt)/2); 
                    break;
                }
                if(sensor_cnt>=cal_cnt){
                    motor1_move(STOP);
                    debug_uart.printf("Motor_thread: cal_cnt = %d\r\n", cal_cnt);  
                    break;
                }
      }
            cur_cnt = 0;            
      wait(1);
      debug_uart.printf("Motor_thread: motor2 move to center\r\n"); 
      motor2_move(MOVING_UP);
      wait(1.6);
      motor2_move(STOP);
            init_flag = 1;
            debug_uart.printf("Motor_thread: auto-curtain length was calibrated sucessfully\r\n");          
    }else{
            debug_uart.printf("Motor_thread: auto-curtain is waiting for command\r\n"); 
            wait(3);            
        }    
  }
}

void led0_thread(void const *argument) {
    int err;
    char rxBuf[32];
    char wifi_rxBuf[32];
    char i; 
    int position;
    char dat[2];

    while (1) {
        wifi_uart.printf("get_down\r");
        timer.reset();  
        b.clear();
        while(timer.read_ms()<5000){
            if(wifi_uart.readable()){
                char ch = wifi_uart.getc();
                if(ch!=0x0d){
                    b += ch;
                }else{
                    debug_uart.printf("get string: %s \r\n", b.c_str());
                    #if 1
                    if(!strncmp(b.c_str(),"down none",9))
                    {
                        //debug_uart.printf("--- none\r\n");
                    }
                    if(!(strncmp(b.c_str(),"down set_properties",19)))  
                    {
                        //debug_uart.printf("--- set_properties\r\n");
                        b.erase(0,b.length()-3);
                        position = atoi(b.c_str());
                        debug_uart.printf("position = %d\r\n",position);
                        wifi_uart.printf("result 2 7 0\r\n");
                        b.clear();
                        continue;
                    }       
                    if(!(strncmp(b.c_str(),"down get_properties",19)))  
                    {
                        //debug_uart.printf("--- get_properties\r\n");
                        wifi_uart.printf("result 2 4 0 10 2 6 0 %d 2 7 30\r\n", position);
                        b.clear();
                        continue;
                    }               
                    if(!strncmp(b.c_str(),"down MIIO_net_change",20))
                    {
                        if((!strncmp(b.c_str()+21, "offline", 7)))
                        {
                            //debug_uart.printf("offline\r\n");
                        }
                        if((!strncmp(b.c_str()+21, "local", 5)))
                        {
                            //debug_uart.printf("local\r\n");
                        }
                        if((!strncmp(b.c_str()+21, "cloud", 5)))
                        {
                            //debug_uart.printf("cloud\r\n");
                        }
                    }
                    #endif                                      
                    break;
                }
            }
        }
        while(wifi_uart.readable()){wifi_uart.getc();}  
        wait_ms(400);
    }
}

void serialprocess(void const *argument){
    while(1){
        if(debug_uart.readable()){
            char ch = debug_uart.getc();
            if(ch!=0x0d){
                a += ch;
            }else{
                debug_uart.printf("get command from uart: '%s'\r\n", a.c_str());
                if(!strncmp(a.c_str(),"stp1",4)){
                    debug_uart.printf("stepper1 ready\r\n");
                }
                if(!strncmp(a.c_str(),"stp2",4)){
                    debug_uart.printf("stepper2 ready\r\n");
                }
                if(!strncmp(a.c_str(),"ovflag",6)){
                    debug_uart.printf("ovflag = 1\r\n");
                }
                a.clear(); 
            }
        }
    }
}

void serialIRQ(void){
    debug_uart.putc(debug_uart.getc());
}

void sensor_capture_cb(void){
  sensor_cnt++;
  if(open_flag){
        if(cur_cnt<tar_cnt){
            cur_cnt++;  
        }    
  }
  if(close_flag){
    if(cur_cnt>0){
      cur_cnt--;  
    }
  }
}

void motor1_move(uint8_t dir){/*main motor*/
  if(dir==1){/*forward*/
    MOTOA1 = 0;
    MOTOB1 = 1;
  }else if(dir==2){/*backward*/
    MOTOA1 = 1;
    MOTOB1 = 0;
  }else{ /*stop*/
    MOTOA1 = 0;
    MOTOB1 = 0;
  }
}

void motor2_move(uint8_t dir){/*assistant motor*/
  if(dir==1){/*up*/
    MOTOA2 = 0;
    MOTOB2 = 1;
  }else if(dir==2){/*down*/
    MOTOA2 = 1;
    MOTOB2 = 0;
  }else{ /*stop*/
    MOTOA2 = 0;
    MOTOB2 = 0;
  }
}


void system_init(){
  MOTOA1 = 0;
  MOTOB1 = 0;
  MOTOA2 = 0;
  MOTOB2 = 0;
  init_flag = 0; 
  cur_cnt = 0;
  cal_cnt = 0; 
  sense_value = 0;
    debug_uart.printf("\r\n");
  debug_uart.printf("************************************************\r\n");
  debug_uart.printf("******************LAIWU TECH********************\r\n");  
  debug_uart.printf("************************************************\r\n");
  debug_uart.printf("****system init done, wait 3 seconds to start***\r\n");
  wait(3);
}

int main() {

        system_init();

    led1 = 1; 
    flag = 0;
        
    wait(3);
        
        InterruptIn Hall1(PA_14);
        Hall1.fall(callback(sensor_capture_cb)); // Attach ISR to handle button press event
        
        debug_uart.printf("************************************************\r\n");
        debug_uart.printf("***************hall sensor init*****************\r\n");


    //Thread thread2(Power_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE); /*check the real-time current*/
        debug_uart.printf("**********************2*************************\r\n");
        //Thread thread3(Motor_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE); /*check the real-time current*/     
        debug_uart.printf("**********************3*************************\r\n");
        Thread thread1(led0_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE); /*check the wifi connection*/
        debug_uart.printf("**********************1*************************\r\n");
        
        debug_uart.printf("**************three threads init****************\r\n");
        
    timer.start();      
        timer_m.start();
        
        debug_uart.printf("************************************************\r\n");
        debug_uart.printf("****************two timer init*****************\r\n");
        
        debug_uart.attach(&serialIRQ, Serial::RxIrq);

    while(1)
    {
       wait(1);
             //wifi_uart.printf("get_down\r");
      //debug_uart.printf("************************************************\r\n");
            //debug_uart.printf("********************%%%%%***********************\r\n");
    }
}