#include "eeprom.h"
#include "main.h"

void readID(int addy){
  char ucdata_write[1];
  char ucdata_read[1];
  ucdata_write[0] = addy; //MCP24AA02_DID, Address here for Device ID
  while (i2c.write((MCP24AA02_ADDR|WRITE), ucdata_write, 1, 0)){;}//Wait for ACK if EEPROM is in 'write' cycle
  i2c.read((MCP24AA02_ADDR|READ),ucdata_read,1,0);
  if(ucdata_read[0]==0x29){
    debug_uart.printf("Code=%#x (Microchip Technology ltd.(c))\r\n",ucdata_read[0]);
  }
  if(ucdata_read[0]==0x41){
    debug_uart.printf("Code=%#x (2K EEPROM Using i2c)\r\n",ucdata_read[0]);
  }else{
    debug_uart.printf("Unknown eeprom device %x\r\n", ucdata_read[0]);
  }   
}

void readEE(int addy){
  char ucdata_write[1];
  char ucdata_read[1];
  ucdata_write[0] = addy; //Address here to read
  while (i2c.write((MCP24AA02_ADDR|WRITE), ucdata_write, 1, 0)){} //Wait for ACK if EEPROM is in 'write' cycle
  i2c.read((MCP24AA02_ADDR|READ),ucdata_read,1,0); //Note 'OR' Address with Read bit
  debug_uart.printf("%c",ucdata_read[0]);
}

void writeEE(int addy,int data){
  char ucdata_write[2];
  ucdata_write[0] = addy;
  ucdata_write[1] = data;
  while (i2c.write((MCP24AA02_ADDR|WRITE), ucdata_write, 1, 0)){} //Wait for ACK if EEPROM is in 'write' cycle
  i2c.write((MCP24AA02_ADDR|WRITE),ucdata_write,2,0); //Note 'OR' Adress with Write bit
  debug_uart.printf("%04d %c\t",addy,data);
}

void eraseEE(void){
  for (int i=0;i<0xFA;i++){ //0xFA to 0xFF are read only with Manufacture/Hardware ID and a Unique Serial Number
    writeEE(i,0xFF);
  }
}