#include "main.h"

void ST7789V_CTRL_Write(unsigned char data)
{
    lcdBus.write(data);
}

void ST7789V_writeCommand(unsigned char command)
{
    TFTCS=0; 
    TFTDC = 0;
    ST7789V_CTRL_Write(command);
    TFTWR = 0;
    TFTWR = 1;
    TFTCS=1; 
}

void ST7789V_writeData(unsigned char data)
{
    TFTCS=0; 
    TFTDC = 1;
    ST7789V_CTRL_Write(data);
    TFTWR = 0;
    TFTWR = 1;
    TFTCS=1; 
}

void ST7789V_writeOneDot(unsigned int color)
{ 
    TFTCS=0;  
    TFTRD=1;
    TFTDC=1;   

    ST7789V_CTRL_Write(color>>8); 
    TFTWR=0;
    TFTWR=1;

    ST7789V_CTRL_Write(color);      
    TFTWR=0;
    TFTWR=1;
        
    TFTCS=1;
}

void ST7789V_Init(void)
{
    TFTDC = 0;
    TFTRD = 1;
    TFTWR = 0;
    
#if 0
    TFTRST = 0; // reset the chip[]
    wait_us(100);
    TFTRST = 1; // take it out of reset
#endif

    wait_us(100);
    ST7789V_writeCommand(0x11);    /* exit SLEEP mode*/
    wait_us(300);  
    ST7789V_writeCommand(0x36);
    ST7789V_writeData(0x00);      /* MADCTL: memory data access control*/
    ST7789V_writeCommand(0x3A);
    ST7789V_writeData(0x05);      /* COLMOD: Interface Pixel format*/
    ST7789V_writeCommand(0xB2);
    ST7789V_writeData(0x0C);
    ST7789V_writeData(0x0C);
    ST7789V_writeData(0x00);
    ST7789V_writeData(0x33);
    ST7789V_writeData(0x33); /*PORCTRK: Porch setting*/
    ST7789V_writeCommand(0xB7);
    ST7789V_writeData(0x75); /*GCTRL: Gate Control*/
    ST7789V_writeCommand(0xBB);
    ST7789V_writeData(0x3d); /*VCOMS: VCOM setting*/
    //ST7789V_writeCommand(0xC0);
    //ST7789V_writeData(0x2C); /*LCMCTRL: LCM Control*/
    ST7789V_writeCommand(0xC2);
    ST7789V_writeData(0x01);
    //ST7789V_writeData(0xFF); /*VDVVRHEN: VDV and VRH Command Enable*/
    ST7789V_writeCommand(0xC3);
    ST7789V_writeData(0x19); /*VRHS: VRH Set*/
    ST7789V_writeCommand(0xC4);
    ST7789V_writeData(0x20); /*VDVS: VDV Set*/
    ST7789V_writeCommand(0xC6);
    ST7789V_writeData(0x0F); /*FRCTRL2: Frame Rate control in normal mode*/
    ST7789V_writeCommand(0xD0);
    ST7789V_writeData(0xA4);
    ST7789V_writeData(0xA1); /*PWCTRL1: Power Control 1*/
    ST7789V_writeCommand(0xD6);
    ST7789V_writeData(0xA1);
    ST7789V_writeCommand(0xE0);
    ST7789V_writeData(0x70);
    ST7789V_writeData(0x04);
    ST7789V_writeData(0x08);
    ST7789V_writeData(0x09);
    ST7789V_writeData(0x09);
    ST7789V_writeData(0x05);
    ST7789V_writeData(0x2A);
    ST7789V_writeData(0x33);
    ST7789V_writeData(0x41);
    ST7789V_writeData(0x07);
    ST7789V_writeData(0x13);
    ST7789V_writeData(0x13);
    ST7789V_writeData(0x29);
    ST7789V_writeData(0x0F); /*PVGAMCTRL: Positive Voltage Gamma control*/
    ST7789V_writeCommand(0xE1);
    ST7789V_writeData(0x70);
    ST7789V_writeData(0x03);
    ST7789V_writeData(0x09);
    ST7789V_writeData(0x0A);
    ST7789V_writeData(0x09);
    ST7789V_writeData(0x06);
    ST7789V_writeData(0x2B);
    ST7789V_writeData(0x34);
    ST7789V_writeData(0x41);
    ST7789V_writeData(0x07);
    ST7789V_writeData(0x12);
    ST7789V_writeData(0x14);
    ST7789V_writeData(0x28);
    ST7789V_writeData(0x2E); /*NVGAMCTRL: Negative Voltage Gamma control*/
    ST7789V_writeCommand(0x21);
    ST7789V_writeCommand(0x29);
    ST7789V_writeCommand(0x2A);
    ST7789V_writeData(0x00);
    ST7789V_writeData(0x00);
    ST7789V_writeData(0x00);
    ST7789V_writeData(0xEF); /*X address set*/
    ST7789V_writeCommand(0x2B);
    ST7789V_writeData(0x00);
    ST7789V_writeData(0x00);
    ST7789V_writeData(0x00);
    ST7789V_writeData(0xEF); /*Y address set*/
    ST7789V_writeCommand(0x2C);
    //wait_us(10);
    //ST7789V_writeCommand(0x29); /*Enable Display*/
}

void BlockWrite(unsigned int Xstart,unsigned int Xend,unsigned int Ystart,unsigned int Yend)
{
    ST7789V_writeCommand(0x2a);   
    ST7789V_writeData((Xstart)>>8);
    ST7789V_writeData((Xstart)&0xff);
    
    ST7789V_writeData((Xend)>>8);
    ST7789V_writeData((Xend)&0xff);
    
    ST7789V_writeCommand(0x2b);   
    ST7789V_writeData((Ystart+40)>>8);
    
    ST7789V_writeData((Ystart+40)&0xff);
    ST7789V_writeData((Yend+40)>>8);
    
    ST7789V_writeData((Yend+40)&0xff);
    ST7789V_writeCommand(0x2c);
}

unsigned char ToOrd(unsigned char ch)
{
    if(ch<32)
    {
        ch=95;
    }
    else if((ch>=32)&&(ch<=47)) //(32~47)空格~/
    {
        ch=(ch-32)+10+62;
    }
    else if((ch>=48)&&(ch<=57))//(48~57)0~9
    {
        ch=ch-48;
    }
    else if((ch>=58)&&(ch<=64))//(58~64):~@
    {
        ch=(ch-58)+10+62+16;
    }
    else if((ch>=65)&&(ch<=126))//(65~126)A~~
    {
        ch=(ch-65)+10;
    }
    else if(ch>126)
    {       
        ch=95;
    }

    return ch;
}

void WriteOneDot(unsigned int color)
{ 
    ST7789V_writeOneDot(color);
}

void  DispOneChar(unsigned char ord,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor)   // ord:0~95
{                                                     
   unsigned char i,j;
   unsigned char  *p;
   unsigned char dat;
   unsigned int index;

   BlockWrite(Xstart,Xstart+(FONT_W-1),Ystart,Ystart+(FONT_H-1));

   index = ord;

   if(index>95)    //95:ASCII CHAR NUM
        index=95;

   index = index*((FONT_W/8)*FONT_H);    

   p = ascii;
   p = p+index;

   for(i=0;i<(FONT_W/8*FONT_H);i++)
    {
       dat=*p++;
       for(j=0;j<8;j++)
        {
           if((dat<<j)&0x80)
             {
                WriteOneDot(TextColor);
             }      
           else 
             {
                WriteOneDot(BackColor);   
             }
         }
     }
}

void DispStr(unsigned char *str,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor)
{

    while(!(*str=='\0'))
    {
        DispOneChar(ToOrd(*str++),Xstart,Ystart,TextColor,BackColor);

        if(Xstart>((COL-1)-FONT_W))
        {
            Xstart=0;
            Ystart=Ystart+FONT_H;
        }
        else
        {
            Xstart=Xstart+FONT_W;
        }

        if(Ystart>((ROW-1)-FONT_H))
        {
            Ystart=0;
        }
    }   
    BlockWrite(0,COL-1,0,ROW-1);
}

void DispInt(unsigned int i,unsigned int Xstart,unsigned int Ystart,unsigned int TextColor,unsigned int BackColor)
{
    if(Xstart>((COL-1)-FONT_W*4))
    {
        Xstart=(COL-1)-FONT_W*4;
    }
    if(Ystart>((ROW-1)-FONT_H))
    {
        Ystart=(Ystart-1)-FONT_H;
    }
            
    DispOneChar((i>>12)%16,Xstart,Ystart,TextColor,BackColor); //ID value
    DispOneChar((i>>8)%16,Xstart+FONT_W,Ystart,TextColor,BackColor);
    DispOneChar((i>>4)%16,Xstart+FONT_W*2,Ystart,TextColor,BackColor);
    DispOneChar(i%16,Xstart+FONT_W*3,Ystart,TextColor,BackColor); 

    BlockWrite(0,COL-1,0,ROW-1);
}

void DispColor(unsigned int color)
{
    unsigned int i,j;

    BlockWrite(0,COL-1,0,ROW-1);

    TFTCS=0; 
    TFTDC=1;
    TFTRD=1;

    for(i=0;i<ROW;i++)
    {
      for(j=0;j<COL;j++)
        {    
            WriteOneDot(color);  
        }
    }

    TFTCS=1; 
}

void DispBand(void)  
{
    unsigned int i,j,k;
    //unsigned int color[8]={0x001f,0x07e0,0xf800,0x07ff,0xf81f,0xffe0,0x0000,0xffff};
    unsigned int color[8]={0xf800,0xf800,0x07e0,0x07e0,0x001f,0x001f,0xffff,0xffff};//0x94B2
    //unsigned int gray16[]={0x0000,0x1082,0x2104,0x3186,0x42,0x08,0x528a,0x630c,0x738e,0x7bcf,0x9492,0xa514,0xb596,0xc618,0xd69a,0xe71c,0xffff};

  BlockWrite(0,COL-1,0,ROW-1);
        
    TFTCS=0;
    TFTRD=1;
    TFTDC=1;                                                                                                      

    for(i=0;i<8;i++)
    {
        for(j=0;j<ROW/8;j++)
        {
        for(k=0;k<COL;k++)
            {
                WriteOneDot(color[i]); 
            } 
        }
    }
    for(j=0;j<ROW%8;j++)
    {
        for(k=0;k<COL;k++)
        {
            WriteOneDot(color[7]); 
        } 
    }
    
    TFTCS=1;
}

void DispPic(unsigned int *picture)
{
    unsigned int *p;
    unsigned int  i,j; //i-row,j-col
    unsigned char n,k; //n-row repeat count,k-col repeat count

    BlockWrite(0,COL-1,0,ROW-1);

    TFTCS =0;
    TFTDC =1;
    TFTRD =1;

    for(n=0;n<ROW/PIC_HEIGHT;n++)         //n-row repeat count
    {
        for(i=0;i<PIC_HEIGHT;i++)
        {
            p=picture;
            for(k=0;k<COL/PIC_WIDTH;k++) //k-col repeat count
            {
                for(j=0;j<PIC_WIDTH;j++)
                {
                        WriteOneDot(*(p+i*PIC_HEIGHT+j));
                }
            }

            p=picture;
            for(j=0;j<COL%PIC_WIDTH;j++)
            {
                WriteOneDot(*(p+i*PIC_HEIGHT+j));
            }
        }
    }

    for(i=0;i<ROW%PIC_HEIGHT;i++)
    {
        p=picture;
        for(k=0;k<COL/PIC_WIDTH;k++) //k-col repeat count
        {
            for(j=0;j<PIC_WIDTH;j++)
            {
                WriteOneDot(*(p+i*PIC_HEIGHT+j));
            }
        }

        p=picture;
        for(j=0;j<COL%PIC_WIDTH;j++)
        {
            WriteOneDot(*(p+i*PIC_HEIGHT+j));
        }
    }
  TFTCS=1;
}

void LCD_block_test(){
  BlockWrite(0,COL-1,0,ROW-1);
  DispColor(GREEN);
  wait(2);
  DispColor(BLUE);
  wait(2);
  DispColor(RED); 
  wait(2);
}



