/***********************************************************
Author: Bernard Borredon
Date : 24 decembre 2015
Version: 1.0
  - creation.
************************************************************/

#include "Led.h"

// Class LedBase

/*    LedBase(PinName pin)
 * Class constructor : create and initialize LedBase instance
 * @param pin : name of the pin connected to the led (PinName)
 * @returns none
 */
LedBase::LedBase(PinName pin) : _pin(pin) 
{
  
  // Led is off
  _pin = 0;
  _isOn = 0;
}

/*    void toggle(void)
 * Toggle led 
 * @param none
 * @returns none
 */
void LedBase::toggle(void)
{
  _isOn = !_isOn;
  _pin = !_pin;
}

/*    void on(void)
 * Light on led
 * @param none
 * @returns none
 */
void LedBase::on(void)
{
  if(!_isOn) {
    _isOn = true;
    _pin = 1;
  }
}

/*    void off(void)
 * Light off led
 * @param none
 * @returns none
 */
void LedBase::off(void)
{
  _isOn = false;
  _pin = 0;
}

/*    bool LedBase::isOn(void)
 * Get led status (on or off)
 * @param none
 * @returns led status (bool)
 *      false : led is off
 *      ture  : led is on
 */
bool LedBase::isOn(void)
{
  return(_isOn);
}

// Class Led 

/*    Led(PinName pin)
 * Class constructor : create and initialize Led instance
 * @param pin : name of the pin connected to the led (PinName)
 * @returns none
 */
Led::Led(PinName pin) : LedBase(pin)
{
  
  // Create LedBase instance
  _led = new LedBase(pin);
}

/*    void atTimer(void)
 * Led on timer : light off the led when called (private fuction)
 * @param none
 * @returns none
 */
void Led::atTimer(void)
{
  _led->off();
}

/*    void toggleCB(void)
 * Led toggle timer : toggle the led when called (private function)
 * @param none
 * @returns none
 */
void Led::toggleCB(void)
{
  _led->toggle();
}

/*    void Led::toggle(uint16_t period, bool mode)
 * Periodically toggle led
 * @param period : toggle period in ms (uinit16_t)
 * @param mode : stop auto toggle if false (bool)
 * @returns none
 */
void Led::toggle(uint16_t period, bool mode)
{
  timestamp_t t;

  // Attach togggleCB function to _tToggle Ticker if mode is true and led is off,
  // overwise detach the function.
  if(mode && !_led->isOn()) {
    t = period * 1000;
    _tToggle.attach_us(this, &Led::toggleCB,t);
  }
  else {
    _tToggle.detach();
  }
}

/*    void pulse(uint16_t time)
 * Light on led for a duration
 * @param time : light on duration in ms (uint16_t)
 * @returns none
 */
void Led::pulse(uint16_t time)
{
  timestamp_t t;
  
  // Attach atTimer function to _tPulse Timer if led is off.
  if(!_led->isOn()) {
    _led->on();
    t = time * 1000;
    _tPulse.attach_us(this,&Led::atTimer,t);
  }
}   
