/*
 * DecaWave.h
 *
 *  Created on: 04.11.2015
 *      Author: kauf
 */

#ifndef _DECAWAVE_H_
#define _DECAWAVE_H_

#include <stddef.h>
#include "deca_device_api.h"
#include "deca_param_types.h"
#include "deca_regs.h"
#include "mbed.h"
#include "PC.h"

#include "globals.h"
//#include "frames.h"

#ifndef uint64
#ifndef _DECA_INT64_
#define _DECA_INT64_
typedef uint64_t uint64;
#endif
#endif

#define TIMEUNITS_TO_US     (1/(128*499.2))             // conversion between the decawave timeunits (ca 15.65ps) to microseconds.
#define US_TO_TIMEUNITS     (128*499.2)                 // conversion between microseconds to the decawave timeunits (ca 15.65ps).
#define MASK_40BIT          (0x00FFFFFFFFFF)            // MP counter is 40 bits
#define MASK_TXDTS          (0x00FFFFFFFE00)            // TX timestamp will snap to 8 ns resolution - mask lower 9 bits.

#define SPEED_OF_LIGHT      (299702547.0f)              // in m/s in air
#define MIN_SPI_FREQ         1000000
#define MAX_SPI_FREQ        20000000

enum dw_state { DW_RECEIVE, DW_TRANSMIT, DW_IDLE };
double dwt_getrangebias(uint8 chan, float range, uint8 prf);


class DecaWave {
public:

  DecaWave();

  virtual ~DecaWave();

  void setup(dwt_config_t config, dwt_txconfig_t configdw_tx, uint32_t delay,
      void (*txcallback)(const dwt_cb_data_t *),
      void (*rxcallback)(const dwt_cb_data_t *));
    
  int8_t sendFrame(uint8_t* message, uint16_t length, uint32_t dtime, 
      uint32_t delay);
  int8_t turnonrx();
  void turnoffrx();

  uint16_t computeFrameLength_us();
  float getRXLevel(dwt_rxdiag_t *diagnostics);
  float getFPLevel();

  uint32_t getStatus();
  uint32_t readdevid();

  uint8_t   getNextSequenceNumber();
  uint16_t  getAntennaDelay();
  uint8_t   getCHAN();
  uint8_t   getPRF();


protected:

  void reset();
  void hardreset();
  void autoreenable();
  int16_t getAntennaDelayOffset(uint32_t board_id);

  uint8_t _sequenceNumber;
  dwt_config_t _deca_config;
  uint8_t _euid[8];
  uint16_t _antennadelay;
  dwt_txconfig_t _configTX;
  dw_state _state;
};

#endif /* _DECAWAVE_H_ */

