#include "PC.h"
#include "mbed.h"

PC::PC(PinName tx, PinName rx, int baudrate) : Serial(tx, rx) 
{
    baud(baudrate);
    cls();
    
    command[0] = '\0';
    command_char_count = 0;
}


void PC::cls() 
{
    printf("\x1B[2J");
}


void PC::locate(int Spalte, int Zeile) 
{
    printf("\x1B[%d;%dH", Zeile + 1, Spalte + 1);
}

//This fufnction enable reading strings from matlab. 
void PC::readcommand(void (*executer)(char*))
{
    
    
    char input = getc();  //get character from the serial bus
    
     if(input == '\r') {   // \r is our end of command character when this shows up, command will be executed !
                   
        this->command[command_char_count] = '\0';
        executer(&command[0]);
        this->command_char_count = 0;                // reset command
        this->command[command_char_count] = '\0';
    //    break;
    } else if (command_char_count < COMMAND_MAX_LENGHT) { //wait for other characters
       // printf("Debug Point 4");
        this->command[command_char_count] = input;
        this->command_char_count++;
      
    }
//}



    
   
/*   while (1)
    {
       
        if (readable())
        {
            scanf( "%s" , command );
            break;
        }
    }
    
   
    
    executer(&command[0]);
    command_char_count = 0;                 // reset command
    
   */ 



}
