#ifndef PS3PAD_H_
#define PS3PAD_H_

/*--------PSPADのアクセスの構造体-------
PS3--.Ps3Read()
|---.right_x
|---.right_y
|---.left_x
|---.left_y;
|---.BUTTON
|       |---.BIT
|       |     |-.HOME
|       |     |-.SELECT
|       |     |-.START
|       |
|       |---.ANALOG
|             |-.L2
|             |-.R2
|             |-.L1
|             |-.R1
|             |-.SANKAKU
|             |-.MARU
|             |-.BATU
|             |-.SIKAKU
|             |-.UP
|             |-.RIGHT
|             |-.DOWN
|             --.LEFT

---------------------------------------*/

//-------------------------------------------------------------------------
// Class
//-------------------------------------------------------------------------
class Ps3pad
{
public:
    Ps3pad(PinName miso, PinName mosi, PinName cs, PinName sclk);
//    void Ps3Read(void);
    void getValuesStop(void);
    void Ps3init(void);

    struct {
        struct {
            uint8_t HOME   ;
            uint8_t SELECT   ;
            uint8_t START    ;
        } BIT;
        struct {
            uint8_t L2       ;
            uint8_t R2       ;
            uint8_t L1       ;
            uint8_t R1       ;

            uint8_t SANKAKU  ;
            uint8_t MARU     ;
            uint8_t BATU     ;
            uint8_t SIKAKU   ;

            uint8_t UP       ;
            uint8_t RIGHT    ;
            uint8_t DOWN     ;
            uint8_t LEFT     ;
        } ANALOG;
    } BUTTON;
    int8_t right_x, right_y, left_x, left_y;
    
    

private:
    char send[19]; //仮に送るだけで、内容は何でもよい
    char get[19];
    void getValues(void);

    Ticker getTiming;
    SPI ds3con;
    DigitalOut ss;
};

#endif /* PSPAD_H_ */
