#include "mbed.h"
#include "ps3pad.h"

//----------------------------------------------------------
// PS3 PAD
//オリジナルの ESP32 + miniUSBHostShield + DualShock3 モジュールとSPI通信をして
//mbedで使えるようにするためのライブラリです。
//ESP32側のSPIslaveの問題で、通信に失敗するとESP32が落ちる( ˘ω˘) という問題があるので、誰かデバッグプリーズ
//どうでもいいけど、出来る限りUARTの通信速度は115200くらいまで上げると、ラグが生じない
//Serial pc(USBTX,USBRX,115200);と宣下の上、普段のprintfの前にpc.をつける
//pc.printf("Hello\r\n"); 的な
//----------------------------------------------------------

Ps3pad::Ps3pad(PinName miso, PinName mosi, PinName cs, PinName sclk) : ds3con(mosi,miso,sclk), ss(cs){
    ds3con.format(8,3);
    ds3con.frequency(1000000);
    
    memset(send,0,19);
    memset(get,0,19);
    for(int i=0;i<4;i++)get[i]=127; //コントローラのホームポジションにセット

    Ps3init();
}

void Ps3pad::Ps3init(void){ //初期化
    getTiming.attach(callback(this, &Ps3pad::getValues),0.001);
}


void Ps3pad::getValuesStop(void){ //使わないほうがいい?
//    getTiming.detatch();
}


void Ps3pad::getValues(void){
    int i;
//    memset(ret,'\0',sizeof(ret)/sizeof(ret[0]));
    uint8_t temp;

    for(i=0;i<4;i++)get[i]=127; //コントローラの初期状態に設定(変な動きをしないように)
    for(i=4;i<19;i++)get[i]=0;

    ss=0; //書き込みの合図(LOW)
    wait_us(10);
    for(i=0;i<19;i++){
        get[i]=__rbit(ds3con.write(__rbit(send[i] << 24)) << 24); //何やってるか忘れたワロス
        temp=0;
        for(int j=0;j<8;j++){
            temp += ((get[i]>>j) &(0x01))<<(7-j); //MSBをLSBに変換する
        }
        get[i]=temp;

        wait_us(10);
    }
    ss=1;
    
    
    left_x = get[0]-128;
    left_y = -(get[1]- 128+1);
    right_x = get[2]-128;
    right_y = -(get[3]- 128+1);
    BUTTON.ANALOG.L1 = get[4];
    BUTTON.ANALOG.L2 = get[5];
    BUTTON.ANALOG.R1 = get[6];
    BUTTON.ANALOG.R2 = get[7];
    BUTTON.ANALOG.SANKAKU = get[8];
    BUTTON.ANALOG.MARU = get[9];
    BUTTON.ANALOG.BATU = get[10];
    BUTTON.ANALOG.SIKAKU = get[11];
    BUTTON.ANALOG.UP = get[12];
    BUTTON.ANALOG.RIGHT = get[13];
    BUTTON.ANALOG.DOWN = get[14];
    BUTTON.ANALOG.LEFT = get[15];
    BUTTON.BIT.HOME = get[16];
    BUTTON.BIT.SELECT = get[17];
    BUTTON.BIT.START = get[18];

}