#include "mbed.h"

// Sampling
#include "DMA_sampling/adc.h"
#include "DMA_sampling/dac.h"
#include "DMA_sampling/pdb.h"
#include "Jareds_DSP/filters_jared.h"
#include "Jareds_DSP/demodulate.h"
// DSP
#include "dsp.h"
#include "print_data.h"

#define PROBE_NUMBER 5
#if PROBE_NUMBER == 1
    #define PRE_COMPUTE_LENGTH 232
#elif PROBE_NUMBER == 2
    #define PRE_COMPUTE_LENGTH 528
#elif PROBE_NUMBER == 3
    #define PRE_COMPUTE_LENGTH 176
#elif PROBE_NUMBER == 4
    #define PRE_COMPUTE_LENGTH 320
#elif PROBE_NUMBER == 5
    #define PRE_COMPUTE_LENGTH 208
#elif PROBE_NUMBER == 6
    #define PRE_COMPUTE_LENGTH 528
#endif
//#define probe_number 1 //Probe number
const int probe_number = PROBE_NUMBER;
//const int PCL_LUT[] = {232,528,176,320,208}; //Pre-compute-length for the different probe numbers 
//190Hz 528
//312Hz 320
//431Hz 232
//481Hz 208 
//568Hz 176

#define PRINT_BUFFER_LENGTH 10000
#define GATHER_STATISTICS 1

Serial pc(USBTX, USBRX);

// for debug purposes
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);
DigitalOut status_0(D0);
DigitalOut status_1(D1);
DigitalOut status_3(D3);
DigitalOut Start_sync(D4);// Currently not being used.
DigitalIn sw2(SW2);//Button 2 Currently not being used
DigitalIn sw3(SW3);//Button 3 Currently not being used

Timer timer;

// defined in dma.cpp
extern int len;
extern uint16_t static_input_array0[];//ADC 0(swaps between a0 and a1.  Used to measure current)
extern uint16_t static_input_array1[];//ADC 1(measures the voltage between the probe and ground)
extern uint16_t static_output_array0[];//DAC outputs whatever wave form we want.
extern uint16_t sampling_status;//used to determine when adc's are done reading.

//#define INPUT_ARRAY_SIZE 32
//#define DECIMATION_FACTOR 8
//#define DEMODULATED_SIGNAL_LENGTH 64

float *input_50k[8];





//190Hz 528
//312Hz 320
//431Hz 232
//481Hz 208 
//568Hz 176
//#define pre_compute_length 208
//#define CarrierFrequency (100000/pre_compute_length)
const int pre_compute_length = PRE_COMPUTE_LENGTH;
const float CarrierFrequency = (100000/pre_compute_length);
#define SAMPLEFREQUENCY 100000

uint16_t out_val_pre[pre_compute_length]; //used to write values to the dac
float twopi = 3.14159265359 * 2;


void pre_compute_tables() {
  // This function will precompute the cos and sin tables used in the rest of the program
  for(int precompute_counter = 0; precompute_counter < pre_compute_length; precompute_counter++){
    out_val_pre[precompute_counter] = (int) ((cos(twopi * CarrierFrequency /SAMPLEFREQUENCY * precompute_counter)) * 2046.0 + 2048.0);//12 bit cos wave
  }
  
  
}


int main() {
    
    led_blue = 1;
    led_green = 1;
    led_red = 1;
    
    pre_compute_tables();
    precompute_tables();
    //turn off all LEDs
    
    //slight change.
    
    
       
    pc.baud(230400);
    /*
    //pc.printf("High: %x Mid: %x Low: %x",SIM->UIDH,SIM->UIDML,SIM->UIDL);
    if(SIM->UIDH == 0x2effff && SIM->UIDML == 0x4e453154 && SIM->UIDL == 0x1004001e) probe_number = 6;
    else if(SIM->UIDH == 0x1cffff && SIM->UIDML == 0x4e453215 && SIM->UIDL == 0x700b0003) probe_number = 2;
    else if(SIM->UIDH == 0x2effff && SIM->UIDML == 0x4e453215 && SIM->UIDL == 0x700b0021) probe_number = 3;
    else if(SIM->UIDH == 0x14ffff && SIM->UIDML == 0x4e453154 && SIM->UIDL == 0x5009002b) probe_number = 4;
    else if(SIM->UIDH == 0x12ffff && SIM->UIDML == 0x4e453103 && SIM->UIDL == 0x60010030) probe_number = 1;
    else if(SIM->UIDH == 0x10ffff && SIM->UIDML == 0x4e453105 && SIM->UIDL == 0x100b0031) probe_number = 5;
    else if(SIM->UIDH == 0x19ffff && SIM->UIDML == 0x4d441504 && SIM->UIDL == 0x90110031) probe_number = 7;//this FRDM board had a bad usb connection
    else
    {
        pc.printf("FRDM BOARD NOT RECOGNIZED.  Here is the new ID:\n\r");
        pc.printf("High: %x Mid: %x Low: %x\n\r",SIM->UIDH,SIM->UIDML,SIM->UIDL);
        probe_number = 6;
    }
    */
    pc.printf("PROBE #%d",probe_number);
    wait(1.0f);

    int DAC_COUNTER = 0;
    
    
    //Filters used in program.  Coefficients generated using matlab FDA tool
    //Fs = 100000, FPass = 1500, FStop = 4500, -40db
    float Coeffs_100k[64] = {0.00368762746013400, -0.00390835182721185, -0.00352466159836192, -0.00378044968164769, -0.00434746630849834, -0.00502920744118478, -0.00570543677799210, -0.00628464650365093, -0.00668691824262464, -0.00683917139561193, -0.00667505410229485, -0.00613341508706847, -0.00516232410283893, -0.00371868951723358, -0.00177417571286934, 0.000685809876396031, 0.00365648516386919, 0.00711658039739992, 0.0110234409358280, 0.0153179248880130, 0.0199204447074274, 0.0247385052308702, 0.0296636617979935, 0.0345813441342327, 0.0393672306749833, 0.0438989152744108, 0.0480511039644129, 0.0517108728403463, 0.0547710075854812, 0.0571509837193129, 0.0587848911618005, 0.0596038010741317, 0.0596038010741317, 0.0587848911618005, 0.0571509837193129, 0.0547710075854812, 0.0517108728403463, 0.0480511039644129, 0.0438989152744108, 0.0393672306749833, 0.0345813441342327, 0.0296636617979935, 0.0247385052308702, 0.0199204447074274, 0.0153179248880130, 0.0110234409358280, 0.00711658039739992, 0.00365648516386919, 0.000685809876396031, -0.00177417571286934, -0.00371868951723358, -0.00516232410283893, -0.00613341508706847, -0.00667505410229485, -0.00683917139561193, -0.00668691824262464, -0.00628464650365093, -0.00570543677799210, -0.00502920744118478, -0.00434746630849834, -0.00378044968164769, -0.00352466159836192, -0.00390835182721185, 0.00368762746013400};
    //FS = 12500, Fpass = 100 Fstop 595 -50 db,  picks on 1KHz signal
    float Coeffs_12500[64] = {-0.00222124676855946, -0.00163176345559825, -0.00214372257722720, -0.00268653504526241, -0.00323192624665395, -0.00374368158669702, -0.00417907979321931, -0.00449328006488225, -0.00463658803501384, -0.00455550760053878, -0.00419848205106894, -0.00352024663122325, -0.00247317556122392, -0.00102679426345247, 0.000845020041268567, 0.00315252023354445, 0.00589238992243332, 0.00904676286706929, 0.0125796442526745, 0.0164391331165775, 0.0205582919104753, 0.0248562683452381, 0.0292399202971496, 0.0336089813533200, 0.0378556202824368, 0.0418719268554270, 0.0455508704073759, 0.0487915537931733, 0.0515035460002020, 0.0536094934833149, 0.0550483048257919, 0.0557785148825623, 0.0557785148825623, 0.0550483048257919, 0.0536094934833149, 0.0515035460002020, 0.0487915537931733, 0.0455508704073759, 0.0418719268554270, 0.0378556202824368, 0.0336089813533200, 0.0292399202971496, 0.0248562683452381, 0.0205582919104753, 0.0164391331165775, 0.0125796442526745, 0.00904676286706929, 0.00589238992243332, 0.00315252023354445, 0.000845020041268567, -0.00102679426345247, -0.00247317556122392, -0.00352024663122325, -0.00419848205106894, -0.00455550760053878, -0.00463658803501384, -0.00449328006488225, -0.00417907979321931, -0.00374368158669702, -0.00323192624665395, -0.00268653504526241, -0.00214372257722720, -0.00163176345559825, -0.00222124676855946};
    //Fs = 1562.5 Fpass = 100, FStop = 195.6, null at 200 Hz
    float Coeffs_1563[32] = {-0.00296990567211633, 0.00784631357544163, 0.00955642274001412, 0.0105078670942049, 0.00746432577935901, -0.000715888274492355, -0.0127656342089486, -0.0248578255670040, -0.0313597093257934, -0.0264804428976321, -0.00639056527392095, 0.0289495639622991, 0.0749846381319702, 0.123239880157668, 0.163403327438059, 0.186215627611441, 0.186215627611441, 0.163403327438059, 0.123239880157668, 0.0749846381319702, 0.0289495639622991, -0.00639056527392095, -0.0264804428976321, -0.0313597093257934, -0.0248578255670040, -0.0127656342089486, -0.000715888274492355, 0.00746432577935901, 0.0105078670942049, 0.00955642274001412, 0.00784631357544163, -0.00296990567211633};
    //Fs = 781.25, Fpass = 60, Fstop = 120, -50 Db
    float Coeffs_782[32] = {-0.00423132648651131, -0.00413085595827858, -0.00212955364173648, 0.00345345707266939, 0.0105870277845968, 0.0147191914630408, 0.0108878516242339, -0.00283458314983071, -0.0224398052018669, -0.0377493805765767, -0.0358474685211045, -0.00721456868509791, 0.0483564412276129, 0.119338204671425, 0.185468453617916, 0.225354002914126, 0.225354002914126, 0.185468453617916, 0.119338204671425, 0.0483564412276129, -0.00721456868509791, -0.0358474685211045, -0.0377493805765767, -0.0224398052018669, -0.00283458314983071, 0.0108878516242339, 0.0147191914630408, 0.0105870277845968, 0.00345345707266939, -0.00212955364173648, -0.00413085595827858, -0.00423132648651131};
    
    float Coeffs[20] = {0.0328368433284673, 0.0237706090075265, 0.0309894695180997, 0.0385253568846695, 0.0459996974310349, 0.0530165318016261, 0.0591943866845610, 0.0641755708098907, 0.0676960677594849, 0.0694621149975389, 0.0694621149975389, 0.0676960677594849, 0.0641755708098907, 0.0591943866845610, 0.0530165318016261, 0.0459996974310349, 0.0385253568846695, 0.0309894695180997, 0.0237706090075265, 0.0328368433284673};
    float Coeffs2[20] = {-0.00506451294187997, -0.00824932319607346, -0.00986370066237912, -0.00518913235010027, 0.00950858650162284, 0.0357083149022659, 0.0711557142019980, 0.109659494661247, 0.142586101123340, 0.161603335553589, 0.161603335553589, 0.142586101123340, 0.109659494661247, 0.0711557142019980, 0.0357083149022659, 0.00950858650162284, -0.00518913235010027, -0.00986370066237912, -0.00824932319607346, -0.00506451294187997};
    
    //note I allocate space for 4 adc inputs, but usually I only use 2
    for(int i = 0; i < 8; i++)
        input_50k[i] = new float[64];//each array represents the input of the adcs
       
    //filters(const int num_filters, const int DECIMATION, filters * f, const int block_size, const int numTaps, float coeffs[], int demodulate_after)
    //num filters: usually 4.  In-phase and quadrature phase for both voltage and current
    //DECIMATION: Decimation Factor
    //f: the filter after current filter.
    //block_size: block size of each filter command should be an integer multiple of DECIMATION
    //Flag noting rather or not to demodulate, and if so what frequency to demodulate at
    filters f4 = filters(4, 8, NULL, 8, 32, Coeffs_782,DEMOD_No_Demod);       
    filters f3 = filters(4, 2, &f4, 4, 32, Coeffs_1563,DEMOD_No_Demod);
    filters f2 = filters(4, 8, &f3, 8, 64, Coeffs_12500,DEMOD_No_Demod);
    filters f1 = filters(2, 8, &f2, 64, 64, Coeffs_100k,DEMOD_200HZ);
    
    /*
    filters f4_b = filters(4, 8, NULL, 8, 32, Coeffs_782,DEMOD_No_Demod);       
    filters f3_b = filters(4, 2, &f4_b, 4, 32, Coeffs_1563,DEMOD_No_Demod);
    filters f2_b = filters(4, 8, &f3_b, 8, 64, Coeffs_12500,DEMOD_No_Demod);
    filters f1_b = filters(2, 8, &f2_b, 64, 64, Coeffs_100k,DEMOD_1000HZ); 
    */
    //filters f_pre = filters(2, 2, &f1, 64, 64, Coeffs_50k,false);
    
    //float output_print_buffer[PRINT_BUFFER_LENGTH];//used to store the adc0 values(current measurment)
    //float output_print_buffer2[PRINT_BUFFER_LENGTH];//used to store the adc0 values(voltage measurment)
    int print_buffer_count = 0;
    
    pdb_init(); // Initalize PDB   
    dac_init(); // initializes DAC   
    adc_init(); // always initialize adc before dma
    pc.printf("ADC Initialized\r\n");
    dma_init2(); // initializes DMAs
    dma_reset(); // This clears any DMA triggers that may have gotten things into a different state
    pc.printf("Buffer Size: %i\r\n", len);
    
    led_green = 1;
    pc.printf("High: %x Mid: %x Low: %x",SIM->UIDH,SIM->UIDML,SIM->UIDL);
    pc.printf("\r\n\r\n\r\n");
    
    pdb_start();
    bool is_actively_printing = false;
    char read_in_character = 'a';
    //while(print_buffer_count<PRINT_BUFFER_LENGTH)
    timer.start();
    while(!GATHER_STATISTICS||print_buffer_count<PRINT_BUFFER_LENGTH)
    {
        if(pc.readable())//if the python code has sent any characters recently
        {
            while(pc.readable())//if there is a Keyboard input
            {
                read_in_character = pc.getc();// read the keyboard input
                if (read_in_character == 'R')//start printing
                {
                    timer.reset();
                    //timer.start();
                    is_actively_printing = true;
                }
                else if (read_in_character == 'S')//Stop printing
                {
                    //timer.stop();
                    is_actively_printing = false;
                }
                else if (read_in_character == 'P')//return probe number
                    pc.printf("p%d",probe_number);
                else if (read_in_character == 'I')//return probe number
                    pc.printf("IMPEDANCE");
                
            }
            
        }
            
        while(sampling_status == 0)//wait until the ADCs read a new values
        {   
            status_0 = 1;   //used for debugging allows to see utilization 
            print_filter_data(&pc,is_actively_printing);//while waiting for new samples print as much data as possible
            //Thread::wait(.0001);
        }
        sampling_status = 0;//sets sampling status to 0.  DMA sets it to one once ADCs sample
        status_0 = 0;//Tied to D0.  use an O-scope to measure how much free time there is to play with.
        status_1 = 1;//Tied to D1.  use an O-scope to measure how much time the processing takes
        
        for(int i = 0; i < len; i++) 
        {
            static_output_array0[i] = out_val_pre[DAC_COUNTER];//DAC output
            DAC_COUNTER++;//Counter to kepp track of where we are in our precomputed table
            if (DAC_COUNTER>=pre_compute_length) {DAC_COUNTER = 0;}//wrap around the counter
            //static_output_array0[i+1] = out_val_pre[DAC_COUNTER];//DAC output
            //DAC_COUNTER++;//Counter to kepp track of where we are in our precomputed table
            //if (DAC_COUNTER>=pre_compute_length) {DAC_COUNTER = 0;}//wrap around the counter
            
            //Note currently we are sampling 2 adc at 100 KHz.  If desired you can also sample 4 ADCs at 50 KHz
            input_50k[1][i]=float(static_input_array1[i]);
           // input_50k[3][i/2]=static_input_array1[i+1];
            input_50k[0][i]=float(static_input_array0[i]);
            //input_50k[2][i/2]=static_input_array0[i+1];
            
        }//End of for loop going throught the buffer of adc samples
        

        f1.input(input_50k,64,DEMOD_200HZ);
        //f1_b.input(input_50k,64,DEMOD_1000HZ);  
        //status_3 = 1;
        //pc.printf("Y");
        //status_3 = 0;
        
        
        status_1 = 0;//turn off D1 used in deterimining how long processing is taking
                 
    }//end of while loop
    
    //prints ADC buffer if desired
    
    //for(int i = 0; i<PRINT_BUFFER_LENGTH; i++)//print all the adc values measured
    //{
    //    printf("%.1f %.1f\n\r",output_print_buffer[i],output_print_buffer2[i]);
    //}
    
        
}
 
