#include "filters_jared.h"


    filters::filters(){}
      /**    
   * @brief Initializes a bank of parrallel decimating filters.    
   * @param[in] num_filters     The number of filters operating in this stage.  Maximum of MAX_NUMBER_OF_FILTERS    
   * @param[in] DECIMATION      Decimataion amount    
   * @param[in] f               Next bank of filters after this stage.  If Null prints the magnitude and phase.    
   * @param[in] blockSize       number of input samples to process per call.
   * @param[in] numTaps     .   The length of the FIR filter
   * @param[in] demodulate_after If true outptuts twice the number of outputs as normal, includes inphas/quadrature phase 
   * @return none.    
   */
    filters::filters(const int num_filters, const int DECIMATION, filters * f, const int block_size, const int numTaps, float coeffs[], int demodulate_after)
    {
        /*
        static bool first_time = true;//used to initialize the static precompute tables in the demodulate function
        if (first_time)
        {
            first_time = false;
            demodulate();//initialize precompute table
        }
        */
        _num_filters = num_filters;
        if (demodulate_after>=0)//if demodulation occurs there are twice as many output channels as input channels
        {
            _num_filters *=2;
        }
        //_demodulation_counter = 0;
        _demodulate_after = demodulate_after;
        _next_filter = f;
        
        
        _decimation_number = DECIMATION;
        _block_size_counter = 0;
        _block_size = block_size;
        if (block_size<DECIMATION)//if your decimating more than the block size that is probably bad
        {
            printf("WARNING BLOCK SIZE IS SMALLER THAN DECIMATION NUMBER");
        }

        for(int i = 0; i<_num_filters; i++)
        {
            _output_samples[i] = new float[block_size/DECIMATION]();//initialize the output channels
            _filter_input[i] = new float[block_size]();//initializes the filter input channesls  this array stores input values until it has block_size of them
            
            //initializes the filter structure.
            _filterStruct[i].M = _decimation_number;
            _filterStruct[i].numTaps = numTaps;
            _filterStruct[i].pCoeffs = coeffs;
            _filterStruct[i].pState = new float[block_size+numTaps-1]();
        }
        if (demodulate_after>=0)
        {
            _num_filters /=2;//this makes it so we process the correct number of inputs
        }
        
    }
    
    void filters::input(float *input_samples[MAX_NUMBER_OF_FILTERS], int length,  int print_identifier)
    {
        for(int k = 0; k<length; k++)//iterate through each input sample
        {
            for(int i = 0; i<_num_filters; i++)//iterate trhough each filter
            {
                _filter_input[i][_block_size_counter] = input_samples[i][k];//pass input sample to a queue filter input buffer
            }
            _block_size_counter++;//counts how many samples are in the que
            if(_block_size_counter>=_block_size)//if the queu has stored enough inputs
            {
                _block_size_counter = 0;//reset counter
                for(int i = 0; i<_num_filters; i++)//fore each filter
                {
                    //perform filtering & decimation
                    arm_fir_decimate_f32(&_filterStruct[i], _filter_input[i], _output_samples[i], _block_size);
                }
                if (_next_filter == NULL)//if this is the last filter
                {
                    for (int j = 0; j<_block_size/_decimation_number; j++)//iterate through output
                    {
                          //calculate magnitude and pahse
                          double real_ip = _output_samples[0][j] * _output_samples[2][j] + _output_samples[1][j] * _output_samples[3][j];
                          double imag_ip = _output_samples[1][j] * _output_samples[2][j] - _output_samples[0][j] * _output_samples[3][j];
                          double y_0_squared = _output_samples[0][j] * _output_samples[0][j] + _output_samples[1][j] * _output_samples[1][j]; 
                          double y_1_squared = _output_samples[2][j] * _output_samples[2][j] + _output_samples[3][j] * _output_samples[3][j];
                        
                          double mag = 51000*sqrt((real_ip * real_ip + imag_ip * imag_ip)) / ((float) y_0_squared);
                          double phase = -atan2(_output_samples[1][j], _output_samples[0][j])+atan2(_output_samples[3][j], _output_samples[2][j]);
                          set_print_buffer(mag,phase, print_identifier);
                            //set_print_buffer_V_I(_output_samples[2][j],_output_samples[3][j],_output_samples[0][j],_output_samples[1][j], print_identifier);
                    }
                }
                else//if this isn't the last set of filters
                {   
                    if (_demodulate_after>=0)
                    {
                        demodulate(_output_samples,_num_filters,_block_size/_decimation_number,_demodulate_after);
                    }
                    //pass the output of this filter to the input of the next filter
                    _next_filter->input(_output_samples,_block_size/_decimation_number, print_identifier);
                }//end else if next filter isn't null
            }//end if(_block_size_counter>=_block_size)
        }// end of for(int k = 0; k<length; k++)
    }//end of input function
    