/**
 *  Setup triggering for DMA2 and PortC
 */
#include "dma.h"

#define TOTAL_SAMPLES 64
#define SAMPLE_BUFFER_LENGTH 128
int len = TOTAL_SAMPLES;
uint16_t sample_array0[SAMPLE_BUFFER_LENGTH];
uint16_t sample_array1[SAMPLE_BUFFER_LENGTH];

uint16_t static_input_array0[TOTAL_SAMPLES];
uint16_t static_input_array1[TOTAL_SAMPLES];

uint16_t static_output_array0[TOTAL_SAMPLES];
uint16_t output_array0[SAMPLE_BUFFER_LENGTH];
uint32_t ADC0_LOCATION[2];

uint16_t sampling_status;
uint16_t sampling_status_done = 1;

uint16_t intermediate_status;
uint16_t intermediate_status_done = 1;

void dma_init2()
{
    ADC0_LOCATION[0] = 0x0C;
    ADC0_LOCATION[1] = 0x0D;
    // Enable clock for DMAMUX and DMA - all the peripherals need clocks to function
    SIM->SCGC6 |= SIM_SCGC6_DMAMUX_MASK;
    SIM->SCGC7 |= SIM_SCGC7_DMA_MASK;  


    // Enable DMA channels and select MUX to the correct source (see page 95 of user manual
    DMAMUX->CHCFG[0] = 0;
    DMAMUX->CHCFG[1] = 0;
    DMAMUX->CHCFG[2] = 0;
    DMAMUX->CHCFG[3] = 0;
    DMAMUX->CHCFG[4] = 0;
    DMAMUX->CHCFG[5] = 0;
    DMAMUX->CHCFG[6] = 0;
    DMAMUX->CHCFG[7] = 0;
    DMAMUX->CHCFG[8] = 0;
    DMAMUX->CHCFG[9] = 0;
    DMAMUX->CHCFG[10] = 0;
  
   
    // Enable request signal for channel 0, 1
    DMA0->ERQ = 0;
    DMA0->ERQ = DMA_ERQ_ERQ0_MASK | DMA_ERQ_ERQ1_MASK;
    
    // select round-robin arbitration priority
    DMA0->CR |= DMA_CR_ERCA_MASK;
    
    // Disable minor loop
    //DMA_CR &= ~DMA_CR_EMLM_MASK;
    DMA0->CR |= DMA_CR_EMLM_MASK;

    DMA0->TCD[0].CSR = 0;
    DMA0->TCD[1].CSR = 0;
    DMA0->TCD[2].CSR = 0;
    DMA0->TCD[3].CSR = 0;
    DMA0->TCD[4].CSR = 0;
    DMA0->TCD[5].CSR = 0;
    DMA0->TCD[6].CSR = 0;
    DMA0->TCD[7].CSR = 0;
    DMA0->TCD[8].CSR = 0;
    DMA0->TCD[9].CSR = 0;
    DMA0->TCD[10].CSR = 0;


// DMA setup for ADC sampling    
    // Set memory address for source and destination for DMA0 and DMA1
    DMA0->TCD[0].SADDR = (uint32_t) &ADC0->R[0];
    DMA0->TCD[0].DADDR = (uint32_t) sample_array0;
    DMA0->TCD[1].SADDR = (uint32_t) &ADC1->R[0];
    DMA0->TCD[1].DADDR = (uint32_t) sample_array1;
    
    // Set an offset for source and destination address
    DMA0->TCD[0].SOFF = 0x00; // Source address offset of 0 bytes per transaction
    DMA0->TCD[0].DOFF = 0x02; // Destination address offset of 2 bytes per transaction
    DMA0->TCD[1].SOFF = 0x00; // Source address offset of 0 bytes per transaction
    DMA0->TCD[1].DOFF = 0x02; // Destination address offset of 2 bytes per transaction
        
    // Set source and destination data transfer size
    DMA0->TCD[0].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
    DMA0->TCD[1].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
        
    // Number of bytes to be transfered in each service request of the channel
    DMA0->TCD[0].NBYTES_MLNO = 0x02;
    DMA0->TCD[1].NBYTES_MLNO = 0x02;
        
   
    DMA0->TCD[0].SLAST = 0;      // Source address adjustment
    DMA0->TCD[0].DLAST_SGA = -len*2*2;  // Destination address adjustment
    DMA0->TCD[1].SLAST = 0;      // Source address adjustment
    DMA0->TCD[1].DLAST_SGA = -len*2*2;  // Destination address adjustment
//    DMA_TCD[2].SLAST = 0;      // Source address adjustment
//    DMA_TCD[2].DLAST_SGA = -len*2;  // Destination address adjustment

    //DMAMUX_CHCFG0 |= DMAMUX_CHCFG_ENBL_MASK | DMAMUX_CHCFG_SOURCE(40); // ADC0
    //DMAMUX_CHCFG1 |= DMAMUX_CHCFG_ENBL_MASK | DMAMUX_CHCFG_SOURCE(41); // ADC1
    /* Source number    Source module
           40                ADC0
           41                ADC1
    */

    DMA0->TCD[0].BITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_BITER_ELINKYES_LINKCH(1) | DMA_BITER_ELINKYES_BITER(SAMPLE_BUFFER_LENGTH);
    DMA0->TCD[0].CITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_CITER_ELINKYES_LINKCH(1) | DMA_CITER_ELINKYES_CITER(SAMPLE_BUFFER_LENGTH);
    DMA0->TCD[0].CSR = DMA_CSR_MAJORLINKCH(1) | DMA_CSR_MAJORELINK_MASK;
    DMA0->TCD[1].BITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_BITER_ELINKYES_LINKCH(8) | DMA_BITER_ELINKYES_BITER(SAMPLE_BUFFER_LENGTH);
    DMA0->TCD[1].CITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_CITER_ELINKYES_LINKCH(8) | DMA_CITER_ELINKYES_CITER(SAMPLE_BUFFER_LENGTH);
    DMA0->TCD[1].CSR = DMA_CSR_MAJORLINKCH(8) | DMA_CSR_MAJORELINK_MASK;
 
    // Setup control and status register

//
// Now set up DAC DMA outputs from the output array
//
    DMA0->ERQ |= DMA_ERQ_ERQ2_MASK;    
    //DMA_TCD[1].CSR |= DMA_CSR_MAJORLINKCH(2) | DMA_CSR_MAJORELINK_MASK;    
    
    // Set memory address for source and destination for DMA0 and DMA1
    DMA0->TCD[2].SADDR = (uint32_t) output_array0;
    DMA0->TCD[2].DADDR = (uint32_t) &DAC0->DAT[0].DATL;
    
    // Set an offset for source and destination address
    DMA0->TCD[2].SOFF = 0x02; // Source address offset of 1 per transaction
    DMA0->TCD[2].DOFF = 0x00; // Destination address offset of 0 bytes per transaction
        
    // Set source and destination data transfer size
    DMA0->TCD[2].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
        
    // Number of bytes to be transfered in each service request of the channel
    DMA0->TCD[2].NBYTES_MLNO = 0x02;
    //DMA_TCD[2].NBYTES_MLOFFYES = DMA_NBYTES_MLOFFYES_MLOFF(0x00) | DMA_NBYTES_MLOFFYES_SMLOE_MASK | DMA_NBYTES_MLOFFYES_NBYTES(0x02);
    //DMA_TCD[1].NBYTES_MLOFFYES = DMA_NBYTES_MLOFFYES_MLOFF(0x02) | DMA_NBYTES_MLOFFYES_DMLOE_MASK | DMA_NBYTES_MLOFFYES_NBYTES(0x02);

        
    // Major iteration count
    //DMA_TCD[2].CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(len);
    //DMA_TCD[2].BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(len);
    
    // Adjustment value used to restore the source and destiny address to the initial value
    // After reading 'len' number of times, the DMA goes back to the beginning by subtracting len*2 from the address (going back to the original address)
    
    DMA0->TCD[2].SLAST = -len*2*2;      // Source address adjustment
    DMA0->TCD[2].DLAST_SGA = 0;  // Destination address adjustment

    DMAMUX->CHCFG[2] |= DMAMUX_CHCFG_ENBL_MASK | DMAMUX_CHCFG_SOURCE(48); // ADC0 Source   Jared's Note I think that this is actually the pdb timer

    DMA0->TCD[2].BITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_BITER_ELINKYES_LINKCH(0) | DMA_BITER_ELINKYES_BITER(len*2);
    DMA0->TCD[2].CITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_CITER_ELINKYES_LINKCH(0) | DMA_CITER_ELINKYES_CITER(len*2);
    DMA0->TCD[2].CSR |= DMA_CSR_MAJORLINKCH(0) | DMA_CSR_MAJORELINK_MASK;
    
//
// Now set up static dataset linking once the ADC samples are recorded
//
    // DMA Channels 4 and 5 now will be enabled
    DMA0->ERQ |= DMA_ERQ_ERQ4_MASK | DMA_ERQ_ERQ5_MASK;

    // Set memory address for source and destination for DMA4 and DMA5
    DMA0->TCD[4].SADDR = (uint32_t) &sample_array0;
    DMA0->TCD[4].DADDR = (uint32_t) &static_input_array0;
    DMA0->TCD[5].SADDR = (uint32_t) &sample_array1;
    DMA0->TCD[5].DADDR = (uint32_t) &static_input_array1;
    
    // Set an offset for source and destination address
    DMA0->TCD[4].SOFF = 0x02; // Source address offset of 2 bits per transaction
    DMA0->TCD[4].DOFF = 0x02; // Destination address offset of 1 bit per transaction
    DMA0->TCD[5].SOFF = 0x02; // Source address offset of 2 bits per transaction
    DMA0->TCD[5].DOFF = 0x02; // Destination address offset of 1 bit per transaction
        
    // Set source and destination data transfer size
    DMA0->TCD[4].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
    DMA0->TCD[5].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
        
    DMA0->TCD[4].NBYTES_MLOFFYES = DMA_NBYTES_MLOFFYES_MLOFF(-len*2) | DMA_NBYTES_MLOFFYES_DMLOE_MASK | DMA_NBYTES_MLOFFYES_NBYTES(0x02*len);
    DMA0->TCD[5].NBYTES_MLOFFYES = DMA_NBYTES_MLOFFYES_MLOFF(-len*2) | DMA_NBYTES_MLOFFYES_DMLOE_MASK | DMA_NBYTES_MLOFFYES_NBYTES(0x02*len);
    
    DMA0->TCD[4].SLAST = -len*2*2;      // Source address adjustment
    DMA0->TCD[4].DLAST_SGA = -len*2;  // Destination address adjustment
    //DMA_TCD[4].DLAST_SGA = 0;  // Destination address adjustment
    DMA0->TCD[5].SLAST = -len*2*2;      // Source address adjustment
    DMA0->TCD[5].DLAST_SGA = -len*2;  // Destination address adjustment
    //DMA_TCD[5].DLAST_SGA = 0;  // Destination address adjustment

    //DMA_TCD[4].CSR |= DMA_CSR_MAJORLINKCH(5) | DMA_CSR_MAJORELINK_MASK;
    DMA0->TCD[4].BITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_BITER_ELINKYES_LINKCH(5) | DMA_BITER_ELINKYES_BITER(2);
    DMA0->TCD[4].CITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_CITER_ELINKYES_LINKCH(5) | DMA_CITER_ELINKYES_CITER(2);
    DMA0->TCD[4].CSR = DMA_CSR_MAJORLINKCH(5) | DMA_CSR_MAJORELINK_MASK;
    DMA0->TCD[5].BITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_BITER_ELINKYES_LINKCH(6) | DMA_BITER_ELINKYES_BITER(2);
    DMA0->TCD[5].CITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_CITER_ELINKYES_LINKCH(6) | DMA_CITER_ELINKYES_CITER(2);
    DMA0->TCD[5].CSR = DMA_CSR_MAJORLINKCH(6) | DMA_CSR_MAJORELINK_MASK;

//
// Now set up linking from static DAC to memory for output through DMA
//
    // DMA Channel 6 will be enabled

    DMA0->ERQ |= DMA_ERQ_ERQ6_MASK;

    // Set memory address for source and destination for DMA6
    DMA0->TCD[6].SADDR = (uint32_t) static_output_array0;
    DMA0->TCD[6].DADDR = (uint32_t) output_array0;
    
    // Set an offset for source and destination address
    DMA0->TCD[6].SOFF = 0x02; // Source address offset of 2 bits per transaction
    DMA0->TCD[6].DOFF = 0x02; // Destination address offset of 1 bit per transaction
        
    // Set source and destination data transfer size
    DMA0->TCD[6].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
    DMA0->TCD[6].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
        
    
    DMA0->TCD[6].NBYTES_MLOFFYES = DMA_NBYTES_MLOFFYES_MLOFF(-len*2) | DMA_NBYTES_MLOFFYES_SMLOE_MASK | DMA_NBYTES_MLOFFYES_NBYTES(0x02*len);
    
    DMA0->TCD[6].SLAST = -len*2;      // Source address adjustment
    //DMA_TCD[6].SLAST = 0;      // Source address adjustment
    DMA0->TCD[6].DLAST_SGA = -len*2*2;  // Destination address adjustment

    DMA0->TCD[6].BITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_BITER_ELINKYES_LINKCH(9) | DMA_BITER_ELINKYES_BITER(2);
    DMA0->TCD[6].CITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_CITER_ELINKYES_LINKCH(9) | DMA_CITER_ELINKYES_CITER(2);

    DMA0->TCD[6].CSR |= DMA_CSR_MAJORLINKCH(9) | DMA_CSR_MAJORELINK_MASK;    
   
//
// Provide control for intermediate loops
//    

    // DMA Channel 8
    DMA0->ERQ |= DMA_ERQ_ERQ8_MASK;
    
    // Set memory address for source and destiantion for DMA 8
    DMA0->TCD[8].SADDR = (uint32_t) &intermediate_status_done;
    DMA0->TCD[8].DADDR = (uint32_t) &intermediate_status;
    
    // Set an offset for source and destination address
    DMA0->TCD[8].SOFF = 0x00; // Source address offset of 2 bits per transaction
    DMA0->TCD[8].DOFF = 0x00; // Destination address offset of 1 bit per transaction
        
    // Set source and destination data transfer size
    DMA0->TCD[8].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
    DMA0->TCD[8].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
        
    // Number of bytes to be transfered in each service request of the channel
    DMA0->TCD[8].NBYTES_MLNO = 0x02; 
        
    // Current major iteration count
    DMA0->TCD[8].CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(len);
    DMA0->TCD[8].BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(len);
      
    DMA0->TCD[8].SLAST = 0;      // Source address adjustment
    DMA0->TCD[8].DLAST_SGA = 0;  // Destination address adjustment
   
    DMA0->TCD[8].CSR |= DMA_CSR_MAJORLINKCH(4) | DMA_CSR_MAJORELINK_MASK;

//
//  Provide status
//   

    // DMA Channel 9
    DMA0->ERQ |= DMA_ERQ_ERQ9_MASK;
    
    // Set memory address for source and destiantion for DMA 8
    DMA0->TCD[9].SADDR = (uint32_t) &sampling_status_done;
    DMA0->TCD[9].DADDR = (uint32_t) &sampling_status;
    
    // Set an offset for source and destination address
    DMA0->TCD[9].SOFF = 0x00; // Source address offset of 2 bits per transaction
    DMA0->TCD[9].DOFF = 0x00; // Destination address offset of 1 bit per transaction
        
    // Set source and destination data transfer size
    DMA0->TCD[9].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
    DMA0->TCD[9].ATTR = DMA_ATTR_SSIZE(1) | DMA_ATTR_DSIZE(1);
        
    // Number of bytes to be transfered in each service request of the channel
    DMA0->TCD[9].NBYTES_MLNO = 0x02; 
        
    // Current major iteration count
    DMA0->TCD[9].CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(len);
    DMA0->TCD[9].BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(len);
    
    DMA0->TCD[9].SLAST = 0;      // Source address adjustment
    DMA0->TCD[9].DLAST_SGA = 0;  // Destination address adjustment
   
   
   
   
   
  //JARED THIS IS WHERE YOU STARTED TO CHANGE THINGS
  // Enable request signal for channel 10 this DMA swaps ADC0 between a0 and a1.
    DMA0->ERQ |= DMA_ERQ_ERQ10_MASK;
    
    
// DMA setup for ADC sampling    
    // Set memory address for source and destination for DMA0 and DMA1
    //DMA_TCD[10].SADDR = (uint32_t) &ADC0_RA;
    //DMA_TCD[10].DADDR = (uint32_t) sample_array0;
    DMA0->TCD[10].SADDR = (uint32_t) ADC0_LOCATION;
    DMA0->TCD[10].DADDR = (uint32_t) &ADC0->SC1[0];
    
    
    
    // Set an offset for source and destination address
    DMA0->TCD[10].SOFF = 0x04; // Source address offset of 0 bytes per transaction
    DMA0->TCD[10].DOFF = 0x00; // Destination address offset of 2 bytes per transaction

        
    // Set source and destination data transfer size
    DMA0->TCD[10].ATTR = DMA_ATTR_SSIZE(2) | DMA_ATTR_DSIZE(2);
        
    // Number of bytes to be transfered in each service request of the channel
    DMA0->TCD[10].NBYTES_MLNO = 0x04;
   
        
   
    DMA0->TCD[10].SLAST = -(4*2);      // Source address adjustment
    DMA0->TCD[10].DLAST_SGA = 0;  // Destination address adjustment
    
    //DMAMUX_CHCFG10 |= DMAMUX_CHCFG_ENBL_MASK | DMAMUX_CHCFG_SOURCE(41); // ADC0 Source   Jared's Note I think that this is actually the pdb timer

    //DMA_TCD[10].CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(2);
    //DMA_TCD[10].BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(2);
    DMA0->TCD[10].BITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_BITER_ELINKYES_LINKCH(8) | DMA_BITER_ELINKYES_BITER(2);
    DMA0->TCD[10].CITER_ELINKYES = DMA_CITER_ELINKYES_ELINK_MASK | DMA_CITER_ELINKYES_LINKCH(8) | DMA_CITER_ELINKYES_CITER(2);
    DMA0->TCD[10].CSR |= DMA_CSR_MAJORLINKCH(8) | DMA_CSR_MAJORELINK_MASK;
   
  
}

void dma_reset() {
    // Set memory address for destinations back to the beginning
    dma_init();
}




/*pc.printf("DMA_CR: %08x\r\n", DMA_CR);
    pc.printf("DMA_ES: %08x\r\n", DMA_ES);
    pc.printf("DMA_ERQ: %08x\r\n", DMA_ERQ);
    pc.printf("DMA_EEI: %08x\r\n", DMA_EEI);
    pc.printf("DMA_CEEI: %02x\r\n", DMA_CEEI);
    pc.printf("DMA_SEEI: %02x\r\n", DMA_SEEI);
    pc.printf("DMA_CERQ: %02x\r\n", DMA_CERQ);
    pc.printf("DMA_SERQ: %02x\r\n", DMA_SERQ);
    pc.printf("DMA_CDNE: %02x\r\n", DMA_CDNE);
    pc.printf("DMA_SSRT: %02x\r\n", DMA_SSRT);
    pc.printf("DMA_CERR: %02x\r\n", DMA_CERR);
    pc.printf("DMA_CINT: %02x\r\n", DMA_CINT);
    pc.printf("DMA_INT: %08x\r\n", DMA_INT);
    pc.printf("DMA_ERR: %08x\r\n", DMA_ERR);
    pc.printf("DMA_HRS: %08x\r\n", DMA_HRS);*/